/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.TangoConst;
import java.util.Hashtable;

public class StateUtilities {
    private Hashtable<DevState, String> STATETABLE = new Hashtable();
    private static StateUtilities m_StateUtilities = null;
    public static final String[] STATELIST = TangoConst.Tango_DevStateName;

    private StateUtilities() {
        this.STATETABLE.put(DevState.ON, STATELIST[0]);
        this.STATETABLE.put(DevState.OFF, STATELIST[1]);
        this.STATETABLE.put(DevState.CLOSE, STATELIST[2]);
        this.STATETABLE.put(DevState.OPEN, STATELIST[3]);
        this.STATETABLE.put(DevState.INSERT, STATELIST[4]);
        this.STATETABLE.put(DevState.EXTRACT, STATELIST[5]);
        this.STATETABLE.put(DevState.MOVING, STATELIST[6]);
        this.STATETABLE.put(DevState.STANDBY, STATELIST[7]);
        this.STATETABLE.put(DevState.FAULT, STATELIST[8]);
        this.STATETABLE.put(DevState.INIT, STATELIST[9]);
        this.STATETABLE.put(DevState.RUNNING, STATELIST[10]);
        this.STATETABLE.put(DevState.ALARM, STATELIST[11]);
        this.STATETABLE.put(DevState.DISABLE, STATELIST[12]);
        this.STATETABLE.put(DevState.UNKNOWN, STATELIST[13]);
    }

    public static StateUtilities getInstance() {
        if (m_StateUtilities == null) {
            m_StateUtilities = new StateUtilities();
        }
        return m_StateUtilities;
    }

    public static Hashtable getStateTable() {
        return StateUtilities.getInstance().STATETABLE;
    }

    public static DevState getStateForName(String string) {
        try {
            string = string.trim().toUpperCase();
            return (DevState)DevState.class.getField(string).get(string);
        }
        catch (Exception exception) {
            return DevState.UNKNOWN;
        }
    }

    public static String getNameForState(DevState devState) {
        return ApiUtil.stateName(devState);
    }

    public static String getNameForState(short s) {
        return ApiUtil.stateName(s);
    }

    public static boolean isStateExist(String string) {
        return StateUtilities.getInstance().STATETABLE.containsValue(string);
    }
}

