/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.Utils;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DbServerStructure;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class Server2TangoHost
extends JDialog {
    private Component parent;
    private DbServerStructure server;
    private JLabel titleLabel;
    private static final Font[] fonts = new Font[]{new Font("Dialog", 1, 18), new Font("Dialog", 1, 14), new Font("Dialog", 1, 12), new Font("Dialog", 0, 12), new Font("Dialog", 0, 11)};
    private static final int SERVER = 0;
    private static final int CLASS = 1;
    private static final int DEVICE = 2;
    private static final int ATTRIB = 3;
    private static final int DATA = 4;

    public Server2TangoHost(JFrame parent, String serverName) throws DevFailed {
        super((Frame)parent, true);
        this.parent = parent;
        this.buildTheForm(serverName);
    }

    public Server2TangoHost(JDialog parent, String serverName) throws DevFailed {
        super((Dialog)parent, true);
        this.parent = parent;
        this.buildTheForm(serverName);
    }

    private void buildTheForm(String serverName) throws DevFailed {
        this.initComponents();
        this.server = new DbServerStructure(serverName);
        this.initOwnComponents(this.server);
        this.titleLabel.setText("Server " + serverName + " on " + ApiUtil.get_db_obj().get_tango_host());
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initOwnComponents(DbServerStructure server) throws DevFailed {
        DbServerTree tree = new DbServerTree(server);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(tree);
        scrollPane.setPreferredSize(new Dimension(700, 600));
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel bottomPanel = new JPanel();
        JButton exportBtn = new JButton();
        JLabel jLabel1 = new JLabel();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Server2TangoHost.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        exportBtn.setText("Export Server");
        exportBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Server2TangoHost.this.exportBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(exportBtn);
        jLabel1.setText("         ");
        bottomPanel.add(jLabel1);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Server2TangoHost.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void exportBtnActionPerformed(ActionEvent evt) {
        try {
            String tgHost = this.getTangoHostToExport(this.server.getName());
            if (tgHost == null) {
                return;
            }
            int option = this.checkIfServerAlreadyExists(this.server, tgHost);
            if (option == 2) {
                return;
            }
            if (option == 0) {
                this.server.remove(tgHost);
            }
            this.server.putInDatabase(tgHost);
            if (JOptionPane.showConfirmDialog(this, this.server.getName() + "  server\nHas been exported to " + tgHost + " \n\n" + "Remove it  in  " + ApiUtil.getTangoHost() + " ?\n", "Confirm Dialog", 0) == 0) {
                this.removeServer();
            }
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
        }
        this.doClose();
    }

    private void removeServer() throws DevFailed {
        block5: {
            DeviceProxy dev = new DeviceProxy("dserver/" + this.server.getName());
            try {
                dev.ping();
                if (JOptionPane.showConfirmDialog(this, this.server.getName() + "  is running!\n" + "Stop it before remove it  in  " + ApiUtil.getTangoHost() + " ?\n", "Confirm Dialog", 0) == 0) {
                    dev.command_inout("Kill");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                    break block5;
                }
                return;
            }
            catch (DevFailed e) {
                if (JOptionPane.showConfirmDialog(this, "Delete  " + this.server.getName() + "  in  " + ApiUtil.getTangoHost() + " ?\n", "Confirm Dialog", 0) == 0) break block5;
                return;
            }
        }
        new DbServer(this.server.getName()).put_info(new DbServInfo(this.server.getName(), "", false, 0));
        this.server.remove();
    }

    private int checkIfServerAlreadyExists(DbServerStructure server, String tgHost) throws DevFailed {
        if (server.alreadyExists(tgHost)) {
            Object[] options = new Object[]{"Write " + tgHost + " nevertheless", "Cancel"};
            switch (JOptionPane.showOptionDialog(this, "WARNING:\n" + server.getName() + " or device(s)  already exists in " + tgHost + " !\n\n", "Warning", -1, 2, null, options, options[0])) {
                case 0: {
                    return 0;
                }
                case -1: 
                case 1: {
                    return 2;
                }
            }
        }
        return 1;
    }

    private String getTangoHostToExport(String serverName) {
        String tgHost = "";
        boolean tgHostOK = false;
        while (tgHost != null && !tgHostOK) {
            tgHost = (String)JOptionPane.showInputDialog(this, "TANGO_HOST to export " + serverName + "  ?", "Input Dialog", 1, null, null, tgHost);
            if (tgHost == null) continue;
            try {
                if (tgHost.equals(ApiUtil.getTangoHost())) {
                    Except.throw_exception((String)"", (String)"Cannot copy server on itself", (String)"Server2TangoHost.getTangoHostToExport()");
                }
                ApiUtil.get_db_obj((String)tgHost);
                tgHostOK = true;
            }
            catch (DevFailed e) {
                ErrorPane.showErrorMessage((Component)this, null, (DevFailed)e);
            }
        }
        return tgHost;
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                Except.throw_exception((String)"SyntaxError", (String)"ServerName ?", (String)"main()");
            }
            new Server2TangoHost((JFrame)null, args[0]).setVisible(true);
        }
        catch (DevFailed e) {
            ErrorPane.showErrorMessage((Component)new Frame(), null, (DevFailed)e);
            System.exit(0);
        }
    }

    private class TangoRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon[] icons = new ImageIcon[5];

        public TangoRenderer() {
            this.icons[0] = Utils.getInstance().getIcon("server.gif");
            this.icons[1] = Utils.getInstance().getIcon("class.gif");
            this.icons[2] = Utils.getInstance().getIcon("device.gif");
            this.icons[3] = Utils.getInstance().getIcon("attleaf.gif");
            this.icons[4] = Utils.getInstance().getIcon("leaf.gif");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, obj, sel, expanded, leaf, row, hasFocus);
            this.setForeground(Color.black);
            this.setBackgroundSelectionColor(Color.lightGray);
            Object userObject = ((DefaultMutableTreeNode)obj).getUserObject();
            int idx = userObject instanceof DbServerStructure ? 0 : (userObject instanceof DbServerStructure.TangoClass ? 1 : (userObject instanceof DbServerStructure.TangoDevice ? 2 : (userObject instanceof DbServerStructure.TangoAttribute ? 3 : 4)));
            this.setFont(fonts[idx]);
            this.setIcon(this.icons[idx]);
            return this;
        }
    }

    public class DbServerTree
    extends JTree
    implements TangoConst {
        private DefaultMutableTreeNode root;

        public DbServerTree(DbServerStructure server) throws DevFailed {
            this.buildTree(server);
            this.expandChildren(this.root);
            this.setSelectionPath(null);
        }

        private void buildTree(DbServerStructure server) {
            this.root = new DefaultMutableTreeNode(server);
            this.createCollectionClassNodes(server);
            this.getSelectionModel().setSelectionMode(1);
            DefaultTreeModel treeModel = new DefaultTreeModel(this.root);
            this.setModel(treeModel);
            ToolTipManager.sharedInstance().registerComponent(this);
            TangoRenderer renderer = new TangoRenderer();
            this.setCellRenderer(renderer);
            this.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent e) {
                }

                @Override
                public void treeExpanded(TreeExpansionEvent e) {
                    DbServerTree.this.expandedPerformed(e);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    DbServerTree.this.treeMouseClicked(evt);
                }
            });
        }

        private void treeMouseClicked(MouseEvent evt) {
        }

        public void expandedPerformed(TreeExpansionEvent evt) {
        }

        private void createCollectionClassNodes(DbServerStructure server) {
            ArrayList classes = server.getClasses();
            for (DbServerStructure.TangoClass clazz : classes) {
                DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(clazz);
                this.root.add(classNode);
                ArrayList properties = clazz.getProperties();
                for (DbServerStructure.TangoProperty property : properties) {
                    classNode.add(new DefaultMutableTreeNode(property));
                }
                ArrayList attributes = clazz.getAttributes();
                for (DbServerStructure.TangoAttribute attribute : attributes) {
                    DefaultMutableTreeNode attributeNode = new DefaultMutableTreeNode(attribute);
                    classNode.add(attributeNode);
                    for (DbServerStructure.TangoProperty property : attribute) {
                        attributeNode.add(new DefaultMutableTreeNode(property));
                    }
                }
                for (DbServerStructure.TangoDevice device : clazz) {
                    DefaultMutableTreeNode deviceNode = new DefaultMutableTreeNode(device);
                    classNode.add(deviceNode);
                    ArrayList deviceProperties = device.getProperties();
                    for (DbServerStructure.TangoProperty property : deviceProperties) {
                        deviceNode.add(new DefaultMutableTreeNode(property));
                    }
                    ArrayList deviceAttributes = device.getAttributes();
                    for (DbServerStructure.TangoAttribute attribute : deviceAttributes) {
                        DefaultMutableTreeNode attributeNode = new DefaultMutableTreeNode(attribute);
                        deviceNode.add(attributeNode);
                        for (DbServerStructure.TangoProperty property : attribute) {
                            attributeNode.add(new DefaultMutableTreeNode(property));
                        }
                    }
                }
            }
        }

        private void expandChildren(DefaultMutableTreeNode node) {
            boolean level_done = false;
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                if (child.isLeaf()) {
                    if (level_done) continue;
                    this.expandNode(child);
                    level_done = true;
                    continue;
                }
                if (child.getUserObject() instanceof DbServerStructure.TangoDevice) continue;
                this.expandChildren(child);
            }
        }

        private void expandNode(DefaultMutableTreeNode node) {
            ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>();
            nodeList.add(node);
            while (node != this.root) {
                node = (DefaultMutableTreeNode)node.getParent();
                nodeList.add(0, node);
            }
            Object[] tn = new DefaultMutableTreeNode[nodeList.size()];
            for (int i = 0; i < nodeList.size(); ++i) {
                tn[i] = (TreeNode)nodeList.get(i);
            }
            TreePath tp = new TreePath(tn);
            this.setSelectionPath(tp);
            this.scrollPathToVisible(tp);
        }
    }
}

