/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import admin.astor.AstorUtil;
import admin.astor.tango_release.TangoClassRelease;
import admin.astor.tango_release.TangoServerRelease;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class TangoServerReleaseList
extends ArrayList<TangoServerRelease> {
    private ArrayList<TangoServerRelease> onErrors = new ArrayList();
    private static final int idlMin = 2;
    private static final int idlMax = 10;

    public TangoServerReleaseList(ArrayList<String> arrayList) {
        Collections.sort(arrayList, new StringComparator());
        int n = 0;
        for (String string : arrayList) {
            double d = (double)n / (double)arrayList.size();
            AstorUtil.increaseSplashProgress(d, "Check " + ++n + "/" + arrayList.size() + " - " + string);
            TangoServerRelease tangoServerRelease = new TangoServerRelease(string);
            if (tangoServerRelease.releaseNumber > 0.0) {
                this.add(tangoServerRelease);
            } else {
                this.onErrors.add(tangoServerRelease);
            }
            if (!AstorUtil.osIsUnix() || n % 920 != 0) continue;
            for (int i = 180; i > 0; --i) {
                AstorUtil.setSplashMessage("Waiting " + i + " sec.");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public int nbClasses() {
        int n = 0;
        for (int i = 2; i <= 10; ++i) {
            ArrayList<TangoClassRelease> arrayList = this.getClassesForIdlRelease(i);
            n += arrayList.size();
        }
        return n;
    }

    public ArrayList<TangoServerRelease> getServersForTangoRelease(double d) {
        ArrayList<TangoServerRelease> arrayList = new ArrayList<TangoServerRelease>();
        for (TangoServerRelease tangoServerRelease : this) {
            if (tangoServerRelease.releaseNumber != d) continue;
            arrayList.add(tangoServerRelease);
        }
        return arrayList;
    }

    public ArrayList<TangoServerRelease> getServersForIdlRelease(int n) {
        ArrayList<TangoServerRelease> arrayList = new ArrayList<TangoServerRelease>();
        for (TangoServerRelease tangoServerRelease : this) {
            if (!tangoServerRelease.hasIDL(n)) continue;
            arrayList.add(tangoServerRelease);
        }
        return arrayList;
    }

    public ArrayList<TangoClassRelease> getClassesForIdlRelease(int n) {
        ArrayList<TangoClassRelease> arrayList = new ArrayList<TangoClassRelease>();
        for (TangoServerRelease tangoServerRelease : this) {
            ArrayList<TangoClassRelease> arrayList2 = tangoServerRelease.getIdlClasses(n);
            for (TangoClassRelease tangoClassRelease : arrayList2) {
                boolean bl = false;
                for (TangoClassRelease tangoClassRelease2 : arrayList) {
                    if (!tangoClassRelease2.className.equals(tangoClassRelease.className)) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList.add(tangoClassRelease);
            }
        }
        Collections.sort(arrayList, new ClassComparator());
        return arrayList;
    }

    public ArrayList<TangoServerRelease> getServersOnError() {
        return this.onErrors;
    }

    public String toString(ArrayList<TangoServerRelease> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (TangoServerRelease tangoServerRelease : arrayList) {
            stringBuilder.append(tangoServerRelease.toStringFull()).append("\n");
        }
        return stringBuilder.toString();
    }

    public String toString(double d) {
        return this.toString(this.getServersForTangoRelease(d));
    }

    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<TangoClassRelease> arrayList = this.getClassesForIdlRelease(n);
        for (TangoClassRelease tangoClassRelease : arrayList) {
            stringBuilder.append(tangoClassRelease).append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toString(this);
    }

    public static void main(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("VacGaugeServer/sr_c1-pen");
        arrayList.add("VacGaugeServer/sr_c1-ip");
        arrayList.add("PLCvacuumValve/sr_c01");
        arrayList.add("Starter/l-c01-1");
        try {
            TangoServerReleaseList tangoServerReleaseList = new TangoServerReleaseList(arrayList);
            System.out.println(tangoServerReleaseList.toString(4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class StringComparator
    implements Comparator<String> {
        StringComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareTo(string2);
        }
    }

    class ClassComparator
    implements Comparator<TangoClassRelease> {
        ClassComparator() {
        }

        @Override
        public int compare(TangoClassRelease tangoClassRelease, TangoClassRelease tangoClassRelease2) {
            return tangoClassRelease.className.compareTo(tangoClassRelease2.className);
        }
    }

    class ServerComparator
    implements Comparator<TangoServerRelease> {
        ServerComparator() {
        }

        @Override
        public int compare(TangoServerRelease tangoServerRelease, TangoServerRelease tangoServerRelease2) {
            return tangoServerRelease.name.compareTo(tangoServerRelease2.name);
        }
    }
}

