/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class CheckServer {
    private static final String[] actions = new String[]{"start", "stop", "restart", "ping"};
    private static String starter_name;
    private static String servname;
    private static String action;
    private static DeviceProxy starter;

    public CheckServer(String[] stringArray) throws DevFailed {
        if (!this.checkSyntax(stringArray)) {
            System.exit(0);
        }
        starter = new DeviceProxy(starter_name);
    }

    public void doAction() throws DevFailed {
        if (action.equals("start")) {
            this.execute("DevStart");
            System.out.println(servname + " started");
        } else if (action.equals("stop")) {
            this.execute("DevStop");
            System.out.println(servname + " stopped");
        } else if (action.equals("restart")) {
            this.restart();
            System.out.println(servname + " restarted");
        } else if (action.equals("ping")) {
            new DeviceProxy("dserver/" + servname).ping();
            System.out.println(servname + " is alive");
        }
    }

    private void execute(String string) throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(servname);
        starter.command_inout(string, deviceData);
    }

    private void restart() throws DevFailed {
        block4: {
            try {
                this.execute("DevStop");
                System.out.println(servname + " stopped");
            }
            catch (DevFailed devFailed) {
                if (devFailed.errors[0].reason.indexOf("NOT running !") >= 0) break block4;
                throw devFailed;
            }
        }
        int n = 5;
        for (int i = 0; i < n; ++i) {
            this.sleep(1000L);
            DeviceData deviceData = new DeviceData();
            deviceData.insert(true);
            DeviceData deviceData2 = starter.command_inout("DevGetStopServers", deviceData);
            String[] stringArray = deviceData2.extractStringArray();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(servname)) continue;
                i = n;
            }
        }
        this.execute("DevStart");
    }

    private synchronized void sleep(long l) {
        try {
            this.wait(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void displaySyntax(String string) {
        int n = string.lastIndexOf("/");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        System.out.println("Syntax :");
        System.out.println(string + "  hosname  servname  action");
        System.out.println("\thosname  : Host name where server running");
        System.out.println("\tservname : Server name (e.g. VacGauge/sr_c02)");
        System.out.print("\taction   : ");
        for (int i = 0; i < actions.length; ++i) {
            if (i > 0) {
                System.out.print(" / ");
            }
            System.out.print(actions[i]);
        }
        System.out.println();
    }

    private boolean checkSyntax(String[] stringArray) {
        if (stringArray.length < 4) {
            this.displaySyntax(stringArray[0]);
            return false;
        }
        starter_name = "tango/admin/" + stringArray[1];
        servname = stringArray[2];
        action = stringArray[3].toLowerCase();
        if (servname.indexOf("/") < 0) {
            System.out.println("Server name syntax error !");
            this.displaySyntax(stringArray[0]);
            return false;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < actions.length; ++i) {
            bl = action.equals(actions[i]);
        }
        if (!bl) {
            System.out.println("action name syntax error !");
            this.displaySyntax(stringArray[0]);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        CheckServer checkServer = null;
        try {
            checkServer = new CheckServer(stringArray);
            checkServer.doAction();
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
    }
}

