/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class AstorCmdLine {
    private int action = -1;
    private TangoHost[] hosts = null;
    private AstorUtil util;
    private static final int NOT_INITIALIZED = -1;
    private static final int START_SERVERS = 0;
    private static final int STOP_SERVERS = 1;
    private static final String[] known_actions = new String[]{"start", "stop"};
    static final int REMOVE_POLLING = 0;
    static final int REMOVE_POLLING_FORCED = 1;
    private static final String PollAttProp = "polled_attr";

    public AstorCmdLine(String[] stringArray) throws Exception {
        this.util = AstorUtil.getInstance();
        this.manageArgs(stringArray);
        this.doAction();
    }

    private void doAction() {
        int n = AstorUtil.getStarterNbStartupLevels();
        switch (this.action) {
            case 0: {
                for (int i = 1; i <= n; ++i) {
                    this.doAction(i);
                }
                break;
            }
            case 1: {
                for (int i = n; i >= 1; --i) {
                    this.doAction(i);
                }
                break;
            }
        }
    }

    private void doAction(int n) {
        if (!this.getConfirm(n)) {
            System.out.println("Skip level " + n);
            return;
        }
        for (TangoHost tangoHost : this.hosts) {
            try {
                switch (this.action) {
                    case 1: {
                        if (tangoHost.getName().startsWith("crate")) break;
                        tangoHost.stopServers(n);
                        break;
                    }
                    case 0: {
                        if (tangoHost.getName().startsWith("crate")) break;
                        tangoHost.startServers(n);
                    }
                }
                System.out.println("\tdone on " + tangoHost.getName());
            }
            catch (DevFailed devFailed) {
                System.out.println("\tfailed on " + tangoHost.getName());
                System.out.println(devFailed.errors[0].desc);
            }
        }
    }

    private boolean getConfirm(int n) {
        String string = "";
        System.out.println("\n");
        do {
            System.out.print(known_actions[this.action] + " all TANGO ds for level " + n + " ?  (y/n) ");
            byte[] byArray = new byte[80];
            try {
                int n2 = System.in.read(byArray);
                if (n2 <= 0) continue;
                string = new String(byArray).toLowerCase().trim();
            }
            catch (IOException iOException) {
                string = "no";
            }
        } while (!string.startsWith("n") && !string.startsWith("y"));
        return string.startsWith("y");
    }

    private void manageArgs(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            this.displaySyntax();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h")) {
                String string;
                if ((string = stringArray[++i]).toLowerCase().equals("all")) {
                    this.hosts = this.util.getTangoHostList();
                    continue;
                }
                this.hosts = new TangoHost[1];
                this.hosts[0] = new TangoHost(string, true);
                continue;
            }
            for (int j = 0; j < known_actions.length; ++j) {
                if (!stringArray[i].equals(known_actions[j])) continue;
                this.action = j;
            }
        }
        if (this.action == -1 || this.hosts == null) {
            this.displaySyntax();
            throw new Exception("Astor Exception");
        }
    }

    private void displaySyntax() {
        System.out.println("Syntax:");
        System.out.println("astor <mode>");
        System.out.println("mode:");
        System.out.println("    -rw    : Astor will be in Read/Write mode");
        System.out.println("    -db_ro : Database will be in Read Only mode");
        System.out.println("    -ro    : Astor will be in read only mode");
        System.out.println("\nor");
        System.out.println("astor <action> <-h hostname>");
        System.out.println();
        System.out.println("Actions:");
        System.out.println("\tstart: will start all servers");
        System.out.println("\tstop : will stop  all servers");
        System.out.println();
        System.out.println("hostname: host to do it \n");
        System.out.println("i.e.: astor start -h alpha    (starts all servers on host alpha)");
        System.out.println("or    astor start -h all      (starts all servers on all controled hosts)");
    }

    public AstorCmdLine(int n, String string) {
        boolean bl = true;
        try {
            switch (n) {
                case 0: {
                    bl = false;
                }
                case 1: {
                    DeviceProxy[] deviceProxyArray = this.getDeviceList(string);
                    if (deviceProxyArray.length == 0) {
                        Except.throw_exception((String)"NO_DEVICES", (String)("No device found for " + string), (String)("DbPollPanel.CmdLineSolution(" + string + ")"));
                    }
                    System.out.println("Polled Attributes For " + string);
                    this.displayAndConfirm(deviceProxyArray, bl);
                }
            }
        }
        catch (Exception exception) {
            Except.print_exception((Exception)exception);
        }
    }

    private void displayAndConfirm(DeviceProxy[] deviceProxyArray, boolean bl) throws DevFailed, IOException {
        byte[] byArray = new byte[80];
        for (DeviceProxy deviceProxy : deviceProxyArray) {
            System.out.println(deviceProxy.get_name());
            PolledAttr[] polledAttrArray = this.getPolledAttributes(deviceProxy);
            boolean[] blArray = new boolean[polledAttrArray.length];
            for (int i = 0; i < polledAttrArray.length; ++i) {
                blArray[i] = bl;
                if (bl) continue;
                System.out.print("   - " + polledAttrArray[i]);
                System.out.print("  -  Remove polling (y/n) ? ");
                int n = System.in.read(byArray);
                if (n <= 0) continue;
                blArray[i] = byArray[0] == 121 || byArray[0] == 89;
            }
            this.removePolling(deviceProxy, polledAttrArray, blArray);
        }
    }

    private void removePolling(DeviceProxy deviceProxy, PolledAttr[] polledAttrArray, boolean[] blArray) throws DevFailed {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < polledAttrArray.length; ++i) {
            if (blArray[i]) continue;
            arrayList.add(polledAttrArray[i].name);
            arrayList.add(polledAttrArray[i].period);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        DbDatum dbDatum = new DbDatum(PollAttProp);
        dbDatum.insert(stringArray);
        deviceProxy.put_property(new DbDatum[]{dbDatum});
        for (int i = 0; i < polledAttrArray.length; ++i) {
            if (!blArray[i]) continue;
            System.out.println(polledAttrArray[i].name + " ..... Polling Removed");
        }
    }

    private DeviceProxy[] getDeviceList(String string) throws DevFailed {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        DbServer dbServer = new DbServer(string);
        for (String string2 : stringArray = dbServer.get_class_list()) {
            String[] stringArray2 = dbServer.get_device_name(string2);
            arrayList.addAll(Arrays.asList(stringArray2));
        }
        String[] stringArray3 = new DeviceProxy[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray3[i] = new DeviceProxy((String)arrayList.get(i));
        }
        return stringArray3;
    }

    public PolledAttr[] getPolledAttributes(DeviceProxy deviceProxy) throws DevFailed {
        DbDatum dbDatum = deviceProxy.get_property(PollAttProp);
        String[] stringArray = dbDatum.extractStringArray();
        if (stringArray == null) {
            return new PolledAttr[0];
        }
        ArrayList<PolledAttr> arrayList = new ArrayList<PolledAttr>();
        for (int i = 0; i < stringArray.length; i += 2) {
            arrayList.add(new PolledAttr(stringArray[i], stringArray[i + 1]));
        }
        PolledAttr[] polledAttrArray = new PolledAttr[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            polledAttrArray[i] = (PolledAttr)arrayList.get(i);
        }
        return polledAttrArray;
    }

    class PolledAttr {
        String name;
        String period;

        public PolledAttr(String string, String string2) {
            this.name = string;
            this.period = string2;
        }

        public String toString() {
            return this.name + "   (" + this.period + " ms)";
        }
    }
}

