/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.util.LinkedList;
import java.util.Random;
import org.zeromq.EmbeddedLibraryTools;
import org.zeromq.ZMQException;

public class ZMQ {
    public static final int NOBLOCK = 1;
    public static final int DONTWAIT = 1;
    public static final int SNDMORE = 2;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int DEALER = 5;
    public static final int XREQ = 5;
    public static final int ROUTER = 6;
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int XPUB = 9;
    public static final int XSUB = 10;
    public static final int STREAMER = 1;
    public static final int FORWARDER = 2;
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;

    public static int getMajorVersion() {
        return ZMQ.version_major();
    }

    public static int getMinorVersion() {
        return ZMQ.version_minor();
    }

    public static int getPatchVersion() {
        return ZMQ.version_patch();
    }

    public static int getFullVersion() {
        return ZMQ.version_full();
    }

    public static int makeVersion(int n, int n2, int n3) {
        return ZMQ.make_version(n, n2, n3);
    }

    public static String getVersionString() {
        return String.format("%d.%d.%d", ZMQ.version_major(), ZMQ.version_minor(), ZMQ.version_patch());
    }

    public static void proxy(Socket socket, Socket socket2, Socket socket3) {
        if (ZMQ.version_full() < ZMQ.make_version(3, 2, 2)) {
            throw new UnsupportedOperationException();
        }
        ZMQ.run_proxy(socket, socket2, socket3);
    }

    public static int poll(PollItem[] pollItemArray, long l) {
        return ZMQ.poll(pollItemArray, pollItemArray.length, l);
    }

    public static int poll(PollItem[] pollItemArray, int n, long l) {
        return Poller.run_poll(pollItemArray, n, l);
    }

    protected static native int version_full();

    protected static native int version_major();

    protected static native int version_minor();

    protected static native int version_patch();

    protected static native int make_version(int var0, int var1, int var2);

    protected static native long ENOTSUP();

    protected static native long EPROTONOSUPPORT();

    protected static native long ENOBUFS();

    protected static native long ENETDOWN();

    protected static native long EADDRINUSE();

    protected static native long EADDRNOTAVAIL();

    protected static native long ECONNREFUSED();

    protected static native long EINPROGRESS();

    protected static native long EHOSTUNREACH();

    protected static native long EMTHREAD();

    protected static native long EFSM();

    protected static native long ENOCOMPATPROTO();

    protected static native long ETERM();

    protected static native long ENOTSOCK();

    private static native void run_proxy(Socket var0, Socket var1, Socket var2);

    public static Context context(int n) {
        return new Context(n);
    }

    static {
        if (!EmbeddedLibraryTools.LOADED_EMBEDDED_LIBRARY) {
            System.loadLibrary("jzmq");
        }
    }

    public static class Poller {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private Context context = null;
        private long timeout = -2L;
        private int size = 0;
        private int next = 0;
        private int used = 0;
        private PollItem[] items = null;
        private LinkedList<Integer> freeSlots = null;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(SelectableChannel selectableChannel) {
            return this.register(selectableChannel, 7);
        }

        public int register(Socket socket, int n) {
            return this.registerInternal(new PollItem(socket, n));
        }

        public int register(SelectableChannel selectableChannel, int n) {
            return this.registerInternal(new PollItem(selectableChannel, n));
        }

        public int register(PollItem pollItem) {
            return this.registerInternal(pollItem);
        }

        private int registerInternal(PollItem pollItem) {
            int n = -1;
            if (!this.freeSlots.isEmpty()) {
                n = this.freeSlots.remove();
            } else {
                if (this.next >= this.size) {
                    int n2 = this.size + 16;
                    PollItem[] pollItemArray = new PollItem[n2];
                    short[] sArray = new short[n2];
                    short[] sArray2 = new short[n2];
                    for (int i = 0; i < this.next; ++i) {
                        pollItemArray[i] = this.items[i];
                    }
                    this.size = n2;
                    this.items = pollItemArray;
                }
                n = this.next++;
            }
            this.items[n] = pollItem;
            ++this.used;
            return n;
        }

        public void unregister(Socket socket) {
            this.unregisterInternal(socket);
        }

        public void unregister(SelectableChannel selectableChannel) {
            this.unregisterInternal(selectableChannel);
        }

        private void unregisterInternal(Object object) {
            for (int i = 0; i < this.next; ++i) {
                PollItem pollItem = this.items[i];
                if (pollItem.socket != object && pollItem.channel != object) continue;
                this.items[i] = null;
                this.freeSlots.add(i);
                --this.used;
                break;
            }
        }

        public Socket getSocket(int n) {
            if (n < 0 || n >= this.next) {
                return null;
            }
            return this.items[n].socket;
        }

        public PollItem getItem(int n) {
            if (n < 0 || n >= this.next) {
                return null;
            }
            return this.items[n];
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long l) {
            if (l < -1L) {
                return;
            }
            this.timeout = l;
        }

        public int getSize() {
            return this.size;
        }

        public int getNext() {
            return this.next;
        }

        public long poll() {
            long l = -1L;
            if (this.timeout > -1L) {
                l = this.timeout;
            }
            return this.poll(l);
        }

        public int poll(long l) {
            if (l < -1L) {
                return 0;
            }
            if (this.size <= 0 || this.next <= 0) {
                return 0;
            }
            return Poller.run_poll(this.items, this.used, l);
        }

        public boolean pollin(int n) {
            return this.poll_mask(n, 1);
        }

        public boolean pollout(int n) {
            return this.poll_mask(n, 2);
        }

        public boolean pollerr(int n) {
            return this.poll_mask(n, 4);
        }

        public Poller(int n) {
            this(null, n);
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        protected Poller(Context context, int n) {
            this.context = context;
            this.size = n;
            this.next = 0;
            this.items = new PollItem[this.size];
            this.freeSlots = new LinkedList();
        }

        protected static native int run_poll(PollItem[] var0, int var1, long var2);

        private boolean poll_mask(int n, int n2) {
            if (n2 <= 0 || n < 0 || n >= this.next) {
                return false;
            }
            return (this.items[n].revents & n2) > 0;
        }
    }

    public static class PollItem {
        private Socket socket;
        private SelectableChannel channel;
        private int events;
        private int revents;

        public PollItem(Socket socket, int n) {
            this.socket = socket;
            this.events = n;
            this.revents = 0;
        }

        public PollItem(SelectableChannel selectableChannel, int n) {
            this.channel = selectableChannel;
            this.events = n;
            this.revents = 0;
        }

        public SelectableChannel getRawSocket() {
            return this.channel;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public boolean isError() {
            return (this.revents & 4) > 0;
        }

        public int readyOps() {
            return this.revents;
        }

        public boolean isReadable() {
            return (this.revents & 1) > 0;
        }

        public boolean isWritable() {
            return (this.revents & 2) > 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PollItem)) {
                return false;
            }
            PollItem pollItem = (PollItem)object;
            if (this.socket != null && this.socket == pollItem.socket) {
                return true;
            }
            return this.channel != null && this.channel == pollItem.channel;
        }
    }

    public static class Socket {
        private long socketHandle;
        private Context context = null;
        private static final int HWM = 1;
        private static final int SWAP = 3;
        private static final int AFFINITY = 4;
        private static final int IDENTITY = 5;
        private static final int SUBSCRIBE = 6;
        private static final int UNSUBSCRIBE = 7;
        private static final int RATE = 8;
        private static final int RECOVERY_IVL = 9;
        private static final int MCAST_LOOP = 10;
        private static final int SNDBUF = 11;
        private static final int RCVBUF = 12;
        private static final int RCVMORE = 13;
        private static final int FD = 14;
        private static final int EVENTS = 15;
        private static final int TYPE = 16;
        private static final int LINGER = 17;
        private static final int RECONNECT_IVL = 18;
        private static final int BACKLOG = 19;
        private static final int RECONNECT_IVL_MAX = 21;
        private static final int MAXMSGSIZE = 22;
        private static final int SNDHWM = 23;
        private static final int RCVHWM = 24;
        private static final int MULTICAST_HOPS = 25;
        private static final int RCVTIMEO = 27;
        private static final int SNDTIMEO = 28;
        private static final int IPV4ONLY = 31;
        private static final int ROUTER_MANDATORY = 33;
        private static final int KEEPALIVE = 34;
        private static final int KEEPALIVECNT = 35;
        private static final int KEEPALIVEIDLE = 36;
        private static final int KEEPALIVEINTVL = 37;

        public void close() {
            this.finalize();
        }

        public int getType() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1;
            }
            return (int)this.getLongSockopt(16);
        }

        public long getLinger() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(17);
        }

        public long getReconnectIVL() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return -1L;
            }
            return this.getLongSockopt(18);
        }

        public long getBacklog() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(19);
        }

        public long getReconnectIVLMax() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return -1L;
            }
            return this.getLongSockopt(21);
        }

        public long getMaxMsgSize() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(22);
        }

        public long getSndHWM() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(23);
        }

        public long getRcvHWM() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(24);
        }

        public long getHWM() {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(1);
        }

        public long getSwap() {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return -1L;
            }
            return this.getLongSockopt(3);
        }

        public long getAffinity() {
            return this.getLongSockopt(4);
        }

        public long getTCPKeepAliveSetting() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(34);
        }

        public long getTCPKeepAliveIdle() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(36);
        }

        public long getTCPKeepAliveInterval() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(37);
        }

        public long getTCPKeepAliveCount() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 2, 0)) {
                return -1L;
            }
            return this.getLongSockopt(35);
        }

        public byte[] getIdentity() {
            return this.getBytesSockopt(5);
        }

        public long getRate() {
            return this.getLongSockopt(8);
        }

        public long getRecoveryInterval() {
            return this.getLongSockopt(9);
        }

        public boolean hasMulticastLoop() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return false;
            }
            return this.getLongSockopt(10) != 0L;
        }

        public void setMulticastHops(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(25, l);
        }

        public long getMulticastHops() {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return 1L;
            }
            return this.getLongSockopt(25);
        }

        public void setReceiveTimeOut(int n) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return;
            }
            this.setLongSockopt(27, n);
        }

        public int getReceiveTimeOut() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return -1;
            }
            return (int)this.getLongSockopt(27);
        }

        public void setSendTimeOut(int n) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return;
            }
            this.setLongSockopt(28, n);
        }

        public int getSendTimeOut() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 2, 0)) {
                return -1;
            }
            return (int)this.getLongSockopt(28);
        }

        public long getSendBufferSize() {
            return this.getLongSockopt(11);
        }

        public long getReceiveBufferSize() {
            return this.getLongSockopt(12);
        }

        public boolean getIPv4Only() {
            return this.getLongSockopt(31) == 1L;
        }

        public boolean hasReceiveMore() {
            return this.getLongSockopt(13) != 0L;
        }

        public long getFD() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(14);
        }

        public long getEvents() {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return -1L;
            }
            return this.getLongSockopt(15);
        }

        public void setLinger(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 0)) {
                return;
            }
            this.setLongSockopt(17, l);
        }

        public void setReconnectIVL(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return;
            }
            this.setLongSockopt(18, l);
        }

        public void setBacklog(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(19, l);
        }

        public void setReconnectIVLMax(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(2, 1, 10)) {
                return;
            }
            this.setLongSockopt(21, l);
        }

        public void setMaxMsgSize(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(22, l);
        }

        public void setSndHWM(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(23, l);
        }

        public void setRcvHWM(long l) {
            if (ZMQ.version_full() < ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(24, l);
        }

        public void setHWM(long l) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(1, l);
        }

        public void setSwap(long l) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(3, l);
        }

        public void setAffinity(long l) {
            this.setLongSockopt(4, l);
        }

        public void setTCPKeepAlive(long l) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(34, l);
            }
        }

        public void setTCPKeepAliveCount(long l) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(35, l);
            }
        }

        public void setTCPKeepAliveInterval(long l) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(37, l);
            }
        }

        public void setTCPKeepAliveIdle(long l) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 2, 0)) {
                this.setLongSockopt(36, l);
            }
        }

        public void setIdentity(byte[] byArray) {
            this.setBytesSockopt(5, byArray);
        }

        public void subscribe(byte[] byArray) {
            this.setBytesSockopt(6, byArray);
        }

        public void unsubscribe(byte[] byArray) {
            this.setBytesSockopt(7, byArray);
        }

        public void setRate(long l) {
            this.setLongSockopt(8, l);
        }

        public void setRecoveryInterval(long l) {
            this.setLongSockopt(9, l);
        }

        public void setMulticastLoop(boolean bl) {
            if (ZMQ.version_full() >= ZMQ.make_version(3, 0, 0)) {
                return;
            }
            this.setLongSockopt(10, bl ? 1L : 0L);
        }

        public void setSendBufferSize(long l) {
            this.setLongSockopt(11, l);
        }

        public void setReceiveBufferSize(long l) {
            this.setLongSockopt(12, l);
        }

        public void setIPv4Only(boolean bl) {
            this.setLongSockopt(31, bl ? 1L : 0L);
        }

        public void setRouterMandatory(boolean bl) {
            this.setLongSockopt(33, bl ? 1L : 0L);
        }

        public native void bind(String var1);

        public int bindToRandomPort(String string) {
            return this.bindToRandomPort(string, 2000, 20000, 100);
        }

        public int bindToRandomPort(String string, int n) {
            return this.bindToRandomPort(string, n, 20000, 100);
        }

        public int bindToRandomPort(String string, int n, int n2) {
            return this.bindToRandomPort(string, n, n2, 100);
        }

        public int bindToRandomPort(String string, int n, int n2, int n3) {
            Random random = new Random();
            for (int i = 0; i < n3; ++i) {
                int n4 = random.nextInt(n2 - n + 1) + n;
                try {
                    this.bind(String.format("%s:%s", string, n4));
                    return n4;
                }
                catch (ZMQException zMQException) {
                    if ((long)zMQException.getErrorCode() == ZMQ.EADDRINUSE()) continue;
                    throw zMQException;
                }
            }
            throw new ZMQException("Could not bind socket to random port.", (int)ZMQ.EADDRINUSE());
        }

        public native void unbind(String var1);

        public native void connect(String var1);

        public native void disconnect(String var1);

        public boolean send(byte[] byArray, int n, int n2) {
            return this.send(byArray, n, byArray.length, n2);
        }

        public native boolean send(byte[] var1, int var2, int var3, int var4);

        public native boolean sendZeroCopy(ByteBuffer var1, int var2, int var3);

        public boolean send(byte[] byArray, int n) {
            return this.send(byArray, 0, byArray.length, n);
        }

        public boolean send(String string) {
            byte[] byArray = string.getBytes();
            return this.send(byArray, 0, byArray.length, 0);
        }

        public boolean sendMore(String string) {
            byte[] byArray = string.getBytes();
            return this.send(byArray, 0, byArray.length, 2);
        }

        public boolean send(String string, int n) {
            byte[] byArray = string.getBytes();
            return this.send(byArray, 0, byArray.length, n);
        }

        public native byte[] recv(int var1);

        public native int recv(byte[] var1, int var2, int var3, int var4);

        public native int recvZeroCopy(ByteBuffer var1, int var2, int var3);

        public final byte[] recv() {
            return this.recv(0);
        }

        public String recvStr() {
            return this.recvStr(0);
        }

        public String recvStr(int n) {
            byte[] byArray = this.recv(n);
            if (byArray == null) {
                return null;
            }
            return new String(byArray);
        }

        protected Socket(Context context, int n) {
            this.context = context;
            this.construct(context, n);
        }

        protected native void construct(Context var1, int var2);

        protected native void finalize();

        protected native long getLongSockopt(int var1);

        protected native byte[] getBytesSockopt(int var1);

        protected native void setLongSockopt(int var1, long var2);

        protected native void setBytesSockopt(int var1, byte[] var2);

        private long getSocketHandle() {
            return this.socketHandle;
        }
    }

    public static class Context {
        private long contextHandle;

        public void term() {
            this.finalize();
        }

        public Socket socket(int n) {
            return new Socket(this, n);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int n) {
            return new Poller(this, n);
        }

        protected Context(int n) {
            this.construct(n);
        }

        protected native void construct(int var1);

        protected native void finalize();

        private long getContextHandle() {
            return this.contextHandle;
        }
    }

    public static enum Error {
        ENOTSUP(ZMQ.ENOTSUP()),
        EPROTONOSUPPORT(ZMQ.EPROTONOSUPPORT()),
        ENOBUFS(ZMQ.ENOBUFS()),
        ENETDOWN(ZMQ.ENETDOWN()),
        EADDRINUSE(ZMQ.EADDRINUSE()),
        EADDRNOTAVAIL(ZMQ.EADDRNOTAVAIL()),
        ECONNREFUSED(ZMQ.ECONNREFUSED()),
        EINPROGRESS(ZMQ.EINPROGRESS()),
        EHOSTUNREACH(ZMQ.EHOSTUNREACH()),
        EMTHREAD(ZMQ.EMTHREAD()),
        EFSM(ZMQ.EFSM()),
        ENOCOMPATPROTO(ZMQ.ENOCOMPATPROTO()),
        ETERM(ZMQ.ETERM()),
        ENOTSOCK(ZMQ.ENOTSOCK());

        private final long code;

        private Error(long l) {
            this.code = l;
        }

        public long getCode() {
            return this.code;
        }

        public static Error findByCode(int n) {
            for (Error error : (Error[])Error.class.getEnumConstants()) {
                if (error.getCode() != (long)n) continue;
                return error;
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code:" + n);
        }
    }
}

