/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transaction;

import org.jacorb.transaction.Sleeper;
import org.omg.CORBA.INTERNAL;

public class Timer
extends Thread {
    private boolean stoped = true;
    private Channel[] channels;
    private int top;

    Timer(int max_of_chan) {
        this.channels = new Channel[max_of_chan];
        for (int i = 0; i < this.channels.length; ++i) {
            this.channels[i] = null;
        }
        this.top = 0;
        this.start();
    }

    private int find_free() {
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i] != null) continue;
            return i;
        }
        throw new INTERNAL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            if (!this.stoped) {
                this.stoped = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void go() {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            if (this.stoped) {
                this.stoped = false;
                this.resume();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add_channel(Sleeper slp, int time) {
        if (time <= 0) {
            throw new INTERNAL();
        }
        Channel ch = new Channel(slp, time);
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            int ix = this.find_free();
            if (ix > this.top) {
                throw new INTERNAL();
            }
            if (ix == this.top) {
                ++this.top;
            }
            this.channels[ix] = ch;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.go();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy_channel(int ix) {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            this.channels[ix] = null;
            if (this.top - 1 == ix) {
                --this.top;
            }
            if (this.top == 0) {
                this.stoped = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill_channel(Sleeper slp) {
        Channel[] channelArray = this.channels;
        synchronized (this.channels) {
            for (int i = 0; i < this.top; ++i) {
                if (this.channels[i] == null || this.channels[i].slp != slp) continue;
                this.destroy_channel(i);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void count() {
        int sz = this.top;
        for (int i = 0; i < sz; ++i) {
            if (this.channels[i] == null || this.channels[i].time == 0) continue;
            --this.channels[i].time;
            if (this.channels[i].time != 0) continue;
            this.channels[i].slp.wakeup();
        }
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.stoped) {
                    this.suspend();
                    continue;
                }
                Timer.sleep(1000L);
                this.count();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
    }

    class Channel {
        Sleeper slp;
        int time;

        Channel(Sleeper _slp, int _time) {
            this.slp = _slp;
            this.time = _time;
        }
    }
}

