/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.security.SecureRandom;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.security.ssl.sun_jsse.JSRandom;
import org.slf4j.Logger;

public class SSLRandom
implements Configurable {
    private JSRandom randomImpl;
    protected Logger logger;

    protected SecureRandom getSecureRandom() {
        SecureRandom result = null;
        if (this.randomImpl != null) {
            result = this.randomImpl.getSecureRandom();
        }
        return result;
    }

    @Override
    public void configure(Configuration config) throws ConfigurationException {
        this.logger = config.getLogger("jacorb.security.jsse");
        try {
            this.randomImpl = (JSRandom)config.getAttributeAsObject("jacorb.security.randomClassPlugin");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Using JSRandom implemented by " + this.randomImpl);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

