/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoAttConfigListener;
import fr.esrf.TangoApi.events.TangoAttConfigEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoAttConfig
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoAttConfig(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoAttConfigListener(ITangoAttConfigListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoAttConfigListener.class, listener);
        this.event_identifier = this.subscribe_att_config_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoAttConfigListener(ITangoAttConfigListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoAttConfigListener.class, listener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoAttConfig tangoAttConfig = this;
        if (EventUtil.graphicAvailable()) {
            Runnable do_work_later = new Runnable(){

                @Override
                public void run() {
                    TangoAttConfig.this.fireTangoAttConfigEvent(tangoAttConfig, eventData);
                }
            };
            SwingUtilities.invokeLater(do_work_later);
        } else {
            this.fireTangoAttConfigEvent(tangoAttConfig, eventData);
        }
    }

    private void fireTangoAttConfigEvent(TangoAttConfig tangoAttConfig, EventData eventData) {
        TangoAttConfigEvent tangoAttConfigEvent = new TangoAttConfigEvent(tangoAttConfig, eventData);
        ArrayList<EventListener> listeners = this.event_listeners.getListeners(ITangoAttConfigListener.class);
        for (EventListener eventListener : listeners) {
            ((ITangoAttConfigListener)eventListener).attConfig(tangoAttConfigEvent);
        }
    }
}

