/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoDs.TangoConst;
import java.util.Hashtable;

public class QualityUtilities {
    private Hashtable<AttrQuality, String> QUALITYTABLE = new Hashtable();
    private static QualityUtilities m_QualityUtilities = null;
    public static final String[] QUALITYIST = TangoConst.Tango_QualityName;

    private QualityUtilities() {
        this.QUALITYTABLE.put(AttrQuality.ATTR_VALID, QUALITYIST[0]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_INVALID, QUALITYIST[1]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_ALARM, QUALITYIST[2]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_CHANGING, QUALITYIST[3]);
        this.QUALITYTABLE.put(AttrQuality.ATTR_WARNING, QUALITYIST[4]);
    }

    public static QualityUtilities getInstance() {
        if (m_QualityUtilities == null) {
            m_QualityUtilities = new QualityUtilities();
        }
        return m_QualityUtilities;
    }

    public static Hashtable getQualityTable() {
        return QualityUtilities.getInstance().QUALITYTABLE;
    }

    public static AttrQuality getQualityForName(String string) {
        try {
            string = "ATTR_" + string.trim().toUpperCase();
            return (AttrQuality)AttrQuality.class.getField(string).get(string);
        }
        catch (Exception exception) {
            return AttrQuality.ATTR_INVALID;
        }
    }

    public static String getNameForQuality(AttrQuality attrQuality) {
        return ApiUtil.qualityName(attrQuality);
    }

    public static String getNameForQuality(short s) {
        return ApiUtil.qualityName(s);
    }

    public static boolean isQualityExist(String string) {
        return QualityUtilities.getInstance().QUALITYTABLE.containsValue(string);
    }
}

