/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

public class DbServerStructure {
    private String serverName;
    private ArrayList<TangoClass> classes = new ArrayList();

    public DbServerStructure(String string) throws DevFailed {
        DbServer dbServer = new DbServer(string);
        this.serverName = string;
        new DeviceProxy("dserver/" + string.toLowerCase());
        String[] stringArray = dbServer.get_class_list();
        this.classes.add(new TangoClass("DServer"));
        for (String string2 : stringArray) {
            this.classes.add(new TangoClass(string2));
        }
    }

    public String getName() {
        return this.serverName;
    }

    public ArrayList<TangoClass> getClasses() {
        return this.classes;
    }

    public void putInDatabase(String string) throws DevFailed {
        Database database = ApiUtil.get_db_obj(string);
        this.createTheServer(database);
        this.putProperties(database);
    }

    public boolean alreadyExists(String string) throws DevFailed {
        String string2 = "tango://" + string + "/";
        try {
            new DeviceProxy(string2 + "dserver/" + this.serverName.toLowerCase());
            return true;
        }
        catch (DevFailed devFailed) {
            for (TangoClass tangoClass : this.classes) {
                for (TangoDevice tangoDevice : tangoClass) {
                    try {
                        new DeviceProxy(string2 + tangoDevice.name);
                        return true;
                    }
                    catch (DevFailed devFailed2) {
                        if (devFailed2.errors[0].desc.contains("not defined in the database")) continue;
                        Except.re_throw_exception(devFailed2, "FailedToCheck", "Failed to check " + tangoDevice.name + "in " + string, "DbServerStructure.alreadyExists()");
                    }
                }
            }
            return false;
        }
    }

    private void createTheServer(Database database) throws DevFailed {
        ArrayList<DbDevInfo> arrayList = new ArrayList<DbDevInfo>();
        for (TangoClass tangoClass : this.classes) {
            for (TangoDevice tangoDevice : tangoClass) {
                arrayList.add(new DbDevInfo(tangoDevice.name, tangoClass.name, this.serverName));
            }
        }
        DbDevInfo[] dbDevInfoArray = new DbDevInfo[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            dbDevInfoArray[i] = (DbDevInfo)arrayList.get(i);
        }
        database.add_server(this.serverName, dbDevInfoArray);
    }

    private void putProperties(Database database) throws DevFailed {
        for (TangoClass tangoClass : this.classes) {
            tangoClass.putProperties(database);
            tangoClass.putAttributeProperties(database);
            for (TangoDevice tangoDevice : tangoClass) {
                tangoDevice.putProperties(database);
                tangoDevice.putAttributeProperties(database);
            }
        }
    }

    public void remove() throws DevFailed {
        this.remove(ApiUtil.get_db_obj().get_tango_host());
    }

    public void remove(String string) throws DevFailed {
        Database database = ApiUtil.get_db_obj(string);
        for (int i = this.classes.size() - 1; i >= 0; --i) {
            for (String[] stringArray : this.classes.get(i)) {
                database.delete_device(stringArray.name);
            }
        }
        for (TangoClass tangoClass : this.classes) {
            String[] stringArray;
            if (tangoClass.name.toLowerCase().equals("dserver") || (stringArray = database.get_device_name("*", tangoClass.name)).length != 0) continue;
            tangoClass.removeProperties(database);
        }
    }

    public String toString() {
        return this.serverName;
    }

    public class TangoProperty {
        String name;
        String[] values;

        TangoProperty(String string, String[] stringArray) {
            this.name = string;
            this.values = stringArray;
        }

        public String toString() {
            String string = this.name;
            if (this.values.length > 0) {
                string = string + ": " + this.values[0];
                if (this.values.length > 1) {
                    string = string + "...";
                }
            }
            return string;
        }
    }

    public class TangoAttribute
    extends ArrayList<TangoProperty> {
        String name;

        TangoAttribute(String string) {
            this.name = string;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public class TangoDevice
    extends DeviceProxy {
        String name;
        ArrayList<TangoProperty> properties;
        ArrayList<TangoAttribute> attributes;

        TangoDevice(String string) throws DevFailed {
            String[] stringArray;
            DbDatum[] dbDatumArray;
            super(string);
            this.properties = new ArrayList();
            this.attributes = new ArrayList();
            this.name = string;
            String[] stringArray2 = this.get_property_list("*");
            if (stringArray2.length > 0) {
                dbDatumArray = this.get_property(stringArray2);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (dbDatumArray[i].is_empty()) continue;
                    this.properties.add(new TangoProperty(stringArray2[i], dbDatumArray[i].extractStringArray()));
                }
            }
            dbDatumArray = ApiUtil.get_db_obj();
            for (String string2 : stringArray = dbDatumArray.get_device_attribute_list(string)) {
                DbAttribute dbAttribute = dbDatumArray.get_device_attribute_property(string, string2);
                for (Object e : dbAttribute) {
                    DbDatum dbDatum = (DbDatum)e;
                    if (dbDatum.is_empty()) continue;
                    TangoAttribute tangoAttribute = new TangoAttribute(string2);
                    tangoAttribute.add(new TangoProperty(dbDatum.name, dbDatum.extractStringArray()));
                    this.attributes.add(tangoAttribute);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<TangoProperty> getProperties() {
            return this.properties;
        }

        public ArrayList<TangoAttribute> getAttributes() {
            return this.attributes;
        }

        private void putProperties(Database database) throws DevFailed {
            if (this.properties.size() > 0) {
                DbDatum[] dbDatumArray = new DbDatum[this.properties.size()];
                int n = 0;
                for (TangoProperty tangoProperty : this.properties) {
                    dbDatumArray[n++] = new DbDatum(tangoProperty.name, tangoProperty.values);
                }
                database.put_device_property(this.name, dbDatumArray);
            }
        }

        private void putAttributeProperties(Database database) throws DevFailed {
            ArrayList<DbAttribute> arrayList = new ArrayList<DbAttribute>();
            if (this.attributes.size() > 0) {
                for (TangoAttribute tangoAttribute : this.attributes) {
                    if (tangoAttribute.size() <= 0) continue;
                    DbAttribute dbAttribute = new DbAttribute(this.name);
                    for (TangoProperty tangoProperty : tangoAttribute) {
                        dbAttribute.add(new DbDatum(tangoProperty.name, tangoProperty.values));
                    }
                    arrayList.add(dbAttribute);
                }
                DbAttribute[] dbAttributeArray = new DbAttribute[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    dbAttributeArray[i] = (DbAttribute)arrayList.get(i);
                }
                database.put_device_attribute_property(this.name, dbAttributeArray);
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public class TangoClass
    extends ArrayList<TangoDevice> {
        String name;
        ArrayList<TangoProperty> properties = new ArrayList();
        ArrayList<TangoAttribute> attributes = new ArrayList();

        private TangoClass(String string) throws DevFailed {
            Object[] objectArray;
            this.name = string;
            Database database = ApiUtil.get_db_obj();
            String[] stringArray = database.get_class_property_list(string, "*");
            if (stringArray.length > 0) {
                objectArray = database.get_class_property(string, stringArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (((DbDatum)objectArray[i]).is_empty()) continue;
                    this.properties.add(new TangoProperty(stringArray[i], ((DbDatum)objectArray[i]).extractStringArray()));
                }
            }
            Object[] objectArray2 = objectArray = database.get_class_attribute_list(string, "*");
            int n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray2[i];
                Object object2 = database.get_class_attribute_property(string, (String)object);
                Iterator iterator = ((Vector)object2).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    DbDatum dbDatum = (DbDatum)e;
                    if (dbDatum.is_empty()) continue;
                    TangoAttribute tangoAttribute = new TangoAttribute((String)object);
                    tangoAttribute.add(new TangoProperty(dbDatum.name, dbDatum.extractStringArray()));
                    this.attributes.add(tangoAttribute);
                }
            }
            for (Object object2 : objectArray2 = new DbServer(DbServerStructure.this.serverName).get_device_name(string)) {
                this.add(new TangoDevice((String)object2));
            }
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<TangoProperty> getProperties() {
            return this.properties;
        }

        public ArrayList<TangoAttribute> getAttributes() {
            return this.attributes;
        }

        private void putProperties(Database database) throws DevFailed {
            if (this.properties.size() > 0) {
                DbDatum[] dbDatumArray = new DbDatum[this.properties.size()];
                int n = 0;
                for (TangoProperty tangoProperty : this.properties) {
                    dbDatumArray[n++] = new DbDatum(tangoProperty.name, tangoProperty.values);
                }
                database.put_class_property(this.name, dbDatumArray);
            }
        }

        private void putAttributeProperties(Database database) throws DevFailed {
            ArrayList<DbAttribute> arrayList = new ArrayList<DbAttribute>();
            if (this.attributes.size() > 0) {
                for (TangoAttribute tangoAttribute : this.attributes) {
                    if (tangoAttribute.size() <= 0) continue;
                    DbAttribute dbAttribute = new DbAttribute(this.name);
                    for (TangoProperty tangoProperty : tangoAttribute) {
                        dbAttribute.add(new DbDatum(tangoProperty.name, tangoProperty.values));
                    }
                    arrayList.add(dbAttribute);
                }
                DbAttribute[] dbAttributeArray = new DbAttribute[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    dbAttributeArray[i] = (DbAttribute)arrayList.get(i);
                }
                database.put_class_attribute_property(this.name, dbAttributeArray);
            }
        }

        private void removeProperties(Database database) throws DevFailed {
            if (this.properties.size() > 0) {
                String[] stringArray = new String[this.properties.size()];
                for (int i = 0; i < this.properties.size(); ++i) {
                    stringArray[i] = this.properties.get((int)i).name;
                }
                database.delete_class_property(this.name, stringArray);
            }
            if (this.attributes.size() > 0) {
                for (TangoAttribute tangoAttribute : this.attributes) {
                    if (tangoAttribute.size() <= 0) continue;
                    String[] stringArray = new String[tangoAttribute.size()];
                    for (int i = 0; i < tangoAttribute.size(); ++i) {
                        stringArray[i] = ((TangoProperty)tangoAttribute.get((int)i)).name;
                    }
                    database.delete_class_attribute_property(this.name, tangoAttribute.name, stringArray);
                }
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

