/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tango_release;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class TangoClassRelease {
    String className;
    int idl = 0;
    String error = "";

    public TangoClassRelease(DbServer dbServer, String string) {
        this.className = string;
        try {
            String[] stringArray = this.getDevices(dbServer, string);
            if (stringArray.length > 0) {
                this.idl = new DeviceProxy(stringArray[0]).get_idl_version();
            } else {
                this.error = "No device found for class " + string + " on server " + dbServer.name();
            }
        }
        catch (DevFailed devFailed) {
            this.error = devFailed.errors[0].desc;
        }
    }

    public String[] getDevices(DbServer dbServer, String string) throws DevFailed {
        return dbServer.get_device_name(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\t");
        stringBuilder.append(this.className).append(" (");
        if (this.idl > 0) {
            stringBuilder.append("idl=").append(this.idl);
        } else {
            stringBuilder.append(this.error);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string = "VacGaugeServer/sr_c1-pen";
        String string2 = "VacGauge";
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        try {
            TangoClassRelease tangoClassRelease = new TangoClassRelease(new DbServer(string), string2);
            System.out.println(tangoClassRelease);
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

