/*
 * Decompiled with CFR 0.152.
 */
package admin.astor;

import admin.astor.AstorUtil;
import admin.astor.TangoHost;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class HostList
extends JDialog {
    private JDialog parent;
    private TangoHost[] hosts;
    private String selectedHostName;
    private int retVal = 0;
    private JList hostList;
    private JScrollPane jScrollPane1;
    private JLabel titleLabel;

    public HostList(JDialog jDialog) throws DevFailed {
        super((Dialog)jDialog, true);
        this.parent = jDialog;
        this.initComponents();
        this.hosts = AstorUtil.getInstance().getTangoHostList();
        String[] stringArray = new String[this.hosts.length];
        int n = 0;
        for (TangoHost tangoHost : this.hosts) {
            int n2 = tangoHost.name().lastIndexOf(47);
            stringArray[n++] = n2 > 0 ? tangoHost.name().substring(n2 + 1) : tangoHost.name();
        }
        this.hostList.setListData(stringArray);
        this.hostList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                HostList.this.listSelectionPerformed(mouseEvent);
            }
        });
        this.titleLabel.setText("Host List ");
        int n3 = 20 * stringArray.length;
        if (n3 > 600) {
            n3 = 600;
        }
        this.jScrollPane1.setPreferredSize(new Dimension(200, n3));
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.hostList = new JList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HostList.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Hosts in control system");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HostList.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HostList.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        this.jScrollPane1.setViewportView(this.hostList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private TangoHost getHost(String string) {
        String string2 = "tango/admin/" + string.toLowerCase();
        for (TangoHost tangoHost : this.hosts) {
            if (!tangoHost.name().toLowerCase().equals(string2)) continue;
            return tangoHost;
        }
        return null;
    }

    public ArrayList<String> getServerList() throws DevFailed {
        DeviceData deviceData = new DeviceData();
        deviceData.insert(this.selectedHostName);
        DeviceData deviceData2 = ApiUtil.get_db_obj().command_inout("DbGetHostServerList", deviceData);
        String[] stringArray = deviceData2.extractStringArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.startsWith("Starter/")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String getSelectedHostName() {
        return this.selectedHostName;
    }

    private void listSelectionPerformed(MouseEvent mouseEvent) {
        System.out.println("In listSelectionPerformed() " + mouseEvent.getClickCount());
        if (mouseEvent.getClickCount() == 2) {
            this.selectedHostName = (String)this.hostList.getSelectedValue();
            this.retVal = 0;
            this.doClose();
        }
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.selectedHostName = (String)this.hostList.getSelectedValue();
        this.retVal = 0;
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }
}

