/*
 * Decompiled with CFR 0.152.
 */
package jive3;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import jive.JiveUtils;
import jive.MultiLineCellEditor;

public class PropertyHistoryDlg
extends JFrame {
    private DevicePropertyHistPanel devicePropertyHistPanel;
    private DeviceAttributePropertyHistPanel deviceAttributePropertyHistPanel;
    private ClassPropertyHistPanel classPropertyHistPanel;
    private ClassAttributePropertyHistPanel classAttributePropertyHistPanel;
    private ObjectPropertyHistPanel objectPropertyHistPanel;
    private JTabbedPane tabPane = new JTabbedPane();

    PropertyHistoryDlg() {
        this.tabPane.setFont(ATKConstant.labelFont);
        this.devicePropertyHistPanel = new DevicePropertyHistPanel();
        this.tabPane.add((Component)this.devicePropertyHistPanel, "Device properties");
        this.deviceAttributePropertyHistPanel = new DeviceAttributePropertyHistPanel();
        this.tabPane.add((Component)this.deviceAttributePropertyHistPanel, "Device att. properties");
        this.classPropertyHistPanel = new ClassPropertyHistPanel();
        this.tabPane.add((Component)this.classPropertyHistPanel, "Class properties");
        this.classAttributePropertyHistPanel = new ClassAttributePropertyHistPanel();
        this.tabPane.add((Component)this.classAttributePropertyHistPanel, "Class att. properties");
        this.objectPropertyHistPanel = new ObjectPropertyHistPanel();
        this.tabPane.add((Component)this.objectPropertyHistPanel, "Free properties");
        this.getContentPane().add(this.tabPane);
        this.setTitle("Tango Database History");
    }

    public void viewDevicePropertyHistory(String string, String string2) {
        this.devicePropertyHistPanel.text1.setText(string);
        this.devicePropertyHistPanel.text2.setText(string2);
        this.devicePropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.devicePropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewDeviceAttPropertyHistory(String string, String string2, String string3) {
        this.deviceAttributePropertyHistPanel.text1.setText(string);
        this.deviceAttributePropertyHistPanel.text2.setText(string2);
        this.deviceAttributePropertyHistPanel.text3.setText(string3);
        this.deviceAttributePropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.deviceAttributePropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewClassAttPropertyHistory(String string, String string2, String string3) {
        this.classAttributePropertyHistPanel.text1.setText(string);
        this.classAttributePropertyHistPanel.text2.setText(string2);
        this.classAttributePropertyHistPanel.text3.setText(string3);
        this.classAttributePropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.classAttributePropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewFreePropertyHistory(String string, String string2) {
        this.objectPropertyHistPanel.text1.setText(string);
        this.objectPropertyHistPanel.text2.setText(string2);
        this.objectPropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.objectPropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void viewClassPropertyHistory(String string, String string2) {
        this.classPropertyHistPanel.text1.setText(string);
        this.classPropertyHistPanel.text2.setText(string2);
        this.classPropertyHistPanel.performSearch();
        this.tabPane.setSelectedComponent(this.classPropertyHistPanel);
        this.tabPane.getSelectedComponent().setVisible(true);
    }

    public void setDatabase(Database database, String string) {
        this.devicePropertyHistPanel.setDatabase(database);
        this.deviceAttributePropertyHistPanel.setDatabase(database);
        this.classPropertyHistPanel.setDatabase(database);
        this.classAttributePropertyHistPanel.setDatabase(database);
        this.objectPropertyHistPanel.setDatabase(database);
        if (database == null) {
            this.setTitle("Tango Database History [No connection]");
        } else {
            this.setTitle("Tango Database History [" + string + "]");
        }
    }

    public static void main(String[] stringArray) {
        Database database;
        PropertyHistoryDlg propertyHistoryDlg = new PropertyHistoryDlg();
        try {
            database = ApiUtil.get_db_obj();
        }
        catch (DevFailed devFailed) {
            JiveUtils.showTangoError(devFailed);
            database = null;
        }
        propertyHistoryDlg.setDatabase(database, "");
        propertyHistoryDlg.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen((Frame)propertyHistoryDlg);
        propertyHistoryDlg.setVisible(true);
    }

    class MultiLineCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        Color selColor = new Color(200, 200, 255);

        public MultiLineCellRenderer() {
            this.setEditable(false);
            this.setLineWrap(false);
            this.setWrapStyleWord(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                this.setText((String)object);
            } else {
                this.setText("");
            }
            if (bl) {
                this.setBackground(this.selColor);
            } else {
                this.setBackground(Color.white);
            }
            return this;
        }
    }

    class ClassAttributePropertyHistPanel
    extends AttributePropertyHistPanel {
        private String className;

        ClassAttributePropertyHistPanel() {
            this.className = null;
            this.initComponents("Class", "Attribute", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.className = this.text1.getText();
            String string = this.text2.getText();
            String string2 = this.text3.getText();
            try {
                DbHistory[] dbHistoryArray = this.db.get_class_attribute_property_history(this.className, string, string2);
                this.updateHistory(dbHistoryArray);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.className == null) {
                return;
            }
            int n = this.theTable.getSelectedRow();
            if (n >= 0) {
                String string = (String)this.dm.getValueAt(n, 1);
                String string2 = (String)this.dm.getValueAt(n, 2);
                String string3 = (String)this.dm.getValueAt(n, 3);
                if (string3.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int n2 = JOptionPane.showConfirmDialog(null, "Do you to reapply attribute property " + string2 + "?", "Confirm reapply", 0);
                    if (n2 == 0) {
                        DbAttribute dbAttribute = new DbAttribute(string);
                        dbAttribute.add(string2, JiveUtils.makeStringArray(string3));
                        this.db.put_class_attribute_property(this.className, dbAttribute);
                    }
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    class DeviceAttributePropertyHistPanel
    extends AttributePropertyHistPanel {
        private String devName;

        DeviceAttributePropertyHistPanel() {
            this.devName = null;
            this.initComponents("Device", "Attribute", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.devName = this.text1.getText();
            String string = this.text2.getText();
            String string2 = this.text3.getText();
            try {
                DbHistory[] dbHistoryArray = this.db.get_device_attribute_property_history(this.devName, string, string2);
                this.updateHistory(dbHistoryArray);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        @Override
        void reApply() {
            block8: {
                if (this.db == null) {
                    return;
                }
                if (this.devName == null) {
                    return;
                }
                int n = this.theTable.getSelectedRow();
                if (n >= 0) {
                    String string = (String)this.dm.getValueAt(n, 1);
                    String string2 = (String)this.dm.getValueAt(n, 2);
                    String string3 = (String)this.dm.getValueAt(n, 3);
                    if (string3.equals("DELETED")) {
                        JiveUtils.showJiveError("Cannot reapply deleted property");
                        return;
                    }
                    try {
                        int n2 = JOptionPane.showConfirmDialog(null, "Do you to reapply attribute property " + string2 + "?", "Confirm reapply", 0);
                        if (n2 != 0) break block8;
                        DbAttribute dbAttribute = new DbAttribute(string);
                        dbAttribute.add(string2, JiveUtils.makeStringArray(string3));
                        this.db.put_device_attribute_property(this.devName, dbAttribute);
                        n2 = JOptionPane.showConfirmDialog(null, "The device " + this.devName + " need to be restarted\nDo you want to do it now ?", "Confirm restart", 0);
                        if (n2 == 0) {
                            DbDevImportInfo dbDevImportInfo = this.db.import_device(this.devName);
                            DeviceProxy deviceProxy = new DeviceProxy("dserver/" + dbDevImportInfo.server);
                            DeviceData deviceData = new DeviceData();
                            deviceData.insert(this.devName);
                            deviceProxy.command_inout("DevRestart", deviceData);
                        }
                    }
                    catch (DevFailed devFailed) {
                        JiveUtils.showTangoError(devFailed);
                    }
                } else {
                    JiveUtils.showJiveError("Empty selection");
                }
            }
        }
    }

    abstract class AttributePropertyHistPanel
    extends JPanel
    implements ActionListener {
        Database db;
        String[] colName = new String[]{"Date", "Attribute", "Property name", "Value"};
        private MultiLineCellEditor editor;
        JTextField text1;
        JTextField text2;
        JTextField text3;
        private JLabel selectionLabel;
        private JButton searchButton;
        private JButton reApplyButton;
        DefaultTableModel dm;
        JTable theTable;

        AttributePropertyHistPanel() {
        }

        void initComponents(String string, String string2, String string3) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(null);
            jPanel.setPreferredSize(new Dimension(640, 85));
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(ATKConstant.labelFont);
            jLabel.setBounds(5, 5, 100, 25);
            jPanel.add(jLabel);
            this.text1 = new JTextField();
            this.text1.setMargin(JiveUtils.noMargin);
            this.text1.setFont(ATKConstant.labelFont);
            this.text1.setBounds(110, 5, 200, 25);
            jPanel.add(this.text1);
            JLabel jLabel2 = new JLabel(string2);
            jLabel2.setFont(ATKConstant.labelFont);
            jLabel2.setBounds(5, 30, 100, 25);
            jPanel.add(jLabel2);
            this.text2 = new JTextField();
            this.text2.setMargin(JiveUtils.noMargin);
            this.text2.setFont(ATKConstant.labelFont);
            this.text2.setBounds(110, 30, 200, 25);
            jPanel.add(this.text2);
            JLabel jLabel3 = new JLabel(string3);
            jLabel3.setFont(ATKConstant.labelFont);
            jLabel3.setBounds(5, 55, 100, 25);
            jPanel.add(jLabel3);
            this.text3 = new JTextField();
            this.text3.setMargin(JiveUtils.noMargin);
            this.text3.setFont(ATKConstant.labelFont);
            this.text3.setBounds(110, 55, 200, 25);
            jPanel.add(this.text3);
            this.searchButton = new JButton("Search");
            this.searchButton.setBounds(320, 5, 100, 25);
            this.searchButton.addActionListener(this);
            jPanel.add(this.searchButton);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.setPreferredSize(new Dimension(640, 35));
            this.reApplyButton = new JButton("Reapply selection");
            this.reApplyButton.setBounds(5, 5, 200, 25);
            this.reApplyButton.addActionListener(this);
            this.reApplyButton.setEnabled(false);
            jPanel2.add(this.reApplyButton);
            this.selectionLabel = new JLabel("Selection:");
            this.selectionLabel.setFont(ATKConstant.labelFont);
            this.selectionLabel.setHorizontalAlignment(2);
            this.selectionLabel.setBounds(210, 5, 400, 25);
            jPanel2.add(this.selectionLabel);
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel2, "South");
            this.dm = new DefaultTableModel(){

                public Class getColumnClass(int n) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.theTable = new JTable(this.dm);
            this.editor = new MultiLineCellEditor(this.theTable);
            this.theTable.setDefaultEditor(String.class, this.editor);
            MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer();
            this.theTable.setDefaultRenderer(String.class, multiLineCellRenderer);
            this.theTable.setSelectionMode(0);
            this.theTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    AttributePropertyHistPanel.this.refreshSelection();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    AttributePropertyHistPanel.this.refreshSelection();
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.theTable);
            this.add((Component)jScrollPane, "Center");
        }

        private void refreshTable() {
            this.editor.updateRows();
            this.theTable.getColumnModel().getColumn(0).setMaxWidth(140);
            this.theTable.getColumnModel().getColumn(0).setMinWidth(140);
            this.theTable.getColumnModel().getColumn(0).setPreferredWidth(140);
            this.theTable.getColumnModel().getColumn(3).setPreferredWidth(300);
            this.theTable.validate();
        }

        private void refreshSelection() {
            int n = this.theTable.getSelectedRow();
            if (n < 0) {
                this.selectionLabel.setText("Selection:");
                this.reApplyButton.setEnabled(false);
            } else {
                String string = (String)this.dm.getValueAt(n, 3);
                if (string.equals("DELETED")) {
                    this.selectionLabel.setText("Selection:");
                    this.reApplyButton.setEnabled(false);
                } else {
                    String string2 = (String)this.dm.getValueAt(n, 0);
                    String string3 = (String)this.dm.getValueAt(n, 1);
                    String string4 = (String)this.dm.getValueAt(n, 2);
                    this.selectionLabel.setText("Selection: " + string3 + "/" + string4 + " at " + string2);
                    this.reApplyButton.setEnabled(!JiveUtils.readOnly);
                }
            }
        }

        void setDatabase(Database database) {
            this.db = database;
            this.dm.setDataVector(new String[0][3], this.colName);
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            this.refreshTable();
        }

        void updateHistory(DbHistory[] dbHistoryArray) {
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            if (dbHistoryArray.length == 0) {
                JiveUtils.showJiveError("No data found.");
                this.dm.setDataVector(new String[0][3], this.colName);
            } else {
                Object[][] objectArray = new String[dbHistoryArray.length][4];
                for (int i = 0; i < dbHistoryArray.length; ++i) {
                    objectArray[i][0] = dbHistoryArray[i].getDate();
                    objectArray[i][1] = dbHistoryArray[i].getAttributeName();
                    objectArray[i][2] = dbHistoryArray[i].getName();
                    objectArray[i][3] = dbHistoryArray[i].isDeleted() ? "DELETED" : dbHistoryArray[i].getValue();
                }
                this.dm.setDataVector(objectArray, this.colName);
            }
            this.refreshTable();
        }

        abstract void performSearch();

        abstract void reApply();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.searchButton) {
                this.performSearch();
            } else if (object == this.reApplyButton) {
                this.reApply();
            }
        }
    }

    class ObjectPropertyHistPanel
    extends PropertyHistPanel {
        private String objName;

        ObjectPropertyHistPanel() {
            this.objName = null;
            this.initComponents("Object", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.objName = this.text1.getText();
            String string = this.text2.getText();
            try {
                DbHistory[] dbHistoryArray = this.db.get_property_history(this.objName, string);
                this.updateHistory(dbHistoryArray);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.objName == null) {
                return;
            }
            int n = this.theTable.getSelectedRow();
            if (n >= 0) {
                String string = (String)this.dm.getValueAt(n, 1);
                String string2 = (String)this.dm.getValueAt(n, 2);
                if (string2.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int n2 = JOptionPane.showConfirmDialog(null, "Do you to reapply free property " + string + "?", "Confirm reapply", 0);
                    if (n2 == 0) {
                        this.db.put_property(this.objName, JiveUtils.makeDbDatum(string, string2));
                    }
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    class ClassPropertyHistPanel
    extends PropertyHistPanel {
        private String className;

        ClassPropertyHistPanel() {
            this.className = null;
            this.initComponents("Class", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.className = this.text1.getText();
            String string = this.text2.getText();
            try {
                DbHistory[] dbHistoryArray = this.db.get_class_property_history(this.className, string);
                this.updateHistory(dbHistoryArray);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.className == null) {
                return;
            }
            int n = this.theTable.getSelectedRow();
            if (n >= 0) {
                String string = (String)this.dm.getValueAt(n, 1);
                String string2 = (String)this.dm.getValueAt(n, 2);
                if (string2.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int n2 = JOptionPane.showConfirmDialog(null, "Do you to reapply class property " + string + "?", "Confirm reapply", 0);
                    if (n2 == 0) {
                        this.db.put_class_property(this.className, JiveUtils.makeDbDatum(string, string2));
                    }
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    class DevicePropertyHistPanel
    extends PropertyHistPanel {
        private String devName;

        DevicePropertyHistPanel() {
            this.devName = null;
            this.initComponents("Device", "Property");
        }

        @Override
        void performSearch() {
            if (this.db == null) {
                return;
            }
            this.devName = this.text1.getText();
            String string = this.text2.getText();
            try {
                DbHistory[] dbHistoryArray = this.db.get_device_property_history(this.devName, string);
                this.updateHistory(dbHistoryArray);
            }
            catch (DevFailed devFailed) {
                JiveUtils.showTangoError(devFailed);
            }
        }

        @Override
        void reApply() {
            if (this.db == null) {
                return;
            }
            if (this.devName == null) {
                return;
            }
            int n = this.theTable.getSelectedRow();
            if (n >= 0) {
                String string = (String)this.dm.getValueAt(n, 1);
                String string2 = (String)this.dm.getValueAt(n, 2);
                if (string2.equals("DELETED")) {
                    JiveUtils.showJiveError("Cannot reapply deleted property");
                    return;
                }
                try {
                    int n2 = JOptionPane.showConfirmDialog(null, "Do you to reapply device property " + string + "?", "Confirm reapply", 0);
                    if (n2 == 0) {
                        this.db.put_device_property(this.devName, JiveUtils.makeDbDatum(string, string2));
                    }
                }
                catch (DevFailed devFailed) {
                    JiveUtils.showTangoError(devFailed);
                }
            } else {
                JiveUtils.showJiveError("Empty selection");
            }
        }
    }

    abstract class PropertyHistPanel
    extends JPanel
    implements ActionListener {
        Database db;
        String[] colName = new String[]{"Date", "Property name", "Value"};
        private MultiLineCellEditor editor;
        JTextField text1;
        JTextField text2;
        JLabel selectionLabel;
        private JButton searchButton;
        private JButton reApplyButton;
        DefaultTableModel dm;
        JTable theTable;

        PropertyHistPanel() {
        }

        void initComponents(String string, String string2) {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel(null);
            jPanel.setPreferredSize(new Dimension(640, 60));
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(ATKConstant.labelFont);
            jLabel.setBounds(5, 5, 100, 25);
            jPanel.add(jLabel);
            this.text1 = new JTextField();
            this.text1.setMargin(JiveUtils.noMargin);
            this.text1.setFont(ATKConstant.labelFont);
            this.text1.setBounds(110, 5, 200, 25);
            jPanel.add(this.text1);
            JLabel jLabel2 = new JLabel(string2);
            jLabel2.setFont(ATKConstant.labelFont);
            jLabel2.setBounds(5, 30, 100, 25);
            jPanel.add(jLabel2);
            this.text2 = new JTextField();
            this.text2.setMargin(JiveUtils.noMargin);
            this.text2.setFont(ATKConstant.labelFont);
            this.text2.setBounds(110, 30, 200, 25);
            jPanel.add(this.text2);
            this.searchButton = new JButton("Search");
            this.searchButton.setBounds(320, 5, 100, 25);
            this.searchButton.addActionListener(this);
            jPanel.add(this.searchButton);
            JPanel jPanel2 = new JPanel(null);
            jPanel2.setPreferredSize(new Dimension(640, 35));
            this.reApplyButton = new JButton("Reapply selection");
            this.reApplyButton.setBounds(5, 5, 200, 25);
            this.reApplyButton.addActionListener(this);
            this.reApplyButton.setEnabled(false);
            jPanel2.add(this.reApplyButton);
            this.selectionLabel = new JLabel("Selection:");
            this.selectionLabel.setFont(ATKConstant.labelFont);
            this.selectionLabel.setHorizontalAlignment(2);
            this.selectionLabel.setBounds(210, 5, 400, 25);
            jPanel2.add(this.selectionLabel);
            this.add((Component)jPanel, "North");
            this.add((Component)jPanel2, "South");
            this.dm = new DefaultTableModel(){

                public Class getColumnClass(int n) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.theTable = new JTable(this.dm);
            this.editor = new MultiLineCellEditor(this.theTable);
            this.theTable.setDefaultEditor(String.class, this.editor);
            MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer();
            this.theTable.setDefaultRenderer(String.class, multiLineCellRenderer);
            this.theTable.setSelectionMode(0);
            this.theTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    PropertyHistPanel.this.refreshSelection();
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    PropertyHistPanel.this.refreshSelection();
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.theTable);
            this.add((Component)jScrollPane, "Center");
        }

        private void refreshTable() {
            this.editor.updateRows();
            this.theTable.getColumnModel().getColumn(0).setMaxWidth(140);
            this.theTable.getColumnModel().getColumn(0).setMinWidth(140);
            this.theTable.getColumnModel().getColumn(0).setPreferredWidth(140);
            this.theTable.getColumnModel().getColumn(2).setPreferredWidth(300);
            this.theTable.validate();
        }

        private void refreshSelection() {
            int n = this.theTable.getSelectedRow();
            if (n < 0) {
                this.selectionLabel.setText("Selection:");
                this.reApplyButton.setEnabled(false);
            } else {
                String string = (String)this.dm.getValueAt(n, 2);
                if (string.equals("DELETED")) {
                    this.selectionLabel.setText("Selection:");
                    this.reApplyButton.setEnabled(false);
                } else {
                    String string2 = (String)this.dm.getValueAt(n, 0);
                    String string3 = (String)this.dm.getValueAt(n, 1);
                    this.selectionLabel.setText("Selection:" + string3 + " at " + string2);
                    this.reApplyButton.setEnabled(!JiveUtils.readOnly);
                }
            }
        }

        void setDatabase(Database database) {
            this.db = database;
            this.dm.setDataVector(new String[0][3], this.colName);
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            this.refreshTable();
        }

        void updateHistory(DbHistory[] dbHistoryArray) {
            this.selectionLabel.setText("Selection:");
            this.reApplyButton.setEnabled(false);
            if (dbHistoryArray.length == 0) {
                JiveUtils.showJiveError("No data found.");
                this.dm.setDataVector(new String[0][3], this.colName);
            } else {
                Object[][] objectArray = new String[dbHistoryArray.length][3];
                for (int i = 0; i < dbHistoryArray.length; ++i) {
                    objectArray[i][0] = dbHistoryArray[i].getDate();
                    objectArray[i][1] = dbHistoryArray[i].getName();
                    objectArray[i][2] = dbHistoryArray[i].isDeleted() ? "DELETED" : dbHistoryArray[i].getValue();
                }
                this.dm.setDataVector(objectArray, this.colName);
            }
            this.refreshTable();
        }

        abstract void performSearch();

        abstract void reApply();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.searchButton) {
                this.performSearch();
            } else if (object == this.reApplyButton) {
                this.reApply();
            }
        }
    }
}

