/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import jive.MultiLineCellRenderer;
import jive.MultiLineTextArea;

public class MultiLineCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    MultiLineTextArea textArea;
    JScrollPane textView;
    JTable table;

    public MultiLineCellEditor(JTable jTable) {
        this.table = jTable;
        MultiLineCellRenderer multiLineCellRenderer = new MultiLineCellRenderer();
        this.table.setDefaultRenderer(String.class, multiLineCellRenderer);
        this.textArea = new MultiLineTextArea(this);
        this.textView = new JScrollPane(this.textArea);
        this.textView.setVerticalScrollBarPolicy(21);
        this.textView.setHorizontalScrollBarPolicy(31);
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.updateRow(i);
        }
    }

    public MultiLineTextArea getTextArea() {
        return this.textArea;
    }

    private int cellHeight(int n, int n2) {
        if (n == this.table.getEditingRow() && n2 == this.table.getEditingColumn()) {
            return this.textArea.getPreferredSize().height + 4;
        }
        return this.table.getDefaultRenderer(String.class).getTableCellRendererComponent((JTable)this.table, (Object)this.table.getModel().getValueAt((int)n, (int)n2), (boolean)false, (boolean)false, (int)n, (int)n2).getPreferredSize().height + 1;
    }

    void updateRow(int n) {
        int n2 = 0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            int n3 = this.cellHeight(n, i);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        this.table.setRowHeight(n, n2);
    }

    public void updateRows() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.updateRow(i);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.textArea.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.textArea.rowEditing = n;
        this.textArea.columnEditing = n2;
        this.textArea.setEditable(n2 != 0);
        this.textArea.ignoreChange = true;
        this.textArea.setText(jTable.getValueAt(n, n2).toString());
        this.textArea.ignoreChange = false;
        jTable.setRowHeight(n, this.textArea.getPreferredSize().height + 4);
        return this.textView;
    }
}

