/*
 * Decompiled with CFR 0.152.
 */
package jive;

import java.io.StringReader;
import java.util.Vector;

public class ArgParser {
    private StringReader theStream;
    private char nextChar;
    private char currentChar;
    private boolean backSlashed;
    private int width;
    private int height;

    public ArgParser(String string) throws NumberFormatException {
        if (string == null || string.length() == 0) {
            throw new NumberFormatException("Empty argument, you must specify a value");
        }
        this.theStream = new StringReader(string);
        this.width = 0;
        this.height = 0;
        this.read_char();
        this.read_char();
    }

    public boolean parse_boolean() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_boolean(string);
        }
        throw new NumberFormatException("boolean value expected.");
    }

    public boolean[] parse_boolean_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        boolean[] blArray = new boolean[vector.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.get_boolean((String)vector.get(i));
        }
        return blArray;
    }

    public boolean[] parse_boolean_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        boolean[] blArray = new boolean[this.width * this.height];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.get_boolean((String)vector.get(i));
        }
        return blArray;
    }

    public byte parse_char() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_char(string);
        }
        throw new NumberFormatException("char value expected.");
    }

    public byte[] parse_char_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        byte[] byArray = new byte[vector.size()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.get_char((String)vector.get(i));
        }
        return byArray;
    }

    public byte[] parse_char_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        byte[] byArray = new byte[this.width * this.height];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.get_char((String)vector.get(i));
        }
        return byArray;
    }

    public short parse_uchar() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_uchar(string);
        }
        throw new NumberFormatException("unsigned char value expected.");
    }

    public short[] parse_uchar_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        short[] sArray = new short[vector.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.get_uchar((String)vector.get(i));
        }
        return sArray;
    }

    public short[] parse_uchar_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        short[] sArray = new short[this.width * this.height];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.get_uchar((String)vector.get(i));
        }
        return sArray;
    }

    public short parse_short() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_short(string);
        }
        throw new NumberFormatException("short value expected.");
    }

    public short[] parse_short_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        short[] sArray = new short[vector.size()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.get_short((String)vector.get(i));
        }
        return sArray;
    }

    public short[] parse_short_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        short[] sArray = new short[this.width * this.height];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = this.get_short((String)vector.get(i));
        }
        return sArray;
    }

    public int parse_ushort() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_ushort(string);
        }
        throw new NumberFormatException("unsigned short value expected.");
    }

    public int[] parse_ushort_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get_ushort((String)vector.get(i));
        }
        return nArray;
    }

    public int[] parse_ushort_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        int[] nArray = new int[this.width * this.height];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get_ushort((String)vector.get(i));
        }
        return nArray;
    }

    public int parse_long() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_long(string);
        }
        throw new NumberFormatException("Integer value expected.");
    }

    public int[] parse_long_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get_long((String)vector.get(i));
        }
        return nArray;
    }

    public int[] parse_long_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        int[] nArray = new int[this.width * this.height];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get_long((String)vector.get(i));
        }
        return nArray;
    }

    public long parse_ulong() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_ulong(string);
        }
        throw new NumberFormatException("unsigned long value expected.");
    }

    public long[] parse_ulong_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        long[] lArray = new long[vector.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.get_ulong((String)vector.get(i));
        }
        return lArray;
    }

    public long[] parse_ulong_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        long[] lArray = new long[this.width * this.height];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.get_ulong((String)vector.get(i));
        }
        return lArray;
    }

    public long parse_long64() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return this.get_long64(string);
        }
        throw new NumberFormatException("long64 value expected.");
    }

    public long[] parse_long64_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        long[] lArray = new long[vector.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.get_long64((String)vector.get(i));
        }
        return lArray;
    }

    public long[] parse_long64_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        long[] lArray = new long[this.width * this.height];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.get_long64((String)vector.get(i));
        }
        return lArray;
    }

    public float parse_float() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return Float.parseFloat(string);
        }
        throw new NumberFormatException("float value expected.");
    }

    public float[] parse_float_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        float[] fArray = new float[vector.size()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Float.parseFloat((String)vector.get(i));
        }
        return fArray;
    }

    public float[] parse_float_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        float[] fArray = new float[this.width * this.height];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Float.parseFloat((String)vector.get(i));
        }
        return fArray;
    }

    public double parse_double() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return Double.parseDouble(string);
        }
        throw new NumberFormatException("double value expected.");
    }

    public double[] parse_double_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        return dArray;
    }

    public double[] parse_double_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        double[] dArray = new double[this.width * this.height];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Double.parseDouble((String)vector.get(i));
        }
        return dArray;
    }

    public String parse_string() throws NumberFormatException {
        String string = this.read_word();
        if (string != null) {
            return string;
        }
        throw new NumberFormatException("string expected.");
    }

    public String[] parse_string_array() throws NumberFormatException {
        Vector vector = this.parse_array();
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public String[] parse_string_image() throws NumberFormatException {
        Vector vector = this.parse_image();
        String[] stringArray = new String[this.width * this.height];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.get(i);
        }
        return stringArray;
    }

    public int get_image_width() {
        return this.width;
    }

    public int get_image_height() {
        return this.height;
    }

    private void read_char() {
        this.backSlashed = false;
        try {
            int n = this.theStream.read();
            this.currentChar = this.nextChar;
            this.nextChar = n < 0 ? (char)'\u0000' : (char)n;
        }
        catch (Exception exception) {
            this.nextChar = '\u0000';
            this.currentChar = '\u0000';
        }
        if (this.currentChar == '\\' && this.nextChar == '\"') {
            this.read_char();
            this.backSlashed = true;
        }
    }

    private void jump_space() {
        while (this.currentChar <= ' ' && this.currentChar > '\u0000') {
            this.read_char();
        }
    }

    private String read_word() throws NumberFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        this.jump_space();
        if (this.currentChar == ',' || this.currentChar == '[' || this.currentChar == ']') {
            stringBuffer.append(this.currentChar);
            this.read_char();
            return stringBuffer.toString();
        }
        if (this.currentChar == '\"' && !this.backSlashed) {
            this.read_char();
            while ((this.currentChar != '\"' || this.backSlashed) && this.currentChar != '\u0000' && this.currentChar != '\n') {
                stringBuffer.append(this.currentChar);
                this.read_char();
            }
            if (this.currentChar == '\u0000' || this.currentChar == '\n') {
                NumberFormatException numberFormatException = new NumberFormatException("Unterminated string.");
                throw numberFormatException;
            }
            this.read_char();
            return stringBuffer.toString();
        }
        while (this.currentChar > ' ' && this.currentChar != '[' && this.currentChar != ']' && this.currentChar != ',') {
            stringBuffer.append(this.currentChar);
            this.read_char();
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    private void jump_sep(String string) throws NumberFormatException {
        String string2 = this.read_word();
        if (string2 == null) {
            throw new NumberFormatException("Separator " + string + " expected.");
        }
        if (!string2.equals(string)) {
            throw new NumberFormatException("Separator " + string + " expected.");
        }
    }

    private boolean is_array_end() {
        if (this.currentChar == '\u0000') {
            return true;
        }
        return this.currentChar == ']';
    }

    private Vector parse_array() throws NumberFormatException {
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        this.jump_space();
        if (this.currentChar == '[') {
            bl = true;
            this.jump_sep("[");
            this.jump_space();
        }
        while (!this.is_array_end()) {
            vector.add(this.read_word());
            this.jump_space();
            if (this.is_array_end()) continue;
            this.jump_sep(",");
            this.jump_space();
        }
        if (bl) {
            this.jump_sep("]");
        }
        return vector;
    }

    private Vector parse_image() throws NumberFormatException {
        Vector vector = this.parse_array();
        this.jump_space();
        this.width = vector.size();
        this.height = 1;
        while (this.currentChar == '[') {
            Vector vector2 = this.parse_array();
            if (vector2.size() != this.width) {
                throw new NumberFormatException("All lines in an image must have the same size.");
            }
            vector.addAll(vector2);
            ++this.height;
            this.jump_space();
        }
        return vector;
    }

    private boolean get_boolean(String string) throws NumberFormatException {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
            return false;
        }
        throw new NumberFormatException("invalid boolean value " + string + " [true,false or 0,1].");
    }

    private long get_number(String string, String string2, long l, long l2) throws NumberFormatException {
        long l3;
        int n = 10;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            string = string.substring(2);
            n = 16;
        }
        if ((l3 = Long.parseLong(string, n)) < l || l3 > l2) {
            throw new NumberFormatException(string2 + " value " + l3 + " out of range [" + l + "," + l2 + "].");
        }
        return l3;
    }

    private byte get_char(String string) throws NumberFormatException {
        if (string.startsWith("'")) {
            if (string.endsWith("'") && string.length() == 3) {
                return (byte)string.charAt(1);
            }
            throw new NumberFormatException("Invalid char value for input string " + string);
        }
        return (byte)this.get_number(string, "char", -128L, 127L);
    }

    private short get_uchar(String string) throws NumberFormatException {
        return (short)this.get_number(string, "unsigned char", 0L, 255L);
    }

    private short get_short(String string) throws NumberFormatException {
        return (short)this.get_number(string, "short", -32768L, 32767L);
    }

    private int get_ushort(String string) throws NumberFormatException {
        return (int)this.get_number(string, "unsigned short", 0L, 65535L);
    }

    private int get_long(String string) throws NumberFormatException {
        return (int)this.get_number(string, "long", Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private long get_ulong(String string) throws NumberFormatException {
        return this.get_number(string, "unsigned long", 0L, 0xFFFFFFFFL);
    }

    private long get_long64(String string) throws NumberFormatException {
        return this.get_number(string, "long64", Long.MIN_VALUE, Long.MAX_VALUE);
    }

    private static void print_array(boolean[] blArray) {
        System.out.print("Length=" + blArray.length + ": ");
        for (int i = 0; i < blArray.length; ++i) {
            System.out.print(blArray[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(byte[] byArray) {
        System.out.print("Length=" + byArray.length + ": ");
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print(byArray[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(short[] sArray) {
        System.out.print("Length=" + sArray.length + ": ");
        for (int i = 0; i < sArray.length; ++i) {
            System.out.print(sArray[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(int[] nArray) {
        System.out.print("Length=" + nArray.length + ": ");
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print(nArray[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(float[] fArray) {
        System.out.print("Length=" + fArray.length + ": ");
        for (int i = 0; i < fArray.length; ++i) {
            System.out.print(fArray[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(double[] dArray) {
        System.out.print("Length=" + dArray.length + ": ");
        for (int i = 0; i < dArray.length; ++i) {
            System.out.print(dArray[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(String[] stringArray) {
        System.out.print("Length=" + stringArray.length + ": ");
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.print(stringArray[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        ArgParser argParser = new ArgParser("true");
        ArgParser argParser2 = new ArgParser("7,8,127.123,1e6,57.8");
        ArgParser argParser3 = new ArgParser("[1.0,2,3.5] [4,5.7,6] [7,8,127.123] [10.1,11.2,12]");
        ArgParser argParser4 = new ArgParser("toto,\"ta ta\",titi");
        ArgParser argParser5 = new ArgParser("[34,5] [toto,\"ta ta\",titi]");
        ArgParser argParser6 = new ArgParser("[7,8,-9,16,5700,0x10]");
        ArgParser argParser7 = new ArgParser("\"test with \\\" ,quote\"");
        ArgParser argParser8 = new ArgParser("\\\"quote\\\"");
        try {
            System.out.println(argParser.parse_boolean());
            ArgParser.print_array(argParser2.parse_float_array());
            ArgParser.print_array(argParser3.parse_double_image());
            ArgParser.print_array(argParser4.parse_string_array());
            ArgParser.print_array(argParser5.parse_long_array());
            ArgParser.print_array(argParser5.parse_string_array());
            ArgParser.print_array(argParser6.parse_short_array());
            System.out.println(argParser7.parse_string());
            System.out.println(argParser8.parse_string());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Getting error:" + numberFormatException);
        }
    }
}

