/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.logviewer;

import fr.esrf.logviewer.MyTableModel;
import fr.esrf.logviewer.XMLFileHandler;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class LoadXMLAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(LoadXMLAction.class);
    private final JFrame mParent;
    private final JFileChooser mChooser = new JFileChooser();
    private final XMLReader mParser;
    private final XMLFileHandler mHandler;

    LoadXMLAction(JFrame jFrame, MyTableModel myTableModel) throws SAXException, ParserConfigurationException {
        this.mChooser.setMultiSelectionEnabled(false);
        this.mChooser.setFileSelectionMode(0);
        this.mParent = jFrame;
        this.mHandler = new XMLFileHandler(myTableModel);
        this.mParser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        this.mParser.setContentHandler(this.mHandler);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        LOG.info((Object)"load file called");
        if (this.mChooser.showOpenDialog(this.mParent) == 0) {
            LOG.info((Object)"Need to load a file");
            File file = this.mChooser.getSelectedFile();
            LOG.info((Object)("loading the contents of " + file.getAbsolutePath()));
            try {
                int n = this.loadFile(file.getAbsolutePath());
                JOptionPane.showMessageDialog(this.mParent, "Loaded " + n + " events.", "CHAINSAW", 1);
            }
            catch (Exception exception) {
                LOG.warn((Object)"caught an exception loading the file", (Throwable)exception);
                JOptionPane.showMessageDialog(this.mParent, "Error parsing file - " + exception.getMessage(), "CHAINSAW", 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int loadFile(String string) throws SAXException, IOException {
        XMLReader xMLReader = this.mParser;
        synchronized (xMLReader) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
            stringBuffer.append("<!DOCTYPE log4j:eventSet ");
            stringBuffer.append("[<!ENTITY data SYSTEM \"file:///");
            stringBuffer.append(string);
            stringBuffer.append("\">]>\n");
            stringBuffer.append("<log4j:eventSet xmlns:log4j=\"Claira\">\n");
            stringBuffer.append("&data;\n");
            stringBuffer.append("</log4j:eventSet>\n");
            InputSource inputSource = new InputSource(new StringReader(stringBuffer.toString()));
            this.mParser.parse(inputSource);
            return this.mHandler.getNumEvents();
        }
    }
}

