/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.Dynamics;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDValueProgram;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import java.awt.Color;
import java.awt.Font;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

class LXFileLoader {
    private int CrtLine;
    private int StartLine;
    char CurrentChar;
    String version;
    private String word;
    FileReader f;

    public LXFileLoader(FileReader fileReader) {
        this.f = fileReader;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void read_char() throws IOException {
        this.CurrentChar = this.f.ready() ? (char)this.f.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    String read_safe_word() throws IOException {
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    String read_safe_full_word() throws IOException {
        this.word = this.read_word(true);
        if (this.word == null) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return this.word;
    }

    String read_line() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.CurrentChar != '\n' && this.CurrentChar != '\u0000') {
            if (this.CurrentChar != '\u0000') {
                stringBuffer.append(this.CurrentChar);
            }
            this.read_char();
        }
        if (stringBuffer.length() == 0) {
            throw new IOException("Unexpected end of file " + this.CrtLine);
        }
        return stringBuffer.toString();
    }

    void jump_space() throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char();
        }
    }

    String read_word(boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.jump_space();
        this.StartLine = this.CrtLine;
        if (!bl && this.CurrentChar == ';') {
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            return stringBuffer.toString();
        }
        if (this.CurrentChar == '\"') {
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            while (this.CurrentChar != '\"' && this.CurrentChar != '\u0000') {
                stringBuffer.append(this.CurrentChar);
                this.read_char();
            }
            if (this.CurrentChar == '\u0000' || this.CurrentChar == '\n') {
                IOException iOException = new IOException("String too long at line " + this.StartLine);
                throw iOException;
            }
            stringBuffer.append(this.CurrentChar);
            this.read_char();
            return stringBuffer.toString();
        }
        if (bl) {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n') {
                stringBuffer.append(this.CurrentChar);
                this.read_char();
            }
        } else {
            while (this.CurrentChar > ' ' && this.CurrentChar != '\n' && this.CurrentChar != ';') {
                stringBuffer.append(this.CurrentChar);
                this.read_char();
            }
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getCurrentLine() {
        return this.StartLine;
    }

    int read_int() throws IOException {
        int n;
        String string = this.read_safe_word();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad integer format at line " + this.CrtLine + "\n" + numberFormatException.getMessage());
        }
        return n;
    }

    int read_int_16() throws IOException {
        int n;
        String string = this.read_safe_word();
        try {
            n = (int)Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad integer format at line " + this.CrtLine + "\n" + numberFormatException.getMessage());
        }
        return n;
    }

    double read_double() throws IOException {
        double d;
        String string = this.read_safe_word();
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad double format at line " + this.CrtLine + "\n" + numberFormatException.getMessage());
        }
        return d;
    }

    Color read_color() throws IOException {
        String string = this.read_safe_word();
        String string2 = string.substring(0, 2);
        String string3 = string.substring(2, 4);
        String string4 = string.substring(4, 6);
        if (string2.equals("-1")) {
            string2 = "FF";
        }
        if (string3.equals("-1")) {
            string3 = "FF";
        }
        if (string4.equals("-1")) {
            string4 = "FF";
        }
        try {
            return new Color(Integer.parseInt(string2, 16), Integer.parseInt(string3, 16), Integer.parseInt(string4, 16));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad color format at line " + this.CrtLine + "\n" + numberFormatException.getMessage());
        }
    }

    void jump_colon() throws IOException {
        String string = this.read_safe_word();
        if (!string.equals(";")) {
            throw new IOException("';' expected at line " + this.CrtLine + "\n");
        }
    }

    Font read_font() throws IOException {
        this.jump_space();
        String string = this.read_line();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() < 7) {
            return new Font(string, 0, 10);
        }
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        if (string3.equals("bold")) {
            n2 |= 1;
        }
        if (string4.equals("i")) {
            n2 |= 2;
        }
        try {
            n = Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            n = 12;
        }
        return new Font(string2, n2, n);
    }

    void jump_dynamics() throws IOException {
        this.jump_space();
        if (this.CurrentChar == 'd') {
            this.word = this.read_safe_word();
            while (!this.word.equals("end")) {
                this.word = this.read_safe_word();
            }
            this.read_safe_word();
        }
    }

    Dynamics read_dynamics() throws IOException {
        this.jump_space();
        if (this.CurrentChar == 'd') {
            String string;
            Dynamics dynamics = new Dynamics();
            this.read_safe_word();
            while (true) {
                if ((string = this.read_safe_word()).equals("_dynClassName")) {
                    dynamics.dynClassName = this.read_safe_word();
                    continue;
                }
                if (string.equals("_dynValueFlag")) {
                    dynamics.dynValueFlag = this.read_int();
                    continue;
                }
                if (string.equals("_dynSensitive")) {
                    dynamics.dynSensitive = this.read_int();
                    continue;
                }
                if (string.equals("_dynMinColor")) {
                    dynamics.dynMinColor = this.read_int();
                    continue;
                }
                if (string.equals("_dynMaxColor")) {
                    dynamics.dynMaxColor = this.read_int();
                    continue;
                }
                if (string.equals("_dynNumColors")) {
                    dynamics.dynNumColors = this.read_int();
                    continue;
                }
                if (string.equals("_dynColorIndicator")) {
                    dynamics.dynColorIndicator = this.read_int();
                    continue;
                }
                if (string.equals("_dynUseThreshold")) {
                    dynamics.dynUseThreshold = this.read_int();
                    continue;
                }
                if (string.equals("_dynTextFormat")) {
                    this.jump_space();
                    dynamics.dynTextFormat = this.read_line();
                    continue;
                }
                if (string.equals("_dynMinimum")) {
                    dynamics.dynMinimum = this.read_double();
                    continue;
                }
                if (string.equals("_dynMaximum")) {
                    dynamics.dynMaximum = this.read_double();
                    continue;
                }
                if (string.equals("_dynUserMinimum")) {
                    dynamics.dynUserMinimum = this.read_double();
                    continue;
                }
                if (string.equals("_dynUserMaximum")) {
                    dynamics.dynUserMaximum = this.read_double();
                    continue;
                }
                if (string.equals("_dynValue")) {
                    dynamics.dynValue = this.read_double();
                    continue;
                }
                if (!string.equals("_dynThreshold")) break;
                dynamics.dynThreshold = this.read_double();
            }
            if (string.equals("end")) {
                this.read_safe_word();
                return dynamics;
            }
            throw new IOException("Invalid loox dynamics keyword :" + string);
        }
        return null;
    }

    JDObject parseLxRectangle(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        double d = this.read_double();
        double d2 = this.read_double();
        double d3 = this.read_double();
        double d4 = this.read_double();
        lXObject.setBounds(d, d2, d3, d4);
        if (this.CurrentChar != '\n') {
            lXObject.shadowWidth = this.read_int();
            lXObject.invertShadow = this.read_int() != 0;
        }
        return new JDRectangle(lXObject);
    }

    JDObject parseLxLine(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        int n = this.read_int();
        if (n != 2) {
            throw new IOException("Only 2 point are allowed for line object, line " + this.CrtLine + "\n");
        }
        double d = this.read_double();
        double d2 = this.read_double();
        double d3 = this.read_double();
        double d4 = this.read_double();
        lXObject.setBounds(d, d2, d3, d4);
        return new JDLine(lXObject, d + lXObject.px, d2 + lXObject.py, d3 + lXObject.px, d4 + lXObject.py, lXObject.lineArrow);
    }

    JDObject parseLxPolyline(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        boolean bl = this.read_int() == 1;
        boolean bl2 = this.read_int() == 1;
        this.read_int();
        lXObject.shadowWidth = this.read_int();
        lXObject.invertShadow = this.read_int() != 0;
        this.read_int();
        this.read_int();
        this.read_int();
        int n = this.read_int();
        if (bl) {
            this.read_double();
            this.read_double();
            double[] dArray = new double[n - 1];
            double[] dArray2 = new double[n - 1];
            for (int i = 0; i < n - 1; ++i) {
                dArray[i] = this.read_double() + lXObject.px;
                dArray2[i] = this.read_double() + lXObject.py;
            }
            return new JDSpline(lXObject, dArray, dArray2, bl2);
        }
        double[] dArray = new double[n];
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.read_double() + lXObject.px;
            dArray3[i] = this.read_double() + lXObject.py;
        }
        return new JDPolyline(lXObject, dArray, dArray3, bl2);
    }

    JDObject parseLxEllipse(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        double d = this.read_double();
        double d2 = this.read_double();
        double d3 = this.read_double();
        double d4 = this.read_double();
        lXObject.setBounds(d, d2, d3, d4);
        int n = this.read_int() / 64;
        int n2 = this.read_int() / 64;
        return new JDEllipse(lXObject, 360 - (n + n2), n2, lXObject.arcMode);
    }

    JDObject parseLxText(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        lXObject.px += this.read_double();
        lXObject.py += this.read_double();
        lXObject.fillStyle = 0;
        this.read_int();
        this.read_char();
        this.read_char();
        String string = this.read_line();
        string = string.replace('\u0001', '\n');
        return new JDLabel(lXObject, string);
    }

    JDObject parseLxPara(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        this.read_int();
        lXObject.shadowWidth = this.read_int();
        lXObject.invertShadow = this.read_int() != 0;
        this.read_int();
        this.read_int();
        int n = 4;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.read_double() + lXObject.px;
            dArray2[i] = this.read_double() + lXObject.py;
        }
        return new JDPolyline(lXObject, dArray, dArray2, true);
    }

    JDObject parseLxImage(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        this.read_int();
        double d = this.read_double();
        double d2 = this.read_double();
        double d3 = this.read_double();
        double d4 = this.read_double();
        String string = this.read_safe_word();
        lXObject.setBounds(d, d2, d3, d4);
        return new JDImage(lXObject, string);
    }

    private Vector findObjects(String string, Vector vector) {
        int n = vector.size();
        Vector<JDObject> vector2 = new Vector<JDObject>();
        for (int i = 0; i < n; ++i) {
            JDObject jDObject = (JDObject)vector.get(i);
            if (jDObject instanceof JDGroup) {
                if (jDObject.name.equals(string)) {
                    vector2.add(jDObject);
                    continue;
                }
                Vector vector3 = ((JDGroup)jDObject).getChildren();
                Vector vector4 = this.findObjects(string, vector3);
                vector2.addAll(vector4);
                continue;
            }
            boolean bl = jDObject.name.equals(string);
            if (!bl) continue;
            vector2.add((JDObject)vector.get(i));
        }
        return vector2;
    }

    JDObject parseLxGroup(LXObject lXObject) throws IOException {
        JDObject jDObject;
        Dynamics dynamics = this.read_dynamics();
        double d = this.read_double();
        double d2 = this.read_double();
        double d3 = this.read_double();
        double d4 = this.read_double();
        lXObject.setBounds(d, d2, d3, d4);
        Vector<JDObject> vector = new Vector<JDObject>();
        while ((jDObject = this.parseObject(true)) != null) {
            vector.add(jDObject);
            jDObject.translate(lXObject.px, lXObject.py);
        }
        JDGroup jDGroup = new JDGroup(lXObject, vector);
        if (dynamics != null) {
            if (dynamics.dynClassName.equals("multipleStatesClass")) {
                int n = (int)dynamics.dynMinimum;
                int n2 = (int)dynamics.dynMaximum;
                for (int i = n; i <= n2; ++i) {
                    String string = Integer.toString(i);
                    Vector vector2 = this.findObjects(string, vector);
                    if (vector2.size() == 0) {
                        System.out.println("LXFileLoader.parseLxGroup() : Warning, sub-object '" + string + "' not found in " + lXObject.name);
                        continue;
                    }
                    JDValueProgram jDValueProgram = new JDValueProgram(3);
                    jDValueProgram.addNewEntry();
                    jDValueProgram.setDefaultMapping("false");
                    jDValueProgram.setMappingAt(0, "true");
                    jDValueProgram.setValueAt(0, string);
                    for (int j = 0; j < vector2.size(); ++j) {
                        ((JDObject)vector2.get(j)).setVisibilityMapper(jDValueProgram.copy());
                    }
                }
                ((JDObject)jDGroup).setMinValue(n);
                ((JDObject)jDGroup).setMaxValue(n2);
                ((JDObject)jDGroup).setInitValue((int)dynamics.dynValue);
                jDGroup.setInteractive(dynamics.dynSensitive == 1);
                jDGroup.setValueChangeMode(0);
            } else {
                System.out.println("LXFileLoader.parseLxGroup() : Warning, " + dynamics.dynClassName + " not suported.");
            }
        }
        return jDGroup;
    }

    JDObject parseLxEndGroup(LXObject lXObject) throws IOException {
        this.jump_dynamics();
        this.read_double();
        this.read_double();
        this.read_double();
        this.read_double();
        return null;
    }

    JDObject parseObject(boolean bl) throws IOException {
        this.jump_space();
        if (this.CurrentChar == '\u0000') {
            return null;
        }
        LXObject lXObject = new LXObject();
        lXObject.parse(this, bl);
        switch (lXObject.type) {
            case 0: {
                return this.parseLxPolyline(lXObject);
            }
            case 1: {
                return this.parseLxText(lXObject);
            }
            case 2: {
                return this.parseLxEndGroup(lXObject);
            }
            case 3: {
                return this.parseLxGroup(lXObject);
            }
            case 4: {
                return this.parseLxRectangle(lXObject);
            }
            case 5: {
                return this.parseLxEllipse(lXObject);
            }
            case 6: {
                return this.parseLxLine(lXObject);
            }
            case 11: {
                return this.parseLxImage(lXObject);
            }
            case 13: {
                return this.parseLxPara(lXObject);
            }
        }
        throw new IOException("Object type " + lXObject.type + "not supported");
    }

    Vector parseFile() throws IOException {
        JDObject jDObject;
        Vector<JDObject> vector = new Vector<JDObject>();
        this.word = this.read_word(false);
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        if (!this.word.equalsIgnoreCase("L3.3")) {
            throw new IOException("Invalid header , Loox V3.3 file or higher required!");
        }
        this.word = this.read_safe_word();
        boolean bl = false;
        while (!bl) {
            bl = this.word.equals("gend");
            if (bl) continue;
            this.word = this.read_safe_word();
        }
        while ((jDObject = this.parseObject(false)) != null) {
            vector.add(jDObject);
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            FileReader fileReader = new FileReader(stringArray[0]);
            LXFileLoader lXFileLoader = new LXFileLoader(fileReader);
            lXFileLoader.parseFile();
            fileReader.close();
        }
        catch (IOException iOException) {
            System.out.println("Reading of " + stringArray[0] + " failed " + iOException.getMessage());
            iOException.printStackTrace();
        }
        System.exit(0);
    }
}

