/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDSliderPanel
extends JPanel
implements ActionListener {
    private JLabel valueLabel;
    private JTextField valueText;
    private JLabel minValueLabel;
    private JTextField minValueText;
    private JLabel maxValueLabel;
    private JTextField maxValueText;
    private JButton applyValueBtn;
    private JLabel orientationLabel;
    private JComboBox orientationCombo;
    private JButton cursorPropBtn;
    private JButton cursorNewBtn;
    private JButton cursorCopyBtn;
    private JDSlider[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDSliderPanel(JDSlider[] jDSliderArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Slider Value"));
        jPanel.setBounds(5, 5, 370, 55);
        this.valueLabel = JDUtils.createLabel("Val");
        this.valueLabel.setBounds(10, 20, 30, 25);
        jPanel.add(this.valueLabel);
        this.valueText = new JTextField();
        this.valueText.setMargin(JDUtils.zMargin);
        this.valueText.setEditable(true);
        this.valueText.setFont(JDUtils.labelFont);
        this.valueText.setBounds(45, 20, 50, 24);
        this.valueText.addActionListener(this);
        jPanel.add(this.valueText);
        this.minValueLabel = JDUtils.createLabel("Min");
        this.minValueLabel.setBounds(100, 20, 30, 25);
        jPanel.add(this.minValueLabel);
        this.minValueText = new JTextField();
        this.minValueText.setMargin(JDUtils.zMargin);
        this.minValueText.setEditable(true);
        this.minValueText.setFont(JDUtils.labelFont);
        this.minValueText.setBounds(135, 20, 50, 24);
        this.minValueText.addActionListener(this);
        jPanel.add(this.minValueText);
        this.maxValueLabel = JDUtils.createLabel("Max");
        this.maxValueLabel.setBounds(190, 20, 30, 25);
        jPanel.add(this.maxValueLabel);
        this.maxValueText = new JTextField();
        this.maxValueText.setMargin(JDUtils.zMargin);
        this.maxValueText.setEditable(true);
        this.maxValueText.setFont(JDUtils.labelFont);
        this.maxValueText.setBounds(225, 20, 50, 24);
        this.maxValueText.addActionListener(this);
        jPanel.add(this.maxValueText);
        this.applyValueBtn = new JButton("Apply");
        this.applyValueBtn.setFont(JDUtils.labelFont);
        this.applyValueBtn.setMargin(new Insets(0, 0, 0, 0));
        this.applyValueBtn.setForeground(Color.BLACK);
        this.applyValueBtn.addActionListener(this);
        this.applyValueBtn.setBounds(285, 20, 75, 25);
        jPanel.add(this.applyValueBtn);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Styles"));
        jPanel2.setBounds(5, 65, 370, 55);
        this.orientationLabel = JDUtils.createLabel("Orientation");
        this.orientationLabel.setBounds(10, 20, 100, 20);
        jPanel2.add(this.orientationLabel);
        this.orientationCombo = new JComboBox();
        this.orientationCombo.setFont(JDUtils.labelFont);
        this.orientationCombo.addItem("Left to Right");
        this.orientationCombo.addItem("Right To Left");
        this.orientationCombo.addItem("Top to Bottom");
        this.orientationCombo.addItem("Bottom to Top");
        this.orientationCombo.addActionListener(this);
        this.orientationCombo.setBounds(120, 20, 240, 25);
        jPanel2.add(this.orientationCombo);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(null);
        jPanel3.setBorder(JDUtils.createTitleBorder("Cursor"));
        jPanel3.setBounds(5, 120, 370, 55);
        this.cursorPropBtn = new JButton("Properties");
        this.cursorPropBtn.setFont(JDUtils.labelFont);
        this.cursorPropBtn.setMargin(new Insets(0, 0, 0, 0));
        this.cursorPropBtn.setForeground(Color.BLACK);
        this.cursorPropBtn.addActionListener(this);
        this.cursorPropBtn.setBounds(10, 20, 110, 25);
        jPanel3.add(this.cursorPropBtn);
        this.cursorNewBtn = new JButton("Pick new");
        this.cursorNewBtn.setFont(JDUtils.labelFont);
        this.cursorNewBtn.setMargin(new Insets(0, 0, 0, 0));
        this.cursorNewBtn.setForeground(Color.BLACK);
        this.cursorNewBtn.addActionListener(this);
        this.cursorNewBtn.setBounds(130, 20, 110, 25);
        jPanel3.add(this.cursorNewBtn);
        this.cursorCopyBtn = new JButton("Extract");
        this.cursorCopyBtn.setFont(JDUtils.labelFont);
        this.cursorCopyBtn.setMargin(new Insets(0, 0, 0, 0));
        this.cursorCopyBtn.setForeground(Color.BLACK);
        this.cursorCopyBtn.addActionListener(this);
        this.cursorCopyBtn.setBounds(250, 20, 110, 25);
        jPanel3.add(this.cursorCopyBtn);
        this.add(jPanel3);
        this.updatePanel(jDSliderArray);
    }

    public void updatePanel(JDSlider[] jDSliderArray) {
        this.allObjects = jDSliderArray;
        this.isUpdating = true;
        if (jDSliderArray == null || jDSliderArray.length <= 0) {
            this.valueText.setText("");
            this.minValueText.setText("");
            this.maxValueText.setText("");
            this.orientationCombo.setSelectedIndex(-1);
        } else {
            this.refreshControls();
        }
        this.isUpdating = false;
    }

    private void refreshControls() {
        JDSlider jDSlider = this.allObjects[0];
        this.isUpdating = true;
        this.valueText.setText(Double.toString(jDSlider.getSliderValue()));
        this.minValueText.setText(Double.toString(jDSlider.getMinimum()));
        this.maxValueText.setText(Double.toString(jDSlider.getMaximum()));
        this.orientationCombo.setSelectedIndex(jDSlider.getOrientation());
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            this.oldRect = this.oldRect.union(this.allObjects[i].getRepaintRect());
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            rectangle = rectangle.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = actionEvent.getSource();
        if (object == this.minValueText) {
            try {
                double d = Double.parseDouble(this.minValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMinimum(d);
                }
                this.invoker.setNeedToSave(true, "Change minimum slider value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for min value");
            }
            this.refreshControls();
        } else if (object == this.maxValueText) {
            try {
                double d = Double.parseDouble(this.maxValueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMaximum(d);
                }
                this.invoker.setNeedToSave(true, "Change maximum slider value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for max value");
            }
            this.refreshControls();
        } else if (object == this.valueText) {
            try {
                double d = Double.parseDouble(this.valueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setSliderValue(d);
                }
                this.invoker.setNeedToSave(true, "Change slider value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for value");
            }
            this.refreshControls();
        } else if (object == this.applyValueBtn) {
            try {
                double d = Double.parseDouble(this.minValueText.getText());
                double d2 = Double.parseDouble(this.maxValueText.getText());
                double d3 = Double.parseDouble(this.valueText.getText());
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setMinimum(d);
                    this.allObjects[i].setMaximum(d2);
                    this.allObjects[i].setSliderValue(d3);
                }
                this.invoker.setNeedToSave(true, "Change slider value range");
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "One or more value are incorrect");
            }
            this.refreshControls();
        } else if (object == this.orientationCombo) {
            int n = this.orientationCombo.getSelectedIndex();
            if (n >= 0) {
                for (int i = 0; i < this.allObjects.length; ++i) {
                    this.allObjects[i].setOrientation(n);
                }
                this.invoker.setNeedToSave(true, "Change slider orientation");
            }
        } else {
            if (object == this.cursorPropBtn) {
                Vector<JDObject> vector = new Vector<JDObject>();
                vector.add(this.allObjects[0].getCursor());
                JDUtils.updatePropertyDialog(vector);
                return;
            }
            if (object == this.cursorNewBtn) {
                this.getRootPane().getParent().setVisible(false);
                this.invoker.pickCursor(this.allObjects[0]);
                return;
            }
            if (object == this.cursorCopyBtn) {
                JDObject jDObject = this.allObjects[0].getCursor().copy(50, 50);
                this.invoker.addObject(jDObject);
                this.invoker.setNeedToSave(true, "Extract slider cursor");
                jDObject.refresh();
            }
        }
        this.repaintObjects();
    }
}

