/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

class JDGradientViewer
extends JComponent
implements MouseListener,
MouseMotionListener {
    private Cursor moveCursor = Cursor.getPredefinedCursor(13);
    private Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private static final double arrowLgth = 50.0;
    private static final Color transBlue = new Color(0, 255, 0, 196);
    private GradientPaint gradient = null;
    private double amp;
    private double vx;
    private double vy;
    private int xc = 0;
    private int yc = 0;
    private int dragMode = 0;
    private double offset;

    public JDGradientViewer() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setGradient(float f, float f2, Color color, float f3, float f4, Color color2, boolean bl) {
        this.gradient = new GradientPaint(f, f2, color, f3, f4, color2, bl);
        this.vx = f3 - f;
        this.vy = f4 - f2;
        this.amp = Math.sqrt(this.vx * this.vx + this.vy * this.vy);
        this.vx = this.vx * 50.0 / this.amp;
        this.vy = this.vy * 50.0 / this.amp;
        this.offset = Math.sqrt(f * f + f2 * f2);
        this.repaint();
    }

    public float getX1() {
        return (float)this.gradient.getPoint1().getX();
    }

    public float getY1() {
        return (float)this.gradient.getPoint1().getY();
    }

    public float getX2() {
        return (float)this.gradient.getPoint2().getX();
    }

    public float getY2() {
        return (float)this.gradient.getPoint2().getY();
    }

    public Color getColor1() {
        return this.gradient.getColor1();
    }

    public void setColor1(Color color) {
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), color, (float)this.gradient.getPoint2().getX(), (float)this.gradient.getPoint2().getY(), this.gradient.getColor2(), this.gradient.isCyclic());
    }

    public Color getColor2() {
        return this.gradient.getColor2();
    }

    public void setColor2(Color color) {
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), this.gradient.getColor1(), (float)this.gradient.getPoint2().getX(), (float)this.gradient.getPoint2().getY(), color, this.gradient.isCyclic());
    }

    public boolean isCyclic() {
        return this.gradient.isCyclic();
    }

    public void setCyclic(boolean bl) {
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), this.gradient.getColor1(), (float)this.gradient.getPoint2().getX(), (float)this.gradient.getPoint2().getY(), this.gradient.getColor2(), bl);
    }

    public int getAmplitupe() {
        return (int)(this.amp + 0.5);
    }

    public void setAmplitute(int n) {
        double d = (double)n / this.amp;
        double d2 = this.gradient.getPoint2().getX() - this.gradient.getPoint1().getX();
        double d3 = this.gradient.getPoint2().getY() - this.gradient.getPoint1().getY();
        this.setGradient((float)this.gradient.getPoint1().getX(), (float)this.gradient.getPoint1().getY(), this.gradient.getColor1(), (float)(this.gradient.getPoint1().getX() + d2 * d), (float)(this.gradient.getPoint1().getY() + d3 * d), this.gradient.getColor2(), this.gradient.isCyclic());
    }

    public int getOffset() {
        return (int)(this.offset + 0.5);
    }

    public void setOffset(int n) {
        double d = (double)n - this.offset;
        double d2 = d / 50.0;
        float f = (float)(this.vx * d2);
        float f2 = (float)(this.vy * d2);
        this.setGradient((float)this.gradient.getPoint1().getX() + f, (float)this.gradient.getPoint1().getY() + f2, this.gradient.getColor1(), (float)this.gradient.getPoint2().getX() + f, (float)this.gradient.getPoint2().getY() + f2, this.gradient.getColor2(), this.gradient.isCyclic());
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.gradient != null) {
            Dimension dimension = this.getSize();
            this.xc = dimension.width / 2;
            this.yc = dimension.height / 2;
            graphics.translate(this.xc, this.yc);
            ((Graphics2D)graphics).setPaint(this.gradient);
            graphics.fillRect(-this.xc, -this.yc, dimension.width, dimension.height);
            graphics.translate(-this.xc, -this.yc);
            graphics.setColor(transBlue);
            graphics.fillRect(this.xc - 2, this.yc - 2, 5, 5);
            graphics.drawLine(this.xc, this.yc, this.xc + (int)this.vx, this.yc + (int)this.vy);
            graphics.drawRect(this.xc + (int)this.vx - 3, this.yc + (int)this.vy - 3, 6, 6);
            graphics.drawOval(this.xc - 50, this.yc - 50, 100, 100);
        }
        this.paintBorder(graphics);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dragMode = this.isInside(mouseEvent) ? 1 : 0;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragMode = 0;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragMode == 1) {
            double d = mouseEvent.getX() - this.xc;
            double d2 = mouseEvent.getY() - this.yc;
            double d3 = Math.sqrt(d * d + d2 * d2);
            double d4 = this.gradient.getPoint1().getX();
            double d5 = this.gradient.getPoint1().getY();
            double d6 = Math.sqrt(d4 * d4 + d5 * d5) / d3;
            double d7 = this.gradient.getPoint2().getX();
            double d8 = this.gradient.getPoint2().getY();
            double d9 = Math.sqrt(d7 * d7 + d8 * d8) / d3;
            if (d3 > 5.0) {
                this.setGradient((float)(d * d6), (float)(d2 * d6), this.gradient.getColor1(), (float)(d * d9), (float)(d2 * d9), this.gradient.getColor2(), this.gradient.isCyclic());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.isInside(mouseEvent)) {
            this.setCursor(this.moveCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    private boolean isInside(MouseEvent mouseEvent) {
        int n = this.xc + (int)this.vx - mouseEvent.getX();
        int n2 = this.yc + (int)this.vy - mouseEvent.getY();
        return n > -5 && n < 5 && n2 > -5 && n2 < 5;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

