/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDGradientViewer;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JDGradientDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private JDGradientViewer viewer;
    private JLabel color1Label;
    private JButton color1Button;
    private JLabel color2Label;
    private JButton color2Button;
    private JLabel ampLabel;
    private JSpinner ampSpinner;
    private JLabel offLabel;
    private JSpinner offSpinner;
    private JCheckBox cyclicCheckBox;
    private JDObject[] allObjects;
    private JComponent invoker;
    private JButton applyButton;
    private JButton dismissButton;
    private boolean modified = false;

    public JDGradientDialog(JDialog jDialog, JDObject[] jDObjectArray, JComponent jComponent) {
        super((Dialog)jDialog, true);
        this.allObjects = jDObjectArray;
        this.invoker = jComponent;
        this.initComponents();
    }

    public JDGradientDialog(JFrame jFrame, JDObject[] jDObjectArray, JComponent jComponent) {
        super((Frame)jFrame, true);
        this.allObjects = jDObjectArray;
        this.invoker = jComponent;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.viewer = new JDGradientViewer();
        this.viewer.setGradient(this.allObjects[0].gradientX1, this.allObjects[0].gradientY1, this.allObjects[0].gradientC1, this.allObjects[0].gradientX2, this.allObjects[0].gradientY2, this.allObjects[0].gradientC2, this.allObjects[0].gradientCyclic);
        this.viewer.setBorder(BorderFactory.createEtchedBorder());
        this.viewer.setBounds(5, 5, 200, 200);
        jPanel.add(this.viewer);
        this.color1Label = JDUtils.createLabel("Color 1");
        this.color1Label.setBounds(210, 5, 90, 24);
        jPanel.add(this.color1Label);
        this.color1Button = new JButton("...");
        this.color1Button.setMargin(new Insets(0, 0, 0, 0));
        this.color1Button.setBackground(this.allObjects[0].gradientC1);
        this.color1Button.addActionListener(this);
        this.color1Button.setBounds(300, 5, 60, 24);
        jPanel.add(this.color1Button);
        this.color2Label = JDUtils.createLabel("Color 2");
        this.color2Label.setBounds(210, 35, 90, 24);
        jPanel.add(this.color2Label);
        this.color2Button = new JButton("...");
        this.color2Button.setMargin(new Insets(0, 0, 0, 0));
        this.color2Button.setBackground(this.allObjects[0].gradientC2);
        this.color2Button.addActionListener(this);
        this.color2Button.setBounds(300, 35, 60, 24);
        jPanel.add(this.color2Button);
        this.ampLabel = new JLabel("Amplitude");
        this.ampLabel.setFont(JDUtils.labelFont);
        this.ampLabel.setForeground(JDUtils.labelColor);
        this.ampLabel.setBounds(210, 65, 90, 24);
        jPanel.add(this.ampLabel);
        this.ampSpinner = new JSpinner();
        Integer n = new Integer(this.viewer.getAmplitupe());
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(65535);
        Integer n4 = new Integer(1);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.ampSpinner.setModel(spinnerNumberModel);
        this.ampSpinner.addChangeListener(this);
        this.ampSpinner.setBounds(300, 65, 60, 26);
        jPanel.add(this.ampSpinner);
        this.offLabel = new JLabel("Offset");
        this.offLabel.setFont(JDUtils.labelFont);
        this.offLabel.setForeground(JDUtils.labelColor);
        this.offLabel.setBounds(210, 95, 90, 24);
        jPanel.add(this.offLabel);
        this.offSpinner = new JSpinner();
        n = new Integer(this.viewer.getOffset());
        n2 = new Integer(0);
        n3 = new Integer(65535);
        n4 = new Integer(1);
        spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
        this.offSpinner.setModel(spinnerNumberModel);
        this.offSpinner.addChangeListener(this);
        this.offSpinner.setBounds(300, 95, 60, 26);
        jPanel.add(this.offSpinner);
        this.cyclicCheckBox = new JCheckBox("Cyclic");
        this.cyclicCheckBox.setFont(JDUtils.labelFont);
        this.cyclicCheckBox.setForeground(JDUtils.labelColor);
        this.cyclicCheckBox.setBounds(210, 125, 150, 25);
        this.cyclicCheckBox.setSelected(this.viewer.isCyclic());
        this.cyclicCheckBox.addActionListener(this);
        jPanel.add(this.cyclicCheckBox);
        this.applyButton = new JButton("Apply");
        this.applyButton.setFont(JDUtils.labelFont);
        this.applyButton.addActionListener(this);
        this.applyButton.setBounds(5, 210, 100, 26);
        jPanel.add(this.applyButton);
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.setFont(JDUtils.labelFont);
        this.dismissButton.addActionListener(this);
        this.dismissButton.setBounds(260, 210, 100, 26);
        jPanel.add(this.dismissButton);
        this.setTitle("Gradient properties");
        this.setContentPane(jPanel);
    }

    private void repaintObjects() {
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        for (int i = 1; i < this.allObjects.length; ++i) {
            rectangle = rectangle.union(this.allObjects[i].getRepaintRect());
        }
        this.invoker.repaint(rectangle);
    }

    public boolean editGradient() {
        ATKGraphicsUtils.centerDialog(this, 367, 240);
        this.setVisible(true);
        return this.modified;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.color1Button) {
            Color color = JColorChooser.showDialog(this, "Choose 1st color", this.color1Button.getBackground());
            if (color != null) {
                this.viewer.setColor1(color);
                this.color1Button.setBackground(color);
            }
        } else if (object == this.color2Button) {
            Color color = JColorChooser.showDialog(this, "Choose 2nd color", this.color2Button.getBackground());
            if (color != null) {
                this.viewer.setColor2(color);
                this.color2Button.setBackground(color);
            }
        } else if (object == this.cyclicCheckBox) {
            this.viewer.setCyclic(this.cyclicCheckBox.isSelected());
        } else if (object == this.applyButton) {
            for (int i = 0; i < this.allObjects.length; ++i) {
                this.allObjects[i].setGradientFillParam(this.viewer.getX1(), this.viewer.getY1(), this.viewer.getColor1(), this.viewer.getX2(), this.viewer.getY2(), this.viewer.getColor2(), this.viewer.isCyclic());
            }
            this.modified = true;
            this.repaintObjects();
        } else if (object == this.dismissButton) {
            this.dispose();
            this.setVisible(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.ampSpinner) {
            Integer n = (Integer)this.ampSpinner.getValue();
            this.viewer.setAmplitute(n);
        } else if (object == this.offSpinner) {
            Integer n = (Integer)this.offSpinner.getValue();
            this.viewer.setOffset(n);
        }
    }
}

