/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import fr.esrf.tangoatk.widget.util.interlock.NetObject;
import fr.esrf.tangoatk.widget.util.interlock.XpssLink;
import fr.esrf.tangoatk.widget.util.interlock.XpssObject;
import java.awt.Dimension;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

class XpssFileLoader {
    private static final int NUMBER = 1;
    private static final int STRING = 2;
    private static final int SLASH = 3;
    private static final int BEGIN_KW = 4;
    private static final int END_KW = 5;
    private static final int LINK_KW = 6;
    private static final int OBJECT_KW = 7;
    private final String[] lexical_word = new String[]{"NULL", "NUMBER", "STRING", "SLASH", "Begin", "End", "Link", "Object"};
    private int CrtLine;
    private int StartLine;
    private char CurrentChar;
    private String word;
    FileReader f;

    public XpssFileLoader(FileReader fileReader) throws IOException {
        this.f = fileReader;
        this.CrtLine = 1;
        this.CurrentChar = (char)32;
    }

    private void read_char(FileReader fileReader) throws IOException {
        this.CurrentChar = fileReader.ready() ? (char)fileReader.read() : (char)'\u0000';
        if (this.CurrentChar == '\n') {
            ++this.CrtLine;
        }
    }

    private void jump_space(FileReader fileReader) throws IOException {
        while (this.CurrentChar <= ' ' && this.CurrentChar > '\u0000') {
            this.read_char(fileReader);
        }
    }

    private String read_word(FileReader fileReader) throws IOException {
        String string = "";
        this.jump_space(fileReader);
        if (this.CurrentChar == '/') {
            string = string + this.CurrentChar;
            this.read_char(fileReader);
            return string;
        }
        this.StartLine = this.CrtLine;
        while (this.CurrentChar > ' ' && this.CurrentChar != '/') {
            string = string + this.CurrentChar;
            this.read_char(fileReader);
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private String read_full_line(FileReader fileReader) throws IOException {
        String string = "";
        this.StartLine = this.CrtLine;
        while (this.CurrentChar != '\n' && this.CurrentChar != '\u0000') {
            this.read_char(fileReader);
        }
        if (this.CurrentChar != '\u0000') {
            this.read_char(fileReader);
        }
        while (this.CurrentChar >= ' ') {
            string = string + this.CurrentChar;
            this.read_char(fileReader);
        }
        return string;
    }

    private boolean isNumber(String string) {
        char c;
        boolean bl = true;
        for (int i = 0; i < string.length() && bl; bl &= (c = string.charAt(i)) >= '0' && c <= '9' || c == '.' || c == 'e' || c == 'E' || c == '-', ++i) {
        }
        return bl;
    }

    private int class_lex(String string) {
        if (string == null) {
            return 0;
        }
        if (string.length() == 0) {
            return 2;
        }
        if (string.equals("/")) {
            return 3;
        }
        if (string.equalsIgnoreCase("begin")) {
            return 4;
        }
        if (string.equalsIgnoreCase("end")) {
            return 5;
        }
        if (string.equalsIgnoreCase("link")) {
            return 6;
        }
        if (string.equalsIgnoreCase("object")) {
            return 7;
        }
        if (this.isNumber(string)) {
            return 1;
        }
        return 2;
    }

    private void CHECK_LEX(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Invalid syntyax at line " + this.StartLine + ", " + this.lexical_word[n2] + " expected");
        }
    }

    public int getCurrentLine() {
        return this.StartLine;
    }

    public void startBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 4);
        this.word = this.read_word(this.f);
        this.CHECK_LEX(this.class_lex(this.word), 7);
        this.word = this.read_word(this.f);
    }

    public void endBlock() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 5);
        this.word = this.read_word(this.f);
        this.CHECK_LEX(this.class_lex(this.word), 7);
        this.word = this.read_word(this.f);
    }

    public boolean isEndBlock() {
        return this.class_lex(this.word) == 5;
    }

    public XpssLink parseLink() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 6);
        this.word = this.read_word(this.f);
        int n = this.parseInteger();
        int n2 = this.parseInteger();
        int n3 = this.parseInteger();
        this.parseInteger();
        return new XpssLink(n, n2, n3);
    }

    public XpssLink parseLastLink() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 6);
        this.word = this.read_word(this.f);
        int n = this.parseInteger();
        int n2 = this.parseInteger();
        int n3 = this.parseInteger();
        return new XpssLink(n, n2, n3);
    }

    int parseInteger() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 1);
        int n = 0;
        try {
            n = Integer.parseInt(this.word);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Invalid number at line " + this.StartLine);
        }
        this.word = this.read_word(this.f);
        return n;
    }

    public String parseString() throws IOException {
        this.CHECK_LEX(this.class_lex(this.word), 2);
        String string = this.word;
        this.word = this.read_word(this.f);
        return string;
    }

    public XpssObject parseObject() throws IOException {
        XpssObject xpssObject = new XpssObject();
        xpssObject.type = this.parseInteger();
        xpssObject.org.x = this.parseInteger();
        xpssObject.org.y = this.parseInteger();
        xpssObject.addLink(this.parseLink());
        xpssObject.addLink(this.parseLink());
        xpssObject.addLink(this.parseLastLink());
        switch (xpssObject.type) {
            case 1: {
                xpssObject.label1 = this.read_full_line(this.f);
                xpssObject.label2 = this.read_full_line(this.f);
                xpssObject.typeStr = this.read_full_line(this.f);
                this.word = this.read_word(this.f);
                xpssObject.idHigh = this.parseInteger();
                this.CHECK_LEX(this.class_lex(this.word), 3);
                this.word = this.read_word(this.f);
                xpssObject.idLow = this.parseInteger();
                xpssObject.idDev = this.parseInteger();
                break;
            }
            case 7: {
                xpssObject.label1 = this.read_full_line(this.f);
                this.word = this.read_word(this.f);
                break;
            }
            case 8: {
                xpssObject.label1 = this.read_full_line(this.f);
                xpssObject.label2 = this.read_full_line(this.f);
                xpssObject.typeStr = this.read_full_line(this.f);
                xpssObject.permitFileName = this.read_full_line(this.f);
                this.word = this.read_word(this.f);
                break;
            }
            case 4: {
                xpssObject.label1 = "24V";
                this.word = this.read_word(this.f);
                break;
            }
            default: {
                this.word = this.read_word(this.f);
            }
        }
        return xpssObject;
    }

    private int findWithCoord(Vector vector, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        XpssObject xpssObject = null;
        int n4 = vector.size();
        while (n3 < n4 && !bl) {
            xpssObject = (XpssObject)vector.get(n3);
            bl = xpssObject.org.x == n && xpssObject.org.y == n2;
            if (bl) continue;
            ++n3;
        }
        if (bl) {
            return n3;
        }
        return -1;
    }

    public Vector parseXpssFile(Dimension dimension) throws IOException {
        NetObject netObject;
        XpssObject xpssObject;
        boolean bl = false;
        Vector<XpssObject> vector = new Vector<XpssObject>();
        Vector<NetObject> vector2 = new Vector<NetObject>();
        this.word = this.read_word(this.f);
        if (this.word == null) {
            throw new IOException("File empty !");
        }
        int n = this.class_lex(this.word);
        while (!bl) {
            switch (n) {
                case 4: {
                    this.startBlock();
                    xpssObject = this.parseObject();
                    if (xpssObject != null) {
                        if (xpssObject.org.x < 0 || xpssObject.org.x * dimension.width >= 1800 || xpssObject.org.y < 0 || xpssObject.org.y * dimension.height >= 1600) {
                            System.out.println("Warning:Out of bounds object detected. Ignoring...");
                        } else {
                            vector.add(xpssObject);
                            netObject = xpssObject.convert(dimension);
                            if (netObject != null) {
                                vector2.add(netObject);
                            }
                        }
                    }
                    this.endBlock();
                    break;
                }
                default: {
                    throw new IOException("Invalid syntyax at line " + this.StartLine + ": 'Begin' expected.");
                }
            }
            n = this.class_lex(this.word);
            bl = this.word == null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            xpssObject = (XpssObject)vector.get(i);
            netObject = (NetObject)vector2.get(i);
            for (int j = 0; j < xpssObject.links.size(); ++j) {
                XpssLink xpssLink = (XpssLink)xpssObject.links.get(j);
                int n2 = this.findWithCoord(vector, xpssLink.pos.x, xpssLink.pos.y);
                if (n2 != -1) {
                    netObject.addChild((NetObject)vector2.get(n2));
                    continue;
                }
                System.out.println("Warning: Not ended link detected. Ignoring...");
            }
        }
        vector.clear();
        return vector2;
    }
}

