/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.LabelRect;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

public class AdvancedJLChart
extends JLChart {
    public static final int MENU_DATALOAD = 6;
    public static final int MENU_RESET = 7;
    protected JPopupMenu dataViewMenu;
    protected JMenuItem removeDataViewMenuItem;
    protected JMenuItem dataViewOptionItem;
    protected JMenuItem loadFileMenuItem = new JMenuItem("Load data File");
    protected JMenuItem resetMenuItem;

    public AdvancedJLChart() {
        this.loadFileMenuItem.addActionListener(this);
        this.resetMenuItem = new JMenuItem("Reset Chart");
        this.resetMenuItem.addActionListener(this);
        this.chartMenu.add(this.loadFileMenuItem);
        this.chartMenu.add(this.resetMenuItem);
    }

    @Override
    public void removeMenuItem(int n) {
        switch (n) {
            case 6: {
                this.chartMenu.remove(this.loadFileMenuItem);
                break;
            }
            case 7: {
                this.chartMenu.remove(this.resetMenuItem);
                break;
            }
            default: {
                super.removeMenuItem(n);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.loadFileMenuItem) {
            File file;
            JFileChooser jFileChooser = new JFileChooser(this.lastDataFileLocation);
            jFileChooser.addChoosableFileFilter(new MultiExtFileFilter("Text files", "txt", new String[0]));
            jFileChooser.setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.loadDataFile(file.getAbsolutePath());
                this.lastDataFileLocation = file.getParentFile().getAbsolutePath();
            }
        } else if (actionEvent.getSource() == this.resetMenuItem) {
            this.reset();
            this.repaint();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getButton() == 3) {
            for (int i = 0; i < this.labelRect.size(); ++i) {
                LabelRect labelRect = (LabelRect)this.labelRect.get(i);
                if (!labelRect.rect.contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                bl = this.prepareDataViewMenu(labelRect.view);
                break;
            }
        }
        if (bl) {
            this.dataViewMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    protected boolean prepareDataViewMenu(JLDataView jLDataView) {
        int n;
        if (this.dataViewMenu == null) {
            this.dataViewMenu = new JPopupMenu();
            this.removeDataViewMenuItem = new JMenuItem("Remove");
            this.dataViewOptionItem = new JMenuItem("Options");
            this.dataViewMenu.add(this.removeDataViewMenuItem);
            this.dataViewMenu.add(this.dataViewOptionItem);
        }
        final JLDataView jLDataView2 = jLDataView;
        this.removeDataViewMenuItem.setText("Remove : " + jLDataView.getName());
        ActionListener[] actionListenerArray = this.removeDataViewMenuItem.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.removeDataViewMenuItem.removeActionListener(actionListenerArray[n]);
        }
        this.removeDataViewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedJLChart.this.removeDataView(jLDataView2);
                AdvancedJLChart.this.repaint();
            }
        });
        this.dataViewOptionItem.setText("Options : " + jLDataView.getName());
        actionListenerArray = this.dataViewOptionItem.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.dataViewOptionItem.removeActionListener(actionListenerArray[n]);
        }
        this.dataViewOptionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedJLChart.this.showDataOptionDialog(jLDataView2);
            }
        });
        return true;
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        JComponent jComponent;
        String string;
        JFrame jFrame = new JFrame();
        final AdvancedJLChart advancedJLChart = new AdvancedJLChart();
        advancedJLChart.setHeaderFont(new Font("Times", 1, 18));
        advancedJLChart.setLabelFont(new Font("Times", 1, 12));
        advancedJLChart.setHeader("Test DataView");
        if (stringArray.length > 0) {
            string = stringArray[0];
        } else {
            jComponent = new JFileChooser(".");
            ((JFileChooser)jComponent).addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = null;
                    String string2 = file.getName();
                    int n = string2.lastIndexOf(46);
                    if (n > 0 && n < string2.length() - 1) {
                        string = string2.substring(n + 1).toLowerCase();
                    }
                    return string != null && string.equals("txt");
                }

                @Override
                public String getDescription() {
                    return "text files ";
                }
            });
            ((JFileChooser)jComponent).setDialogTitle("Load Graph Data (Text file with TAB separated fields)");
            int n = ((JFileChooser)jComponent).showOpenDialog(null);
            if (n == 0) {
                serializable = ((JFileChooser)jComponent).getSelectedFile();
                string = ((File)serializable).getAbsolutePath();
            } else {
                string = "";
                System.exit(0);
            }
        }
        advancedJLChart.reset(false);
        advancedJLChart.loadDataFile(string);
        jComponent = new JPanel();
        jComponent.setLayout(new FlowLayout());
        JButton jButton = new JButton("Exit");
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                System.exit(0);
            }
        });
        jComponent.add(jButton);
        serializable = new JButton("Options");
        ((Component)serializable).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                advancedJLChart.showOptionDialog();
            }
        });
        jComponent.add((Component)serializable);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)advancedJLChart, "Center");
        jFrame.getContentPane().add((Component)jComponent, "South");
        jFrame.setSize(400, 300);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

