/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

class XORCaret
extends DefaultCaret {
    protected double lastPaintedWidth = 0.0;
    protected Font currentFont = null;
    protected float currentAscent = 0.0f;
    protected LineMetrics currentLineMetrics = null;
    protected Rectangle currentRectangle = null;
    protected FontRenderContext frc = null;

    public XORCaret() {
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                XORCaret.this.getComponent().repaint();
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.isVisible()) {
            this.frc = ((Graphics2D)graphics).getFontRenderContext();
            JTextComponent jTextComponent = this.getComponent();
            TextUI textUI = jTextComponent.getUI();
            Rectangle rectangle = null;
            int n = this.getDot();
            try {
                this.currentRectangle = rectangle = textUI.modelToView(jTextComponent, n);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            graphics.setColor(Color.red);
            this.lastPaintedWidth = this.currentWidth();
            graphics.fillRect(rectangle.x, rectangle.y, (int)this.lastPaintedWidth, rectangle.height);
            graphics.setColor(jTextComponent.getBackground());
            try {
                String string;
                if (n < jTextComponent.getDocument().getLength() && !Character.isISOControl((string = this.getComponent().getText(n, 1)).charAt(0))) {
                    graphics.drawString(string, rectangle.x, rectangle.y + (int)this.currentAscent);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void damage(Rectangle rectangle) {
    }

    protected double currentWidth() {
        Font font = this.getComponent().getFont();
        String string = null;
        try {
            string = this.getComponent().getText(this.getDot(), 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (font != this.currentFont) {
            this.currentLineMetrics = font.getLineMetrics(string, this.frc);
            this.currentAscent = this.currentLineMetrics.getAscent();
        }
        char c = string != null && string.length() > 0 ? string.charAt(0) : (char)' ';
        return font.getStringBounds(Character.toString(c), this.frc).getWidth();
    }
}

