/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class RestrictedFolderJFileChooser
extends JFileChooser {
    private String initFolder = null;
    private String[] autorizedFolders = null;
    private String[] autorizedCanonicalFolders = null;

    public RestrictedFolderJFileChooser(String string) {
        super(".");
        this.initFolder = string;
        if (this.initFolder != null) {
            this.setCurrentDirectory(new File(this.initFolder));
            this.addAutorizedFolder(this.initFolder);
        }
    }

    public void addAutorizedFolder(String string) {
        if (string == null) {
            return;
        }
        if (string.length() <= 0) {
            return;
        }
        if (this.autorizedFolders == null) {
            this.autorizedFolders = new String[1];
            this.autorizedFolders[0] = string;
        } else {
            int n = this.autorizedFolders.length;
            String[] stringArray = new String[n + 1];
            System.arraycopy(this.autorizedFolders, 0, stringArray, 0, n);
            stringArray[n] = string;
            this.autorizedFolders = stringArray;
        }
        this.updateAutorizedCanonicalFolders();
    }

    private void updateAutorizedCanonicalFolders() {
        this.autorizedCanonicalFolders = new String[this.autorizedFolders.length];
        for (int i = 0; i < this.autorizedFolders.length; ++i) {
            this.autorizedCanonicalFolders[i] = this.getCanonicalFolder(this.autorizedFolders[i]);
        }
    }

    private String getCanonicalFolder(String string) {
        File file = new File(string);
        String string2 = null;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string2 = new String(string);
        }
        return string2;
    }

    public File showDialog(Component component, String string, String string2) {
        String string3;
        boolean bl;
        File file = null;
        String string4 = null;
        this.setCurrentDirectory(new File(this.initFolder));
        int n = super.showDialog(component, string);
        if (n != 0) {
            return null;
        }
        file = this.getSelectedFile();
        try {
            string4 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(component, "Failed to get the canonical path of the selected file.\n\n" + iOException + "\n\n\n", string + " aborted.\n", 0);
            return null;
        }
        if (string2 == null) {
            bl = this.isInAutorizedFolders(string4);
            string3 = this.getAutorizedFolderHint();
        } else {
            bl = this.isInSpecifiedFolder(string4, string2);
            string3 = "The file should be located inside " + string2 + " \n ";
        }
        if (!bl) {
            JOptionPane.showMessageDialog(component, "The selected file is not inside the authorized root folder(s)\n\n" + string3, string + " aborted.\n", 0);
            return null;
        }
        return file;
    }

    private boolean isInSpecifiedFolder(String string, String string2) {
        File file = new File(string2);
        String string3 = null;
        try {
            string3 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string3 = new String(string2);
        }
        return string.startsWith(string3);
    }

    private boolean isInAutorizedFolders(String string) {
        if (this.autorizedCanonicalFolders == null) {
            return true;
        }
        if (this.autorizedCanonicalFolders.length <= 0) {
            return true;
        }
        for (int i = 0; i < this.autorizedCanonicalFolders.length; ++i) {
            if (!string.startsWith(this.autorizedCanonicalFolders[i])) continue;
            return true;
        }
        return false;
    }

    private String getAutorizedFolderHint() {
        if (this.autorizedFolders == null) {
            return "";
        }
        if (this.autorizedFolders.length <= 0) {
            return "";
        }
        String string = "The file should be located inside one the following folders : \n ";
        for (int i = 0; i < this.autorizedFolders.length; ++i) {
            string = string + "     " + this.autorizedFolders[i] + "\n";
        }
        return string;
    }
}

