/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import java.awt.Color;

public class Gradient {
    private Color[] colorVal = null;
    private double[] colorPos = null;

    public Gradient() {
        this.colorVal = new Color[2];
        this.colorPos = new double[2];
        this.colorVal[0] = new Color(0, 0, 0);
        this.colorVal[1] = new Color(255, 255, 255);
        this.colorPos[0] = 0.0;
        this.colorPos[1] = 1.0;
    }

    public Gradient(double[] dArray, Color[] colorArray) {
        this.colorVal = colorArray;
        this.colorPos = dArray;
    }

    public void buidColorGradient() {
        this.buildRainbowGradient();
    }

    public void buildRainbowGradient() {
        this.colorVal = new Color[5];
        this.colorPos = new double[5];
        this.colorVal[0] = new Color(200, 0, 250);
        this.colorVal[1] = new Color(40, 40, 255);
        this.colorVal[2] = new Color(40, 255, 40);
        this.colorVal[3] = new Color(250, 250, 0);
        this.colorVal[4] = new Color(255, 0, 0);
        this.colorPos[0] = 0.0;
        this.colorPos[1] = 0.25;
        this.colorPos[2] = 0.5;
        this.colorPos[3] = 0.75;
        this.colorPos[4] = 1.0;
    }

    public void invertGradient() {
        Color[] colorArray = new Color[this.colorVal.length];
        for (int i = 0; i < this.colorVal.length; ++i) {
            colorArray[i] = this.colorVal[this.colorVal.length - i - 1];
        }
        System.arraycopy(colorArray, 0, this.colorVal, 0, this.colorVal.length);
    }

    public Gradient cloneMe() {
        Gradient gradient = new Gradient();
        gradient.colorPos = new double[this.getEntryNumber()];
        gradient.colorVal = new Color[this.getEntryNumber()];
        for (int i = 0; i < this.getEntryNumber(); ++i) {
            gradient.colorPos[i] = this.colorPos[i];
            gradient.colorVal[i] = new Color(this.colorVal[i].getRGB());
        }
        return gradient;
    }

    public int[] buildColorMap(int n) {
        if (this.colorVal == null) {
            return null;
        }
        if (this.colorVal.length <= 1) {
            return null;
        }
        int n2 = 0;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)i / (double)n;
            if (n2 < this.colorPos.length - 2 && d >= this.colorPos[n2 + 1]) {
                ++n2;
            }
            double d2 = this.colorVal[n2].getRed();
            double d3 = this.colorVal[n2].getGreen();
            double d4 = this.colorVal[n2].getBlue();
            double d5 = this.colorVal[n2 + 1].getRed();
            double d6 = this.colorVal[n2 + 1].getGreen();
            double d7 = this.colorVal[n2 + 1].getBlue();
            double d8 = (d - this.colorPos[n2]) / (this.colorPos[n2 + 1] - this.colorPos[n2]);
            if (d8 < 0.0) {
                d8 = 0.0;
            }
            if (d8 > 1.0) {
                d8 = 1.0;
            }
            nArray[i] = (int)(d2 + (d5 - d2) * d8) * 65536 + (int)(d3 + (d6 - d3) * d8) * 256 + (int)(d4 + (d7 - d4) * d8);
        }
        return nArray;
    }

    public int getEntryNumber() {
        return this.colorVal.length;
    }

    public Color getColorAt(int n) {
        return this.colorVal[n];
    }

    public double getPosAt(int n) {
        return this.colorPos[n];
    }

    public void setColorAt(int n, Color color) {
        if (n >= 0 && n < this.colorVal.length) {
            this.colorVal[n] = color;
        }
    }

    public void setPosAt(int n, double d) {
        if (n > 0 && n < this.colorVal.length - 1 && d >= 0.0 && d <= 1.0) {
            if (n == 0) {
                if (d < this.colorPos[n + 1]) {
                    this.colorPos[n] = d;
                }
            } else if (n == this.colorVal.length - 1) {
                if (d > this.colorPos[n - 1]) {
                    this.colorPos[n] = d;
                }
            } else if (d < this.colorPos[n + 1] && d > this.colorPos[n - 1]) {
                this.colorPos[n] = d;
            }
        }
    }

    public int addEntry(Color color, double d) {
        if (d <= 0.0 || d >= 1.0) {
            return -1;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.colorPos.length && !bl) {
            bl = d < this.colorPos[n];
            if (bl) continue;
            ++n;
        }
        if (bl) {
            if (Math.abs(this.colorPos[n] - d) < 0.01) {
                return -1;
            }
            Color[] colorArray = this.colorVal;
            double[] dArray = this.colorPos;
            this.colorVal = new Color[this.colorPos.length + 1];
            this.colorPos = new double[this.colorVal.length];
            System.arraycopy(colorArray, 0, this.colorVal, 0, n);
            System.arraycopy(dArray, 0, this.colorPos, 0, n);
            this.colorVal[n] = color;
            this.colorPos[n] = d;
            System.arraycopy(colorArray, n, this.colorVal, n + 1, colorArray.length - n);
            System.arraycopy(dArray, n, this.colorPos, n + 1, colorArray.length - n);
            return n;
        }
        return -1;
    }

    public void removeEntry(int n) {
        if (n > 0 && n < this.colorVal.length - 1) {
            Color[] colorArray = this.colorVal;
            double[] dArray = this.colorPos;
            this.colorVal = new Color[this.colorPos.length - 1];
            this.colorPos = new double[this.colorVal.length];
            System.arraycopy(colorArray, 0, this.colorVal, 0, n);
            System.arraycopy(colorArray, n + 1, this.colorVal, n, colorArray.length - n - 1);
            System.arraycopy(dArray, 0, this.colorPos, 0, n);
            System.arraycopy(dArray, n + 1, this.colorPos, n, dArray.length - n - 1);
        }
    }
}

