/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.image;

import fr.esrf.tangoatk.widget.image.IImageViewer;
import fr.esrf.tangoatk.widget.image.IRasterConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class GrayscaleColorConverter
implements IRasterConverter {
    final int IMAGE_DEPTH = 256;
    final int INCREASE = 0;
    final int DECREASE = 1;
    public static final int _256_COLORS = 0;
    final int GRAY_SCALE = 1;
    final int CONTRASTED_COLOR = 2;
    public int[][] raster = null;
    private int[] colormap = new int[256];
    private BufferedImage image;
    private IImageViewer imgviewer;
    private final int NB_MAIN_COLORS = 8;
    private final int BLACK = 0;
    private final int BLUE = 32;
    private final int CYAN = 64;
    private final int GREEN = 96;
    private final int YELLOW = 128;
    private final int WHITE = 160;
    private final int MAGENTA = 192;
    private final int RED = 224;
    private final int BG_MAX = 64;
    private Rectangle roi = null;

    public GrayscaleColorConverter(int n) {
        switch (n) {
            case 0: {
                this.set256ColorsLookUpTable();
                break;
            }
            case 1: {
                this.setGrayScaleLookUpTable();
            }
        }
    }

    public void changeLookUpTable(int n) {
        switch (n) {
            case 0: {
                this.set256ColorsLookUpTable();
                break;
            }
            case 1: {
                this.setGrayScaleLookUpTable();
            }
        }
        if (this.image == null) {
            return;
        }
        for (int i = 0; i < this.image.getHeight(); ++i) {
            for (int j = 0; j < this.image.getWidth(); ++j) {
                this.image.setRGB(j, i, this.colormap[this.raster[j][i]]);
            }
        }
        this.imgviewer.repaint();
    }

    private void setGrayScaleLookUpTable() {
        for (int i = 0; i < 256; ++i) {
            Color color = new Color(i, i, i);
            this.colormap[i] = color.getRGB();
        }
    }

    private void set256ColorsLookUpTable() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 4;
        for (int i = 0; i < 256; ++i) {
            if (i == 0) {
                n3 = 0;
                n2 = 0;
                n = 0;
            } else if (i == 32) {
                n = 0;
                n2 = 127;
                n3 = 255;
            } else if (i == 64) {
                n = 0;
                n2 = 255;
                n3 = 255;
            } else if (i == 96) {
                n = 127;
                n2 = 255;
                n3 = 0;
            } else if (i == 128) {
                n = 255;
                n2 = 255;
                n3 = 127;
            } else if (i == 160) {
                n = 255;
                n2 = 255;
                n3 = 255;
            } else if (i == 192) {
                n = 255;
                n2 = 0;
                n3 = 255;
            } else if (i == 224) {
                n = 255;
                n2 = 0;
                n3 = 0;
            } else if (i < 32) {
                n3 += n4;
            } else if (i < 64) {
                n2 += n4;
            } else if (i < 96) {
                n3 -= n4;
            } else if (i < 128) {
                n += n4;
            } else if (i < 160) {
                n3 += n4;
            } else if (i < 192) {
                n2 -= n4;
            } else if (i < 224) {
                n3 -= n4;
            } else {
                n -= n4;
            }
            Color color = new Color(n, n2, n3);
            this.colormap[i] = color.getRGB();
        }
    }

    public void createColormapImage() {
        int n = 100;
        int n2 = 256;
        this.raster = new int[n][n2];
        this.image = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.raster[j][i] = n2 - i - 1;
                this.image.setRGB(j, i, this.colormap[this.raster[j][i]]);
            }
        }
    }

    public void setModel(IImageViewer iImageViewer) {
        this.imgviewer = iImageViewer;
    }

    @Override
    public void setImageViewer(IImageViewer iImageViewer) {
        this.imgviewer = iImageViewer;
    }

    @Override
    public BufferedImage convertRaster(double[][] dArray) {
        this.createImage(dArray);
        return this.image;
    }

    public void rasterChanged(double[][] dArray) {
        BufferedImage bufferedImage = this.convertRaster(dArray);
        this.imgviewer.setImage(bufferedImage);
        this.imgviewer.setSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public void rasterChanged() {
        this.imgviewer.setImage(this.image);
        this.imgviewer.setSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
    }

    public void createImage(double[][] dArray) {
        int n = dArray[0].length;
        int n2 = dArray.length;
        this.raster = new int[n][n2];
        this.image = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.raster[j][i] = 0xFF & (int)dArray[i][j];
                this.image.setRGB(j, i, this.colormap[this.raster[j][i]]);
            }
        }
    }

    public void createImage(int[][] nArray) {
        this.raster = nArray;
        int n = this.raster.length;
        int n2 = this.raster[0].length;
        this.image = new BufferedImage(n, n2, 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.image.setRGB(j, i, this.colormap[this.raster[j][i]]);
            }
        }
    }

    private Rectangle calculateROI() {
        int n;
        int n2 = this.image.getWidth();
        int n3 = this.image.getHeight();
        Point point = new Point(0, 0);
        Point point2 = new Point(n2 - 1, n3 - 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        int n8 = 0;
        for (n = 5; n < n3; ++n) {
            for (int i = 5; i < n2; ++i) {
                n8 = 0xFF & this.raster[i][n];
                if (n8 > n4) {
                    n4 = n8;
                    n5 = i;
                    n6 = n;
                }
                if (n != 0 && n != n3 - 1 && i != 0 && i != n2 - 1 || n8 <= n7 || n8 >= 64) continue;
                n7 = n8;
            }
        }
        System.out.println(n5 + ", " + n6 + " -> " + n4 + " Bg = " + n7);
        point.x = point.y - 0;
        point2.x = n2 - 1;
        point2.y = n3 - 1;
        for (n = n5; n > 0; --n) {
            n8 = 0xFF & this.raster[n][n6];
            if (n8 > n7) continue;
            point.x = n;
            break;
        }
        for (n = n5; n < n2; ++n) {
            n8 = 0xFF & this.raster[n][n6];
            if (n8 > n7) continue;
            point2.x = n;
            break;
        }
        for (n = n6; n > 0; --n) {
            n8 = 0xFF & this.raster[n5][n];
            if (n8 > n7) continue;
            point.y = n;
            break;
        }
        for (n = n6; n < n3; ++n) {
            n8 = 0xFF & this.raster[n5][n];
            if (n8 > n7) continue;
            point2.y = n;
            break;
        }
        return new Rectangle(point, new Dimension(point2.x - point.x, point2.y - point.y));
    }

    public void drawROI(boolean bl) {
        if (bl) {
            this.roi = this.calculateROI();
        }
        Graphics graphics = this.image.getGraphics();
        graphics.setXORMode(Color.blue);
        graphics.drawRect(this.roi.x, this.roi.y, this.roi.width, this.roi.height);
    }
}

