/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.RawImageEvent;
import fr.esrf.tangoatk.widget.attribute.IRoiListener;
import fr.esrf.tangoatk.widget.attribute.RoiEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.image.IImageFormat;
import fr.esrf.tangoatk.widget.image.Jpeg24ImageFormat;
import fr.esrf.tangoatk.widget.image.Jpeg8ImageFormat;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.image.Mono16ImageFormat;
import fr.esrf.tangoatk.widget.image.Mono8ImageFormat;
import fr.esrf.tangoatk.widget.image.RGB24ImageFormat;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.AxisPanel;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class RawImageViewer
extends JPanel
implements IRawImageListener,
ActionListener,
MouseListener,
MouseMotionListener {
    private IRawImage model;
    private IImageFormat format = null;
    private String encFormat = null;
    private boolean snapToGrid;
    private boolean isNegative;
    private Gradient gColor;
    private int[] gColormap;
    private int iSz;
    private EventListenerList listenerList;
    private Rectangle oldSelection = null;
    private Insets noMargin = new Insets(0, 0, 0, 0);
    private boolean isBestFit;
    private boolean autoZoom = false;
    private boolean firstRefresh = false;
    private boolean userZoom = false;
    private boolean showingMenu;
    private int profileMode;
    private double minFit;
    private double maxFit;
    private String errorString = "No image";
    private Font panelFont;
    protected JImage imagePanel;
    private JScrollPane imageView;
    private JPopupMenu imgMenu;
    private JCheckBoxMenuItem[] formatMenuItem;
    private JCheckBoxMenuItem bestFitMenuItem;
    private JCheckBoxMenuItem snapToGridMenuItem;
    private JCheckBoxMenuItem negativeMenuItem;
    private JCheckBoxMenuItem toolbarMenuItem;
    private JCheckBoxMenuItem statusLineMenuItem;
    private JCheckBoxMenuItem showGradMenuItem;
    private JMenuItem selectionMenuItem;
    private JMenuItem selectionMaxMenuItem;
    private JMenuItem fileMenuItem;
    private JMenuItem tableMenuItem;
    private JMenuItem lineProfileMenuItem;
    private JMenuItem histogramMenuItem;
    private JMenuItem settingsMenuItem;
    private JMenuItem statsMenuItem;
    private JButton selectButton;
    private JButton selectMaxButton;
    private JButton fileButton;
    private JButton tableButton;
    private JButton profileButton;
    private JButton histoButton;
    private JButton settingsButton;
    private JButton axisButton;
    private JScrollPane buttonView;
    private JDialog settingsDialog = null;
    private LabelViewer attNameLabel;
    private JButton propButton;
    private JCheckBox bestFitCheck;
    private JTextField fitMinText;
    private JTextField fitMaxText;
    private JTextField formatText;
    private JCheckBox snapToGridCheck;
    private JTextField snapToGridText;
    private JCheckBox negativeCheck;
    private JComboBox imageSizeCombo;
    private JGradientEditor gradViewer;
    private JButton gradButton;
    private JButton okButton;
    private JButton cancelButton;
    SimplePropertyFrame propDialog = null;
    private JFrame tableDialog = null;
    private JTableRow tablePanel;
    private LineProfilerViewer lineProfiler = null;
    private JDialog axisDialog = null;
    private JButton axisCloseButton;
    private JPanel cfgPanel;
    private JLabel statusLabel;
    private JLabel rangeLabel;
    private JGradientViewer gradientTool;

    public RawImageViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.panelFont = new Font("Dialog", 0, 11);
        this.imagePanel = new JImage();
        this.imagePanel.setBorder(null);
        this.imagePanel.setSnapGrid(8);
        this.imageView = new JScrollPane(this.imagePanel);
        this.add((Component)this.imageView, "Center");
        this.imgMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Image Viewer");
        jMenuItem.setEnabled(false);
        this.bestFitMenuItem = new JCheckBoxMenuItem("Best fit");
        this.bestFitMenuItem.addActionListener(this);
        this.snapToGridMenuItem = new JCheckBoxMenuItem("Align to grid");
        this.snapToGridMenuItem.addActionListener(this);
        this.negativeMenuItem = new JCheckBoxMenuItem("Negative image");
        this.negativeMenuItem.addActionListener(this);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Show toolbar");
        this.toolbarMenuItem.addActionListener(this);
        this.statusLineMenuItem = new JCheckBoxMenuItem("Show status line");
        this.statusLineMenuItem.addActionListener(this);
        this.showGradMenuItem = new JCheckBoxMenuItem("Show gradient");
        this.showGradMenuItem.addActionListener(this);
        this.selectionMenuItem = new JMenuItem("Free selection");
        this.selectionMenuItem.addActionListener(this);
        this.selectionMaxMenuItem = new JMenuItem("Select all");
        this.selectionMaxMenuItem.addActionListener(this);
        this.lineProfileMenuItem = new JMenuItem("Line profile");
        this.lineProfileMenuItem.addActionListener(this);
        this.histogramMenuItem = new JMenuItem("Histogram");
        this.histogramMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save selection");
        this.fileMenuItem.addActionListener(this);
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.statsMenuItem = new JMenuItem("Statistics");
        this.statsMenuItem.addActionListener(this);
        this.tableMenuItem = new JMenuItem("Selection to table");
        this.tableMenuItem.addActionListener(this);
        this.imgMenu.add(jMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.bestFitMenuItem);
        this.imgMenu.add(this.negativeMenuItem);
        this.imgMenu.add(this.snapToGridMenuItem);
        this.imgMenu.add(this.toolbarMenuItem);
        this.imgMenu.add(this.statusLineMenuItem);
        this.imgMenu.add(this.showGradMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.selectionMenuItem);
        this.imgMenu.add(this.selectionMaxMenuItem);
        this.imgMenu.add(this.fileMenuItem);
        this.imgMenu.add(this.tableMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.lineProfileMenuItem);
        this.imgMenu.add(this.histogramMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.settingsMenuItem);
        this.imgMenu.add(this.statsMenuItem);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setPreferredSize(new Dimension(60, 335));
        this.buttonView = new JScrollPane(jPanel);
        this.buttonView.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.buttonView, "West");
        this.buttonView.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                RawImageViewer.this.adjustToolbarSize();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                RawImageViewer.this.adjustToolbarSize();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                RawImageViewer.this.adjustToolbarSize();
            }
        });
        this.selectButton = new JButton();
        this.selectButton.setMargin(this.noMargin);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select.gif")));
        this.selectButton.setBounds(2, 5, 36, 36);
        this.selectButton.setToolTipText("Free selection");
        this.selectButton.addActionListener(this);
        jPanel.add(this.selectButton);
        this.selectMaxButton = new JButton();
        this.selectMaxButton.setMargin(this.noMargin);
        this.selectMaxButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_selectmax.gif")));
        this.selectMaxButton.setBounds(2, 45, 36, 36);
        this.selectMaxButton.setToolTipText("Select whole image");
        this.selectMaxButton.addActionListener(this);
        jPanel.add(this.selectMaxButton);
        this.fileButton = new JButton();
        this.fileButton.setMargin(this.noMargin);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_snapshot.gif")));
        this.fileButton.setBounds(2, 85, 36, 36);
        this.fileButton.setToolTipText("Save snapshot");
        this.fileButton.addActionListener(this);
        jPanel.add(this.fileButton);
        this.tableButton = new JButton();
        this.tableButton.setMargin(this.noMargin);
        this.tableButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_table.gif")));
        this.tableButton.setBounds(2, 125, 36, 36);
        this.tableButton.setToolTipText("Selection to table");
        this.tableButton.addActionListener(this);
        jPanel.add(this.tableButton);
        this.profileButton = new JButton();
        this.profileButton.setMargin(this.noMargin);
        this.profileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile.gif")));
        this.profileButton.setBounds(2, 170, 36, 36);
        this.profileButton.setToolTipText("Line profile");
        this.profileButton.addActionListener(this);
        jPanel.add(this.profileButton);
        this.histoButton = new JButton();
        this.histoButton.setMargin(this.noMargin);
        this.histoButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_histo.gif")));
        this.histoButton.setBounds(2, 205, 36, 36);
        this.histoButton.setToolTipText("Histogram");
        this.histoButton.addActionListener(this);
        jPanel.add(this.histoButton);
        this.settingsButton = new JButton();
        this.settingsButton.setMargin(this.noMargin);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_option.gif")));
        this.settingsButton.setBounds(2, 250, 36, 36);
        this.settingsButton.setToolTipText("Image viewer settings");
        this.settingsButton.addActionListener(this);
        jPanel.add(this.settingsButton);
        this.axisButton = new JButton();
        this.axisButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_axis.gif")));
        this.axisButton.setMargin(this.noMargin);
        this.axisButton.setBounds(2, 295, 36, 36);
        this.axisButton.setToolTipText("Axis settings");
        this.axisButton.addActionListener(this);
        jPanel.add(this.axisButton);
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 40));
        this.add((Component)this.cfgPanel, "South");
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(this.panelFont);
        this.statusLabel.setBounds(5, 0, 400, 20);
        this.cfgPanel.add(this.statusLabel);
        this.rangeLabel = new JLabel("");
        this.rangeLabel.setFont(this.panelFont);
        this.rangeLabel.setBounds(5, 20, 400, 20);
        this.cfgPanel.add(this.rangeLabel);
        this.gradientTool = new JGradientViewer();
        this.gradientTool.getAxis().setMinimum(0.0);
        this.gradientTool.getAxis().setMaximum(256.0);
        this.add((Component)this.gradientTool, "East");
        this.imagePanel.addMouseMotionListener(this);
        this.imagePanel.addMouseListener(this);
        this.isBestFit = false;
        this.setAlignToGrid(true);
        this.isNegative = false;
        this.gColor = new Gradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.iSz = 1;
        this.showingMenu = true;
        this.listenerList = new EventListenerList();
        this.profileMode = 0;
        this.minFit = 0.0;
        this.maxFit = 100.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String string, byte[] byArray) {
        if (string == null) {
            this.format = null;
            this.encFormat = null;
            this.errorString = "No image";
            this.statusLabel.setText("");
            this.imagePanel.setImage(null);
            this.freePopup();
            this.imageView.revalidate();
        } else {
            RawImageViewer rawImageViewer = this;
            synchronized (rawImageViewer) {
                if (this.encFormat == null || !this.encFormat.equalsIgnoreCase(string)) {
                    this.encFormat = string;
                    if (string.equalsIgnoreCase("JPEG_GRAY8")) {
                        this.format = new Jpeg8ImageFormat();
                        this.format.initDefault(this.gradientTool);
                    } else if (string.equalsIgnoreCase("GRAY8")) {
                        this.format = new Mono8ImageFormat();
                        this.format.initDefault(this.gradientTool);
                    } else if (string.equalsIgnoreCase("GRAY16")) {
                        this.format = new Mono16ImageFormat();
                        this.format.initDefault(this.gradientTool);
                    } else if (string.equalsIgnoreCase("JPEG_RGB")) {
                        this.format = new Jpeg24ImageFormat();
                        this.format.initDefault(this.gradientTool);
                        this.setGradientVisible(false);
                    } else if (string.equalsIgnoreCase("RGB24")) {
                        this.format = new RGB24ImageFormat();
                        this.format.initDefault(this.gradientTool);
                        this.setGradientVisible(false);
                    } else {
                        this.errorString = string + " format not supported";
                        this.statusLabel.setText(this.errorString);
                        this.format = null;
                    }
                    if (this.format != null) {
                        this.format.setFitting(this.isBestFit, this.minFit, this.maxFit);
                    }
                }
                if (this.format != null) {
                    try {
                        this.format.setData(byArray);
                    }
                    catch (IOException iOException) {
                        this.errorString = iOException.getMessage();
                        this.imagePanel.setImage(null);
                        this.freePopup();
                        this.imageView.revalidate();
                    }
                }
                this.computeAutoZoom();
                this.convertImage();
                this.refreshComponents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFit(boolean bl) {
        this.isBestFit = bl;
        this.applyFitting();
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
        }
    }

    public boolean isBestFit() {
        return this.isBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient gradient) {
        this.gColor = gradient;
        this.gColormap = gradient.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.gradientTool.repaint();
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNegative(boolean bl) {
        this.isNegative = bl;
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setToolbarVisible(boolean bl) {
        this.buttonView.setVisible(bl);
    }

    public boolean isToolbarVisible() {
        return this.buttonView.isVisible();
    }

    public void setStatusLineVisible(boolean bl) {
        this.cfgPanel.setVisible(bl);
    }

    public boolean isStatusLineVisible() {
        return this.cfgPanel.isVisible();
    }

    public int getZoom() {
        int n = 0;
        switch (this.iSz) {
            case -4: {
                n = 0;
                break;
            }
            case -2: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 8: {
                n = 5;
            }
        }
        return n;
    }

    public void setZoom(int n) {
        switch (n) {
            case 0: {
                this.iSz = -4;
                break;
            }
            case 1: {
                this.iSz = -2;
                break;
            }
            case 2: {
                this.iSz = 1;
                break;
            }
            case 3: {
                this.iSz = 2;
                break;
            }
            case 4: {
                this.iSz = 4;
                break;
            }
            case 5: {
                this.iSz = 8;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "NumberImageViewer.setZoom():\nInvalid zoom index value. [0..5]", "Error", 0);
                this.iSz = 1;
            }
        }
        if (this.iSz < 0) {
            this.imagePanel.setMarkerScale(-this.iSz);
        } else {
            this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
        }
        this.userZoom = true;
    }

    public void setAutoZoom(boolean bl) {
        this.autoZoom = bl;
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public void setAlignToGrid(boolean bl) {
        this.snapToGrid = bl;
        this.imagePanel.setSnapToGrid(bl);
    }

    public boolean isAlignToGrid() {
        return this.snapToGrid;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public void setShowingMenu(boolean bl) {
        this.showingMenu = bl;
    }

    public void addRoiListener(IRoiListener iRoiListener) {
        this.listenerList.add(IRoiListener.class, iRoiListener);
    }

    public void removeRoiListener(IRoiListener iRoiListener) {
        this.listenerList.remove(IRoiListener.class, iRoiListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Rectangle rectangle) {
        this.divRect(rectangle);
        this.imagePanel.setSelection(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.refreshComponents();
        }
    }

    public Rectangle getSelection() {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            this.mulRect(rectangle);
        }
        return rectangle;
    }

    public Insets getImageMargin() {
        return this.imagePanel.getMargin();
    }

    public void setImageMargin(Insets insets) {
        this.imagePanel.setMargin(insets);
    }

    public void setSelectionEnabled(boolean bl) {
        this.imagePanel.setSelectionEnabled(bl);
    }

    public boolean isSelectionEnabled() {
        return this.imagePanel.isSelectionEnabled();
    }

    public void setCrossCursor(boolean bl) {
        this.imagePanel.setCrossCursor(bl);
    }

    public void setCrossCursorColor(Color color) {
        this.imagePanel.setCursorColor(color);
    }

    public int getSelectionMode() {
        return this.imagePanel.getSelectionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionMode(int n) {
        this.imagePanel.clearSelection();
        this.imagePanel.setSelectionMode(n);
        this.freePopup();
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.refreshSelectionMinMax();
        }
    }

    public JLAxis getXAxis() {
        return this.imagePanel.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.imagePanel.getYAxis();
    }

    public void setGradientVisible(boolean bl) {
        this.gradientTool.setVisible(bl);
    }

    public boolean isGradientVisible() {
        return this.gradientTool.isVisible();
    }

    public int getImageXCoord(int n) {
        if (this.iSz < 0) {
            return (n - this.imagePanel.getXOrigin()) / -this.iSz;
        }
        return (n - this.imagePanel.getXOrigin()) * this.iSz;
    }

    public int getImageYCoord(int n) {
        if (this.iSz < 0) {
            return (n - this.imagePanel.getYOrigin()) / -this.iSz;
        }
        return (n - this.imagePanel.getYOrigin()) * this.iSz;
    }

    public Dimension getCurrentImageSize() {
        Dimension dimension = new Dimension();
        if (this.format != null) {
            dimension.width = this.format.getWidth();
            dimension.height = this.format.getHeight();
        } else {
            dimension.width = 0;
            dimension.height = 0;
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.settingsMenuItem) {
            this.showSettings();
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.settingsDialog.setVisible(false);
        } else if (actionEvent.getSource() == this.okButton) {
            this.applySettings();
        } else if (actionEvent.getSource() == this.propButton) {
            this.showPropertyFrame();
        } else if (actionEvent.getSource() == this.gradButton) {
            this.showGradientEditor();
        } else if (object == this.selectButton || object == this.selectionMenuItem) {
            this.imagePanel.clearSelection();
            this.imagePanel.setSelectionMode(1);
            this.profileMode = 0;
            this.freePopup();
            RawImageViewer rawImageViewer = this;
            synchronized (rawImageViewer) {
                this.refreshSelectionMinMax();
            }
        } else if (object == this.selectMaxButton || object == this.selectionMaxMenuItem) {
            Dimension dimension = this.imagePanel.getImageSize();
            this.imagePanel.setSelection(0, 0, dimension.width, dimension.height);
            this.selectionChanged();
        } else if (object == this.fileButton || object == this.fileMenuItem) {
            this.saveFile();
        } else if (object == this.tableButton || object == this.tableMenuItem) {
            this.showTable();
        } else if (object == this.profileButton || object == this.lineProfileMenuItem) {
            this.imagePanel.setSelectionMode(0);
            this.constructLineProfiler();
            this.lineProfiler.setLineProfileMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 1;
            RawImageViewer rawImageViewer = this;
            synchronized (rawImageViewer) {
                this.refreshLineProfile();
                this.refreshSelectionMinMax();
            }
        } else if (object == this.histoButton || object == this.histogramMenuItem) {
            this.imagePanel.setSelectionMode(1);
            this.constructLineProfiler();
            this.lineProfiler.setHistogramMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 2;
            RawImageViewer rawImageViewer = this;
            synchronized (rawImageViewer) {
                this.refreshLineProfile();
            }
        } else if (object == this.settingsButton) {
            this.showSettings();
        } else if (object == this.axisButton) {
            this.showAxisDialog();
        } else if (object == this.axisCloseButton) {
            this.axisDialog.setVisible(false);
        } else if (object == this.bestFitMenuItem) {
            this.setBestFit(!this.isBestFit());
        } else if (object == this.negativeMenuItem) {
            this.setNegative(!this.isNegative());
        } else if (object == this.snapToGridMenuItem) {
            this.setAlignToGrid(!this.isAlignToGrid());
        } else if (object == this.toolbarMenuItem) {
            this.setToolbarVisible(!this.isToolbarVisible());
        } else if (object == this.statusLineMenuItem) {
            this.setStatusLineVisible(!this.isStatusLineVisible());
        } else if (object == this.showGradMenuItem) {
            this.setGradientVisible(!this.isGradientVisible());
        } else if (object == this.statsMenuItem) {
            JOptionPane.showMessageDialog(this, this.getImageInfo(), "Image Information", 1);
        } else if (object == this.bestFitCheck) {
            boolean bl = this.bestFitCheck.isSelected();
            this.fitMinText.setEnabled(!bl);
            this.fitMaxText.setEnabled(!bl);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        if (this.format == null) {
            return;
        }
        Dimension dimension = this.getCurrentImageSize();
        int n = this.getImageXCoord(mouseEvent.getX());
        int n2 = this.getImageYCoord(mouseEvent.getY());
        if (n >= dimension.width || n2 >= dimension.height || n2 < 0 || n < 0) {
            this.statusLabel.setText(this.getLabelInfoString());
        } else {
            this.statusLabel.setText(this.getLabelInfoString() + " (" + n + "," + n2 + ")=" + this.format.getValueStr(n, n2));
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            if (this.oldSelection == null) {
                this.selectionChanged();
            } else if (!rectangle.equals(this.oldSelection)) {
                this.selectionChanged();
            }
        }
        this.oldSelection = rectangle;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && this.showingMenu && mouseEvent.getSource() == this.imagePanel) {
            this.bestFitMenuItem.setSelected(this.isBestFit());
            this.snapToGridMenuItem.setSelected(this.isAlignToGrid());
            this.negativeMenuItem.setSelected(this.isNegative());
            this.toolbarMenuItem.setSelected(this.isToolbarVisible());
            this.statusLineMenuItem.setSelected(this.isStatusLineVisible());
            this.showGradMenuItem.setSelected(this.isGradientVisible());
            if (this.format != null) {
                this.showGradMenuItem.setEnabled(!this.format.isColorFormat());
            }
            this.imgMenu.show(this.imagePanel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setData(null, null);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void rawImageChange(RawImageEvent rawImageEvent) {
        this.setData(rawImageEvent.getEncodedFormat(), rawImageEvent.getValue());
    }

    public void setModel(IRawImage iRawImage) {
        if (this.settingsDialog != null) {
            this.attNameLabel.setModel((IAttribute)iRawImage);
        }
        if (this.model != null) {
            this.model.removeRawImageListener((IRawImageListener)this);
            this.model = null;
        }
        if (iRawImage != null) {
            this.imagePanel.setImage(null);
            this.firstRefresh = !this.userZoom;
            this.freePopup();
            this.model = iRawImage;
            this.model.addRawImageListener((IRawImageListener)this);
            this.model.refresh();
        }
    }

    public void clearModel() {
        this.setModel(null);
    }

    private void constructSettingsPanel() {
        if (this.settingsDialog == null) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(null);
            jPanel.setMinimumSize(new Dimension(290, 235));
            jPanel.setPreferredSize(new Dimension(290, 235));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            jPanel.add(this.attNameLabel);
            this.attNameLabel.setModel((IAttribute)this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(this.panelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            jPanel.add(this.propButton);
            JSeparator jSeparator = new JSeparator();
            jSeparator.setBounds(0, 40, 500, 10);
            jPanel.add(jSeparator);
            this.bestFitCheck = new JCheckBox("Best fit");
            this.bestFitCheck.setSelected(false);
            this.bestFitCheck.setFont(this.panelFont);
            this.bestFitCheck.setBounds(5, 50, 85, 20);
            this.bestFitCheck.setToolTipText("Display the image using the whole color range");
            this.bestFitCheck.addActionListener(this);
            jPanel.add(this.bestFitCheck);
            JLabel jLabel = new JLabel("Min (%)");
            jLabel.setFont(this.panelFont);
            jLabel.setBounds(90, 50, 50, 20);
            jLabel.setHorizontalAlignment(2);
            jPanel.add(jLabel);
            this.fitMinText = new JTextField("");
            this.fitMinText.setMargin(this.noMargin);
            this.fitMinText.setFont(this.panelFont);
            this.fitMinText.setBounds(140, 50, 40, 20);
            jPanel.add(this.fitMinText);
            JLabel jLabel2 = new JLabel("Max (%)");
            jLabel2.setFont(this.panelFont);
            jLabel2.setBounds(190, 50, 50, 20);
            jLabel2.setHorizontalAlignment(2);
            jPanel.add(jLabel2);
            this.fitMaxText = new JTextField("");
            this.fitMaxText.setMargin(this.noMargin);
            this.fitMaxText.setFont(this.panelFont);
            this.fitMaxText.setBounds(240, 50, 40, 20);
            jPanel.add(this.fitMaxText);
            JSeparator jSeparator2 = new JSeparator();
            jSeparator2.setBounds(0, 80, 500, 10);
            jPanel.add(jSeparator2);
            JLabel jLabel3 = new JLabel("Format");
            jLabel3.setFont(this.panelFont);
            jLabel3.setBounds(5, 90, 70, 20);
            jPanel.add(jLabel3);
            this.formatText = new JTextField("");
            this.formatText.setEditable(false);
            this.formatText.setMargin(this.noMargin);
            this.formatText.setFont(this.panelFont);
            this.formatText.setBounds(80, 90, 200, 20);
            jPanel.add(this.formatText);
            JLabel jLabel4 = new JLabel("Colormap");
            jLabel4.setFont(this.panelFont);
            jLabel4.setBounds(5, 115, 70, 20);
            jPanel.add(jLabel4);
            this.gradViewer = new JGradientEditor();
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.setEditable(false);
            this.gradViewer.setToolTipText("Display the image using this colormap");
            this.gradViewer.setBounds(80, 115, 180, 20);
            jPanel.add(this.gradViewer);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(this.panelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 115, 20, 20);
            this.gradButton.addActionListener(this);
            jPanel.add(this.gradButton);
            this.negativeCheck = new JCheckBox("Negative image");
            this.negativeCheck.setSelected(false);
            this.negativeCheck.setFont(this.panelFont);
            this.negativeCheck.setBounds(5, 140, 110, 20);
            this.negativeCheck.setToolTipText("Display the negative image");
            jPanel.add(this.negativeCheck);
            JLabel jLabel5 = new JLabel("Image size");
            jLabel5.setFont(this.panelFont);
            jLabel5.setBounds(115, 140, 85, 20);
            jLabel5.setHorizontalAlignment(0);
            jPanel.add(jLabel5);
            this.imageSizeCombo = new JComboBox();
            this.imageSizeCombo.setFont(this.panelFont);
            this.imageSizeCombo.addItem("400  %");
            this.imageSizeCombo.addItem("200  %");
            this.imageSizeCombo.addItem("100  %");
            this.imageSizeCombo.addItem("50   %");
            this.imageSizeCombo.addItem("25   %");
            this.imageSizeCombo.addItem("12.5 %");
            this.imageSizeCombo.setBounds(200, 140, 80, 22);
            jPanel.add(this.imageSizeCombo);
            JSeparator jSeparator3 = new JSeparator();
            jSeparator3.setBounds(0, 168, 500, 10);
            jPanel.add(jSeparator3);
            this.snapToGridCheck = new JCheckBox("Align to grid");
            this.snapToGridCheck.setSelected(false);
            this.snapToGridCheck.setFont(this.panelFont);
            this.snapToGridCheck.setBounds(5, 175, 100, 20);
            this.snapToGridCheck.setToolTipText("Align the selection to the grid");
            jPanel.add(this.snapToGridCheck);
            JLabel jLabel6 = new JLabel("Grid spacing");
            jLabel6.setFont(this.panelFont);
            jLabel6.setBounds(110, 175, 90, 20);
            jPanel.add(jLabel6);
            this.snapToGridText = new JTextField("");
            this.snapToGridText.setMargin(this.noMargin);
            this.snapToGridText.setFont(this.panelFont);
            this.snapToGridText.setBounds(205, 175, 50, 20);
            jPanel.add(this.snapToGridText);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(this.panelFont);
            this.okButton.setBounds(5, 205, 80, 25);
            this.okButton.addActionListener(this);
            jPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(this.panelFont);
            this.cancelButton.setBounds(205, 205, 80, 25);
            this.cancelButton.addActionListener(this);
            jPanel.add(this.cancelButton);
            Window window = ATKGraphicsUtils.getWindowForComponent(this);
            this.settingsDialog = window instanceof Frame ? new JDialog((Frame)window, true) : (window instanceof Dialog ? new JDialog((Dialog)window, true) : new JDialog((Frame)null, true));
            this.settingsDialog.setResizable(false);
            this.settingsDialog.setContentPane(jPanel);
            this.settingsDialog.setTitle("Image viewer settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSettings() {
        this.constructSettingsPanel();
        this.bestFitCheck.setSelected(this.isBestFit);
        this.snapToGridCheck.setSelected(this.snapToGrid);
        this.negativeCheck.setSelected(this.isNegative);
        this.imageSizeCombo.setSelectedIndex(this.getZoom());
        this.fitMinText.setText(Double.toString(this.minFit));
        this.fitMaxText.setText(Double.toString(this.maxFit));
        this.fitMinText.setEnabled(!this.isBestFit);
        this.fitMaxText.setEnabled(!this.isBestFit);
        this.snapToGridText.setText(Integer.toString(this.imagePanel.getSnapGrid()));
        if (this.format != null) {
            if (this.format.isColorFormat()) {
                this.gradientTool.setVisible(false);
            }
            this.formatText.setText(this.format.getName());
        } else {
            this.formatText.setText("");
        }
        ATKGraphicsUtils.centerDialog(this.settingsDialog);
        this.settingsDialog.setVisible(true);
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.convertImage();
            this.refreshComponents();
        }
    }

    private void applyFitting() {
        boolean bl = true;
        try {
            if (this.fitMinText != null) {
                this.minFit = Double.parseDouble(this.fitMinText.getText());
                this.maxFit = Double.parseDouble(this.fitMaxText.getText());
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (this.format != null && !(bl = this.format.setFitting(this.isBestFit, this.minFit, this.maxFit))) {
            JOptionPane.showMessageDialog(null, "Invalid fitting parameters\nRestoring default", "Error", 0);
            this.format.setFitting(true, 0.0, 100.0);
            this.minFit = 0.0;
            this.maxFit = 100.0;
            this.isBestFit = true;
        }
    }

    private void applySettings() {
        String string = this.snapToGridText.getText();
        this.isBestFit = this.bestFitCheck.isSelected();
        this.applyFitting();
        this.snapToGrid = this.snapToGridCheck.isSelected();
        this.isNegative = this.negativeCheck.isSelected();
        this.setZoom(this.imageSizeCombo.getSelectedIndex());
        this.setAlignToGrid(this.snapToGrid);
        try {
            int n = Integer.parseInt(string);
            this.imagePanel.setSnapGrid(n);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for grid value", "Error", 0);
        }
        this.settingsDialog.setVisible(false);
    }

    private void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsDialog, true);
            }
            this.propDialog.setModel((IAttribute)this.model);
            this.propDialog.setVisible(true);
        }
    }

    private void showGradientEditor() {
        Gradient gradient = JGradientEditor.showDialog(this.settingsDialog, this.gColor);
        if (gradient != null) {
            this.gColor = gradient;
            this.gColormap = gradient.buildColorMap(65536);
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.repaint();
            this.gradientTool.setGradient(this.gColor);
            this.gradientTool.repaint();
        }
    }

    private void computeAutoZoom() {
        if (this.format == null) {
            return;
        }
        if (this.firstRefresh || this.autoZoom) {
            int n;
            int n2 = this.format.getHeight();
            if (n2 > 0 && n > 0) {
                int n3;
                if (n > 800 || n2 > 600) {
                    for (n3 = 1; (n > 800 || n2 > 600) && n3 < 8 && n % 2 == 0 && n2 % 2 == 0; n /= 2, n2 /= 2, n3 *= 2) {
                    }
                    this.iSz = n3;
                } else {
                    for (n = this.format.getWidth(); n < 600 && n2 < 400 && n3 < 4; n *= 2, n2 *= 2, n3 *= 2) {
                    }
                    this.iSz = n3 != 1 ? -n3 : 1;
                }
                if (this.iSz < 0) {
                    this.imagePanel.setMarkerScale(-this.iSz);
                } else {
                    this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
                }
                this.firstRefresh = false;
            }
        }
    }

    private void adjustToolbarSize() {
        if (this.buttonView.isVisible()) {
            this.buttonView.setPreferredSize(new Dimension(60, 0));
        }
        this.revalidate();
    }

    private void saveFile() {
        File file;
        int n = 0;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Color 24 Bits)";
            }
        };
        FileFilter fileFilter2 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Mono 8 Bits)";
            }
        };
        FileFilter fileFilter3 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Color 24 Bits)";
            }
        };
        FileFilter fileFilter4 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Mono 8 Bits)";
            }
        };
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(fileFilter3);
        jFileChooser.addChoosableFileFilter(fileFilter4);
        jFileChooser.addChoosableFileFilter(fileFilter);
        jFileChooser.addChoosableFileFilter(fileFilter2);
        jFileChooser.setDialogTitle("Save snapshot");
        int n2 = jFileChooser.showSaveDialog(this);
        if (n2 == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            FileFilter fileFilter5 = jFileChooser.getFileFilter();
            if (fileFilter5 == fileFilter || fileFilter5 == fileFilter2) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("jpg")) {
                    file = new File(file.getAbsolutePath() + ".jpg");
                }
            } else if (fileFilter5 == fileFilter3 || fileFilter5 == fileFilter4) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("png")) {
                    file = new File(file.getAbsolutePath() + ".png");
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please select a valid image format", "Error", 0);
                return;
            }
            if (file.exists()) {
                n = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n == 0) {
                if (fileFilter5 == fileFilter) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "jpg", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter5 == fileFilter2) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "jpg", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter5 == fileFilter3) {
                    try {
                        ImageIO.write((RenderedImage)this.imagePanel.getImage(), "png", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter5 == fileFilter4) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "png", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                }
            }
        }
    }

    private BufferedImage get8BitImage() {
        int n = this.imagePanel.getImage().getWidth();
        int n2 = this.imagePanel.getImage().getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private void fireRoiChange() {
        IRoiListener[] iRoiListenerArray = (IRoiListener[])this.listenerList.getListeners(IRoiListener.class);
        RoiEvent roiEvent = new RoiEvent(this, this.getSelection());
        for (int i = 0; i < iRoiListenerArray.length; ++i) {
            iRoiListenerArray[i].roiChange(roiEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectionChanged() {
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            this.refreshComponents();
        }
        this.fireRoiChange();
    }

    private void mulRect(Rectangle rectangle) {
        if (this.iSz < 0) {
            rectangle.x /= -this.iSz;
            rectangle.y /= -this.iSz;
            rectangle.width /= -this.iSz;
            rectangle.height /= -this.iSz;
        } else {
            rectangle.x *= this.iSz;
            rectangle.y *= this.iSz;
            rectangle.width *= this.iSz;
            rectangle.height *= this.iSz;
        }
    }

    private void divRect(Rectangle rectangle) {
        if (this.iSz < 0) {
            rectangle.x *= -this.iSz;
            rectangle.y *= -this.iSz;
            rectangle.width *= -this.iSz;
            rectangle.height *= -this.iSz;
        } else {
            rectangle.x /= this.iSz;
            rectangle.y /= this.iSz;
            rectangle.width /= this.iSz;
            rectangle.height /= this.iSz;
        }
    }

    private void mulPoint(Point point) {
        boolean bl = false;
        boolean bl2 = false;
        Dimension dimension = this.getCurrentImageSize();
        if (this.iSz < 0) {
            point.x /= -this.iSz;
            point.y /= -this.iSz;
        } else {
            if (point.x == dimension.width / this.iSz - 1) {
                point.x = dimension.width - 1;
                bl = true;
            }
            if (point.y == dimension.height / this.iSz - 1) {
                point.y = dimension.height - 1;
                bl2 = true;
            }
            if (!bl) {
                point.x *= this.iSz;
            }
            if (!bl2) {
                point.y *= this.iSz;
            }
        }
    }

    private void freePopup() {
        if (this.lineProfiler != null) {
            this.lineProfiler.setData(null);
        }
        if (this.tableDialog != null) {
            this.tablePanel.clearData();
        }
    }

    private void constructTablePanel() {
        if (this.tableDialog == null) {
            this.tablePanel = new JTableRow();
            this.tableDialog = new JFrame();
            this.tableDialog.setContentPane(this.tablePanel);
            this.tableDialog.setTitle("[table] ImageViewer");
            this.tableDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    RawImageViewer.this.tablePanel.clearData();
                    RawImageViewer.this.tableDialog.dispose();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTable() {
        this.constructTablePanel();
        if (this.tableDialog.isVisible()) {
            this.tableDialog.setVisible(true);
            return;
        }
        RawImageViewer rawImageViewer = this;
        synchronized (rawImageViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(this.tableDialog);
        this.tableDialog.setVisible(true);
    }

    private boolean buildTable() {
        Object[][] objectArray;
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            objectArray = this.imagePanel.getImageSize();
            rectangle = new Rectangle(0, 0, objectArray.width, objectArray.height);
        }
        this.mulRect(rectangle);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        try {
            objectArray = new Double[rectangle.height][rectangle.width];
            for (int i = 0; i < rectangle.height; ++i) {
                for (int j = 0; j < rectangle.width; ++j) {
                    objectArray[i][j] = new Double(this.format.getValue(rectangle.x + j, rectangle.y + i));
                }
            }
            this.tablePanel.setData(objectArray, rectangle.x, rectangle.y);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.out.println("Out of memory, cannot build the table");
            this.tablePanel.clearData();
        }
        return true;
    }

    private double[] buildHistogramData() {
        int n;
        double[] dArray = new double[this.format.getHistogramWidth()];
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            Dimension dimension = this.imagePanel.getImageSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        this.mulRect(rectangle);
        for (n = 0; n < dArray.length; ++n) {
            dArray[n] = 0.0;
        }
        try {
            for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
                for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                    int n2 = (int)this.format.getValue(n, i);
                    dArray[n2] = dArray[n2] + 1.0;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("NumberImageViewer.buildHistogramData() : Cannot build histogram. One or more value exceed the range [0..65535].");
            return null;
        }
        return dArray;
    }

    private void refreshComponents() {
        this.refreshLineProfile();
        this.refreshSelectionMinMax();
        if (this.tableDialog != null && this.tableDialog.isVisible()) {
            this.buildTable();
            this.tablePanel.repaint();
        }
    }

    private void constructLineProfiler() {
        if (this.lineProfiler == null) {
            this.lineProfiler = new LineProfilerViewer();
            this.lineProfiler.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    RawImageViewer.this.lineProfiler.setData(null);
                    RawImageViewer.this.lineProfiler.dispose();
                }
            });
        }
    }

    private void refreshLineProfile() {
        if (this.format == null) {
            return;
        }
        if (this.lineProfiler != null && this.lineProfiler.isVisible() && this.profileMode > 0) {
            switch (this.profileMode) {
                case 1: {
                    this.lineProfiler.setData(this.buildProfileData());
                    break;
                }
                case 2: {
                    double[] dArray = this.buildHistogramData();
                    if (dArray != null) {
                        this.lineProfiler.setData(dArray, 0);
                        break;
                    }
                    this.lineProfiler.setData(null);
                }
            }
        }
    }

    private double[] buildProfileData() {
        Dimension dimension = this.getCurrentImageSize();
        Point[] pointArray = this.imagePanel.getSelectionPoint();
        if (pointArray != null) {
            double[] dArray;
            this.mulPoint(pointArray[0]);
            this.mulPoint(pointArray[1]);
            int n = pointArray[1].x - pointArray[0].x;
            int n2 = pointArray[1].y - pointArray[0].y;
            int n3 = Math.abs(n);
            int n4 = Math.abs(n2);
            if (n3 > n4) {
                double d = (double)n2 / (double)n3;
                dArray = new double[n3 + 1];
                int n5 = pointArray[0].x;
                for (int i = 0; i <= n3; ++i) {
                    int n6 = pointArray[0].y + (int)(d * (double)i);
                    dArray[i] = n5 >= 0 && n5 < dimension.width && n6 >= 0 && n6 < dimension.height ? this.format.getValue(n5, n6) : Double.NaN;
                    if (n < 0) {
                        --n5;
                        continue;
                    }
                    ++n5;
                }
            } else {
                double d = (double)n / (double)n4;
                dArray = new double[n4 + 1];
                int n7 = pointArray[0].y;
                for (int i = 0; i <= n4; ++i) {
                    int n8 = pointArray[0].x + (int)(d * (double)i);
                    dArray[i] = n8 >= 0 && n8 < dimension.width && n7 >= 0 && n7 < dimension.height ? this.format.getValue(n8, n7) : Double.NaN;
                    if (n2 < 0) {
                        --n7;
                        continue;
                    }
                    ++n7;
                }
            }
            return dArray;
        }
        return null;
    }

    private void showAxisDialog() {
        if (this.axisDialog == null) {
            Window window = ATKGraphicsUtils.getWindowForComponent(this);
            this.axisDialog = window instanceof Frame ? new JDialog((Frame)window, false) : (window instanceof Dialog ? new JDialog((Dialog)window, false) : new JDialog((Frame)null, false));
            this.axisDialog.setTitle("Axis settings");
            JPanel jPanel = new JPanel(null);
            JTabbedPane jTabbedPane = new JTabbedPane();
            AxisPanel axisPanel = new AxisPanel(this.getXAxis(), 3, null);
            AxisPanel axisPanel2 = new AxisPanel(this.getYAxis(), 1, null);
            jTabbedPane.add("X axis", axisPanel);
            jTabbedPane.add("Y axis", axisPanel2);
            jTabbedPane.setBounds(5, 5, 300, 370);
            jPanel.add(jTabbedPane);
            this.axisCloseButton = new JButton("Close");
            this.axisCloseButton.setFont(ATKConstant.labelFont);
            this.axisCloseButton.setBounds(225, 380, 80, 25);
            jPanel.add(this.axisCloseButton);
            this.axisCloseButton.addActionListener(this);
            jPanel.setPreferredSize(new Dimension(310, 410));
            jTabbedPane.setBounds(5, 5, 300, 370);
            this.axisDialog.setContentPane(jPanel);
        }
        ATKGraphicsUtils.centerDialog(this.axisDialog);
        this.axisDialog.setVisible(true);
        this.imagePanel.repaint();
    }

    private void refreshSelectionMinMax() {
        if (this.format == null) {
            return;
        }
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            Dimension dimension = this.imagePanel.getImageSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        this.mulRect(rectangle);
        double d = 65536.0;
        double d2 = 0.0;
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                double d3 = this.format.getValue(j, i);
                if (d3 > d2) {
                    d2 = d3;
                }
                if (!(d3 < d)) continue;
                d = d3;
            }
        }
        String string = "Selection: (" + rectangle.x + "," + rectangle.y + ") - [" + rectangle.width + "," + rectangle.height + "]";
        if (d <= d2) {
            this.rangeLabel.setText(string + " Range: " + Double.toString(d) + " , " + Double.toString(d2));
        } else {
            this.rangeLabel.setText("");
        }
    }

    private String getLabelInfoString() {
        Dimension dimension = this.getCurrentImageSize();
        int n = this.iSz < 0 ? (int)(100.0 * (double)(-this.iSz)) : (int)(100.0 / (double)this.iSz);
        return n + "% [" + dimension.width + "," + dimension.height + "]";
    }

    private String getImageInfo() {
        double d;
        int n;
        int n2;
        String string = "";
        if (this.format == null) {
            return "No image";
        }
        IImageFormat iImageFormat = this.format;
        string = string + "Format: " + iImageFormat.getName() + "\n";
        string = string + "Full Width: " + iImageFormat.getWidth() + "\n";
        string = string + "Full Height: " + iImageFormat.getHeight() + "\n\n";
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            Dimension dimension = this.imagePanel.getImageSize();
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        }
        this.mulRect(rectangle);
        string = string + "Selection: (" + rectangle.x + "," + rectangle.y + ") - [" + rectangle.width + "," + rectangle.height + "]\n";
        double d2 = 65536.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n2 = rectangle.y; n2 < rectangle.y + rectangle.height; ++n2) {
            for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
                d = iImageFormat.getValue(n, n2);
                if (d > d3) {
                    d3 = d;
                }
                if (d < d2) {
                    d2 = d;
                }
                d4 += d;
                d6 += 1.0;
            }
        }
        double d7 = d4 / d6;
        for (n2 = rectangle.y; n2 < rectangle.y + rectangle.height; ++n2) {
            for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
                d = iImageFormat.getValue(n, n2);
                d5 += (d - d7) * (d - d7);
            }
        }
        double d8 = Math.sqrt(d5 / d6);
        Double d9 = new Double(d7);
        Double d10 = new Double(d8);
        if (d2 <= d3) {
            string = string + "Minimum: " + Double.toString(d2) + "\n";
            string = string + "Maximum: " + Double.toString(d3) + "\n";
        }
        string = string + "Average: " + String.format("%.2f", d9) + "\n";
        string = string + "Std deviation: " + String.format("%.2f", d10) + "\n";
        return string;
    }

    private void convertImage() {
        int n;
        int n2;
        if (this.format == null || this.format.isNull()) {
            this.statusLabel.setText(this.errorString);
            return;
        }
        int n3 = this.format.getWidth();
        int n4 = this.format.getHeight();
        if (n3 == 0 || n4 == 0) {
            return;
        }
        BufferedImage bufferedImage = this.imagePanel.getImage();
        if (this.iSz < 0) {
            n2 = n3 * -this.iSz;
            n = n4 * -this.iSz;
        } else {
            n2 = n3 / this.iSz;
            n = n4 / this.iSz;
        }
        if (bufferedImage == null || bufferedImage.getHeight() != n || bufferedImage.getWidth() != n2) {
            bufferedImage = new BufferedImage(n2, n, 1);
            this.imagePanel.setImage(bufferedImage);
            this.freePopup();
            this.statusLabel.setText(this.getLabelInfoString());
            this.refreshComponents();
        }
        int[] nArray = new int[n2];
        this.format.computeFitting();
        if (this.isGradientVisible()) {
            this.gradientTool.repaint();
        }
        if (this.iSz < 0) {
            int n5 = -this.iSz;
            for (int i = 0; i < n4; ++i) {
                int n6;
                for (n6 = 0; n6 < n3; ++n6) {
                    int n7 = this.format.getRGB(this.isNegative, this.gColormap, n6, i);
                    for (int j = 0; j < n5; ++j) {
                        nArray[n6 * n5 + j] = n7;
                    }
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    bufferedImage.setRGB(0, i * n5 + n6, n2, 1, nArray, 0, n2);
                }
            }
        } else {
            int n8 = 0;
            for (int i = 0; i < n; ++i) {
                int n9 = 0;
                for (int j = 0; j < n2; ++j) {
                    nArray[j] = this.format.getRGB(this.isNegative, this.gColormap, n9, n8);
                    n9 += this.iSz;
                }
                bufferedImage.setRGB(0, i, n2, 1, nArray, 0, n2);
                n8 += this.iSz;
            }
        }
        this.imagePanel.repaint();
        this.imageView.revalidate();
    }

    public static void main(String[] stringArray) {
        Object object;
        JFrame jFrame = new JFrame();
        final RawImageViewer rawImageViewer = new RawImageViewer();
        rawImageViewer.setCrossCursor(true);
        rawImageViewer.setBestFit(true);
        final AttributeList attributeList = new AttributeList();
        final ErrorHistory errorHistory = new ErrorHistory();
        attributeList.addErrorListener((IErrorListener)errorHistory);
        try {
            object = (IRawImage)attributeList.add("sr/d-ccd/id25-a/jpegimage");
            rawImageViewer.setModel((IRawImage)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)rawImageViewer, "Center");
        object = new JPanel();
        JButton jButton = new JButton("Show errors");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                errorHistory.setVisible(true);
            }
        });
        ((Container)object).add(jButton);
        JButton jButton2 = new JButton("Show diag");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        ((Container)object).add(jButton2);
        JButton jButton3 = new JButton("Change model");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    IRawImage iRawImage = (IRawImage)attributeList.add("sr/d-ccd/d9-a/jpegimage");
                    rawImageViewer.setModel(iRawImage);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        ((Container)object).add(jButton3);
        jFrame.getContentPane().add((Component)object, "South");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("RawImageViewer");
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.setRefreshInterval(1000);
        attributeList.startRefresher();
    }
}

