/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IImageListener;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.NumberImageEvent;
import fr.esrf.tangoatk.widget.attribute.IRoiListener;
import fr.esrf.tangoatk.widget.attribute.RoiEvent;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.image.LineProfilerViewer;
import fr.esrf.tangoatk.widget.properties.LabelViewer;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKDiagnostic;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.JGradientEditor;
import fr.esrf.tangoatk.widget.util.JGradientViewer;
import fr.esrf.tangoatk.widget.util.JImage;
import fr.esrf.tangoatk.widget.util.JSmoothLabel;
import fr.esrf.tangoatk.widget.util.JTableRow;
import fr.esrf.tangoatk.widget.util.MultiExtFileFilter;
import fr.esrf.tangoatk.widget.util.chart.AxisPanel;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;

public class NumberImageViewer
extends JPanel
implements IImageListener,
MouseMotionListener,
MouseListener,
ActionListener,
KeyListener,
JDrawable {
    INumberImage model;
    protected double[][] doubleValues = null;
    private Rectangle oldSelection = null;
    protected int profileMode;
    private boolean showingMenu;
    private boolean snapToGrid;
    private boolean sigHistogram;
    private boolean rectXYmode;
    private boolean isNegative;
    private int integrationWidthH;
    private int integrationWidthV;
    protected int startHisto;
    private Gradient gColor;
    private int[] gColormap;
    private int iSz;
    private EventListenerList listenerList;
    protected Insets noMargin = new Insets(0, 0, 0, 0);
    private boolean autoZoom = false;
    private boolean firstRefresh = false;
    private boolean userZoom = false;
    private int verticalExtent = 1;
    private String lastConfig = "";
    private boolean isBestFit;
    private boolean autoBestFit;
    private double bfMin = 0.0;
    private double bfMax = 65536.0;
    private double autoBfMin;
    private double autoBfMax;
    private double bfa0;
    private double bfa1;
    private double curSelMin;
    private double curSelMax;
    protected JImage imagePanel;
    protected JScrollPane imageView;
    protected JPanel buttonPanel;
    protected JButton selectButton;
    protected JButton selectMaxButton;
    protected JButton selectColorButton;
    protected JButton fileButton;
    protected JButton zoomButton;
    protected JButton tableButton;
    protected JButton profileButton;
    protected JButton profile2Button;
    protected JButton histoButton;
    protected JButton settingsButton;
    protected JButton axisButton;
    protected JButton loadButton;
    protected JButton saveButton;
    protected JButton printButton;
    protected JScrollPane buttonView;
    private Font panelFont;
    private JPanel cfgPanel;
    private JLabel statusLabel;
    private JLabel rangeLabel;
    private JLabel avgLabel;
    private JLabel selLabel;
    protected JTextField selText;
    protected JPopupMenu imgMenu;
    protected JMenuItem infoMenuItem;
    protected JCheckBoxMenuItem bestFitMenuItem;
    protected JCheckBoxMenuItem snapToGridMenuItem;
    protected JCheckBoxMenuItem negativeMenuItem;
    protected JCheckBoxMenuItem toolbarMenuItem;
    protected JCheckBoxMenuItem statusLineMenuItem;
    protected JCheckBoxMenuItem showGradMenuItem;
    protected JMenuItem selectionMenuItem;
    protected JMenuItem selectionMaxMenuItem;
    protected JMenuItem selectionColorMenuItem;
    protected JMenuItem fileMenuItem;
    protected JMenuItem zoomMenuItem;
    protected JMenuItem tableMenuItem;
    protected JMenuItem lineProfileMenuItem;
    protected JMenuItem lineProfile2MenuItem;
    protected JMenu dblProfileMenu;
    protected JCheckBoxMenuItem vLeftCheckMenuItem;
    protected JCheckBoxMenuItem vCenterCheckMenuItem;
    protected JCheckBoxMenuItem vRigthCheckMenuItem;
    protected JCheckBoxMenuItem hTopCheckMenuItem;
    protected JCheckBoxMenuItem hCenterCheckMenuItem;
    protected JCheckBoxMenuItem hBottomCheckMenuItem;
    protected JMenuItem histogramMenuItem;
    protected JMenuItem settingsMenuItem;
    protected JMenuItem loadMenuItem;
    protected JMenuItem saveMenuItem;
    protected JMenuItem saveDataFileMenuItem;
    protected JMenuItem printMenuItem;
    protected JCheckBoxMenuItem displayLogMenuItem;
    private JGradientViewer gradientTool;
    protected LineProfilerViewer lineProfiler = null;
    private JFrame zoomDialog = null;
    private JPanel zoomPanel;
    private JScrollPane zoomView;
    private JImage zoomImage;
    private JPanel zoomCfgPanel;
    private JComboBox zoomCombo;
    private int zoomFactor;
    private int zoomXOrg;
    private int zoomYOrg;
    private JLabel zoomText;
    private JDialog settingsDialog = null;
    private JPanel settingsPanel;
    private LabelViewer attNameLabel;
    private JButton propButton;
    private JCheckBox sigHistogramCheck;
    private JCheckBox rectDisplayCheck;
    private JCheckBox bestFitCheck;
    private JCheckBox autoBestFitCheck;
    private JLabel minBestFitLabel;
    private JTextField minBestFitText;
    private JLabel maxBestFitLabel;
    private JTextField maxBestFitText;
    private JLabel integrationWidthHLabel;
    private JTextField integrationWidthHText;
    private JLabel integrationWidthVLabel;
    private JTextField integrationWidthVText;
    private JCheckBox snapToGridCheck;
    private JLabel snapToGridLabel;
    private JTextField snapToGridText;
    private JCheckBox negativeCheck;
    private JComboBox imageSizeCombo;
    private JLabel imageSizeLabel;
    private JGradientEditor gradViewer;
    private JButton gradButton;
    private JLabel gradLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JDialog axisDialog = null;
    private JTabbedPane tabPane;
    private AxisPanel xAxisPanel;
    private AxisPanel yAxisPanel;
    private JButton axisCloseButton;
    private JFrame tableDialog = null;
    private JTableRow tablePanel;
    SimplePropertyFrame propDialog = null;
    static String[] exts = new String[]{"toolBarVisible", "statusLineVisible", "gradientVisible", "bestFit", "zoom", "xAxis", "yAxis"};
    protected String lastSnapshotLocation = ".";
    protected FileFilter lastFileFilter = null;
    protected boolean logValues = false;
    private int rgbNaN = 0;
    private Color colorNaN = null;

    public NumberImageViewer() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.initImagePanel();
        this.initButtonPanel();
        this.initGradient();
        this.initStatusLine();
        this.initPopupMenu();
        this.isBestFit = true;
        this.rectXYmode = false;
        this.integrationWidthH = 1;
        this.integrationWidthV = 1;
        this.setAlignToGrid(true);
        this.autoBestFit = true;
        this.sigHistogram = false;
        this.isNegative = false;
        this.showingMenu = true;
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        this.startHisto = 0;
        this.zoomFactor = 0;
        this.iSz = 1;
        this.listenerList = new EventListenerList();
    }

    protected void initImagePanel() {
        this.imagePanel = new JImage();
        this.imagePanel.setBorder(null);
        this.imagePanel.setSnapGrid(8);
        this.imageView = new JScrollPane(this.imagePanel);
        this.add((Component)this.imageView, "Center");
        this.imagePanel.addMouseMotionListener(this);
        this.imagePanel.addMouseListener(this);
        this.imagePanel.addKeyListener(this);
    }

    protected void initButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(null);
        this.buttonPanel.setMinimumSize(new Dimension(60, 575));
        this.buttonPanel.setPreferredSize(new Dimension(60, 575));
        this.buttonView = new JScrollPane(this.buttonPanel);
        this.buttonView.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.buttonView, "West");
        this.selectButton = new JButton();
        this.selectButton.setMargin(this.noMargin);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select.gif")));
        this.selectButton.setBounds(2, 5, 36, 36);
        this.selectButton.setToolTipText("Free selection");
        this.selectButton.addActionListener(this);
        this.buttonPanel.add(this.selectButton);
        this.selectMaxButton = new JButton();
        this.selectMaxButton.setMargin(this.noMargin);
        this.selectMaxButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_selectmax.gif")));
        this.selectMaxButton.setBounds(2, 40, 36, 36);
        this.selectMaxButton.setToolTipText("Select whole image");
        this.selectMaxButton.addActionListener(this);
        this.buttonPanel.add(this.selectMaxButton);
        this.selectColorButton = new JButton();
        this.selectColorButton.setMargin(this.noMargin);
        this.selectColorButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_select_color.gif")));
        this.selectColorButton.setBounds(2, 75, 36, 36);
        this.selectColorButton.setToolTipText("Selection Color...");
        this.selectColorButton.addActionListener(this);
        this.buttonPanel.add(this.selectColorButton);
        this.fileButton = new JButton();
        this.fileButton.setMargin(this.noMargin);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_snapshot.gif")));
        this.fileButton.setBounds(2, 115, 36, 36);
        this.fileButton.setToolTipText("Save snapshot");
        this.fileButton.addActionListener(this);
        this.buttonPanel.add(this.fileButton);
        this.zoomButton = new JButton();
        this.zoomButton.setMargin(this.noMargin);
        this.zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_zoom.gif")));
        this.zoomButton.setBounds(2, 155, 36, 36);
        this.zoomButton.setToolTipText("Zoom selection");
        this.zoomButton.addActionListener(this);
        this.buttonPanel.add(this.zoomButton);
        this.tableButton = new JButton();
        this.tableButton.setMargin(this.noMargin);
        this.tableButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_table.gif")));
        this.tableButton.setBounds(2, 195, 36, 36);
        this.tableButton.setToolTipText("Selection to table");
        this.tableButton.addActionListener(this);
        this.buttonPanel.add(this.tableButton);
        this.profileButton = new JButton();
        this.profileButton.setMargin(this.noMargin);
        this.profileButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile.gif")));
        this.profileButton.setBounds(2, 240, 36, 36);
        this.profileButton.setToolTipText("Line profile");
        this.profileButton.addActionListener(this);
        this.buttonPanel.add(this.profileButton);
        this.profile2Button = new JButton();
        this.profile2Button.setMargin(this.noMargin);
        this.profile2Button.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_profile2.gif")));
        this.profile2Button.setBounds(2, 280, 36, 36);
        this.profile2Button.setToolTipText("Line profiles");
        this.profile2Button.addActionListener(this);
        this.buttonPanel.add(this.profile2Button);
        this.histoButton = new JButton();
        this.histoButton.setMargin(this.noMargin);
        this.histoButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_histo.gif")));
        this.histoButton.setBounds(2, 320, 36, 36);
        this.histoButton.setToolTipText("Histogram");
        this.histoButton.addActionListener(this);
        this.buttonPanel.add(this.histoButton);
        this.settingsButton = new JButton();
        this.settingsButton.setMargin(this.noMargin);
        this.settingsButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_option.gif")));
        this.settingsButton.setBounds(2, 365, 36, 36);
        this.settingsButton.setToolTipText("Image viewer settings");
        this.settingsButton.addActionListener(this);
        this.buttonPanel.add(this.settingsButton);
        this.axisButton = new JButton();
        this.axisButton.setIcon(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_axis.gif")));
        this.axisButton.setMargin(this.noMargin);
        this.axisButton.setBounds(2, 405, 36, 36);
        this.axisButton.setToolTipText("Axis settings");
        this.axisButton.addActionListener(this);
        this.buttonPanel.add(this.axisButton);
        this.loadButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_load_settings.gif")));
        this.loadButton.setToolTipText("Load settings");
        this.loadButton.setMargin(this.noMargin);
        this.loadButton.setBounds(2, 450, 36, 36);
        this.loadButton.addActionListener(this);
        this.buttonPanel.add(this.loadButton);
        this.saveButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_save_settings.gif")));
        this.saveButton.setToolTipText("Save settings");
        this.saveButton.setMargin(this.noMargin);
        this.saveButton.setBounds(2, 490, 36, 36);
        this.saveButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/image/img_print.gif")));
        this.printButton.setToolTipText("Print Image");
        this.printButton.setMargin(this.noMargin);
        this.printButton.setBounds(2, 535, 36, 36);
        this.printButton.addActionListener(this);
        this.buttonPanel.add(this.printButton);
    }

    protected void initGradient() {
        this.gradientTool = new JGradientViewer();
        this.gradientTool.getAxis().setMinimum(0.0);
        this.gradientTool.getAxis().setMaximum(65536.0);
        this.add((Component)this.gradientTool, "East");
        this.gColor = new Gradient();
        this.gColor.buildRainbowGradient();
        this.gColormap = this.gColor.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
    }

    protected void initStatusLine() {
        this.cfgPanel = new JPanel();
        this.cfgPanel.setLayout(null);
        this.cfgPanel.setPreferredSize(new Dimension(0, 50));
        this.add((Component)this.cfgPanel, "South");
        this.panelFont = new Font("Dialog", 0, 11);
        this.statusLabel = new JLabel("");
        this.statusLabel.setFont(this.panelFont);
        this.statusLabel.setBounds(5, 3, 290, 20);
        this.cfgPanel.add(this.statusLabel);
        this.rangeLabel = new JLabel("");
        this.rangeLabel.setFont(this.panelFont);
        this.rangeLabel.setBounds(305, 3, 300, 20);
        this.cfgPanel.add(this.rangeLabel);
        this.avgLabel = new JLabel("");
        this.avgLabel.setFont(this.panelFont);
        this.avgLabel.setBounds(305, 25, 300, 20);
        this.cfgPanel.add(this.avgLabel);
        this.selLabel = new JLabel("Selection");
        this.selLabel.setFont(this.panelFont);
        this.selLabel.setBounds(5, 25, 55, 20);
        this.cfgPanel.add(this.selLabel);
        this.selText = new JTextField("None");
        this.selText.setMargin(this.noMargin);
        this.selText.setFont(this.panelFont);
        this.selText.setBounds(65, 25, 230, 20);
        this.selText.addKeyListener(this);
        this.cfgPanel.add(this.selText);
    }

    protected void initPopupMenu() {
        this.imgMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem("Image Viewer");
        this.infoMenuItem.setEnabled(false);
        this.bestFitMenuItem = new JCheckBoxMenuItem("Best fit");
        this.bestFitMenuItem.addActionListener(this);
        this.snapToGridMenuItem = new JCheckBoxMenuItem("Align to grid");
        this.snapToGridMenuItem.addActionListener(this);
        this.negativeMenuItem = new JCheckBoxMenuItem("Negative image");
        this.negativeMenuItem.addActionListener(this);
        this.toolbarMenuItem = new JCheckBoxMenuItem("Show toolbar");
        this.toolbarMenuItem.addActionListener(this);
        this.statusLineMenuItem = new JCheckBoxMenuItem("Show status line");
        this.statusLineMenuItem.addActionListener(this);
        this.showGradMenuItem = new JCheckBoxMenuItem("Show gradient");
        this.showGradMenuItem.addActionListener(this);
        this.selectionMenuItem = new JMenuItem("Free selection");
        this.selectionMenuItem.addActionListener(this);
        this.selectionMaxMenuItem = new JMenuItem("Select all");
        this.selectionMaxMenuItem.addActionListener(this);
        this.selectionColorMenuItem = new JMenuItem("Selection Color...");
        this.selectionColorMenuItem.addActionListener(this);
        this.lineProfileMenuItem = new JMenuItem("Line profile");
        this.lineProfileMenuItem.addActionListener(this);
        this.lineProfile2MenuItem = new JMenuItem("Line profiles");
        this.lineProfile2MenuItem.addActionListener(this);
        this.dblProfileMenu = new JMenu("Position");
        this.hTopCheckMenuItem = new JCheckBoxMenuItem("Horizontal Line (Top)");
        this.hTopCheckMenuItem.addActionListener(this);
        this.dblProfileMenu.add(this.hTopCheckMenuItem);
        this.hCenterCheckMenuItem = new JCheckBoxMenuItem("Horizontal Line (Center)");
        this.hCenterCheckMenuItem.addActionListener(this);
        this.dblProfileMenu.add(this.hCenterCheckMenuItem);
        this.hBottomCheckMenuItem = new JCheckBoxMenuItem("Horizontal Line (Bottom)");
        this.hBottomCheckMenuItem.addActionListener(this);
        this.dblProfileMenu.add(this.hBottomCheckMenuItem);
        this.dblProfileMenu.add(new JSeparator());
        this.vLeftCheckMenuItem = new JCheckBoxMenuItem("Vertical Line (Left)");
        this.vLeftCheckMenuItem.addActionListener(this);
        this.dblProfileMenu.add(this.vLeftCheckMenuItem);
        this.vCenterCheckMenuItem = new JCheckBoxMenuItem("Vertical Line (Center)");
        this.vCenterCheckMenuItem.addActionListener(this);
        this.dblProfileMenu.add(this.vCenterCheckMenuItem);
        this.vRigthCheckMenuItem = new JCheckBoxMenuItem("Vertical Line (Right)");
        this.vRigthCheckMenuItem.addActionListener(this);
        this.dblProfileMenu.add(this.vRigthCheckMenuItem);
        this.refreshDblProfileMenu();
        this.histogramMenuItem = new JMenuItem("Histogram");
        this.histogramMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save selection");
        this.fileMenuItem.addActionListener(this);
        this.saveDataFileMenuItem = new JMenuItem("Save selection in data file");
        this.saveDataFileMenuItem.addActionListener(this);
        this.zoomMenuItem = new JMenuItem("Zoom selection");
        this.zoomMenuItem.addActionListener(this);
        this.settingsMenuItem = new JMenuItem("Settings");
        this.settingsMenuItem.addActionListener(this);
        this.tableMenuItem = new JMenuItem("Selection to table");
        this.tableMenuItem.addActionListener(this);
        this.loadMenuItem = new JMenuItem("Load settings");
        this.loadMenuItem.addActionListener(this);
        this.saveMenuItem = new JMenuItem("Save settings");
        this.saveMenuItem.addActionListener(this);
        this.printMenuItem = new JMenuItem("Print image");
        this.printMenuItem.addActionListener(this);
        this.displayLogMenuItem = new JCheckBoxMenuItem("Display log values");
        this.displayLogMenuItem.addActionListener(this);
        this.imgMenu.add(this.infoMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.bestFitMenuItem);
        this.imgMenu.add(this.negativeMenuItem);
        this.imgMenu.add(this.snapToGridMenuItem);
        this.imgMenu.add(this.toolbarMenuItem);
        this.imgMenu.add(this.statusLineMenuItem);
        this.imgMenu.add(this.showGradMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.selectionMenuItem);
        this.imgMenu.add(this.selectionMaxMenuItem);
        this.imgMenu.add(this.selectionColorMenuItem);
        this.imgMenu.add(this.fileMenuItem);
        this.imgMenu.add(this.saveDataFileMenuItem);
        this.imgMenu.add(this.zoomMenuItem);
        this.imgMenu.add(this.tableMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.lineProfileMenuItem);
        this.imgMenu.add(this.lineProfile2MenuItem);
        this.imgMenu.add(this.dblProfileMenu);
        this.imgMenu.add(this.histogramMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.settingsMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.loadMenuItem);
        this.imgMenu.add(this.saveMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.printMenuItem);
        this.imgMenu.add(new JSeparator());
        this.imgMenu.add(this.displayLogMenuItem);
    }

    @Override
    public void initForEditing() {
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String string) {
        if (string.equalsIgnoreCase("toolBarVisible")) {
            return "Displays the left toolbar.";
        }
        if (string.equalsIgnoreCase("statusLineVisible")) {
            return "Displays the bottom status line.";
        }
        if (string.equalsIgnoreCase("gradientVisible")) {
            return "Displays the right gradient scale";
        }
        if (string.equalsIgnoreCase("bestFit")) {
            return "Displays the image using the whole color range";
        }
        if (string.equalsIgnoreCase("zoom")) {
            return "zoom factor: 0=800%, 1=400%, 2=200%, 3=100%, 4=50%, 5=25%, 6=12.5%";
        }
        if (string.equalsIgnoreCase("xAxis")) {
            return JLAxis.getHelpString();
        }
        if (string.equalsIgnoreCase("yAxis")) {
            return JLAxis.getHelpString();
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setExtendedParam(String string, String string2, boolean bl) {
        CfFileReader cfFileReader;
        if (string.equalsIgnoreCase("toolBarVisible")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setToolbarVisible(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setToolbarVisible(false);
                return true;
            }
            this.showJdrawError(bl, "toolBarVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("statusLineVisible")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setStatusLineVisible(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setStatusLineVisible(false);
                return true;
            }
            this.showJdrawError(bl, "statusLineVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("gradientVisible")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setGradientVisible(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setGradientVisible(false);
                return true;
            }
            this.showJdrawError(bl, "gradientVisible", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("bestFit")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setBestFit(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setBestFit(false);
                return true;
            }
            this.showJdrawError(bl, "bestFit", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("zoom")) {
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.showJdrawError(bl, "zoom", "Wrong number syntax.");
                return false;
            }
            if (n >= 0 && n <= 6) {
                this.setZoom(n);
                return false;
            }
            this.showJdrawError(bl, "zoom", "Invalid value: 0 to 6 allowed.");
            return false;
        }
        if (string.equalsIgnoreCase("xAxis")) {
            CfFileReader cfFileReader2;
            if (!string2.endsWith("\n")) {
                string2 = string2 + "\n";
            }
            if (!(cfFileReader2 = new CfFileReader()).parseText(string2)) {
                this.showJdrawError(bl, "xAxis settings", "Failed to parse given config");
                return false;
            }
            this.getXAxis().applyConfiguration("x", cfFileReader2);
            return true;
        }
        if (!string.equalsIgnoreCase("yAxis")) return false;
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        if (!(cfFileReader = new CfFileReader()).parseText(string2)) {
            this.showJdrawError(bl, "yAxis settings", "Failed to parse given config");
            return false;
        }
        this.getYAxis().applyConfiguration("y", cfFileReader);
        return true;
    }

    @Override
    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("toolBarVisible")) {
            return this.isToolbarVisible() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("statusLineVisible")) {
            return this.isStatusLineVisible() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("gradientVisible")) {
            return this.isGradientVisible() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("bestFit")) {
            return this.isBestFit() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("zoom")) {
            return Integer.toString(this.getZoom());
        }
        if (string.equalsIgnoreCase("xAxis")) {
            return this.getXAxis().getConfiguration("x");
        }
        if (string.equalsIgnoreCase("yAxis")) {
            return this.getYAxis().getConfiguration("y");
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "NumberImageViewer: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    public void addRoiListener(IRoiListener iRoiListener) {
        this.listenerList.add(IRoiListener.class, iRoiListener);
    }

    public void removeRoiListener(IRoiListener iRoiListener) {
        this.listenerList.remove(IRoiListener.class, iRoiListener);
    }

    public void fireRoiChange() {
        IRoiListener[] iRoiListenerArray = (IRoiListener[])this.listenerList.getListeners(IRoiListener.class);
        RoiEvent roiEvent = new RoiEvent(this, this.getSelection());
        for (int i = 0; i < iRoiListenerArray.length; ++i) {
            iRoiListenerArray[i].roiChange(roiEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFit(boolean bl) {
        this.isBestFit = bl;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isBestFit() {
        return this.isBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoBestFit(boolean bl) {
        this.autoBestFit = bl;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isAutoBestFit() {
        return this.autoBestFit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBestFitMinMax(double d, double d2) {
        if (d < d2) {
            this.bfMin = d;
            this.bfMax = d2;
        }
        if (!this.autoBestFit) {
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.convertImage();
                if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                    this.buildZoom();
                }
            }
        }
    }

    public double getBestFitMin() {
        return this.bfMin;
    }

    public double getBestFitMax() {
        return this.bfMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGradient(Gradient gradient) {
        this.gColor = gradient;
        this.gColormap = gradient.buildColorMap(65536);
        this.gradientTool.setGradient(this.gColor);
        this.gradientTool.repaint();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public Gradient getGradient() {
        return this.gColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNegative(boolean bl) {
        this.isNegative = bl;
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
                this.buildZoom();
            }
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setAlignToGrid(boolean bl) {
        this.snapToGrid = bl;
        this.imagePanel.setSnapToGrid(bl);
    }

    public boolean isAlignToGrid() {
        return this.snapToGrid;
    }

    public void setToolbarVisible(boolean bl) {
        this.buttonView.setVisible(bl);
    }

    public boolean isToolbarVisible() {
        return this.buttonView.isVisible();
    }

    public void setStatusLineVisible(boolean bl) {
        this.cfgPanel.setVisible(bl);
    }

    public boolean isStatusLineVisible() {
        return this.cfgPanel.isVisible();
    }

    public void setGradientVisible(boolean bl) {
        this.gradientTool.setVisible(bl);
    }

    public boolean isGradientVisible() {
        return this.gradientTool.isVisible();
    }

    public void setShowingMenu(boolean bl) {
        this.showingMenu = bl;
    }

    public void setZoom(int n) {
        switch (n) {
            case 0: {
                this.iSz = -8;
                break;
            }
            case 1: {
                this.iSz = -4;
                break;
            }
            case 2: {
                this.iSz = -2;
                break;
            }
            case 3: {
                this.iSz = 1;
                break;
            }
            case 4: {
                this.iSz = 2;
                break;
            }
            case 5: {
                this.iSz = 4;
                break;
            }
            case 6: {
                this.iSz = 8;
                break;
            }
            default: {
                JOptionPane.showMessageDialog(this, "NumberImageViewer.setZoom():\nInvalid zoom index value. [0..5]", "Error", 0);
                this.iSz = 1;
            }
        }
        if (this.iSz < 0) {
            this.imagePanel.setMarkerScale(-this.iSz);
        } else {
            this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
        }
        this.userZoom = true;
    }

    public int getZoom() {
        int n = 0;
        switch (this.iSz) {
            case -8: {
                n = 0;
                break;
            }
            case -4: {
                n = 1;
                break;
            }
            case -2: {
                n = 2;
                break;
            }
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 8: {
                n = 6;
            }
        }
        return n;
    }

    public void setAutoZoom(boolean bl) {
        this.autoZoom = bl;
    }

    public boolean getAutoZoom() {
        return this.autoZoom;
    }

    public boolean isShowingMenu() {
        return this.showingMenu;
    }

    public Insets getImageMargin() {
        return this.imagePanel.getMargin();
    }

    public void setImageMargin(Insets insets) {
        this.imagePanel.setMargin(insets);
    }

    public Dimension getCurrentImageSize() {
        if (this.doubleValues == null) {
            return new Dimension(0, 0);
        }
        int n = this.doubleValues.length;
        if (n == 0) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.doubleValues[0].length, n);
    }

    public void setSelectionEnabled(boolean bl) {
        this.imagePanel.setSelectionEnabled(bl);
    }

    public boolean isSelectionEnabled() {
        return this.imagePanel.isSelectionEnabled();
    }

    public void setCrossCursor(boolean bl) {
        this.imagePanel.setCrossCursor(bl);
    }

    public void setCrossCursorColor(Color color) {
        this.imagePanel.setCursorColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(Rectangle rectangle) {
        this.divRect(rectangle);
        this.imagePanel.setSelection(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshComponents();
        }
    }

    public Rectangle getSelection() {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            this.mulRect(rectangle);
        }
        return rectangle;
    }

    public int getSelectionMode() {
        return this.imagePanel.getSelectionMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectionMode(int n) {
        this.imagePanel.clearSelection();
        this.imagePanel.setSelectionMode(n);
        this.freePopup();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshStatusLine();
            this.refreshSelectionMinMax();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(double[][] dArray) {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.doubleValues = dArray;
            this.computeVerticalExtent();
            this.computeAutoZoom();
            this.convertImage();
            this.refreshComponents();
        }
        if (this.doubleValues == null) {
            this.imagePanel.setImage(null);
            this.freePopup();
        }
        this.imagePanel.revalidate();
        this.imagePanel.repaint();
        this.imageView.revalidate();
        this.imageView.repaint();
    }

    public void loadImage(String string) throws IOException {
        File file = new File(string);
        BufferedImage bufferedImage = ImageIO.read(file);
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n];
        double[][] dArray = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            bufferedImage.getRGB(0, i, n, 1, nArray, 0, n);
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = (nArray[j] & 0xFF00) >> 8;
            }
        }
        this.setData(dArray);
    }

    public int addCrossMarker(int n, int n2, Color color) {
        return this.imagePanel.addCrossMarker(n, n2, color);
    }

    public int addRectangleMarker(int n, int n2, int n3, int n4, Color color) {
        return this.imagePanel.addRectangleMarker(n, n2, n3, n4, color);
    }

    public int addVerticalLineMarker(int n, Color color) {
        return this.imagePanel.addVerticalLineMarker(n, color);
    }

    public int addHorizontalLineMarker(int n, Color color) {
        return this.imagePanel.addHorizontalLineMarker(n, color);
    }

    public void setMarkerPos(int n, int n2, int n3, int n4, int n5) {
        this.imagePanel.setMarkerPos(n, n2, n3, n4, n5);
    }

    public void clearMarkers() {
        this.imagePanel.clearMarkers();
    }

    public boolean hasMarker() {
        return this.imagePanel.getMarkerNumber() > 0;
    }

    public JLAxis getXAxis() {
        return this.imagePanel.getXAxis();
    }

    public JLAxis getYAxis() {
        return this.imagePanel.getYAxis();
    }

    public JLAxis getGradientAxis() {
        return this.gradientTool.getAxis();
    }

    public int getImageXCoord(int n) {
        if (this.iSz < 0) {
            return (n - this.imagePanel.getXOrigin()) / -this.iSz;
        }
        return (n - this.imagePanel.getXOrigin()) * this.iSz;
    }

    public int getImageYCoord(int n) {
        if (this.iSz < 0) {
            return (n - this.imagePanel.getYOrigin()) / -this.iSz;
        }
        return (n - this.imagePanel.getYOrigin()) * this.iSz;
    }

    public void setVerticalExtent(int n) {
        this.verticalExtent = n;
    }

    private void refreshDblProfileMenu() {
        this.dblProfileMenu.setEnabled(this.profileMode == 3);
        if (this.profileMode == 3) {
            this.hTopCheckMenuItem.setState(false);
            this.hCenterCheckMenuItem.setState(false);
            this.hBottomCheckMenuItem.setState(false);
            switch (this.imagePanel.getHorizontalPosition()) {
                case 0: {
                    this.hTopCheckMenuItem.setState(true);
                    break;
                }
                case 1: {
                    this.hCenterCheckMenuItem.setState(true);
                    break;
                }
                case 2: {
                    this.hBottomCheckMenuItem.setState(true);
                }
            }
            this.vLeftCheckMenuItem.setState(false);
            this.vCenterCheckMenuItem.setState(false);
            this.vRigthCheckMenuItem.setState(false);
            switch (this.imagePanel.getVerticalPosition()) {
                case 0: {
                    this.vLeftCheckMenuItem.setState(true);
                    break;
                }
                case 1: {
                    this.vCenterCheckMenuItem.setState(true);
                    break;
                }
                case 2: {
                    this.vRigthCheckMenuItem.setState(true);
                }
            }
        }
    }

    protected void mulRect(Rectangle rectangle) {
        if (this.iSz < 0) {
            rectangle.x /= -this.iSz;
            rectangle.y /= -this.iSz;
            rectangle.width /= -this.iSz;
            rectangle.height /= -this.iSz;
        } else {
            rectangle.x *= this.iSz;
            rectangle.y *= this.iSz;
            rectangle.width *= this.iSz;
            rectangle.height *= this.iSz;
        }
    }

    private void divRect(Rectangle rectangle) {
        if (this.iSz < 0) {
            rectangle.x *= -this.iSz;
            rectangle.y *= -this.iSz;
            rectangle.width *= -this.iSz;
            rectangle.height *= -this.iSz;
        } else {
            rectangle.x /= this.iSz;
            rectangle.y /= this.iSz;
            rectangle.width /= this.iSz;
            rectangle.height /= this.iSz;
        }
    }

    protected void mulPoint(Point point) {
        boolean bl = false;
        boolean bl2 = false;
        Dimension dimension = this.getCurrentImageSize();
        if (this.iSz < 0) {
            point.x /= -this.iSz;
            point.y /= -this.iSz;
        } else {
            if (point.x == dimension.width / this.iSz - 1) {
                point.x = dimension.width - 1;
                bl = true;
            }
            if (point.y == dimension.height / this.iSz - 1) {
                point.y = dimension.height - 1;
                bl2 = true;
            }
            if (!bl) {
                point.x *= this.iSz;
            }
            if (!bl2) {
                point.y *= this.iSz;
            }
        }
    }

    protected void freePopup() {
        if (this.lineProfiler != null) {
            this.lineProfiler.setData(null);
        }
        if (this.zoomDialog != null) {
            this.zoomImage.setImage(null);
        }
        if (this.tableDialog != null) {
            this.tablePanel.clearData();
        }
    }

    protected double[] buildProfileData(Point point, Point point2) {
        double[] dArray;
        Dimension dimension = this.getCurrentImageSize();
        this.mulPoint(point);
        this.mulPoint(point2);
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        int n3 = Math.abs(n);
        int n4 = Math.abs(n2);
        if (n == 0 && n2 == 0) {
            return new double[0];
        }
        if (n == 0 && n2 != 0) {
            dArray = new double[n4 + 1];
            int n5 = point.y;
            int n6 = point.x;
            int n7 = this.integrationWidthV / 2;
            for (int i = 0; i <= n4; ++i) {
                double d = 0.0;
                double d2 = 0.0;
                for (int j = -n7; j <= n7; ++j) {
                    d = n6 + j >= 0 && n6 + j < dimension.width && n5 >= 0 && n5 < dimension.height ? (d += this.doubleValues[n5][n6 + j]) : Double.NaN;
                    d2 += 1.0;
                }
                dArray[i] = d / d2;
                if (n2 < 0) {
                    --n5;
                    continue;
                }
                ++n5;
            }
        } else if (n != 0 && n2 == 0) {
            dArray = new double[n3 + 1];
            int n8 = point.x;
            int n9 = point.y;
            int n10 = this.integrationWidthH / 2;
            for (int i = 0; i <= n3; ++i) {
                double d = 0.0;
                double d3 = 0.0;
                for (int j = -n10; j <= n10; ++j) {
                    d = n8 >= 0 && n8 < dimension.width && n9 + j >= 0 && n9 + j < dimension.height ? (d += this.doubleValues[n9 + j][n8]) : Double.NaN;
                    d3 += 1.0;
                }
                dArray[i] = d / d3;
                if (n < 0) {
                    --n8;
                    continue;
                }
                ++n8;
            }
        } else if (n3 > n4) {
            double d = (double)n2 / (double)n3;
            dArray = new double[n3 + 1];
            int n11 = point.x;
            for (int i = 0; i <= n3; ++i) {
                int n12 = point.y + (int)(d * (double)i);
                dArray[i] = n11 >= 0 && n11 < dimension.width && n12 >= 0 && n12 < dimension.height ? this.doubleValues[n12][n11] : Double.NaN;
                if (n < 0) {
                    --n11;
                    continue;
                }
                ++n11;
            }
        } else {
            double d = (double)n / (double)n4;
            dArray = new double[n4 + 1];
            int n13 = point.y;
            for (int i = 0; i <= n4; ++i) {
                int n14 = point.x + (int)(d * (double)i);
                dArray[i] = n14 >= 0 && n14 < dimension.width && n13 >= 0 && n13 < dimension.height ? this.doubleValues[n13][n14] : Double.NaN;
                if (n2 < 0) {
                    --n13;
                    continue;
                }
                ++n13;
            }
        }
        return dArray;
    }

    protected double[] buildHistogramData() {
        if (this.doubleValues == null) {
            return null;
        }
        double[] dArray = new double[65536];
        this.startHisto = 0;
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            int n;
            int n2;
            this.mulRect(rectangle);
            for (n2 = 0; n2 < 65536; ++n2) {
                dArray[n2] = 0.0;
            }
            try {
                for (n2 = rectangle.x; n2 < rectangle.x + rectangle.width; ++n2) {
                    for (n = rectangle.y; n < rectangle.y + rectangle.height; ++n) {
                        int n3 = (int)this.doubleValues[n][n2];
                        dArray[n3] = dArray[n3] + 1.0;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("NumberImageViewer.buildHistogramData() : Cannot build histogram. One or more value exceed the range [0..65535].");
                return null;
            }
            if (!this.sigHistogram) {
                return dArray;
            }
            n = 0;
            int n4 = 65535;
            boolean bl = false;
            while (n < 65536 && !bl) {
                bl = dArray[n] > 0.0;
                if (bl) continue;
                ++n;
            }
            bl = false;
            while (n4 >= 0 && !bl) {
                bl = dArray[n4] > 0.0;
                if (bl) continue;
                --n4;
            }
            int n5 = n4 - n + 1;
            double[] dArray2 = new double[n5];
            for (n2 = 0; n2 < n5; ++n2) {
                dArray2[n2] = dArray[n + n2];
            }
            this.startHisto = n;
            return dArray2;
        }
        return null;
    }

    protected void refreshLineProfile() {
        if (this.lineProfiler != null && this.lineProfiler.isVisible() && this.profileMode > 0) {
            this.refreshDblProfileMenu();
            switch (this.profileMode) {
                case 1: {
                    Point[] pointArray = this.imagePanel.getSelectionPoint();
                    if (pointArray != null) {
                        this.lineProfiler.setData(this.buildProfileData(pointArray[0], pointArray[1]));
                        break;
                    }
                    this.lineProfiler.setData(null);
                    break;
                }
                case 2: {
                    double[] dArray = this.buildHistogramData();
                    if (dArray != null) {
                        this.lineProfiler.setData(dArray, this.startHisto);
                        break;
                    }
                    this.lineProfiler.setData(null);
                    break;
                }
                case 3: {
                    Point[] pointArray = this.imagePanel.getSelectionCrossPoint();
                    if (pointArray != null) {
                        this.lineProfiler.setData(this.buildProfileData(pointArray[0], pointArray[1]));
                        this.lineProfiler.setData2(this.buildProfileData(pointArray[2], pointArray[3]));
                        break;
                    }
                    this.lineProfiler.setData(null);
                    this.lineProfiler.setData2(null);
                }
            }
        }
    }

    private void refreshSelectionMinMax() {
        double d;
        int n;
        int n2;
        if (this.doubleValues == null) {
            this.rangeLabel.setText("");
            this.avgLabel.setText("");
            return;
        }
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null || this.imagePanel.getSelectionMode() != 1) {
            this.rangeLabel.setText("");
            return;
        }
        this.mulRect(rectangle);
        this.curSelMin = 65536.0;
        this.curSelMax = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n2 = rectangle.y; n2 < rectangle.y + rectangle.height; ++n2) {
            for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
                d = this.doubleValues[n2][n];
                if (d > this.curSelMax) {
                    this.curSelMax = d;
                }
                if (d < this.curSelMin) {
                    this.curSelMin = d;
                }
                d2 += d;
                d4 += 1.0;
            }
        }
        d5 = d2 / d4;
        for (n2 = rectangle.y; n2 < rectangle.y + rectangle.height; ++n2) {
            for (n = rectangle.x; n < rectangle.x + rectangle.width; ++n) {
                d = this.doubleValues[n2][n];
                d3 += (d - d5) * (d - d5);
            }
        }
        d6 = Math.sqrt(d3 / d4);
        Double d7 = new Double(d5);
        Double d8 = new Double(d6);
        this.avgLabel.setText("Average: " + String.format("%.2f", d7) + "  Std deviation: " + String.format("%.2f", d8));
        if (this.curSelMin <= this.curSelMax) {
            this.rangeLabel.setText("Range: " + Double.toString(this.curSelMin) + " , " + Double.toString(this.curSelMax));
        } else {
            this.rangeLabel.setText("");
        }
    }

    private void refreshComponents() {
        this.refreshSelectionMinMax();
        this.refreshLineProfile();
        if (this.zoomDialog != null && this.zoomDialog.isVisible()) {
            this.buildZoom();
            this.zoomView.revalidate();
            this.zoomPanel.repaint();
        }
        if (this.tableDialog != null && this.tableDialog.isVisible()) {
            this.buildTable();
            this.tablePanel.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectionChanged() {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshComponents();
        }
        this.fireRoiChange();
    }

    protected void refreshStatusLine() {
        int n = this.imagePanel.getSelectionMode();
        String string = "None";
        switch (n) {
            case 0: {
                Point[] pointArray = this.imagePanel.getSelectionPoint();
                if (pointArray == null) break;
                this.mulPoint(pointArray[0]);
                this.mulPoint(pointArray[1]);
                string = "Line (" + pointArray[0].x + "," + pointArray[0].y + ") - (" + pointArray[1].x + "," + pointArray[1].y + ")";
                break;
            }
            case 2: {
                Point[] pointArray = this.imagePanel.getSelectionCrossPoint();
                if (pointArray == null) break;
                this.mulPoint(pointArray[0]);
                this.mulPoint(pointArray[1]);
                this.mulPoint(pointArray[2]);
                this.mulPoint(pointArray[3]);
                string = "(" + pointArray[0].x + "," + pointArray[0].y + ")-(" + pointArray[1].x + "," + pointArray[1].y + ")";
                string = string + " (" + pointArray[2].x + "," + pointArray[2].y + ")-(" + pointArray[3].x + "," + pointArray[3].y + ")";
                break;
            }
            case 1: {
                Rectangle rectangle = this.imagePanel.getSelectionRect();
                if (rectangle == null) break;
                this.mulRect(rectangle);
                string = this.rectXYmode ? "Rect (" + rectangle.x + "," + rectangle.y + ") - (" + (rectangle.x + rectangle.width - 1) + "," + (rectangle.y + rectangle.height + -1) + ")" : "Rect (" + rectangle.x + "," + rectangle.y + ") - [" + rectangle.width + "," + rectangle.height + "]";
            }
        }
        this.selText.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showZoom() {
        this.constructZoomPanel();
        if (this.zoomDialog.isVisible()) {
            this.zoomDialog.setVisible(true);
            return;
        }
        Object object = this;
        synchronized (object) {
            if (!this.buildZoom()) {
                return;
            }
        }
        this.zoomCombo.setSelectedIndex(this.zoomFactor);
        this.zoomText.setText("");
        this.zoomDialog.setTitle("[zoom] ImageViewer");
        this.zoomDialog.pack();
        object = Toolkit.getDefaultToolkit();
        Dimension dimension = ((Toolkit)object).getScreenSize();
        Dimension dimension2 = this.zoomDialog.getPreferredSize();
        this.zoomDialog.setBounds((dimension.width - dimension2.height) / 2, (dimension.height - dimension2.height) / 2, dimension2.width, dimension2.height);
        this.zoomDialog.setVisible(true);
    }

    private void applySettings() {
        int n;
        String string = this.minBestFitText.getText();
        String string2 = this.maxBestFitText.getText();
        String string3 = this.snapToGridText.getText();
        this.isBestFit = this.bestFitCheck.isSelected();
        this.autoBestFit = this.autoBestFitCheck.isSelected();
        this.snapToGrid = this.snapToGridCheck.isSelected();
        this.isNegative = this.negativeCheck.isSelected();
        this.sigHistogram = this.sigHistogramCheck.isSelected();
        this.rectXYmode = this.rectDisplayCheck.isSelected();
        this.setZoom(this.imageSizeCombo.getSelectedIndex());
        this.setAlignToGrid(this.snapToGrid);
        try {
            n = Integer.parseInt(this.integrationWidthHText.getText());
            if (n % 2 == 0) {
                JOptionPane.showMessageDialog(null, "Integration width (H) must be an odd number", "Error", 0);
            } else {
                this.integrationWidthH = n;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for integration width (H)", "Error", 0);
        }
        try {
            n = Integer.parseInt(this.integrationWidthVText.getText());
            if (n % 2 == 0) {
                JOptionPane.showMessageDialog(null, "Integration width (V) must be an odd number", "Error", 0);
            } else {
                this.integrationWidthV = n;
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for integration width (V)", "Error", 0);
        }
        try {
            int n2 = Integer.parseInt(string3);
            this.imagePanel.setSnapGrid(n2);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Invalid syntax for grid value", "Error", 0);
        }
        if (!this.autoBestFit) {
            try {
                this.bfMin = Double.parseDouble(string);
                this.bfMax = Double.parseDouble(string2);
                if (this.bfMin >= this.bfMax) {
                    JOptionPane.showMessageDialog(null, "maximum  best fit value is lower or equal than minimum!", "Error", 0);
                    this.autoBestFit = true;
                    this.bfMin = 0.0;
                    this.bfMax = 65536.0;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Invalid syntax for maximum or minimum best fit value", "Error", 0);
                this.autoBestFit = true;
                this.bfMin = 0.0;
                this.bfMax = 65536.0;
            }
        }
        this.settingsDialog.setVisible(false);
    }

    public void saveSetting(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            String string2 = this.getSettings();
            fileWriter.write(string2, 0, string2.length());
            fileWriter.close();
            this.lastConfig = string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to write " + string, "Error", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        String string = "";
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            string = string + "minBestFitText:'" + this.minBestFitText.getText() + "'\n";
            string = string + "maxBestFitText:'" + this.maxBestFitText.getText() + "'\n";
            string = string + "snapToGridText:'" + this.snapToGridText.getText() + "'\n";
            string = string + "isBestFit:'" + this.bestFitCheck.isSelected() + "'\n";
            string = string + "autoBestFit:'" + this.autoBestFitCheck.isSelected() + "'\n";
            string = string + "snapToGrid:'" + this.snapToGridCheck.isSelected() + "'\n";
            string = string + "isNegative:'" + this.negativeCheck.isSelected() + "'\n";
            string = string + "sigHistogram:'" + this.sigHistogramCheck.isSelected() + "'\n";
            string = string + "zoom:'" + this.imageSizeCombo.getSelectedIndex() + "'\n";
            string = string + "toolBarVisible:'" + this.toolbarMenuItem.isSelected() + "'\n";
            string = string + "statusLineVisible:'" + this.statusLineMenuItem.isSelected() + "'\n";
            int n = this.gColor.getEntryNumber();
            string = string + "gradientCount:'" + n + "'\n";
            for (int i = 0; i < n; ++i) {
                Color color = this.gColor.getColorAt(i);
                string = string + "gradientColor_" + i + "_red:'" + color.getRed() + "'\n";
                string = string + "gradientColor_" + i + "_green:'" + color.getGreen() + "'\n";
                string = string + "gradientColor_" + i + "_blue:'" + color.getBlue() + "'\n";
                string = string + "gradientPos_" + i + ":'" + this.gColor.getPosAt(i) + "'\n";
                color = null;
            }
        }
        return string;
    }

    public String loadSetting(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.readFile(string)) {
            return "Failed to read " + string;
        }
        this.lastConfig = string;
        return this.applySettings(cfFileReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String applySettings(CfFileReader cfFileReader) {
        this.constructSettingsPanel();
        String string = "";
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            int n;
            String string2 = this.minBestFitText.getText();
            String string3 = this.maxBestFitText.getText();
            String string4 = this.snapToGridText.getText();
            boolean bl = this.bestFitCheck.isSelected();
            boolean bl2 = this.autoBestFitCheck.isSelected();
            boolean bl3 = this.snapToGridCheck.isSelected();
            boolean bl4 = this.negativeCheck.isSelected();
            boolean bl5 = this.sigHistogramCheck.isSelected();
            int n2 = this.imageSizeCombo.getSelectedIndex();
            boolean bl6 = this.toolbarMenuItem.isSelected();
            boolean bl7 = this.statusLineMenuItem.isSelected();
            int n3 = 0;
            Vector<String> vector = cfFileReader.getParam("minBestFitText");
            if (vector == null) {
                string = string + "Unable to find minBestFitText";
                return string;
            }
            this.minBestFitText.setText(vector.get(0).toString());
            vector = cfFileReader.getParam("maxBestFitText");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                string = string + "Unable to find maxBestFitText";
                return string;
            }
            this.maxBestFitText.setText(vector.get(0).toString());
            vector = cfFileReader.getParam("snapToGridText");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                string = string + "Unable to find snapToGridText";
                return string;
            }
            this.snapToGridText.setText(vector.get(0).toString());
            vector = cfFileReader.getParam("isBestFit");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                string = string + "Unable to find isBestFit";
                return string;
            }
            this.bestFitCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("autoBestFit");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                string = string + "Unable to find autoBestFit";
                return string;
            }
            this.autoBestFitCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("snapToGrid");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                string = string + "Unable to find snapToGrid";
                return string;
            }
            this.snapToGridCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("isNegative");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                string = string + "Unable to find isNegative";
                return string;
            }
            this.negativeCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("sigHistogram");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                this.negativeCheck.setSelected(bl4);
                string = string + "Unable to find sigHistogram";
                return string;
            }
            this.sigHistogramCheck.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("zoom");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                this.negativeCheck.setSelected(bl4);
                this.sigHistogramCheck.setSelected(bl5);
                string = string + "Unable to find zoom";
                return string;
            }
            try {
                n = Integer.parseInt(vector.get(0).toString());
                this.imageSizeCombo.setSelectedIndex(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                this.negativeCheck.setSelected(bl4);
                this.sigHistogramCheck.setSelected(bl5);
                string = string + "zoom: invalid number\n";
                return string;
            }
            vector = cfFileReader.getParam("toolBarVisible");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                this.negativeCheck.setSelected(bl4);
                this.sigHistogramCheck.setSelected(bl5);
                this.imageSizeCombo.setSelectedIndex(n2);
                string = string + "Unable to find toolBarVisible";
                return string;
            }
            this.toolbarMenuItem.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("statusLineVisible");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                this.negativeCheck.setSelected(bl4);
                this.sigHistogramCheck.setSelected(bl5);
                this.imageSizeCombo.setSelectedIndex(n2);
                this.toolbarMenuItem.setSelected(bl6);
                string = string + "Unable to find statusLineVisible";
                return string;
            }
            this.statusLineMenuItem.setSelected("true".equalsIgnoreCase(vector.get(0).toString().trim()));
            vector = cfFileReader.getParam("gradientCount");
            if (vector == null) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                this.negativeCheck.setSelected(bl4);
                this.sigHistogramCheck.setSelected(bl5);
                this.imageSizeCombo.setSelectedIndex(n2);
                this.toolbarMenuItem.setSelected(bl6);
                this.statusLineMenuItem.setSelected(bl7);
                string = string + "Unable to find gradientCount";
                return string;
            }
            try {
                n3 = Integer.parseInt(vector.get(0).toString());
            }
            catch (NumberFormatException numberFormatException) {
                this.minBestFitText.setText(string2);
                this.maxBestFitText.setText(string3);
                this.snapToGridText.setText(string4);
                this.bestFitCheck.setSelected(bl);
                this.autoBestFitCheck.setSelected(bl2);
                this.snapToGridCheck.setSelected(bl3);
                this.negativeCheck.setSelected(bl4);
                this.sigHistogramCheck.setSelected(bl5);
                this.imageSizeCombo.setSelectedIndex(n2);
                this.toolbarMenuItem.setSelected(bl6);
                this.statusLineMenuItem.setSelected(bl7);
                string = string + "gradientCount: invalid number";
                return string;
            }
            Color[] colorArray = new Color[n3];
            double[] dArray = new double[n3];
            for (n = 0; n < n3; ++n) {
                double d;
                int n4;
                int n5;
                int n6;
                vector = cfFileReader.getParam("gradientColor_" + n + "_red");
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "Unable to find gradientColor_" + n + "_red";
                    return string;
                }
                try {
                    n6 = Integer.parseInt(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "gradientColor_" + n + "_red: invalid number";
                    return string;
                }
                vector = cfFileReader.getParam("gradientColor_" + n + "_green");
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "Unable to find gradientColor_" + n + "_green";
                    return string;
                }
                try {
                    n5 = Integer.parseInt(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "gradientColor_" + n + "_green: invalid number";
                    return string;
                }
                vector = cfFileReader.getParam("gradientColor_" + n + "_blue");
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "Unable to find gradientColor_" + n + "_blue";
                    return string;
                }
                try {
                    n4 = Integer.parseInt(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "gradientColor_" + n + "_blue: invalid number";
                    return string;
                }
                vector = cfFileReader.getParam("gradientPos_" + n);
                if (vector == null) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "Unable to find gradientPos_" + n;
                    return string;
                }
                try {
                    d = Double.parseDouble(vector.get(0).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.minBestFitText.setText(string2);
                    this.maxBestFitText.setText(string3);
                    this.snapToGridText.setText(string4);
                    this.bestFitCheck.setSelected(bl);
                    this.autoBestFitCheck.setSelected(bl2);
                    this.snapToGridCheck.setSelected(bl3);
                    this.negativeCheck.setSelected(bl4);
                    this.sigHistogramCheck.setSelected(bl5);
                    this.imageSizeCombo.setSelectedIndex(n2);
                    this.toolbarMenuItem.setSelected(bl6);
                    this.statusLineMenuItem.setSelected(bl7);
                    string = string + "gradientPos_" + n + ": invalid number";
                    return string;
                }
                colorArray[n] = new Color(n6, n5, n4);
                dArray[n] = d;
            }
            this.gColor = new Gradient(dArray, colorArray);
            this.gColormap = this.gColor.buildColorMap(65536);
            this.gradientTool.setGradient(this.gColor);
            this.applySettings();
            this.setToolbarVisible(this.toolbarMenuItem.isSelected());
            this.setStatusLineVisible(this.statusLineMenuItem.isSelected());
            this.convertImage();
            this.refreshComponents();
        }
        return string;
    }

    private void saveButtonActionPerformed() {
        File file;
        int n;
        int n2 = 0;
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("txt");
            }

            @Override
            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showSaveDialog(this)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            if (MultiExtFileFilter.getExtension(file) == null) {
                file = new File(file.getAbsolutePath() + ".txt");
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                this.saveSetting(file.getAbsolutePath());
            }
        }
    }

    private void loadButtonActionPerformed() {
        String string;
        File file;
        int n;
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("txt");
            }

            @Override
            public String getDescription() {
                return "text files ";
            }
        });
        if (this.lastConfig.length() > 0) {
            jFileChooser.setSelectedFile(new File(this.lastConfig));
        }
        if ((n = jFileChooser.showOpenDialog(this)) == 0 && (file = jFileChooser.getSelectedFile()) != null && !bl && (string = this.loadSetting(file.getAbsolutePath())).length() > 0) {
            JOptionPane.showMessageDialog(this, string, "Errors reading " + file.getName(), 0);
        }
    }

    private void showAxisDialog() {
        if (this.axisDialog == null) {
            Window window = ATKGraphicsUtils.getWindowForComponent(this);
            this.axisDialog = window instanceof Frame ? new JDialog((Frame)window, false) : (window instanceof Dialog ? new JDialog((Dialog)window, false) : new JDialog((Frame)null, false));
            this.axisDialog.setTitle("Axis settings");
            JPanel jPanel = new JPanel(null);
            this.tabPane = new JTabbedPane();
            this.xAxisPanel = new AxisPanel(this.getXAxis(), 3, null);
            this.yAxisPanel = new AxisPanel(this.getYAxis(), 1, null);
            this.tabPane.add("X axis", this.xAxisPanel);
            this.tabPane.add("Y axis", this.yAxisPanel);
            this.tabPane.setBounds(5, 5, 300, 370);
            jPanel.add(this.tabPane);
            this.axisCloseButton = new JButton("Close");
            this.axisCloseButton.setFont(ATKConstant.labelFont);
            this.axisCloseButton.setBounds(225, 380, 80, 25);
            jPanel.add(this.axisCloseButton);
            this.axisCloseButton.addActionListener(this);
            jPanel.setPreferredSize(new Dimension(310, 410));
            this.tabPane.setBounds(5, 5, 300, 370);
            this.axisDialog.setContentPane(jPanel);
        }
        ATKGraphicsUtils.centerDialog(this.axisDialog);
        this.axisDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSettings() {
        this.constructSettingsPanel();
        this.initSettings();
        ATKGraphicsUtils.centerDialog(this.settingsDialog);
        this.settingsDialog.setVisible(true);
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.convertImage();
            this.refreshComponents();
        }
    }

    private void initSettings() {
        this.minBestFitText.setText(Double.toString(this.bfMin));
        this.maxBestFitText.setText(Double.toString(this.bfMax));
        this.integrationWidthVText.setText(Integer.toString(this.integrationWidthV));
        this.integrationWidthHText.setText(Integer.toString(this.integrationWidthH));
        this.minBestFitLabel.setEnabled(!this.autoBestFit);
        this.minBestFitText.setEnabled(!this.autoBestFit);
        this.maxBestFitLabel.setEnabled(!this.autoBestFit);
        this.maxBestFitText.setEnabled(!this.autoBestFit);
        this.bestFitCheck.setSelected(this.isBestFit);
        this.autoBestFitCheck.setSelected(this.autoBestFit);
        this.sigHistogramCheck.setSelected(this.sigHistogram);
        this.snapToGridCheck.setSelected(this.snapToGrid);
        this.negativeCheck.setSelected(this.isNegative);
        this.imageSizeCombo.setSelectedIndex(this.getZoom());
        this.snapToGridText.setText(Integer.toString(this.imagePanel.getSnapGrid()));
        this.rectDisplayCheck.setSelected(this.rectXYmode);
        this.gradViewer.setGradient(this.gColor);
    }

    private boolean buildTable() {
        Object object;
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            object = this.imagePanel.getImageSize();
            rectangle = new Rectangle(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        }
        this.mulRect(rectangle);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        object = null;
        if (this.model != null) {
            object = this.model.getFormat();
        }
        if (object != null && ((String)object).length() > 0) {
            if (((String)object).indexOf(37) == -1) {
                Object[][] objectArray = new String[rectangle.height][rectangle.width];
                for (int i = 0; i < rectangle.height; ++i) {
                    for (int j = 0; j < rectangle.width; ++j) {
                        objectArray[i][j] = Double.isNaN(this.doubleValues[rectangle.y + i][rectangle.x + j]) || Double.isInfinite(this.doubleValues[rectangle.y + i][rectangle.x + j]) ? Double.toString(this.doubleValues[rectangle.y + i][rectangle.x + j]) : AttrManip.format((String)object, (double)this.doubleValues[rectangle.y + i][rectangle.x + j]);
                    }
                }
                this.tablePanel.setData(objectArray, rectangle.x, rectangle.y);
            } else {
                Object[][] objectArray = new String[rectangle.height][rectangle.width];
                for (int i = 0; i < rectangle.height; ++i) {
                    for (int j = 0; j < rectangle.width; ++j) {
                        double d = this.doubleValues[rectangle.y + i][rectangle.x + j];
                        objectArray[i][j] = Double.isNaN(d) || Double.isInfinite(d) ? Double.toString(d) : ATKFormat.format((String)object, d);
                    }
                }
                this.tablePanel.setData(objectArray, rectangle.x, rectangle.y);
            }
        } else {
            Object[][] objectArray = new Double[rectangle.height][rectangle.width];
            for (int i = 0; i < rectangle.height; ++i) {
                for (int j = 0; j < rectangle.width; ++j) {
                    objectArray[i][j] = new Double(this.doubleValues[rectangle.y + i][rectangle.x + j]);
                }
            }
            this.tablePanel.setData(objectArray, rectangle.x, rectangle.y);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTable() {
        this.constructTablePanel();
        if (this.tableDialog.isVisible()) {
            this.tableDialog.setVisible(true);
            return;
        }
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
        ATKGraphicsUtils.centerFrameOnScreen(this.tableDialog);
        this.tableDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void constructTable() {
        this.constructTablePanel();
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            if (!this.buildTable()) {
                return;
            }
        }
    }

    private void saveDataFile() {
        this.constructTable();
        if (this.tablePanel != null) {
            this.tablePanel.saveDataFile();
        }
    }

    private void showPropertyFrame() {
        if (this.model != null) {
            if (this.propDialog == null) {
                this.propDialog = new SimplePropertyFrame(this.settingsDialog, true);
            }
            this.propDialog.setModel((IAttribute)this.model);
            this.propDialog.setVisible(true);
        }
    }

    private void showGradientEditor() {
        Gradient gradient = JGradientEditor.showDialog(this.settingsDialog, this.gColor);
        if (gradient != null) {
            this.gColor = gradient;
            this.gColormap = gradient.buildColorMap(65536);
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.repaint();
            this.gradientTool.setGradient(this.gColor);
            this.gradientTool.repaint();
        }
    }

    protected void constructLineProfiler() {
        if (this.lineProfiler == null) {
            this.lineProfiler = new LineProfilerViewer();
            this.lineProfiler.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageViewer.this.lineProfiler.setData(null);
                    NumberImageViewer.this.lineProfiler.dispose();
                }
            });
        }
    }

    private void constructTablePanel() {
        if (this.tableDialog == null) {
            this.tablePanel = new JTableRow();
            this.tableDialog = new JFrame();
            this.tableDialog.setContentPane(this.tablePanel);
            this.tableDialog.setTitle("[table] ImageViewer");
            this.tableDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageViewer.this.tablePanel.clearData();
                    NumberImageViewer.this.tableDialog.dispose();
                }
            });
        }
    }

    private void constructZoomPanel() {
        if (this.zoomDialog == null) {
            this.zoomPanel = new JPanel(new BorderLayout());
            this.zoomImage = new JImage();
            this.zoomImage.setSelectionEnabled(false);
            this.zoomImage.setMargin(new Insets(2, 2, 2, 2));
            this.zoomImage.setImage(null);
            this.zoomView = new JScrollPane(this.zoomImage);
            this.zoomPanel.add((Component)this.zoomView, "Center");
            this.zoomCfgPanel = new JPanel();
            this.zoomCfgPanel.setLayout(null);
            this.zoomCfgPanel.setPreferredSize(new Dimension(0, 25));
            this.zoomCombo = new JComboBox();
            this.zoomCombo.setFont(this.panelFont);
            this.zoomCombo.addItem("Zoom 100%");
            this.zoomCombo.addItem("Zoom 200%");
            this.zoomCombo.addItem("Zoom 300%");
            this.zoomCombo.addItem("Zoom 400%");
            this.zoomCombo.addItem("Zoom 500%");
            this.zoomCombo.addItem("Zoom 600%");
            this.zoomCombo.addItem("Zoom 700%");
            this.zoomCombo.addItem("Zoom 800%");
            this.zoomCombo.setEditable(false);
            this.zoomCombo.setBounds(5, 3, 120, 20);
            this.zoomCombo.addActionListener(this);
            this.zoomCfgPanel.add(this.zoomCombo);
            this.zoomText = new JLabel("");
            this.zoomText.setFont(this.panelFont);
            this.zoomText.setBounds(130, 3, 500, 20);
            this.zoomCfgPanel.add(this.zoomText);
            this.zoomPanel.add((Component)this.zoomCfgPanel, "South");
            this.zoomDialog = new JFrame();
            this.zoomDialog.setContentPane(this.zoomPanel);
            this.zoomDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    NumberImageViewer.this.zoomImage.setImage(null);
                    NumberImageViewer.this.zoomDialog.dispose();
                }
            });
            this.zoomImage.addMouseMotionListener(this);
        }
    }

    private void constructSettingsPanel() {
        if (this.settingsDialog == null) {
            this.settingsPanel = new JPanel();
            this.settingsPanel.setLayout(null);
            this.settingsPanel.setMinimumSize(new Dimension(290, 330));
            this.settingsPanel.setPreferredSize(new Dimension(290, 330));
            this.attNameLabel = new LabelViewer();
            this.attNameLabel.setOpaque(false);
            this.attNameLabel.setFont(new Font("Dialog", 1, 16));
            this.attNameLabel.setBounds(5, 5, 200, 30);
            this.attNameLabel.setHorizontalAlignment(JSmoothLabel.LEFT_ALIGNMENT);
            this.settingsPanel.add(this.attNameLabel);
            this.attNameLabel.setModel((IAttribute)this.model);
            this.propButton = new JButton();
            this.propButton.setText("?");
            this.propButton.setToolTipText("Edit attribute properties");
            this.propButton.setFont(this.panelFont);
            this.propButton.setMargin(new Insets(0, 0, 0, 0));
            this.propButton.setBounds(250, 5, 30, 30);
            this.propButton.addActionListener(this);
            this.settingsPanel.add(this.propButton);
            JSeparator jSeparator = new JSeparator();
            jSeparator.setBounds(0, 40, 500, 10);
            this.settingsPanel.add(jSeparator);
            this.autoBestFitCheck = new JCheckBox("Best fit");
            this.autoBestFitCheck.setSelected(true);
            this.autoBestFitCheck.setFont(this.panelFont);
            this.autoBestFitCheck.setBounds(5, 50, 100, 20);
            this.autoBestFitCheck.setToolTipText("Generate the best fit display using maximum and minimum value of the image");
            this.autoBestFitCheck.addActionListener(this);
            this.settingsPanel.add(this.autoBestFitCheck);
            this.bestFitCheck = new JCheckBox("Enable fitting");
            this.bestFitCheck.setSelected(false);
            this.bestFitCheck.setFont(this.panelFont);
            this.bestFitCheck.setBounds(120, 50, 105, 20);
            this.bestFitCheck.setToolTipText("Display the image using the whole color range");
            this.settingsPanel.add(this.bestFitCheck);
            this.minBestFitLabel = new JLabel("Fit Min");
            this.minBestFitLabel.setFont(this.panelFont);
            this.minBestFitLabel.setBounds(5, 75, 80, 20);
            this.settingsPanel.add(this.minBestFitLabel);
            this.minBestFitText = new JTextField("");
            this.minBestFitText.setMargin(this.noMargin);
            this.minBestFitText.setFont(this.panelFont);
            this.minBestFitText.setBounds(90, 75, 50, 20);
            this.settingsPanel.add(this.minBestFitText);
            this.maxBestFitLabel = new JLabel("Fit Max");
            this.maxBestFitLabel.setFont(this.panelFont);
            this.maxBestFitLabel.setBounds(145, 75, 80, 20);
            this.maxBestFitLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.maxBestFitLabel);
            this.maxBestFitText = new JTextField("");
            this.maxBestFitText.setMargin(this.noMargin);
            this.maxBestFitText.setFont(this.panelFont);
            this.maxBestFitText.setBounds(230, 75, 50, 20);
            this.settingsPanel.add(this.maxBestFitText);
            this.gradLabel = new JLabel("Colormap");
            this.gradLabel.setFont(this.panelFont);
            this.gradLabel.setBounds(5, 100, 70, 20);
            this.settingsPanel.add(this.gradLabel);
            this.gradViewer = new JGradientEditor();
            this.gradViewer.setGradient(this.gColor);
            this.gradViewer.setEditable(false);
            this.gradViewer.setToolTipText("Display the image using this colormap");
            this.gradViewer.setBounds(80, 100, 180, 20);
            this.settingsPanel.add(this.gradViewer);
            this.gradButton = new JButton();
            this.gradButton.setText("...");
            this.gradButton.setToolTipText("Edit colormap");
            this.gradButton.setFont(this.panelFont);
            this.gradButton.setMargin(new Insets(0, 0, 0, 0));
            this.gradButton.setBounds(260, 100, 20, 20);
            this.gradButton.addActionListener(this);
            this.settingsPanel.add(this.gradButton);
            this.negativeCheck = new JCheckBox("Negative image");
            this.negativeCheck.setSelected(false);
            this.negativeCheck.setFont(this.panelFont);
            this.negativeCheck.setBounds(5, 125, 110, 20);
            this.negativeCheck.setToolTipText("Display the negative image");
            this.settingsPanel.add(this.negativeCheck);
            this.imageSizeLabel = new JLabel("Image size");
            this.imageSizeLabel.setFont(this.panelFont);
            this.imageSizeLabel.setBounds(115, 125, 85, 20);
            this.imageSizeLabel.setHorizontalAlignment(0);
            this.settingsPanel.add(this.imageSizeLabel);
            this.imageSizeCombo = new JComboBox();
            this.imageSizeCombo.setFont(this.panelFont);
            this.imageSizeCombo.addItem("800  %");
            this.imageSizeCombo.addItem("400  %");
            this.imageSizeCombo.addItem("200  %");
            this.imageSizeCombo.addItem("100  %");
            this.imageSizeCombo.addItem("50   %");
            this.imageSizeCombo.addItem("25   %");
            this.imageSizeCombo.addItem("12.5 %");
            this.imageSizeCombo.setBounds(200, 125, 80, 22);
            this.settingsPanel.add(this.imageSizeCombo);
            JSeparator jSeparator2 = new JSeparator();
            jSeparator2.setBounds(0, 153, 500, 10);
            this.settingsPanel.add(jSeparator2);
            this.integrationWidthHLabel = new JLabel("Integration width (Horizontal profile)");
            this.integrationWidthHLabel.setFont(this.panelFont);
            this.integrationWidthHLabel.setBounds(5, 160, 220, 20);
            this.settingsPanel.add(this.integrationWidthHLabel);
            this.integrationWidthHText = new JTextField();
            this.integrationWidthHText.setEditable(true);
            this.integrationWidthHText.setBounds(230, 160, 50, 20);
            this.settingsPanel.add(this.integrationWidthHText);
            this.integrationWidthVLabel = new JLabel("Integration width (Vertical profile)");
            this.integrationWidthVLabel.setFont(this.panelFont);
            this.integrationWidthVLabel.setBounds(5, 185, 220, 20);
            this.settingsPanel.add(this.integrationWidthVLabel);
            this.integrationWidthVText = new JTextField();
            this.integrationWidthVText.setEditable(true);
            this.integrationWidthVText.setBounds(230, 185, 50, 20);
            this.settingsPanel.add(this.integrationWidthVText);
            JSeparator jSeparator3 = new JSeparator();
            jSeparator3.setBounds(0, 218, 500, 10);
            this.settingsPanel.add(jSeparator3);
            this.snapToGridCheck = new JCheckBox("Align to grid");
            this.snapToGridCheck.setSelected(false);
            this.snapToGridCheck.setFont(this.panelFont);
            this.snapToGridCheck.setBounds(5, 225, 100, 20);
            this.snapToGridCheck.setToolTipText("Align the selection to the grid");
            this.settingsPanel.add(this.snapToGridCheck);
            this.snapToGridLabel = new JLabel("Grid spacing");
            this.snapToGridLabel.setFont(this.panelFont);
            this.snapToGridLabel.setBounds(110, 225, 90, 20);
            this.settingsPanel.add(this.snapToGridLabel);
            this.snapToGridText = new JTextField("");
            this.snapToGridText.setMargin(this.noMargin);
            this.snapToGridText.setFont(this.panelFont);
            this.snapToGridText.setBounds(205, 225, 50, 20);
            this.settingsPanel.add(this.snapToGridText);
            this.sigHistogramCheck = new JCheckBox("Display significant data for histogram");
            this.sigHistogramCheck.setSelected(false);
            this.sigHistogramCheck.setFont(this.panelFont);
            this.sigHistogramCheck.setBounds(5, 250, 280, 20);
            this.sigHistogramCheck.setToolTipText("Clip the histogram to significant data");
            this.settingsPanel.add(this.sigHistogramCheck);
            this.rectDisplayCheck = new JCheckBox("Display rectangle as (x1,y1) - (x2,y2)");
            this.rectDisplayCheck.setSelected(false);
            this.rectDisplayCheck.setFont(this.panelFont);
            this.rectDisplayCheck.setBounds(5, 275, 280, 20);
            this.rectDisplayCheck.setToolTipText("Display rectangle as (x1,y1) - (x2,y2) instead of (x1,y1) - [width,height]");
            this.settingsPanel.add(this.rectDisplayCheck);
            this.okButton = new JButton();
            this.okButton.setText("Apply");
            this.okButton.setFont(this.panelFont);
            this.okButton.setBounds(5, 300, 80, 25);
            this.okButton.addActionListener(this);
            this.settingsPanel.add(this.okButton);
            this.cancelButton = new JButton();
            this.cancelButton.setText("Dismiss");
            this.cancelButton.setFont(this.panelFont);
            this.cancelButton.setBounds(205, 300, 80, 25);
            this.cancelButton.addActionListener(this);
            this.settingsPanel.add(this.cancelButton);
            Window window = ATKGraphicsUtils.getWindowForComponent(this);
            this.settingsDialog = window instanceof Frame ? new JDialog((Frame)window, true) : (window instanceof Dialog ? new JDialog((Dialog)window, true) : new JDialog((Frame)null, true));
            this.settingsDialog.setResizable(false);
            this.settingsDialog.setContentPane(this.settingsPanel);
            this.settingsDialog.setTitle("Image viewer settings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshStatusAndProlfile() {
        NumberImageViewer numberImageViewer = this;
        synchronized (numberImageViewer) {
            this.refreshStatusLine();
            this.refreshLineProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectButton || actionEvent.getSource() == this.selectionMenuItem) {
            this.imagePanel.clearSelection();
            this.imagePanel.setSelectionMode(1);
            this.profileMode = 0;
            this.freePopup();
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.refreshStatusLine();
                this.refreshSelectionMinMax();
            }
        }
        if (actionEvent.getSource() == this.selectMaxButton || actionEvent.getSource() == this.selectionMaxMenuItem) {
            Dimension dimension = this.imagePanel.getImageSize();
            this.imagePanel.setSelection(0, 0, dimension.width, dimension.height);
            this.selectionChanged();
        } else if (actionEvent.getSource() == this.selectColorButton || actionEvent.getSource() == this.selectionColorMenuItem) {
            this.changeSelectionColor();
        } else if (actionEvent.getSource() == this.fileButton || actionEvent.getSource() == this.fileMenuItem) {
            this.saveFile();
        } else if (actionEvent.getSource() == this.profileButton || actionEvent.getSource() == this.lineProfileMenuItem) {
            this.imagePanel.setSelectionMode(0);
            this.constructLineProfiler();
            this.lineProfiler.setLineProfileMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 1;
            this.refreshDblProfileMenu();
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.profile2Button || actionEvent.getSource() == this.lineProfile2MenuItem) {
            this.imagePanel.setSelectionMode(2);
            this.constructLineProfiler();
            this.lineProfiler.setMode(2);
            this.lineProfiler.setVisible(true);
            this.profileMode = 3;
            this.refreshDblProfileMenu();
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.histoButton || actionEvent.getSource() == this.histogramMenuItem) {
            this.imagePanel.setSelectionMode(1);
            this.constructLineProfiler();
            this.lineProfiler.setHistogramMode();
            this.lineProfiler.setVisible(true);
            this.profileMode = 2;
            this.refreshDblProfileMenu();
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.bestFitMenuItem) {
            this.setBestFit(!this.isBestFit());
        } else if (actionEvent.getSource() == this.negativeMenuItem) {
            this.setNegative(!this.isNegative());
        } else if (actionEvent.getSource() == this.snapToGridMenuItem) {
            this.setAlignToGrid(!this.isAlignToGrid());
        } else if (actionEvent.getSource() == this.toolbarMenuItem) {
            this.setToolbarVisible(!this.isToolbarVisible());
        } else if (actionEvent.getSource() == this.statusLineMenuItem) {
            this.setStatusLineVisible(!this.isStatusLineVisible());
        } else if (actionEvent.getSource() == this.showGradMenuItem) {
            this.setGradientVisible(!this.isGradientVisible());
        } else if (actionEvent.getSource() == this.zoomButton || actionEvent.getSource() == this.zoomMenuItem) {
            this.showZoom();
        } else if (actionEvent.getSource() == this.zoomCombo) {
            this.zoomFactor = this.zoomCombo.getSelectedIndex();
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                this.buildZoom();
            }
            this.zoomDialog.pack();
        } else if (actionEvent.getSource() == this.settingsButton || actionEvent.getSource() == this.settingsMenuItem) {
            this.showSettings();
        } else if (actionEvent.getSource() == this.autoBestFitCheck) {
            this.autoBestFit = !this.autoBestFit;
            this.minBestFitLabel.setEnabled(!this.autoBestFit);
            this.minBestFitText.setEnabled(!this.autoBestFit);
            this.maxBestFitLabel.setEnabled(!this.autoBestFit);
            this.maxBestFitText.setEnabled(!this.autoBestFit);
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.settingsDialog.setVisible(false);
        } else if (actionEvent.getSource() == this.axisButton) {
            this.showAxisDialog();
        } else if (actionEvent.getSource() == this.axisCloseButton) {
            this.axisDialog.setVisible(false);
        } else if (actionEvent.getSource() == this.okButton) {
            this.applySettings();
        } else if (actionEvent.getSource() == this.tableButton || actionEvent.getSource() == this.tableMenuItem) {
            this.showTable();
        } else if (actionEvent.getSource() == this.propButton) {
            this.showPropertyFrame();
        } else if (actionEvent.getSource() == this.gradButton) {
            this.showGradientEditor();
        } else if (actionEvent.getSource() == this.loadButton || actionEvent.getSource() == this.loadMenuItem) {
            this.loadButtonActionPerformed();
        } else if (actionEvent.getSource() == this.saveButton || actionEvent.getSource() == this.saveMenuItem) {
            this.saveButtonActionPerformed();
        } else if (actionEvent.getSource() == this.saveDataFileMenuItem) {
            this.saveDataFile();
        } else if (actionEvent.getSource() == this.printButton || actionEvent.getSource() == this.printMenuItem) {
            this.printImage();
        } else if (actionEvent.getSource() == this.displayLogMenuItem) {
            this.setLogValues(this.displayLogMenuItem.isSelected());
        } else if (actionEvent.getSource() == this.vLeftCheckMenuItem) {
            this.imagePanel.setVerticalPosition(0);
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.vCenterCheckMenuItem) {
            this.imagePanel.setVerticalPosition(1);
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.vRigthCheckMenuItem) {
            this.imagePanel.setVerticalPosition(2);
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.hTopCheckMenuItem) {
            this.imagePanel.setHorizontalPosition(0);
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.hCenterCheckMenuItem) {
            this.imagePanel.setHorizontalPosition(1);
            this.refreshStatusAndProlfile();
        } else if (actionEvent.getSource() == this.hBottomCheckMenuItem) {
            this.imagePanel.setHorizontalPosition(2);
            this.refreshStatusAndProlfile();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public synchronized void mouseMoved(MouseEvent mouseEvent) {
        Dimension dimension = this.getCurrentImageSize();
        if (this.doubleValues != null) {
            if (mouseEvent.getSource() == this.imagePanel) {
                int n;
                int n2;
                if (this.iSz < 0) {
                    n2 = (mouseEvent.getX() - this.imagePanel.getXOrigin()) / -this.iSz;
                    n = (mouseEvent.getY() - this.imagePanel.getYOrigin()) / -this.iSz;
                } else {
                    n2 = (mouseEvent.getX() - this.imagePanel.getXOrigin()) * this.iSz;
                    n = (mouseEvent.getY() - this.imagePanel.getYOrigin()) * this.iSz;
                }
                if (n2 >= dimension.width || n >= dimension.height || n < 0 || n2 < 0) {
                    this.statusLabel.setText(this.getLabelInfoString());
                } else {
                    this.statusLabel.setText(this.getLabelInfoString() + " (" + n2 + "," + n + ")=" + Double.toString(this.doubleValues[n][n2]));
                }
                this.refreshStatusLine();
            } else if (mouseEvent.getSource() == this.zoomImage) {
                int n = (mouseEvent.getX() - this.zoomImage.getXOrigin()) / (this.zoomFactor + 1) + this.zoomXOrg;
                int n3 = (mouseEvent.getY() - this.zoomImage.getYOrigin()) / (this.zoomFactor + 1) + this.zoomYOrg;
                if (n >= dimension.width || n3 >= dimension.height || n3 < 0 || n < 0) {
                    this.zoomText.setText("");
                } else {
                    this.zoomText.setText("(" + n + "," + n3 + ") " + Double.toString(this.doubleValues[n3][n]));
                }
            }
        } else {
            this.statusLabel.setText("");
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            if (this.oldSelection == null) {
                this.selectionChanged();
            } else if (!rectangle.equals(this.oldSelection)) {
                this.selectionChanged();
            }
        }
        this.oldSelection = rectangle;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 && this.showingMenu && mouseEvent.getSource() == this.imagePanel) {
            this.bestFitMenuItem.setSelected(this.isBestFit());
            this.snapToGridMenuItem.setSelected(this.isAlignToGrid());
            this.negativeMenuItem.setSelected(this.isNegative());
            this.toolbarMenuItem.setSelected(this.isToolbarVisible());
            this.statusLineMenuItem.setSelected(this.isStatusLineVisible());
            this.showGradMenuItem.setSelected(this.isGradientVisible());
            this.imgMenu.show(this.imagePanel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.selText) {
            if (keyEvent.getKeyCode() == 10) {
                Object object;
                String string = this.selText.getText();
                try {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    String string2;
                    String string3;
                    string = string.substring(string.indexOf(40) + 1);
                    object = string.substring(0, string.indexOf(44));
                    string = string.substring(string.indexOf(44) + 1);
                    String string4 = string.substring(0, string.indexOf(41));
                    if (this.imagePanel.getSelectionMode() == 0) {
                        string = string.substring(string.indexOf(40) + 1);
                        string3 = string.substring(0, string.indexOf(44));
                        string = string.substring(string.indexOf(44) + 1);
                        string2 = string.substring(0, string.indexOf(41));
                    } else {
                        string = string.substring(string.indexOf(91) + 1);
                        string3 = string.substring(0, string.indexOf(44));
                        string = string.substring(string.indexOf(44) + 1);
                        string2 = string.substring(0, string.indexOf(93));
                    }
                    if (this.iSz < 0) {
                        n4 = Integer.parseInt((String)object) * -this.iSz;
                        n3 = Integer.parseInt(string4) * -this.iSz;
                        n2 = Integer.parseInt(string3) * -this.iSz;
                        n = Integer.parseInt(string2) * -this.iSz;
                    } else {
                        n4 = Integer.parseInt((String)object) / this.iSz;
                        n3 = Integer.parseInt(string4) / this.iSz;
                        n2 = Integer.parseInt(string3) / this.iSz;
                        n = Integer.parseInt(string2) / this.iSz;
                    }
                    if (this.imagePanel.getSelectionMode() == 0) {
                        this.imagePanel.setSelection(n4, n3, n2, n);
                    } else {
                        this.imagePanel.setSelection(n4, n3, n4 + n2, n3 + n);
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Invalid syntax for selection", "Error", 0);
                }
                object = this.imagePanel.getSelectionRect();
                if (object != null) {
                    if (this.oldSelection == null) {
                        this.selectionChanged();
                    } else if (!((Rectangle)object).equals(this.oldSelection)) {
                        this.selectionChanged();
                    }
                }
                this.oldSelection = object;
                this.refreshStatusLine();
            }
        } else if (keyEvent.getSource() == this.imagePanel) {
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    NumberImageViewer numberImageViewer = this;
                    synchronized (numberImageViewer) {
                        this.refreshStatusLine();
                        this.refreshSelectionMinMax();
                        this.refreshLineProfile();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setData(null);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void imageChange(NumberImageEvent numberImageEvent) {
        if (this.logValues) {
            this.setData(this.computeLog(numberImageEvent.getValue()));
        } else {
            this.setData(numberImageEvent.getValue());
        }
    }

    public void setModel(INumberImage iNumberImage) {
        this.clearModel();
        if (this.settingsDialog != null) {
            this.attNameLabel.setModel((IAttribute)iNumberImage);
        }
        if (iNumberImage != null) {
            this.imagePanel.setImage(null);
            this.firstRefresh = !this.userZoom;
            this.freePopup();
            this.model = iNumberImage;
            this.model.addImageListener((IImageListener)this);
            this.model.refresh();
        }
    }

    public void clearModel() {
        if (this.model == null) {
            return;
        }
        this.model.removeImageListener((IImageListener)this);
        this.model = null;
        if (this.imagePanel != null) {
            this.imagePanel.setImage(null);
        }
    }

    private void saveEdf(String string) {
        if (this.doubleValues == null) {
            JOptionPane.showMessageDialog(this, "No data to save.");
            return;
        }
        Dimension dimension = this.getCurrentImageSize();
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        } else {
            this.mulRect(rectangle);
        }
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            JOptionPane.showMessageDialog(this, "No area selected.");
            return;
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{\n");
            stringBuffer.append("HeaderID       = EH:000001:000000:000000 ;\n");
            stringBuffer.append("Image          = 1 ;\n");
            stringBuffer.append("ByteOrder      = LowByteFirst ;\n");
            stringBuffer.append("DataType       = UnsignedShort ;\n");
            stringBuffer.append("Dim_1          = " + rectangle.width + " ;\n");
            stringBuffer.append("Dim_2          = " + rectangle.height + " ;\n");
            stringBuffer.append("Size           = " + rectangle.width * rectangle.height * 2 + " ;\n");
            stringBuffer.append("count_time     = 0 ;\n");
            stringBuffer.append("point_no       = 0 ;\n");
            stringBuffer.append("preset         = 1.0 ;\n");
            stringBuffer.append("col_end        = " + (rectangle.width - 1) + " ;\n");
            stringBuffer.append("row_end        = " + (rectangle.height - 1) + " ;\n");
            stringBuffer.append("dir            = . ;\n");
            stringBuffer.append("suffix         = edf ;\n");
            stringBuffer.append("prefix         = ;\n");
            stringBuffer.append("run            = 1 ;\n");
            stringBuffer.append("description    = ;\n");
            stringBuffer.append("title          = snapshot ;\n");
            for (int i = stringBuffer.length(); i < 1022; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("}\n");
            dataOutputStream.writeBytes(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
                for (int j = rectangle.x; j < rectangle.x + rectangle.width; ++j) {
                    int n = (int)this.doubleValues[i][j];
                    stringBuffer.append((char)(n & 0xFF));
                    stringBuffer.append((char)(n >> 8 & 0xFF));
                }
            }
            dataOutputStream.writeBytes(stringBuffer.toString());
            dataOutputStream.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + exception.getMessage());
        }
    }

    private String getLabelInfoString() {
        Dimension dimension = this.getCurrentImageSize();
        int n = this.iSz < 0 ? (int)(100.0 * (double)(-this.iSz)) : (int)(100.0 / (double)this.iSz);
        return n + "% [" + dimension.width + "," + dimension.height + "]";
    }

    private void computeVerticalExtent() {
        int n;
        int n2;
        if (this.doubleValues == null) {
            return;
        }
        if (this.verticalExtent == 1) {
            return;
        }
        int n3 = this.doubleValues.length;
        if (n3 == 0) {
            return;
        }
        int n4 = this.doubleValues[0].length;
        if (n4 == 0) {
            return;
        }
        double[][] dArray = new double[(n3 - 1) * this.verticalExtent + 1][n4];
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            for (n = 0; n < n4; ++n) {
                for (int i = 0; i < this.verticalExtent; ++i) {
                    double d = this.doubleValues[n2][n];
                    double d2 = this.doubleValues[n2 + 1][n];
                    double d3 = (double)i / (double)this.verticalExtent;
                    dArray[n2 * this.verticalExtent + i][n] = d * (1.0 - d3) + d2 * d3;
                }
            }
        }
        n2 = (n3 - 1) * this.verticalExtent;
        for (n = 0; n < n4; ++n) {
            dArray[n2][n] = this.doubleValues[n3 - 1][n];
        }
        this.doubleValues = dArray;
    }

    private void computeAutoZoom() {
        int n;
        if (this.doubleValues == null) {
            return;
        }
        if ((this.firstRefresh || this.autoZoom) && this.doubleValues.length > 0 && (n = this.doubleValues.length) > 0) {
            int n2;
            int n3;
            if (n3 > 800 || n > 600) {
                for (n2 = 1; (n3 > 800 || n > 600) && n2 < 8 && n3 % 2 == 0 && n % 2 == 0; n3 /= 2, n /= 2, n2 *= 2) {
                }
                this.iSz = n2;
            } else {
                for (n3 = this.doubleValues[0].length; n3 < 600 && n < 400 && n2 < 4; n3 *= 2, n *= 2, n2 *= 2) {
                }
                this.iSz = n2 != 1 ? -n2 : 1;
            }
            if (this.iSz < 0) {
                this.imagePanel.setMarkerScale(-this.iSz);
            } else {
                this.imagePanel.setMarkerScale(1.0 / (double)this.iSz);
            }
            this.firstRefresh = false;
        }
    }

    private void preComputeBestFit() {
        if (!this.isBestFit) {
            this.gradientTool.getAxis().setMinimum(0.0);
            this.gradientTool.getAxis().setMaximum(65536.0);
            this.gradientTool.repaint();
            return;
        }
        if (this.doubleValues == null) {
            return;
        }
        if (this.autoBestFit) {
            this.autoBfMin = 65536.0;
            this.autoBfMax = 0.0;
            for (int i = 0; i < this.doubleValues.length; ++i) {
                for (int j = 0; j < this.doubleValues[i].length; ++j) {
                    double d = this.doubleValues[i][j];
                    if (Double.isNaN(d) || Double.isInfinite(d)) continue;
                    if (d > this.autoBfMax) {
                        this.autoBfMax = d;
                    }
                    if (!(d < this.autoBfMin)) continue;
                    this.autoBfMin = d;
                }
            }
            if (this.autoBfMin == 65536.0 && this.autoBfMax == 0.0) {
                this.autoBfMin = 0.0;
                this.autoBfMax = 0.0;
            }
            this.bfa0 = -this.autoBfMin;
            if (this.autoBfMax == this.autoBfMin) {
                this.bfa1 = 0.0;
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax + 1.0);
                this.gradientTool.repaint();
            } else {
                this.bfa1 = 65536.0 / (this.autoBfMax - this.autoBfMin);
                this.gradientTool.getAxis().setMinimum(this.autoBfMin);
                this.gradientTool.getAxis().setMaximum(this.autoBfMax);
                this.gradientTool.repaint();
            }
        } else {
            this.bfa0 = -this.bfMin;
            this.bfa1 = this.bfMax == this.bfMin ? 0.0 : 65536.0 / (this.bfMax - this.bfMin);
            this.gradientTool.getAxis().setMinimum(this.bfMin);
            this.gradientTool.getAxis().setMaximum(this.bfMax);
            this.gradientTool.repaint();
        }
    }

    private int bestFit(double d) {
        int n = (int)((this.bfa0 + d) * this.bfa1);
        if (n < 0) {
            return 0;
        }
        if (n > 65535) {
            return 65535;
        }
        return n;
    }

    private boolean buildZoom() {
        if (this.doubleValues == null) {
            return false;
        }
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle == null) {
            return false;
        }
        this.mulRect(rectangle);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return false;
        }
        this.zoomXOrg = rectangle.x;
        this.zoomYOrg = rectangle.y;
        int n = this.zoomFactor + 1;
        BufferedImage bufferedImage = new BufferedImage(rectangle.width * n, rectangle.height * n, 1);
        int[] nArray = new int[rectangle.width * n];
        this.preComputeBestFit();
        for (int i = rectangle.y; i < rectangle.y + rectangle.height; ++i) {
            int n2;
            for (n2 = rectangle.x; n2 < rectangle.x + rectangle.width; ++n2) {
                int n3;
                int n4;
                if (this.isNegative) {
                    if (this.isBestFit) {
                        n4 = this.gColormap[~this.bestFit(this.doubleValues[i][n2]) & 0xFFFF];
                        for (n3 = 0; n3 < n; ++n3) {
                            nArray[(n2 - rectangle.x) * n + n3] = n4;
                        }
                        continue;
                    }
                    n4 = this.gColormap[~((int)this.doubleValues[i][n2]) & 0xFFFF];
                    for (n3 = 0; n3 < n; ++n3) {
                        nArray[(n2 - rectangle.x) * n + n3] = n4;
                    }
                    continue;
                }
                if (this.isBestFit) {
                    n4 = this.gColormap[this.bestFit(this.doubleValues[i][n2])];
                    for (n3 = 0; n3 < n; ++n3) {
                        nArray[(n2 - rectangle.x) * n + n3] = n4;
                    }
                    continue;
                }
                n4 = this.gColormap[(int)this.doubleValues[i][n2] & 0xFFFF];
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[(n2 - rectangle.x) * n + n3] = n4;
                }
            }
            for (n2 = 0; n2 < n; ++n2) {
                bufferedImage.setRGB(0, (i - rectangle.y) * n + n2, rectangle.width * n, 1, nArray, 0, rectangle.width * n);
            }
        }
        this.zoomImage.setImage(bufferedImage);
        return true;
    }

    private void saveFile() {
        File file;
        int n;
        int n2 = 0;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("edf");
            }

            @Override
            public String getDescription() {
                return "edf - EDF pictues (Mono 16 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter2 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Color 24 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter3 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("jpg");
            }

            @Override
            public String getDescription() {
                return "jpg - JPEG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter4 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Color 24 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter fileFilter5 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = MultiExtFileFilter.getExtension(file);
                return string != null && string.equals("png");
            }

            @Override
            public String getDescription() {
                return "png - PNG pictures (Mono 8 Bits)";
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (object instanceof FileFilter) {
                    return this.getDescription().equals(((FileFilter)object).getDescription());
                }
                return false;
            }
        };
        FileFilter[] fileFilterArray = new FileFilter[]{fileFilter, fileFilter5, fileFilter4, fileFilter3, fileFilter2};
        JFileChooser jFileChooser = new JFileChooser(this.lastSnapshotLocation);
        for (n = 0; n < fileFilterArray.length; ++n) {
            if (fileFilterArray[n].equals(this.lastFileFilter)) continue;
            jFileChooser.addChoosableFileFilter(fileFilterArray[n]);
        }
        if (this.lastFileFilter != null) {
            jFileChooser.addChoosableFileFilter(this.lastFileFilter);
        }
        jFileChooser.setDialogTitle("Save snapshot");
        n = jFileChooser.showSaveDialog(this);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.lastSnapshotLocation = file.getParentFile().getAbsolutePath();
            FileFilter fileFilter6 = jFileChooser.getFileFilter();
            if (fileFilter.equals(fileFilter6)) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("edf")) {
                    file = new File(file.getAbsolutePath() + ".edf");
                }
                this.lastFileFilter = fileFilter6;
            } else if (fileFilter2.equals(fileFilter6) || fileFilter3.equals(fileFilter6)) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("jpg")) {
                    file = new File(file.getAbsolutePath() + ".jpg");
                }
                this.lastFileFilter = fileFilter6;
            } else if (fileFilter4.equals(fileFilter6) || fileFilter5.equals(fileFilter6)) {
                if (MultiExtFileFilter.getExtension(file) == null || !MultiExtFileFilter.getExtension(file).equalsIgnoreCase("png")) {
                    file = new File(file.getAbsolutePath() + ".png");
                }
                this.lastFileFilter = fileFilter6;
            } else {
                JOptionPane.showMessageDialog(this, "Please select a valid image format", "Error", 0);
                return;
            }
            if (file.exists()) {
                n2 = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
            }
            if (n2 == 0) {
                if (fileFilter.equals(fileFilter6)) {
                    this.saveEdf(file.getAbsolutePath());
                } else if (fileFilter2.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.getSelectionImage(), "jpg", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter3.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "jpg", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter4.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.getSelectionImage(), "png", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                } else if (fileFilter5.equals(fileFilter6)) {
                    try {
                        ImageIO.write((RenderedImage)this.get8BitImage(), "png", file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(this, "File could not be saved", "Error", 0);
                    }
                }
            }
        }
        fileFilter4 = null;
        fileFilter5 = null;
        fileFilter2 = null;
        fileFilter3 = null;
        fileFilter = null;
        for (int i = 0; i < fileFilterArray.length; ++i) {
            fileFilterArray[i] = null;
        }
        fileFilterArray = null;
    }

    private BufferedImage getSelectionImage() {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null && rectangle.width * rectangle.height != 0) {
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.imagePanel.getImage(), 0, 0, rectangle.width - 1, rectangle.height - 1, rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, null);
            graphics2D.dispose();
            return bufferedImage;
        }
        int n = this.imagePanel.getImage().getWidth();
        int n2 = this.imagePanel.getImage().getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage get8BitImage() {
        Rectangle rectangle = this.imagePanel.getSelectionRect();
        if (rectangle != null) {
            BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 10);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(this.imagePanel.getImage(), 0, 0, rectangle.width - 1, rectangle.height - 1, rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, null);
            graphics2D.dispose();
            return bufferedImage;
        }
        int n = this.imagePanel.getImage().getWidth();
        int n2 = this.imagePanel.getImage().getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage((Image)this.imagePanel.getImage(), 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setNaNcolor(Color color) {
        this.rgbNaN = color == null ? 0 : color.getRGB();
        this.colorNaN = color;
    }

    private void convertImage() {
        if (this.doubleValues == null) {
            return;
        }
        if (this.doubleValues.length > 0) {
            int n = this.doubleValues.length;
            if (n > 0) {
                int n2;
                int n3;
                int n4 = this.doubleValues[0].length;
                BufferedImage bufferedImage = this.imagePanel.getImage();
                if (this.iSz < 0) {
                    n3 = n4 * -this.iSz;
                    n2 = n * -this.iSz;
                } else {
                    n3 = n4 / this.iSz;
                    n2 = n / this.iSz;
                }
                if (bufferedImage == null || bufferedImage.getHeight() != n2 || bufferedImage.getWidth() != n3) {
                    bufferedImage = new BufferedImage(n3, n2, 1);
                    this.imagePanel.setImage(bufferedImage);
                    this.freePopup();
                    this.statusLabel.setText(this.getLabelInfoString());
                    this.refreshComponents();
                }
                int[] nArray = new int[n3];
                this.preComputeBestFit();
                if (this.iSz < 0) {
                    int n5 = -this.iSz;
                    for (int i = 0; i < n; ++i) {
                        int n6;
                        int n7;
                        int n8;
                        if (this.colorNaN == null) {
                            if (this.isBestFit) {
                                if (this.isNegative) {
                                    for (n8 = 0; n8 < n4; ++n8) {
                                        n7 = this.gColormap[~this.bestFit(this.doubleValues[i][n8]) & 0xFFFF];
                                        for (n6 = 0; n6 < n5; ++n6) {
                                            nArray[n8 * n5 + n6] = n7;
                                        }
                                    }
                                } else {
                                    for (n8 = 0; n8 < n4; ++n8) {
                                        n7 = this.gColormap[this.bestFit(this.doubleValues[i][n8])];
                                        for (n6 = 0; n6 < n5; ++n6) {
                                            nArray[n8 * n5 + n6] = n7;
                                        }
                                    }
                                }
                            } else if (this.isNegative) {
                                for (n8 = 0; n8 < n4; ++n8) {
                                    n7 = this.gColormap[~((int)this.doubleValues[i][n8]) & 0xFFFF];
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        nArray[n8 * n5 + n6] = n7;
                                    }
                                }
                            } else {
                                for (n8 = 0; n8 < n4; ++n8) {
                                    n7 = this.gColormap[(int)this.doubleValues[i][n8] & 0xFFFF];
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        nArray[n8 * n5 + n6] = n7;
                                    }
                                }
                            }
                        } else if (this.isBestFit) {
                            if (this.isNegative) {
                                for (n8 = 0; n8 < n4; ++n8) {
                                    n7 = Double.isNaN(this.doubleValues[i][n8]) ? this.rgbNaN : this.gColormap[~this.bestFit(this.doubleValues[i][n8]) & 0xFFFF];
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        nArray[n8 * n5 + n6] = n7;
                                    }
                                }
                            } else {
                                for (n8 = 0; n8 < n4; ++n8) {
                                    n7 = Double.isNaN(this.doubleValues[i][n8]) ? this.rgbNaN : this.gColormap[this.bestFit(this.doubleValues[i][n8])];
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        nArray[n8 * n5 + n6] = n7;
                                    }
                                }
                            }
                        } else if (this.isNegative) {
                            for (n8 = 0; n8 < n4; ++n8) {
                                n7 = Double.isNaN(this.doubleValues[i][n8]) ? this.rgbNaN : this.gColormap[~((int)this.doubleValues[i][n8]) & 0xFFFF];
                                for (n6 = 0; n6 < n5; ++n6) {
                                    nArray[n8 * n5 + n6] = n7;
                                }
                            }
                        } else {
                            for (n8 = 0; n8 < n4; ++n8) {
                                n7 = Double.isNaN(this.doubleValues[i][n8]) ? this.rgbNaN : this.gColormap[(int)this.doubleValues[i][n8] & 0xFFFF];
                                for (n6 = 0; n6 < n5; ++n6) {
                                    nArray[n8 * n5 + n6] = n7;
                                }
                            }
                        }
                        for (n8 = 0; n8 < n5; ++n8) {
                            bufferedImage.setRGB(0, i * n5 + n8, n3, 1, nArray, 0, n3);
                        }
                    }
                } else if (this.colorNaN == null) {
                    int n9 = 0;
                    for (int i = 0; i < n2; ++i) {
                        int n10;
                        int n11;
                        if (this.isBestFit) {
                            if (this.isNegative) {
                                n11 = 0;
                                for (n10 = 0; n10 < n3; ++n10) {
                                    nArray[n10] = this.gColormap[~this.bestFit(this.doubleValues[n9][n11]) & 0xFFFF];
                                    n11 += this.iSz;
                                }
                            } else {
                                n11 = 0;
                                for (n10 = 0; n10 < n3; ++n10) {
                                    nArray[n10] = this.gColormap[this.bestFit(this.doubleValues[n9][n11])];
                                    n11 += this.iSz;
                                }
                            }
                        } else if (this.isNegative) {
                            n11 = 0;
                            for (n10 = 0; n10 < n3; ++n10) {
                                nArray[n10] = this.gColormap[~((int)this.doubleValues[n9][n11]) & 0xFFFF];
                                n11 += this.iSz;
                            }
                        } else {
                            n11 = 0;
                            for (n10 = 0; n10 < n3; ++n10) {
                                nArray[n10] = this.gColormap[(int)this.doubleValues[n9][n11] & 0xFFFF];
                                n11 += this.iSz;
                            }
                        }
                        bufferedImage.setRGB(0, i, n3, 1, nArray, 0, n3);
                        n9 += this.iSz;
                    }
                } else {
                    int n12 = 0;
                    for (int i = 0; i < n2; ++i) {
                        int n13;
                        int n14;
                        if (this.isBestFit) {
                            if (this.isNegative) {
                                n14 = 0;
                                for (n13 = 0; n13 < n3; ++n13) {
                                    nArray[n13] = Double.isNaN(this.doubleValues[n12][n14]) ? this.rgbNaN : this.gColormap[~this.bestFit(this.doubleValues[n12][n14]) & 0xFFFF];
                                    n14 += this.iSz;
                                }
                            } else {
                                n14 = 0;
                                for (n13 = 0; n13 < n3; ++n13) {
                                    nArray[n13] = Double.isNaN(this.doubleValues[n12][n14]) ? this.rgbNaN : this.gColormap[this.bestFit(this.doubleValues[n12][n14])];
                                    n14 += this.iSz;
                                }
                            }
                        } else if (this.isNegative) {
                            n14 = 0;
                            for (n13 = 0; n13 < n3; ++n13) {
                                nArray[n13] = Double.isNaN(this.doubleValues[n12][n14]) ? this.rgbNaN : this.gColormap[~((int)this.doubleValues[n12][n14]) & 0xFFFF];
                                n14 += this.iSz;
                            }
                        } else {
                            n14 = 0;
                            for (n13 = 0; n13 < n3; ++n13) {
                                nArray[n13] = Double.isNaN(this.doubleValues[n12][n14]) ? this.rgbNaN : this.gColormap[(int)this.doubleValues[n12][n14] & 0xFFFF];
                                n14 += this.iSz;
                            }
                        }
                        bufferedImage.setRGB(0, i, n3, 1, nArray, 0, n3);
                        n12 += this.iSz;
                    }
                }
                this.imagePanel.repaint();
                this.imageView.revalidate();
                return;
            }
            this.doubleValues = null;
        } else {
            this.doubleValues = null;
        }
    }

    public void printImage() {
        ATKGraphicsUtils.printComponent(this.imagePanel, "Print Image", true, 0);
    }

    public boolean isLogValues() {
        return this.logValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogValues(boolean bl) {
        if (bl != this.logValues) {
            NumberImageViewer numberImageViewer = this;
            synchronized (numberImageViewer) {
                if (this.model != null) {
                    double[][] dArray = this.model.getValue();
                    if (bl) {
                        this.setData(this.computeLog(dArray));
                    } else {
                        this.setData(dArray);
                    }
                }
            }
        }
        this.logValues = bl;
    }

    protected double[][] computeLog(double[][] dArray) {
        if (dArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        n = dArray.length;
        if (n > 0) {
            n2 = dArray[0].length;
        }
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = Math.log10(dArray[i][j]);
            }
        }
        return dArray2;
    }

    protected void changeSelectionColor() {
        Color color = JColorChooser.showDialog(this, "Choose Selection Color", this.imagePanel.getSelectionColor());
        if (color != null) {
            this.imagePanel.setSelectionColor(color);
            this.imagePanel.repaint();
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        NumberImageViewer numberImageViewer = new NumberImageViewer();
        AttributeList attributeList = new AttributeList();
        final ErrorHistory errorHistory = new ErrorHistory();
        attributeList.addErrorListener((IErrorListener)errorHistory);
        try {
            INumberImage iNumberImage = stringArray.length > 0 ? (INumberImage)attributeList.add(stringArray[0]) : (INumberImage)attributeList.add("jlp/test/1/att_image");
            numberImageViewer.setModel(iNumberImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = numberImageViewer.addHorizontalLineMarker(512, Color.GREEN);
        numberImageViewer.setCrossCursor(true);
        numberImageViewer.setMarkerPos(n, 0, 256, 0, 0);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)numberImageViewer, "Center");
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Show errors");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                errorHistory.setVisible(true);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Show diag");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ATKDiagnostic.showDiagnostic();
            }
        });
        jPanel.add(jButton2);
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("ImageViewer");
        jFrame.pack();
        jFrame.setVisible(true);
        attributeList.setRefreshInterval(1000);
        attributeList.startRefresher();
    }
}

