/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.sql.Timestamp;
import java.util.Vector;

class DTPrinter
implements Printable,
Pageable {
    private Container container;
    private PageFormat pageFormat;
    private PrinterJob printJob;
    private Vector<Double> taillePages;
    private String documentTitle = "";
    private BufferedImage toPrint = null;
    private int fitMode;
    private int pageCount = 1;
    private double ratio = 1.0;
    private Timestamp date;
    public static final int PORTRAIT = 1;
    public static final int LANDSCAPE = 0;
    public static final int FIT_PAGE_WIDTH = 0;
    public static final int FIT_PAGE = 1;
    public static final int NO_FIT = 2;

    public DTPrinter(Container container) {
        this.container = container;
        this.initPrintablePanel();
    }

    public void initPrintablePanel() {
        this.fitMode = 2;
        this.printJob = PrinterJob.getPrinterJob();
        this.pageFormat = this.printJob.defaultPage();
        Paper paper = (Paper)this.pageFormat.getPaper().clone();
        paper.setImageableArea(paper.getImageableX(), paper.getImageableY(), paper.getWidth() - 30.0, paper.getHeight() - 30.0);
        this.pageFormat.setPaper(paper);
    }

    public void setOrientation(int orientation) {
        this.pageFormat.setOrientation(orientation);
    }

    public void setFitMode(int fitMode) {
        this.fitMode = fitMode;
    }

    public int getPageWidth() {
        return (int)this.pageFormat.getImageableWidth();
    }

    public double getMarginTop() {
        return this.pageFormat.getImageableY();
    }

    public double getMarginLeft() {
        return this.pageFormat.getImageableX();
    }

    public void setLRMargins(double margin) {
        Paper paper = this.pageFormat.getPaper();
        paper.setImageableArea(margin, paper.getImageableY(), paper.getWidth() - margin, paper.getImageableHeight());
        this.pageFormat.setPaper(paper);
    }

    public void setTBMargins(double margin) {
        Paper paper = this.pageFormat.getPaper();
        paper.setImageableArea(paper.getImageableX(), margin, paper.getImageableWidth(), paper.getHeight() - margin);
        this.pageFormat.setPaper(paper);
    }

    public void setDocumentTitle(String title) {
        this.documentTitle = title;
    }

    public void setJobName(String jobName) {
        this.printJob.setJobName(jobName);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        if (pageIndex >= this.pageCount) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        int yPosition = 0;
        if (this.ratio != 1.0) {
            g2d.scale(this.ratio, this.ratio);
        }
        if (pageIndex > 0) {
            yPosition = (int)Math.rint(this.taillePages.get(pageIndex - 1) / this.ratio);
        }
        String details = this.documentTitle + " - [" + (pageIndex + 1) + "/" + this.pageCount + "] (" + this.date.toString() + ") ";
        Font formerPrintFont = g2d.getFont();
        Font newPrintFont = new Font(formerPrintFont.getName(), formerPrintFont.getStyle(), (int)Math.rint((double)formerPrintFont.getSize() / this.ratio));
        g2d.setFont(newPrintFont);
        g2d.drawImage((Image)this.toPrint, 0, yPosition, null);
        g2d.drawString(details, 0, g2d.getClip().getBounds().height - (int)Math.rint(5.0 / this.ratio));
        formerPrintFont = null;
        newPrintFont = null;
        details = null;
        g2d.dispose();
        g2d = null;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        this.calculatePages();
        this.printJob.setPageable(this);
        try {
            if (this.printJob.printDialog()) {
                this.date = new Timestamp(System.currentTimeMillis());
                this.toPrint = new BufferedImage(this.container.getWidth(), this.container.getHeight(), 2);
                this.container.printAll(this.toPrint.getGraphics());
                Paper paper = this.pageFormat.getPaper();
                Paper save = this.pageFormat.getPaper();
                this.pageFormat.setPaper(paper);
                this.printJob.setPrintable(this, this.pageFormat);
                this.printJob.print();
                this.pageFormat.setPaper(save);
            }
        }
        catch (PrinterException pe) {
            System.out.println("Error while printing document:\n" + pe.getMessage());
        }
        finally {
            this.toPrint = null;
            this.date = null;
        }
    }

    private void calculatePages() {
        double pageHeight = this.pageFormat.getImageableHeight();
        double pageWidth = this.pageFormat.getImageableWidth();
        double documentWidth = this.container.getWidth();
        double documentHeight = this.container.getHeight();
        double scaleX = pageWidth / documentWidth;
        double scaleY = pageHeight / documentHeight;
        double cumulatedYMove = 0.0;
        switch (this.fitMode) {
            case 1: {
                this.ratio = Math.min(scaleX, scaleY);
                break;
            }
            case 0: {
                this.ratio = scaleX;
                break;
            }
            case 2: {
                this.ratio = 1.0;
            }
        }
        this.taillePages = new Vector();
        double documentScaledHeight = documentHeight * this.ratio;
        if (documentScaledHeight > pageHeight) {
            int fullPagesCount = (int)Math.ceil(documentScaledHeight / pageHeight);
            for (int i = 0; i < fullPagesCount; ++i) {
                this.taillePages.add(new Double(cumulatedYMove -= pageHeight));
            }
            this.pageCount = this.taillePages.size();
        } else {
            this.pageCount = 1;
        }
    }

    @Override
    public int getNumberOfPages() {
        return this.pageCount;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }
}

