/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.EntityAdapter;
import explorer.EntityTableModel;
import explorer.Preferences;
import explorer.Status;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IStateListener;
import fr.esrf.tangoatk.core.StateEvent;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.util.ArrayList;
import javax.swing.JComponent;

public class CommandTableModel
extends EntityTableModel {
    public static final String COMMAND = "Command";

    public CommandTableModel(Status status, Preferences preferences) {
        this.status = status;
        this.entities = new CommandList();
        this.adapters = new ArrayList();
        this.columnIdentifiers = new ArrayList();
        this.preferences = preferences;
    }

    @Override
    protected void initColumns() {
        this.columnIdentifiers.add(DEVICE);
        this.columnIdentifiers.add(COMMAND);
        this.columnNames = new ArrayList(this.columnIdentifiers);
        this.fireTableStructureChanged();
    }

    @Override
    protected StringBuffer getPreferencePrefix() {
        return new StringBuffer("CommandTable.");
    }

    @Override
    public Object getValueAt(int row, int column) {
        EntityAdapter o = (EntityAdapter)this.adapters.get(row);
        ICommand command = ((CommandAdapter)o).getCommand();
        String header = this.getColumnName(column);
        if (DEVICE == header) {
            return this.getDeviceAlias(command.getDevice());
        }
        if (COMMAND == header) {
            return this.getEntityAlias((IEntity)command);
        }
        return "UGLE";
    }

    protected void addCommand(String name) {
        try {
            this.load(name, null, null);
        }
        catch (ConnectionException e) {
            this.status.status("Cannot load command " + name, (Exception)((Object)e));
        }
    }

    @Override
    public void load(String name, String alias, String deviceAlias) throws ConnectionException {
        ICommand command = (ICommand)this.entities.add(name);
        if (alias != null) {
            command.setAlias(alias);
        }
        this.addCommand(command);
    }

    @Override
    public void addEntity(IEntity command) {
        this.entities.add(command);
        if (this.deviceList != null) {
            this.deviceList.add(command.getDevice());
        }
        this.addCommand((ICommand)command);
    }

    public void addCommand(ICommand command) {
        if (this.exists((IEntity)command)) {
            return;
        }
        if (this.deviceList != null) {
            this.deviceList.add(command.getDevice());
        }
        this.adapters.add(new CommandAdapter(command, this.adapters.size()));
        this.fireTableRowsInserted(this.adapters.size(), this.adapters.size());
    }

    @Override
    protected boolean isExecuteColumn(int i) {
        if (i == -1) {
            return false;
        }
        return this.columnModel.getColumn(i).getHeaderValue() == COMMAND;
    }

    class CommandAdapter
    implements IStateListener,
    EntityAdapter {
        int row;
        ICommand command;

        @Override
        public IEntity getEntity() {
            return this.command;
        }

        @Override
        public void reloadProperties() {
            CommandTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public CommandAdapter(ICommand command, int row) {
            this.row = row;
            this.command = command;
            command.getDevice().addStateListener((IStateListener)this);
        }

        public void errorChange(ErrorEvent evt) {
        }

        public void stateChange(StateEvent evt) {
            JComponent r = CommandTableModel.this.getDeviceRenderer(CommandTableModel.this.getDeviceAlias(this.command.getDevice()));
            if (r == null) {
                return;
            }
            r.setBackground(ATKConstant.getColor4State((String)evt.getState()));
            r.setToolTipText(evt.getState());
            CommandTableModel.this.fireTableRowsUpdated(this.row, this.row);
        }

        public ICommand getCommand() {
            return this.command;
        }

        @Override
        public void remove() {
            this.command.getDevice().removeStateListener((IStateListener)this);
        }
    }
}

