/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.xjep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class FromBase
extends PostfixMathCommand {
    int globalBase = -1;
    String prefix = null;

    public FromBase() {
        this.numberOfParameters = 2;
    }

    public FromBase(int n) {
        this.numberOfParameters = 1;
        this.globalBase = n;
    }

    public FromBase(int n, String string) {
        this.numberOfParameters = 1;
        this.globalBase = n;
        this.prefix = string;
    }

    public void run(Stack stack) throws ParseException {
        Object e;
        int n = this.curNumberOfParameters;
        if (this.globalBase == -1 && n != 2) {
            throw new ParseException("fromBase: number of arguments should be 2");
        }
        if (this.globalBase != -1 && n != 1) {
            throw new ParseException("fromBase: number of arguments should be 1");
        }
        int n2 = this.globalBase;
        if (this.globalBase == -1) {
            e = stack.pop();
            if (e instanceof Number) {
                n2 = ((Number)e).intValue();
            } else {
                throw new ParseException("toBase: second argument should be an integer");
            }
        }
        if ((e = stack.pop()) instanceof String) {
            try {
                Object object = this.fromBase((String)e, n2);
                stack.push(object);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(numberFormatException.getMessage());
            }
        }
        throw new ParseException("fromBase: first arg should be a string");
    }

    public Object fromBase(String string, int n) throws NumberFormatException {
        int n2;
        boolean bl = string.startsWith("-");
        if (bl) {
            string = string.substring(1);
        }
        if (this.prefix != null) {
            if (string.startsWith(this.prefix)) {
                string = string.substring(this.prefix.length());
            } else {
                throw new NumberFormatException("fromBase: string must start with prefix " + this.prefix);
            }
        }
        if ((n2 = string.indexOf(46)) == -1) {
            double d = Long.parseLong(string, n);
            if (bl) {
                d = -d;
            }
            return new Double(d);
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        long l = Long.parseLong(string2, n);
        double d = Long.parseLong(string3, n);
        double d2 = (double)l + d / Math.pow(n, string3.length());
        if (bl) {
            d2 = -d2;
        }
        return new Double(d2);
    }
}

