/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.mrpe;

import org.lsmp.djep.mrpe.MRpEval;

public final class MRpCommandList {
    private static final int STACK_INC = 10;
    MRpCommand[] commands = new MRpCommand[10];
    private short commandPos;
    private int finalType;

    MRpCommandList() {
    }

    final void addCommand(short s, short s2) {
        if (this.commandPos == this.commands.length) {
            MRpCommand[] mRpCommandArray = new MRpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, mRpCommandArray, 0, this.commands.length);
            this.commands = mRpCommandArray;
        }
        this.commands[this.commandPos] = new MRpCommand(s, s2);
        this.commandPos = (short)(this.commandPos + 1);
    }

    final void addCommand(short s, short s2, short s3) {
        if (this.commandPos == this.commands.length) {
            MRpCommand[] mRpCommandArray = new MRpCommand[this.commands.length + 10];
            System.arraycopy(this.commands, 0, mRpCommandArray, 0, this.commands.length);
            this.commands = mRpCommandArray;
        }
        this.commands[this.commandPos] = new MRpCommand(s, s2, s3);
        this.commandPos = (short)(this.commandPos + 1);
    }

    public int getNumCommands() {
        return this.commandPos;
    }

    int getFinalType() {
        return this.finalType;
    }

    void setFinalType(int n) {
        this.finalType = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.commandPos; ++i) {
            stringBuffer.append(this.commands[i].toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    static final class MRpCommand {
        short command;
        short aux1;
        short aux2;

        MRpCommand(short s, short s2) {
            this.command = s;
            this.aux1 = s2;
            this.aux2 = (short)-1;
        }

        MRpCommand(short s, short s2, short s3) {
            this.command = s;
            this.aux1 = s2;
            this.aux2 = s3;
        }

        public String toString() {
            switch (this.command) {
                case 0: {
                    return "Constant\tnum " + this.aux1;
                }
                case 1: {
                    return "Variable\ttype " + MRpEval.dimTypeToDimension(this.aux1) + "\tnum " + this.aux2;
                }
                case 2: {
                    return "ADD\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 3: {
                    return "SUB\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 4: {
                    return "MUL\ttype " + MRpEval.dimTypeToDimension(this.aux1) + " by " + MRpEval.dimTypeToDimension(this.aux2);
                }
                case 5: {
                    return "DIV\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 6: {
                    return "MOD\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 7: {
                    return "POW\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 8: {
                    return "AND\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 9: {
                    return "OR\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 10: {
                    return "NOT\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 11: {
                    return "LT\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 13: {
                    return "GT\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 12: {
                    return "LE\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 14: {
                    return "GE\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 15: {
                    return "NE\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 16: {
                    return "EQ\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 20: {
                    return "Assign type " + MRpEval.dimTypeToDimension(this.aux1) + " no " + this.aux2;
                }
                case 17: {
                    return "List type " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 18: {
                    return "Dot type " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 19: {
                    return "Cross type " + MRpEval.dimTypeToDimension(this.aux1);
                }
                case 23: {
                    return "Function\tnum " + this.aux1;
                }
                case 24: {
                    return "UMinus\ttype " + MRpEval.dimTypeToDimension(this.aux1);
                }
            }
            return "Warning unknown command: " + this.command + " " + this.aux1 + " " + this.aux2;
        }
    }
}

