/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.DICOM_Sorter;
import ij.plugin.FolderOpenerDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.io.File;

public class FolderOpener
implements PlugIn {
    private static boolean convertToGrayscale;
    private static boolean convertToRGB;
    private static boolean sortFileNames;
    private static double scale;
    private static boolean virtualStack;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private FileInfo fi;
    private String info1;

    public void run(String arg) {
        boolean allSameCalibration;
        Calibration cal;
        double max;
        double min;
        ImageStack stack;
        String title;
        String directory;
        block51: {
            int index;
            OpenDialog od = new OpenDialog("Open Image Sequence...", arg);
            directory = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return;
            }
            String[] list = new File(directory).list();
            if (list == null) {
                return;
            }
            title = directory;
            if (title.endsWith(File.separator)) {
                title = title.substring(0, title.length() - 1);
            }
            if ((index = title.lastIndexOf(File.separatorChar)) != -1) {
                title = title.substring(index + 1);
            }
            if (title.endsWith(":")) {
                title = title.substring(0, title.length() - 1);
            }
            IJ.register(FolderOpener.class);
            list = this.trimFileList(list);
            if (list == null) {
                return;
            }
            if (IJ.debugMode) {
                IJ.log("FolderOpener: " + directory + " (" + list.length + " files)");
            }
            int width = 0;
            int height = 0;
            int depth = 0;
            int bitDepth = 0;
            stack = null;
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            cal = null;
            allSameCalibration = true;
            IJ.resetEscape();
            try {
                int i;
                for (int i2 = 0; i2 < list.length; ++i2) {
                    IJ.redirectErrorMessages();
                    ImagePlus imp = new Opener().openImage(directory, list[i2]);
                    if (imp == null) continue;
                    width = imp.getWidth();
                    height = imp.getHeight();
                    bitDepth = imp.getBitDepth();
                    this.fi = imp.getOriginalFileInfo();
                    if (this.showDialog(imp, list)) break;
                    return;
                }
                if (width == 0) {
                    IJ.error("Import Sequence", "This folder does not appear to contain any TIFF,\nJPEG, BMP, DICOM, GIF, FITS or PGM files.");
                    return;
                }
                if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                    this.filter = null;
                }
                if (this.filter != null) {
                    int filteredImages = 0;
                    for (int i3 = 0; i3 < list.length; ++i3) {
                        if (list[i3].indexOf(this.filter) >= 0) {
                            ++filteredImages;
                            continue;
                        }
                        list[i3] = null;
                    }
                    if (filteredImages == 0) {
                        IJ.error("None of the " + list.length + " files contain\n the string '" + this.filter + "' in their name.");
                        return;
                    }
                    String[] list2 = new String[filteredImages];
                    int j = 0;
                    for (i = 0; i < list.length; ++i) {
                        if (list[i] == null) continue;
                        list2[j++] = list[i];
                    }
                    list = list2;
                }
                if (sortFileNames) {
                    list = this.sortFileList(list);
                }
                if (this.n < 1) {
                    this.n = list.length;
                }
                if (this.start < 1 || this.start > list.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > list.length) {
                    this.n = list.length - this.start + 1;
                }
                int count = 0;
                int counter = 0;
                ImagePlus imp = null;
                for (i = this.start - 1; i < list.length; ++i) {
                    String info;
                    if (counter++ % this.increment != 0) continue;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages();
                    if (!virtualStack || stack == null) {
                        imp = opener.openImage(directory, list[i]);
                    }
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        depth = imp.getStackSize();
                        bitDepth = imp.getBitDepth();
                        cal = imp.getCalibration();
                        if (convertToRGB) {
                            bitDepth = 24;
                        }
                        if (convertToGrayscale) {
                            bitDepth = 8;
                        }
                        ColorModel cm = imp.getProcessor().getColorModel();
                        stack = virtualStack ? new VirtualStack(width, height, cm, directory) : (scale < 100.0 ? new ImageStack((int)((double)width * scale / 100.0), (int)((double)height * scale / 100.0), cm) : new ImageStack(width, height, cm));
                        this.info1 = (String)imp.getProperty("Info");
                    }
                    if (imp == null) continue;
                    if (imp.getWidth() != width || imp.getHeight() != height) {
                        IJ.log(list[i] + ": wrong size; " + width + "x" + height + " expected, " + imp.getWidth() + "x" + imp.getHeight() + " found");
                        continue;
                    }
                    String label = imp.getTitle();
                    if (depth == 1 && (info = (String)imp.getProperty("Info")) != null) {
                        label = label + "\n" + info;
                    }
                    if (imp.getCalibration().pixelWidth != cal.pixelWidth) {
                        allSameCalibration = false;
                    }
                    ImageStack inputStack = imp.getStack();
                    for (int slice = 1; slice <= inputStack.getSize(); ++slice) {
                        ImageProcessor ip = inputStack.getProcessor(slice);
                        int bitDepth2 = imp.getBitDepth();
                        if (convertToRGB) {
                            ip = ip.convertToRGB();
                            bitDepth2 = 24;
                        } else if (convertToGrayscale) {
                            ip = ip.convertToByte(true);
                            bitDepth2 = 8;
                        }
                        if (bitDepth2 != bitDepth) {
                            if (bitDepth == 8) {
                                ip = ip.convertToByte(true);
                                bitDepth2 = 8;
                            } else if (bitDepth == 24) {
                                ip = ip.convertToRGB();
                                bitDepth2 = 24;
                            }
                        }
                        if (bitDepth2 != bitDepth) {
                            IJ.log(list[i] + ": wrong bit depth; " + bitDepth + " expected, " + bitDepth2 + " found");
                            break;
                        }
                        if (slice == 1) {
                            ++count;
                        }
                        IJ.showStatus(count + "/" + this.n);
                        IJ.showProgress(count, this.n);
                        if (scale < 100.0) {
                            ip = ip.resize((int)((double)width * scale / 100.0), (int)((double)height * scale / 100.0));
                        }
                        if (ip.getMin() < min) {
                            min = ip.getMin();
                        }
                        if (ip.getMax() > max) {
                            max = ip.getMax();
                        }
                        String label2 = label;
                        if (depth > 1) {
                            label2 = "" + slice;
                        }
                        if (virtualStack) {
                            if (slice != 1) continue;
                            ((VirtualStack)stack).addSlice(list[i]);
                            continue;
                        }
                        stack.addSlice(label2, ip);
                    }
                    if (count < this.n) {
                        if (!IJ.escapePressed()) continue;
                        IJ.beep();
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory("FolderOpener");
                if (stack == null) break block51;
                stack.trim();
            }
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2;
            if (this.info1 != null && this.info1.lastIndexOf("7FE0,0010") > 0) {
                stack = new DICOM_Sorter().sort(stack);
            }
            if ((imp2 = new ImagePlus(title, stack)).getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            if (this.fi == null) {
                this.fi = new FileInfo();
            }
            this.fi.fileFormat = 0;
            this.fi.fileName = "";
            this.fi.directory = directory;
            imp2.setFileInfo(this.fi);
            if (allSameCalibration) {
                imp2.setCalibration(cal);
            }
            if (imp2.getStackSize() == 1 && this.info1 != null) {
                imp2.setProperty("Info", this.info1);
            }
            imp2.show();
        }
        IJ.showProgress(1.0);
    }

    boolean showDialog(ImagePlus imp, String[] list) {
        int fileCount = list.length;
        FolderOpenerDialog gd = new FolderOpenerDialog("Sequence Options", imp, list);
        gd.addNumericField("Number of Images:", fileCount, 0);
        gd.addNumericField("Starting Image:", 1.0, 0);
        gd.addNumericField("Increment:", 1.0, 0);
        gd.addStringField("File Name Contains:", "");
        gd.addNumericField("Scale Images:", scale, 0, 4, "%");
        gd.addCheckbox("Convert to 8-bit Grayscale", convertToGrayscale);
        gd.addCheckbox("Convert_to_RGB", convertToRGB);
        gd.addCheckbox("Sort Names Numerically", sortFileNames);
        gd.addCheckbox("Use Virtual Stack", virtualStack);
        gd.addMessage("10000 x 10000 x 1000 (100.3MB)");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.n = (int)gd.getNextNumber();
        this.start = (int)gd.getNextNumber();
        this.increment = (int)gd.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        if ((scale = gd.getNextNumber()) < 5.0) {
            scale = 5.0;
        }
        if (scale > 100.0) {
            scale = 100.0;
        }
        this.filter = gd.getNextString();
        convertToGrayscale = gd.getNextBoolean();
        convertToRGB = gd.getNextBoolean();
        sortFileNames = gd.getNextBoolean();
        virtualStack = gd.getNextBoolean();
        if (virtualStack) {
            convertToGrayscale = false;
            convertToRGB = false;
            scale = 100.0;
        }
        return true;
    }

    public String[] trimFileList(String[] rawlist) {
        int count = 0;
        for (int i = 0; i < rawlist.length; ++i) {
            String name = rawlist[i];
            if (name.startsWith(".") || name.equals("Thumbs.db") || name.endsWith(".txt") || name.endsWith(".lut") || name.endsWith(".roi") || name.endsWith(".pty")) {
                rawlist[i] = null;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] list = rawlist;
        if (count < rawlist.length) {
            list = new String[count];
            int index = 0;
            for (int i = 0; i < rawlist.length; ++i) {
                if (rawlist[i] == null) continue;
                list[index++] = rawlist[i];
            }
        }
        return list;
    }

    public String[] sortFileList(String[] list) {
        int i;
        int listLength = list.length;
        boolean allSameLength = true;
        int len0 = list[0].length();
        for (int i2 = 0; i2 < listLength; ++i2) {
            if (list[i2].length() == len0) continue;
            allSameLength = false;
            break;
        }
        if (allSameLength) {
            StringSorter.sort(list);
            return list;
        }
        int maxDigits = 15;
        String[] list2 = null;
        for (i = 0; i < listLength; ++i) {
            int len = list[i].length();
            String num = "";
            for (int j = 0; j < len; ++j) {
                char ch = list[i].charAt(j);
                if (ch < '0' || ch > '9') continue;
                num = num + ch;
            }
            if (list2 == null) {
                list2 = new String[listLength];
            }
            if (num.length() == 0) {
                num = "aaaaaa";
            }
            num = "000000000000000" + num;
            num = num.substring(num.length() - maxDigits);
            list2[i] = num + list[i];
        }
        if (list2 != null) {
            StringSorter.sort(list2);
            for (i = 0; i < listLength; ++i) {
                list2[i] = list2[i].substring(maxDigits);
            }
            return list2;
        }
        StringSorter.sort(list);
        return list;
    }

    static {
        sortFileNames = true;
        scale = 100.0;
    }
}

