/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IRawImage;
import fr.esrf.tangoatk.core.IRawImageListener;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import java.io.Serializable;

class RawImageHelper
implements Serializable {
    IAttribute attribute;
    EventSupport propChanges;
    String encFormat = null;

    public RawImageHelper(IAttribute iAttribute) {
        this.init(iAttribute);
    }

    void init(IAttribute iAttribute) {
        this.setAttribute(iAttribute);
        this.propChanges = ((AAttribute)iAttribute).getPropChanges();
    }

    public void setAttribute(IAttribute iAttribute) {
        this.attribute = iAttribute;
    }

    public IAttribute getAttribute() {
        return this.attribute;
    }

    protected void setProperty(String string, Number number) {
        this.attribute.setProperty(string, number);
        this.attribute.storeConfig();
    }

    protected void setProperty(String string, Number number, boolean bl) {
        this.attribute.setProperty(string, number, bl);
    }

    void fireRawImageValueChanged(String string, byte[] byArray, long l) {
        this.propChanges.fireRawImageEvent((IRawImage)this.attribute, string, byArray, l);
    }

    byte[] getRawImageValue(DeviceAttribute deviceAttribute) throws DevFailed {
        DevEncoded devEncoded = deviceAttribute.extractDevEncoded();
        this.encFormat = devEncoded.encoded_format;
        return devEncoded.encoded_data;
    }

    String getRawImageFormat() {
        return this.encFormat;
    }

    void addRawImageListener(IRawImageListener iRawImageListener) {
        this.propChanges.addRawImageListener(iRawImageListener);
    }

    void removeRawImageListener(IRawImageListener iRawImageListener) {
        this.propChanges.removeRawImageListener(iRawImageListener);
    }

    public String getVersion() {
        return "$Id: RawImageHelper.java 13210 2009-03-26 10:00:03Z jlpons $";
    }
}

