/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.core;

import fr.esrf.tangoatk.core.IEntity;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class Property {
    protected String name;
    protected Object value;
    protected Object oldValue;
    protected boolean editable;
    protected IEntity parent;
    protected boolean specified = true;
    protected PropertyChangeSupport propChanges;

    public Property() {
    }

    public Property(IEntity iEntity, String string, Object object, boolean bl) {
        this.propChanges = new PropertyChangeSupport(this);
        this.parent = iEntity;
        this.setName(string);
        this.setValue(object);
        this.editable = bl;
    }

    public void addPresentationListener(PropertyChangeListener propertyChangeListener) {
        this.propChanges.addPropertyChangeListener("presentation", propertyChangeListener);
    }

    public void removePresentationListener(PropertyChangeListener propertyChangeListener) {
        this.propChanges.removePropertyChangeListener("presentation", propertyChangeListener);
    }

    public void refresh() {
        this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
        this.oldValue = this.value;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setSpecified(boolean bl) {
        this.specified = bl;
    }

    public boolean isSpecified() {
        return this.specified;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(Object object) {
        this.setSpecified(true);
        this.oldValue = this.value;
        this.value = object;
    }

    public void setValueFromString(String string) {
        this.setValue(string);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "";
    }

    public int getIntValue() {
        return (Integer)this.value;
    }

    public String getPresentation() {
        String string = "";
        if (this.value != null) {
            string = this.value.toString();
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public void store() {
        this.propChanges.firePropertyChange("presentation", this.oldValue, this.value);
        this.parent.storeConfig();
    }

    public String getVersion() {
        return "$Id: Property.java 12968 2009-01-26 17:54:56Z poncet $";
    }
}

