/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoBuffer;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class JDSlider
extends JDRectangular {
    public static final int SLIDER_HORIZONTAL_LEFT = 0;
    public static final int SLIDER_HORIZONTAL_RIGHT = 1;
    public static final int SLIDER_VERTICAL_TOP = 2;
    public static final int SLIDER_VERTICAL_BOTTOM = 3;
    static final double minDefault = 0.0;
    static final double maxDefault = 1.0;
    static final double valueDefault = 0.5;
    static final int orientationDefault = 3;
    static final JDObject cursorDefault = new JDRectangle("DefaultSliderCursor", 0, 0, 16, 16);
    double min;
    double max;
    double value;
    int orientation;
    JDObject cursor;

    public JDSlider(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(n, n2));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates(n, n2, n3, n4);
        this.updateShape();
    }

    JDSlider(JDSlider jDSlider, int n, int n2) {
        this.cloneObject(jDSlider, n, n2);
        this.min = jDSlider.min;
        this.max = jDSlider.max;
        this.value = jDSlider.value;
        this.orientation = jDSlider.orientation;
        this.cursor = jDSlider.cursor.copy(n, n2);
        this.updateShape();
    }

    JDSlider(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("minSlider")) {
                this.min = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("maxSlider")) {
                this.max = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("valueSlider")) {
                this.value = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("orientation")) {
                this.orientation = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("cursor")) {
                this.cursor = jDFileLoader.parseObject();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDSlider(this, n, n2);
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.min = 0.0;
        this.max = 1.0;
        this.value = 0.5;
        this.orientation = 3;
        this.cursor = cursorDefault.copy(0, 0);
    }

    @Override
    public boolean isInsideObject(int n, int n2) {
        if (this.cursor.isInsideObject(n, n2)) {
            return true;
        }
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        if (this.fillStyle != 0) {
            return this.boundRect.contains(n, n2);
        }
        int n3 = this.boundRect.x;
        int n4 = this.boundRect.x + this.boundRect.width;
        int n5 = this.boundRect.y;
        int n6 = this.boundRect.y + this.boundRect.height;
        return this.isPointOnLine(n, n2, n3, n5, n4, n5) || this.isPointOnLine(n, n2, n4, n5, n4, n6) || this.isPointOnLine(n, n2, n4, n6, n3, n6) || this.isPointOnLine(n, n2, n3, n6, n3, n5);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        this.ptsx[0] = (int)(this.summit[0].x + 0.5);
        this.ptsy[0] = (int)(this.summit[0].y + 0.5);
        this.ptsx[1] = (int)(this.summit[2].x + 0.5);
        this.ptsy[1] = (int)(this.summit[2].y + 0.5);
        this.ptsx[2] = (int)(this.summit[4].x + 0.5);
        this.ptsy[2] = (int)(this.summit[4].y + 0.5);
        this.ptsx[3] = (int)(this.summit[6].x + 0.5);
        this.ptsy[3] = (int)(this.summit[6].y + 0.5);
        if (!Double.isNaN(this.value)) {
            double d = 0.0;
            if (this.min != this.max) {
                d = (this.value - this.min) / (this.max - this.min);
            }
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            this.cursor.centerOrigin();
            double d2 = (this.summit[0].x + this.summit[4].x) / 2.0;
            double d3 = (this.summit[0].y + this.summit[4].y) / 2.0;
            double d4 = this.boundRect.width - 1;
            double d5 = this.boundRect.height - 1;
            switch (this.orientation) {
                case 0: {
                    double d6 = d4 * (d - 0.5);
                    if (d6 < -(d4 / 2.0)) {
                        d6 = -d4 / 2.0;
                    }
                    if (d6 > d4 / 2.0) {
                        d6 = d4 / 2.0;
                    }
                    double d7 = d2 - this.cursor.origin.x + d6;
                    double d8 = d3 - this.cursor.origin.y;
                    if (!(Math.abs(d7) > 0.5) && !(Math.abs(d8) > 0.5)) break;
                    this.cursor.translate(d7, d8);
                    break;
                }
                case 1: {
                    double d9 = d4 * (1.0 - d - 0.5);
                    if (d9 < -(d4 / 2.0)) {
                        d9 = -d4 / 2.0;
                    }
                    if (d9 > d4 / 2.0) {
                        d9 = d4 / 2.0;
                    }
                    double d10 = d2 - this.cursor.origin.x + d9;
                    double d11 = d3 - this.cursor.origin.y;
                    if (!(Math.abs(d10) > 0.5) && !(Math.abs(d11) > 0.5)) break;
                    this.cursor.translate(d10, d11);
                    break;
                }
                case 2: {
                    double d12 = d5 * (d - 0.5);
                    if (d12 < -(d5 / 2.0)) {
                        d12 = -d5 / 2.0;
                    }
                    if (d12 > d5 / 2.0) {
                        d12 = d5 / 2.0;
                    }
                    double d13 = d2 - this.cursor.origin.x;
                    double d14 = d3 - this.cursor.origin.y + d12;
                    if (!(Math.abs(d13) > 0.5) && !(Math.abs(d14) > 0.5)) break;
                    this.cursor.translate(d13, d14);
                    break;
                }
                case 3: {
                    double d15 = d5 * (1.0 - d - 0.5);
                    if (d15 < -(d5 / 2.0)) {
                        d15 = -d5 / 2.0;
                    }
                    if (d15 > d5 / 2.0) {
                        d15 = d5 / 2.0;
                    }
                    double d16 = d2 - this.cursor.origin.x;
                    double d17 = d3 - this.cursor.origin.y + d15;
                    if (!(Math.abs(d16) > 0.5) && !(Math.abs(d17) > 0.5)) break;
                    this.cursor.translate(d16, d17);
                }
            }
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.prepareRendering((Graphics2D)graphics);
        super.paint(jDrawEditor, graphics);
        if (!Double.isNaN(this.value)) {
            this.cursor.paint(jDrawEditor, graphics);
        }
    }

    @Override
    Rectangle getRepaintRect() {
        Rectangle rectangle = super.getRepaintRect();
        if (Double.isNaN(this.value)) {
            return rectangle;
        }
        return rectangle.union(this.cursor.getRepaintRect());
    }

    public void setMaximum(double d) {
        this.max = d;
        this.updateShape();
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMinimum(double d) {
        this.min = d;
        this.updateShape();
    }

    public double getMinimum() {
        return this.min;
    }

    public void setSliderValue(double d) {
        this.value = d;
        this.updateShape();
    }

    public double getSliderValue() {
        return this.value;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.updateShape();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public JDObject getCursor() {
        return this.cursor;
    }

    public void setCursor(JDObject jDObject) {
        this.cursor = jDObject;
        this.updateShape();
    }

    @Override
    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string;
        String string2 = this.saveObjectHeader(fileWriter, n);
        if (this.min != 0.0) {
            string = string2 + "minSlider:" + this.min + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.max != 1.0) {
            string = string2 + "maxSlider:" + this.max + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.value != 0.5) {
            string = string2 + "valueSlider:" + this.value + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.orientation != 3) {
            string = string2 + "orientation:" + this.orientation + "\n";
            fileWriter.write(string, 0, string.length());
        }
        string = string2 + "cursor:\n";
        fileWriter.write(string, 0, string.length());
        this.cursor.saveObject(fileWriter, n + 2);
        this.closeObjectHeader(fileWriter, n);
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(13);
        this.fillUndoPattern(undoPattern);
        undoPattern.min = this.min;
        undoPattern.max = this.max;
        undoPattern.value = this.value;
        undoPattern.textOrientation = this.orientation;
        undoPattern.gChildren = new Vector();
        undoPattern.gChildren.add(this.cursor.getUndoPattern());
        return undoPattern;
    }

    JDSlider(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.min = undoPattern.min;
        this.max = undoPattern.max;
        this.value = undoPattern.value;
        this.orientation = undoPattern.textOrientation;
        Vector vector = new Vector();
        UndoBuffer.rebuildObject((UndoPattern)undoPattern.gChildren.get(0), vector);
        this.cursor = (JDObject)vector.get(0);
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }
}

