/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;

public class JDRoundRectangle
extends JDRectangular
implements JDPolyConvert {
    static final int stepDefault = 6;
    static final int cornerWidthDefault = 24;
    private int step;
    private int cornerWidth;

    public JDRoundRectangle(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(n, n2));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates(n, n2, n3, n4);
        this.updateShape();
    }

    JDRoundRectangle(JDRoundRectangle jDRoundRectangle, int n, int n2) {
        this.cloneObject(jDRoundRectangle, n, n2);
        this.cornerWidth = jDRoundRectangle.cornerWidth;
        this.step = jDRoundRectangle.step;
        this.updateShape();
    }

    JDRoundRectangle(JLXObject jLXObject, int n) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d3 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d + d3 / 2.0;
        this.summit[1].y = d2;
        this.summit[2].x = d + d3;
        this.summit[2].y = d2;
        this.summit[3].x = d + d3;
        this.summit[3].y = d2 + d4 / 2.0;
        this.summit[4].x = d + d3;
        this.summit[4].y = d2 + d4;
        this.summit[5].x = d + d3 / 2.0;
        this.summit[5].y = d2 + d4;
        this.summit[6].x = d;
        this.summit[6].y = d2 + d4;
        this.summit[7].x = d;
        this.summit[7].y = d2 + d4 / 2.0;
        this.step = 6;
        this.cornerWidth = n;
        this.updateShape();
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.step = 6;
        this.cornerWidth = 24;
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDRoundRectangle(this, n, n2);
    }

    @Override
    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        boolean bl = false;
        int n3 = 0;
        if (this.fillStyle != 0) {
            Polygon polygon = new Polygon(this.ptsx, this.ptsy, this.ptsx.length);
            bl = polygon.contains(n, n2);
        } else {
            while (n3 < this.ptsx.length - 1 && !bl) {
                bl = this.isPointOnLine(n, n2, this.ptsx[n3], this.ptsy[n3], this.ptsx[n3 + 1], this.ptsy[n3 + 1]);
                if (bl) continue;
                ++n3;
            }
            if (!bl) {
                bl = this.isPointOnLine(n, n2, this.ptsx[n3], this.ptsy[n3], this.ptsx[0], this.ptsy[0]);
            }
        }
        return bl;
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        if (this.boundRect.width <= this.cornerWidth * 2 || this.boundRect.height <= this.cornerWidth * 2) {
            this.ptsx = new int[4];
            this.ptsy = new int[4];
            this.ptsx[0] = (int)(this.summit[0].x + 0.5);
            this.ptsy[0] = (int)(this.summit[0].y + 0.5);
            this.ptsx[1] = (int)(this.summit[2].x + 0.5);
            this.ptsy[1] = (int)(this.summit[2].y + 0.5);
            this.ptsx[2] = (int)(this.summit[4].x + 0.5);
            this.ptsy[2] = (int)(this.summit[4].y + 0.5);
            this.ptsx[3] = (int)(this.summit[6].x + 0.5);
            this.ptsy[3] = (int)(this.summit[6].y + 0.5);
        } else {
            int n = 0;
            int n2 = 0;
            this.ptsx = new int[(this.step + 1) * 4];
            this.ptsy = new int[(this.step + 1) * 4];
            for (n = 0; n < 4; ++n) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                switch (n) {
                    case 0: {
                        d8 = this.boundRect.x;
                        d7 = this.boundRect.x;
                        d6 = this.boundRect.x + this.cornerWidth / 4;
                        d5 = this.boundRect.x + this.cornerWidth;
                        d4 = this.boundRect.y + this.cornerWidth;
                        d3 = this.boundRect.y + this.cornerWidth / 4;
                        d2 = this.boundRect.y;
                        d = this.boundRect.y;
                        break;
                    }
                    case 1: {
                        d8 = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth;
                        d7 = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth / 4;
                        d6 = this.boundRect.x + this.boundRect.width - 1;
                        d5 = this.boundRect.x + this.boundRect.width - 1;
                        d4 = this.boundRect.y;
                        d3 = this.boundRect.y;
                        d2 = this.boundRect.y + this.cornerWidth / 4;
                        d = this.boundRect.y + this.cornerWidth;
                        break;
                    }
                    case 2: {
                        d8 = this.boundRect.x + this.boundRect.width - 1;
                        d7 = this.boundRect.x + this.boundRect.width - 1;
                        d6 = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth / 4;
                        d5 = this.boundRect.x + this.boundRect.width - 1 - this.cornerWidth;
                        d4 = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth;
                        d3 = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth / 4;
                        d2 = this.boundRect.y + this.boundRect.height - 1;
                        d = this.boundRect.y + this.boundRect.height - 1;
                        break;
                    }
                    default: {
                        d8 = this.boundRect.x + this.cornerWidth;
                        d7 = this.boundRect.x + this.cornerWidth / 4;
                        d6 = this.boundRect.x;
                        d5 = this.boundRect.x;
                        d4 = this.boundRect.y + this.boundRect.height - 1;
                        d3 = this.boundRect.y + this.boundRect.height - 1;
                        d2 = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth / 4;
                        d = this.boundRect.y + this.boundRect.height - 1 - this.cornerWidth;
                    }
                }
                double d9 = 1.0 / (double)this.step;
                double d10 = 0.0;
                for (int i = 0; i <= this.step; ++i) {
                    double d11 = d10 * d10;
                    double d12 = d11 * d10;
                    int n3 = (int)((1.0 - 3.0 * d10 + 3.0 * d11 - d12) * d8 + 3.0 * (d10 - 2.0 * d11 + d12) * d7 + 3.0 * (d11 - d12) * d6 + d12 * d5 + 0.5);
                    int n4 = (int)((1.0 - 3.0 * d10 + 3.0 * d11 - d12) * d4 + 3.0 * (d10 - 2.0 * d11 + d12) * d3 + 3.0 * (d11 - d12) * d2 + d12 * d + 0.5);
                    if (i == 0) {
                        this.ptsx[n2] = (int)(d8 + 0.5);
                        this.ptsy[n2] = (int)(d4 + 0.5);
                    }
                    if (i == this.step) {
                        this.ptsx[n2] = (int)(d5 + 0.5);
                        this.ptsy[n2] = (int)(d + 0.5);
                    } else {
                        this.ptsx[n2] = n3;
                        this.ptsy[n2] = n4;
                    }
                    ++n2;
                    d10 += d9;
                }
            }
        }
        if (this.hasShadow()) {
            this.computeShadow(true);
            this.computeShadowColors();
        }
    }

    @Override
    public JDPolyline convertToPolyline() {
        JDPolyline jDPolyline = this.buildDefaultPolyline();
        jDPolyline.setClosed(true);
        jDPolyline.updateShape();
        return jDPolyline;
    }

    @Override
    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string;
        String string2 = this.saveObjectHeader(fileWriter, n);
        if (this.step != 6) {
            string = string2 + "step:" + this.step + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.cornerWidth != 24) {
            string = string2 + "cornerWidth:" + this.cornerWidth + "\n";
            fileWriter.write(string, 0, string.length());
        }
        this.closeObjectHeader(fileWriter, n);
    }

    JDRoundRectangle(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("cornerWidth")) {
                this.cornerWidth = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("step")) {
                this.step = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(7);
        this.fillUndoPattern(undoPattern);
        undoPattern.step = this.step;
        undoPattern.cornerWidth = this.cornerWidth;
        return undoPattern;
    }

    JDRoundRectangle(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.step = undoPattern.step;
        this.cornerWidth = undoPattern.cornerWidth;
        this.updateShape();
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int n) {
        this.step = n;
        this.updateShape();
    }

    public int getCornerWidth() {
        return this.cornerWidth;
    }

    public void setCornerWidth(int n) {
        this.cornerWidth = n;
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }
}

