/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.LXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class JDImage
extends JDRectangular {
    private static ImageIcon defaultImage = new ImageIcon(JDImage.class.getResource("/fr/esrf/tangoatk/widget/util/jdraw/gif/not_found.gif"));
    private Image theImage = null;
    private int imgWidth = 0;
    private int imgHeight = 0;
    private String fileName;

    public JDImage(String string, String string2, int n, int n2) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(0.0, 0.0));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.fileName = string2;
        this.lineWidth = 0;
        this.createSummit();
        this.loadImage();
        this.computeSummitCoordinates(n, n2, this.imgWidth, this.imgHeight);
        this.updateShape();
        this.centerOrigin();
    }

    JDImage(JDImage jDImage, int n, int n2) {
        this.cloneObject(jDImage, n, n2);
        this.fileName = new String(jDImage.fileName);
        this.invalidateImage();
        this.updateShape();
    }

    JDImage(JLXObject jLXObject, String string) {
        this.initDefault();
        this.loadObject(jLXObject);
        double d = jLXObject.boundRect.getX();
        double d2 = jLXObject.boundRect.getY();
        double d3 = jLXObject.boundRect.getWidth();
        double d4 = jLXObject.boundRect.getHeight();
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        if (string.startsWith("file:/")) {
            string = string.substring(6);
        }
        this.fileName = string;
        this.lineWidth = 0;
        this.fillStyle = 0;
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d + d3 / 2.0;
        this.summit[1].y = d2;
        this.summit[2].x = d + d3;
        this.summit[2].y = d2;
        this.summit[3].x = d + d3;
        this.summit[3].y = d2 + d4 / 2.0;
        this.summit[4].x = d + d3;
        this.summit[4].y = d2 + d4;
        this.summit[5].x = d + d3 / 2.0;
        this.summit[5].y = d2 + d4;
        this.summit[6].x = d;
        this.summit[6].y = d2 + d4;
        this.summit[7].x = d;
        this.summit[7].y = d2 + d4 / 2.0;
        this.loadImage();
        this.updateShape();
    }

    JDImage(LXObject lXObject, String string) {
        this.initDefault();
        this.loadObject(lXObject);
        double d = lXObject.boundRect.getX();
        double d2 = lXObject.boundRect.getY();
        double d3 = lXObject.boundRect.getWidth() - 1.0;
        double d4 = lXObject.boundRect.getHeight() - 1.0;
        this.setOrigin(new Point2D.Double(d + d3 / 2.0, d2 + d4 / 2.0));
        this.summit = new Point2D.Double[8];
        this.createSummit();
        if (string.startsWith("file:/")) {
            string = string.substring(6);
        }
        this.fileName = string;
        this.lineWidth = 0;
        this.fillStyle = 0;
        this.summit[0].x = d;
        this.summit[0].y = d2;
        this.summit[1].x = d + d3 / 2.0;
        this.summit[1].y = d2;
        this.summit[2].x = d + d3;
        this.summit[2].y = d2;
        this.summit[3].x = d + d3;
        this.summit[3].y = d2 + d4 / 2.0;
        this.summit[4].x = d + d3;
        this.summit[4].y = d2 + d4;
        this.summit[5].x = d + d3 / 2.0;
        this.summit[5].y = d2 + d4;
        this.summit[6].x = d;
        this.summit[6].y = d2 + d4;
        this.summit[7].x = d;
        this.summit[7].y = d2 + d4 / 2.0;
        this.loadImage();
        this.updateShape();
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDImage(this, n, n2);
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        this.prepareRendering((Graphics2D)graphics);
        super.paint(jDrawEditor, graphics);
        this.loadImage();
        graphics.drawImage(this.theImage, this.boundRect.x, this.boundRect.y, this.boundRect.width, this.boundRect.height, null);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (this.summit[0].x < this.summit[2].x) {
            if (this.summit[0].y < this.summit[6].y) {
                this.ptsx[0] = (int)this.summit[0].x;
                this.ptsy[0] = (int)this.summit[0].y;
                this.ptsx[1] = (int)this.summit[2].x + 1;
                this.ptsy[1] = (int)this.summit[2].y;
                this.ptsx[2] = (int)this.summit[4].x + 1;
                this.ptsy[2] = (int)this.summit[4].y + 1;
                this.ptsx[3] = (int)this.summit[6].x;
                this.ptsy[3] = (int)this.summit[6].y + 1;
            } else {
                this.ptsx[0] = (int)this.summit[6].x;
                this.ptsy[0] = (int)this.summit[6].y;
                this.ptsx[1] = (int)this.summit[4].x + 1;
                this.ptsy[1] = (int)this.summit[4].y;
                this.ptsx[2] = (int)this.summit[2].x + 1;
                this.ptsy[2] = (int)this.summit[2].y + 1;
                this.ptsx[3] = (int)this.summit[0].x;
                this.ptsy[3] = (int)this.summit[0].y + 1;
            }
        } else if (this.summit[0].y < this.summit[6].y) {
            this.ptsx[0] = (int)this.summit[2].x;
            this.ptsy[0] = (int)this.summit[2].y;
            this.ptsx[1] = (int)this.summit[0].x + 1;
            this.ptsy[1] = (int)this.summit[0].y;
            this.ptsx[2] = (int)this.summit[6].x + 1;
            this.ptsy[2] = (int)this.summit[6].y + 1;
            this.ptsx[3] = (int)this.summit[4].x;
            this.ptsy[3] = (int)this.summit[4].y + 1;
        } else {
            this.ptsx[0] = (int)this.summit[4].x;
            this.ptsy[0] = (int)this.summit[4].y;
            this.ptsx[1] = (int)this.summit[6].x + 1;
            this.ptsy[1] = (int)this.summit[6].y;
            this.ptsx[2] = (int)this.summit[0].x + 1;
            this.ptsy[2] = (int)this.summit[0].y + 1;
            this.ptsx[3] = (int)this.summit[2].x;
            this.ptsy[3] = (int)this.summit[2].y + 1;
        }
    }

    @Override
    public boolean hasShadow() {
        return false;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.invalidateImage();
        this.loadImage();
        this.computeSummitCoordinates((int)this.summit[0].x, (int)this.summit[0].y, this.imgWidth, this.imgHeight);
        this.updateShape();
        this.centerOrigin();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void resetToOriginalSize() {
        this.computeSummitCoordinates((int)this.summit[0].x, (int)this.summit[0].y, this.imgWidth, this.imgHeight);
        this.updateShape();
        this.centerOrigin();
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    @Override
    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string = this.saveObjectHeader(fileWriter, n);
        String string2 = string + "file_name:\"" + this.fileName + "\"\n";
        fileWriter.write(string2, 0, string2.length());
        this.closeObjectHeader(fileWriter, n);
    }

    JDImage(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("file_name")) {
                this.fileName = jDFileLoader.parseString();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.invalidateImage();
        this.updateShape();
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(9);
        this.fillUndoPattern(undoPattern);
        undoPattern.fileName = new String(this.fileName);
        return undoPattern;
    }

    JDImage(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.fileName = undoPattern.fileName;
        this.invalidateImage();
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3 - 1;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3 - 1;
        this.summit[4].y = n2 + n4 - 1;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4 - 1;
        this.centerSummit();
    }

    private void invalidateImage() {
        this.theImage = null;
    }

    private void loadImage() {
        if (this.theImage == null) {
            try {
                if (this.fileName.startsWith("jar:")) {
                    InputStream inputStream = this.getClass().getResourceAsStream(this.fileName.substring(4));
                    this.theImage = ImageIO.read(inputStream);
                } else {
                    File file = new File(this.fileName);
                    this.theImage = ImageIO.read(file);
                }
                this.imgWidth = ((BufferedImage)this.theImage).getWidth();
                this.imgHeight = ((BufferedImage)this.theImage).getHeight();
            }
            catch (IOException iOException) {
                System.out.println("JDImage.loadImage() Warning " + this.fileName + " load failed : " + iOException.getMessage());
                this.theImage = defaultImage.getImage();
                this.imgWidth = defaultImage.getIconWidth();
                this.imgHeight = defaultImage.getIconHeight();
            }
        }
    }
}

