/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;

public class JDBar
extends JDRectangular {
    public static final int BAR_HORIZONTAL_LEFT = 0;
    public static final int BAR_HORIZONTAL_RIGHT = 1;
    public static final int BAR_VERTICAL_TOP = 2;
    public static final int BAR_VERTICAL_BOTTOM = 3;
    static final double minDefault = 0.0;
    static final double maxDefault = 1.0;
    static final double valueDefault = 1.0;
    static final boolean outLineVisibleDefault = true;
    static final int orientationDefault = 3;
    double min;
    double max;
    double value;
    boolean outLineVisible;
    int orientation;

    public JDBar(String string, int n, int n2, int n3, int n4) {
        this.initDefault();
        this.setOrigin(new Point2D.Double(n, n2));
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates(n, n2, n3, n4);
        this.updateShape();
    }

    JDBar(JDBar jDBar, int n, int n2) {
        this.cloneObject(jDBar, n, n2);
        this.min = jDBar.min;
        this.max = jDBar.max;
        this.value = jDBar.value;
        this.outLineVisible = jDBar.outLineVisible;
        this.orientation = jDBar.orientation;
        this.updateShape();
    }

    JDBar(JDFileLoader jDFileLoader) throws IOException {
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("minBar")) {
                this.min = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("maxBar")) {
                this.max = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("valueBar")) {
                this.value = jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("outLineVisible")) {
                this.outLineVisible = jDFileLoader.parseBoolean();
                continue;
            }
            if (string.equals("orientation")) {
                this.orientation = (int)jDFileLoader.parseDouble();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.updateShape();
    }

    @Override
    public JDObject copy(int n, int n2) {
        return new JDBar(this, n, n2);
    }

    @Override
    void initDefault() {
        super.initDefault();
        this.fillStyle = 1;
        this.min = 0.0;
        this.max = 1.0;
        this.value = 1.0;
        this.outLineVisible = true;
        this.orientation = 3;
    }

    @Override
    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        if (this.fillStyle != 0) {
            return this.boundRect.contains(n, n2);
        }
        int n3 = this.boundRect.x;
        int n4 = this.boundRect.x + this.boundRect.width;
        int n5 = this.boundRect.y;
        int n6 = this.boundRect.y + this.boundRect.height;
        return this.isPointOnLine(n, n2, n3, n5, n4, n5) || this.isPointOnLine(n, n2, n4, n5, n4, n6) || this.isPointOnLine(n, n2, n4, n6, n3, n6) || this.isPointOnLine(n, n2, n3, n6, n3, n5);
    }

    @Override
    void updateShape() {
        this.computeBoundRect();
        this.ptsx = new int[4];
        this.ptsy = new int[4];
        if (!Double.isNaN(this.value)) {
            double d = 0.0;
            if (this.min != this.max) {
                d = (this.value - this.min) / (this.max - this.min);
            }
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            switch (this.orientation) {
                case 0: {
                    int n = (int)((double)(this.boundRect.width - 1) * d + 0.5);
                    if (n < 0) {
                        n = 0;
                    }
                    this.ptsx[0] = this.boundRect.x;
                    this.ptsy[0] = this.boundRect.y;
                    this.ptsx[1] = this.boundRect.x + n;
                    this.ptsy[1] = this.boundRect.y;
                    this.ptsx[2] = this.boundRect.x + n;
                    this.ptsy[2] = this.boundRect.y + this.boundRect.height - 1;
                    this.ptsx[3] = this.boundRect.x;
                    this.ptsy[3] = this.boundRect.y + this.boundRect.height - 1;
                    break;
                }
                case 1: {
                    int n = (int)((double)(this.boundRect.width - 1) * (1.0 - d) + 0.5);
                    if (n < 0) {
                        n = 0;
                    }
                    this.ptsx[0] = this.boundRect.x + n;
                    this.ptsy[0] = this.boundRect.y;
                    this.ptsx[1] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[1] = this.boundRect.y;
                    this.ptsx[2] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[2] = this.boundRect.y + this.boundRect.height - 1;
                    this.ptsx[3] = this.boundRect.x + n;
                    this.ptsy[3] = this.boundRect.y + this.boundRect.height - 1;
                    break;
                }
                case 2: {
                    int n = (int)((double)(this.boundRect.height - 1) * d + 0.5);
                    if (n < 0) {
                        n = 0;
                    }
                    this.ptsx[0] = this.boundRect.x;
                    this.ptsy[0] = this.boundRect.y;
                    this.ptsx[1] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[1] = this.boundRect.y;
                    this.ptsx[2] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[2] = this.boundRect.y + n;
                    this.ptsx[3] = this.boundRect.x;
                    this.ptsy[3] = this.boundRect.y + n;
                    break;
                }
                case 3: {
                    int n = (int)((double)(this.boundRect.height - 1) * (1.0 - d) + 0.5);
                    if (n < 0) {
                        n = 0;
                    }
                    this.ptsx[0] = this.boundRect.x;
                    this.ptsy[0] = this.boundRect.y + n;
                    this.ptsx[1] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[1] = this.boundRect.y + n;
                    this.ptsx[2] = this.boundRect.x + this.boundRect.width - 1;
                    this.ptsy[2] = this.boundRect.y + this.boundRect.height - 1;
                    this.ptsx[3] = this.boundRect.x;
                    this.ptsy[3] = this.boundRect.y + this.boundRect.height - 1;
                }
            }
            if (this.hasShadow()) {
                this.computeShadow(true);
                this.computeShadowColors();
            }
        }
    }

    @Override
    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (Double.isNaN(this.value)) {
            return;
        }
        this.prepareRendering((Graphics2D)graphics);
        super.paint(jDrawEditor, graphics);
        if (this.outLineVisible) {
            graphics.setColor(this.foreground);
            int n = (int)(this.summit[0].x + 0.5);
            int n2 = (int)(this.summit[0].y + 0.5);
            int n3 = (int)(this.summit[4].x + 0.5);
            int n4 = (int)(this.summit[4].y + 0.5);
            graphics.drawLine(n, n2, n3, n2);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.drawLine(n3, n4, n, n4);
            graphics.drawLine(n, n4, n, n2);
        }
    }

    public void setMaximum(double d) {
        this.max = d;
        this.updateShape();
    }

    public double getMaximum() {
        return this.max;
    }

    public void setMinimum(double d) {
        this.min = d;
        this.updateShape();
    }

    public double getMinimum() {
        return this.min;
    }

    public void setBarValue(double d) {
        this.value = d;
        this.updateShape();
    }

    public double getBarValue() {
        return this.value;
    }

    public void setOutLineVisible(boolean bl) {
        this.outLineVisible = bl;
    }

    public boolean isOutLineVisible() {
        return this.outLineVisible;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.updateShape();
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    void saveObject(FileWriter fileWriter, int n) throws IOException {
        String string;
        String string2 = this.saveObjectHeader(fileWriter, n);
        if (this.min != 0.0) {
            string = string2 + "minBar:" + this.min + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.max != 1.0) {
            string = string2 + "maxBar:" + this.max + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.value != 1.0) {
            string = string2 + "valueBar:" + this.value + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (this.orientation != 3) {
            string = string2 + "orientation:" + this.orientation + "\n";
            fileWriter.write(string, 0, string.length());
        }
        if (!this.outLineVisible) {
            string = string2 + "outLineVisible:" + this.outLineVisible + "\n";
            fileWriter.write(string, 0, string.length());
        }
        this.closeObjectHeader(fileWriter, n);
    }

    @Override
    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(12);
        this.fillUndoPattern(undoPattern);
        undoPattern.min = this.min;
        undoPattern.max = this.max;
        undoPattern.value = this.value;
        undoPattern.isClosed = this.outLineVisible;
        undoPattern.textOrientation = this.orientation;
        return undoPattern;
    }

    JDBar(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.min = undoPattern.min;
        this.max = undoPattern.max;
        this.value = undoPattern.value;
        this.outLineVisible = undoPattern.isClosed;
        this.orientation = undoPattern.textOrientation;
        this.updateShape();
    }

    private void computeSummitCoordinates(int n, int n2, int n3, int n4) {
        this.summit[0].x = n;
        this.summit[0].y = n2;
        this.summit[2].x = n + n3;
        this.summit[2].y = n2;
        this.summit[4].x = n + n3;
        this.summit[4].y = n2 + n4;
        this.summit[6].x = n;
        this.summit[6].y = n2 + n4;
        this.centerSummit();
    }
}

