/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.interlock;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class NetUtils {
    static final String[] fntList = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    static final Color fColor = new Color(99, 97, 156);
    static final Font labelFont = new Font("Dialog", 0, 12);
    static final Font labelbFont = new Font("Dialog", 1, 12);
    static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public static JMenuItem createMenuItem(String string, int n, int n2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(string);
        if (n != 0) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n, n2));
        }
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static Border createTitleBorder(String string) {
        return BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string, 1, 0, labelbFont, fColor);
    }

    public static void centerDialog(Dialog dialog, int n, int n2) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        if (dialog.getParent() != null) {
            rectangle = dialog.getParent().getBounds();
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle.x = 0;
            rectangle.y = 0;
            rectangle.width = NetUtils.screenSize.width;
            rectangle.height = NetUtils.screenSize.height;
        }
        dialog.pack();
        Insets insets = dialog.getInsets();
        int n3 = n + (insets.right + insets.left);
        int n4 = n2 + (insets.bottom + insets.top);
        int n5 = rectangle.x + (rectangle.width - n3) / 2;
        int n6 = rectangle.y + (rectangle.height - n4) / 2;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 + n3 > NetUtils.screenSize.width) {
            n5 = NetUtils.screenSize.width - n3;
        }
        if (n6 + n4 > NetUtils.screenSize.height) {
            n6 = NetUtils.screenSize.height - n4;
        }
        dialog.setBounds(n5, n6, n3, n4);
    }

    public static void centerFrameOnScreen(Frame frame) {
        Rectangle rectangle = new Rectangle(0, 0, NetUtils.screenSize.width, NetUtils.screenSize.height);
        frame.pack();
        int n = frame.getPreferredSize().width;
        int n2 = frame.getPreferredSize().height;
        int n3 = rectangle.x + (rectangle.width - n) / 2;
        int n4 = rectangle.y + (rectangle.height - n2) / 2;
        frame.setBounds(n3, n4, n, n2);
    }

    static JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(labelFont);
        jLabel.setForeground(fColor);
        return jLabel;
    }

    static boolean fontEquals(Font font, Font font2) {
        return font.getName().equalsIgnoreCase(font2.getName()) && font.getSize() == font2.getSize() && font.getStyle() == font2.getStyle();
    }

    static JComboBox createFontCombo() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(false);
        jComboBox.setFont(labelFont);
        for (int i = 0; i < fntList.length; ++i) {
            jComboBox.addItem(fntList[i]);
        }
        return jComboBox;
    }

    static int getIdx(String string) {
        int n = 0;
        boolean bl = false;
        while (n < fntList.length && !bl) {
            bl = string.equalsIgnoreCase(fntList[n]);
            if (bl) continue;
            ++n;
        }
        if (bl) {
            return n;
        }
        return -1;
    }
}

