/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart.math;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

class PossibleNamesLister
extends JDialog
implements MouseListener {
    protected JLabel lastSelected = null;
    protected JLabel destination = null;
    protected JLabel[] names = null;
    protected JPanel mainPanel = new JPanel();
    protected JScrollPane scroller = null;
    protected int prefWidth = 0;
    protected int prefHeight = 0;
    static final Color selectionColor = new Color(255, 160, 200);
    static final Color mouseOverColor = new Color(200, 180, 255);
    static final Border labelBorder = new LineBorder(Color.BLACK, 1);
    static final Border selectionBorder = new LineBorder(selectionColor, 1);
    static final int maxWidth = 400;
    static final int maxHeight = 400;

    public PossibleNamesLister(String[] stringArray, JDialog jDialog) {
        super(jDialog, "Choose variable:", true);
        this.mainPanel.setLayout(null);
        if (stringArray != null) {
            int n;
            this.names = new JLabel[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.names[n] = stringArray[n] != null ? new JLabel(new String(stringArray[n])) : new JLabel("");
                this.names[n].setBorder(labelBorder);
                if (this.names[n].getPreferredSize().width > this.prefWidth) {
                    this.prefWidth = this.names[n].getPreferredSize().width;
                }
                this.prefHeight += 25;
            }
            for (n = 0; n < this.names.length; ++n) {
                this.names[n].setBounds(0, 25 * n, this.prefWidth, 25);
                this.mainPanel.add(this.names[n]);
                this.names[n].addMouseListener(this);
            }
            this.mainPanel.setPreferredSize(new Dimension(this.prefWidth, this.prefHeight));
        }
        this.scroller = new JScrollPane(this.mainPanel);
        this.setContentPane(this.scroller);
        this.mainPanel.setBackground(Color.WHITE);
        this.scroller.setBackground(Color.WHITE);
        this.scroller.getViewport().setBackground(Color.WHITE);
        this.setBackground(Color.WHITE);
        this.initBounds();
        this.setResizable(false);
    }

    public void initBounds() {
        int n = this.prefWidth + 30 < 400 ? this.prefWidth + 30 : 400;
        int n2 = this.prefHeight + 30 < 400 ? this.prefHeight + 30 : 400;
        int n3 = this.getParent().getX() - (this.prefWidth + 50);
        int n4 = this.getParent().getY();
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        this.setBounds(n3, n4, n, n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            if (this.lastSelected != null) {
                this.lastSelected.setBorder(labelBorder);
                this.lastSelected.setOpaque(false);
                this.lastSelected.setBackground(Color.WHITE);
                this.lastSelected.repaint();
            }
            this.setVisible(false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setBackground(mouseOverColor);
        ((JLabel)mouseEvent.getSource()).setOpaque(true);
        ((JLabel)mouseEvent.getSource()).repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setOpaque(false);
        ((JLabel)mouseEvent.getSource()).setBackground(Color.WHITE);
        ((JLabel)mouseEvent.getSource()).repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.lastSelected != null && this.lastSelected != (JLabel)mouseEvent.getSource()) {
            this.lastSelected.setBorder(labelBorder);
            this.lastSelected.setOpaque(false);
            this.lastSelected.setBackground(Color.WHITE);
            this.lastSelected.repaint();
        }
        ((JLabel)mouseEvent.getSource()).setBackground(selectionColor);
        ((JLabel)mouseEvent.getSource()).setBorder(selectionBorder);
        ((JLabel)mouseEvent.getSource()).setOpaque(true);
        ((JLabel)mouseEvent.getSource()).repaint();
        this.lastSelected = (JLabel)mouseEvent.getSource();
        if (this.destination != null) {
            this.destination.setText(((JLabel)mouseEvent.getSource()).getText());
            this.destination.setToolTipText(((JLabel)mouseEvent.getSource()).getText());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void dispose() {
        if (this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i] = null;
            }
            this.names = null;
        }
        this.lastSelected = null;
    }

    public JLabel getDestination() {
        return this.destination;
    }

    public void setDestination(JLabel jLabel) {
        this.destination = jLabel;
    }
}

