/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Marker;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JImage
extends JComponent
implements MouseMotionListener,
MouseListener,
KeyListener {
    public static final int MODE_LINE = 0;
    public static final int MODE_RECT = 1;
    public static final int MODE_CROSS = 2;
    public static final int VERTICAL_LEFT = 0;
    public static final int VERTICAL_CENTER = 1;
    public static final int VERTICAL_RIGHT = 2;
    public static final int HORIZONTAL_TOP = 0;
    public static final int HORIZONTAL_CENTER = 1;
    public static final int HORIZONTAL_BOTTOM = 2;
    protected static final int MARKER_CROSS = 1;
    protected static final int MARKER_RECT = 2;
    protected static final int MARKER_VLINE = 3;
    protected static final int MARKER_HLINE = 4;
    protected BufferedImage theImage = null;
    protected Insets margin;
    protected int xOrg;
    protected int yOrg;
    protected boolean selectionEnabled;
    protected int mode;
    protected boolean isDragging;
    protected int dragCorner;
    protected int cornerWidth = 10;
    protected int x1 = -1;
    protected int y1 = -1;
    protected int x2 = -1;
    protected int y2 = -1;
    protected boolean snapToGrid;
    protected int grid = 16;
    protected Vector<Marker> markers = null;
    protected double markerScaleFactor = 1.0;
    protected JLAxis xAxis;
    protected int xAxisHeight;
    protected int xAxisUpMargin;
    protected JLAxis yAxis;
    protected int yAxisWidth;
    protected int yAxisRightMargin;
    protected boolean crossCursor = false;
    protected Color cursorColor = Color.WHITE;
    protected int xCursor = -1;
    protected int yCursor = -1;
    protected Color selectionColor = Color.RED;
    protected int horizontalPosition;
    protected int verticalPosition;

    public JImage() {
        this.setLayout(null);
        this.setBorder(null);
        this.setBackground(new Color(180, 180, 200));
        this.setOpaque(true);
        this.setMargin(new Insets(5, 5, 5, 5));
        this.xOrg = 5;
        this.yOrg = 5;
        this.mode = 1;
        this.verticalPosition = 1;
        this.horizontalPosition = 1;
        this.isDragging = false;
        this.selectionEnabled = true;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.snapToGrid = false;
        this.yAxis = new JLAxis(this, 6);
        this.yAxis.setAxisColor(Color.BLACK);
        this.yAxis.setFont(ATKConstant.labelFont);
        this.yAxis.setAutoScale(false);
        this.yAxis.setMinimum(0.0);
        this.yAxis.setMaximum(100.0);
        this.yAxis.setVisible(false);
        this.yAxis.setInverted(false);
        this.xAxis = new JLAxis(this, 2);
        this.xAxis.setAxisColor(Color.BLACK);
        this.xAxis.setFont(ATKConstant.labelFont);
        this.xAxis.setAutoScale(false);
        this.xAxis.setMinimum(0.0);
        this.xAxis.setMaximum(100.0);
        this.xAxis.setVisible(false);
    }

    public void setCrossCursor(boolean bl) {
        this.crossCursor = bl;
        if (bl) {
            this.setCursor(null);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void setCursorColor(Color color) {
        this.cursorColor = color;
    }

    public boolean isCrossCursor() {
        return this.crossCursor;
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
        this.repaint();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public Rectangle getSelectionRect() {
        if (this.hasSelection()) {
            return this.buildSelectionRect();
        }
        return null;
    }

    public Point[] getSelectionPoint() {
        if (this.hasSelection()) {
            Point[] pointArray = new Point[]{new Point(this.x1, this.y1), new Point(this.x2, this.y2)};
            return pointArray;
        }
        return null;
    }

    public Point[] getSelectionCrossPoint() {
        if (this.hasSelection() && this.mode == 2) {
            Point[] pointArray = new Point[4];
            Point point = new Point();
            Point point2 = new Point();
            Point point3 = new Point();
            Point point4 = new Point();
            pointArray[0] = point;
            pointArray[1] = point2;
            pointArray[2] = point3;
            pointArray[3] = point4;
            switch (this.getHorizontalPosition()) {
                case 0: {
                    point.x = this.x1;
                    point2.x = this.x2;
                    point.y = this.y1;
                    point2.y = this.y1;
                    break;
                }
                case 1: {
                    point.x = this.x1;
                    point2.x = this.x2;
                    point.y = (this.y1 + this.y2) / 2;
                    point2.y = (this.y1 + this.y2) / 2;
                    break;
                }
                case 2: {
                    point.x = this.x1;
                    point2.x = this.x2;
                    point.y = this.y2;
                    point2.y = this.y2;
                }
            }
            switch (this.getVerticalPosition()) {
                case 0: {
                    point3.x = this.x1;
                    point4.x = this.x1;
                    point3.y = this.y1;
                    point4.y = this.y2;
                    break;
                }
                case 1: {
                    point3.x = (this.x1 + this.x2) / 2;
                    point4.x = (this.x1 + this.x2) / 2;
                    point3.y = this.y1;
                    point4.y = this.y2;
                    break;
                }
                case 2: {
                    point3.x = this.x2;
                    point4.x = this.x2;
                    point3.y = this.y1;
                    point4.y = this.y2;
                }
            }
            return pointArray;
        }
        return null;
    }

    public void setSelectionMode(int n) {
        this.mode = n;
        this.clipSelection();
        this.repaint();
    }

    public int getSelectionMode() {
        return this.mode;
    }

    public boolean hasSelection() {
        return this.selectionEnabled && this.x1 >= 0 && this.x2 >= 0 && this.y1 >= 0 && this.y2 >= 0;
    }

    public void setSelection(int n, int n2, int n3, int n4) {
        if (this.selectionEnabled) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = n3;
            this.y2 = n4;
            this.clipSelection();
            this.isDragging = false;
            this.repaint();
        }
    }

    public void clearSelection() {
        this.x1 = -1;
        this.y1 = -1;
        this.x2 = -1;
        this.y2 = -1;
        this.isDragging = false;
        this.repaint();
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public int getXOrigin() {
        return this.xOrg + this.yAxis.getThickness();
    }

    public int getYOrigin() {
        return this.yOrg + this.xAxisUpMargin;
    }

    public void setImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = this.theImage;
        this.theImage = bufferedImage;
        this.clearSelection();
        this.repaint();
        if (bufferedImage2 != null) {
            bufferedImage2.flush();
        }
        bufferedImage2 = null;
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public JLAxis getYAxis() {
        return this.yAxis;
    }

    public BufferedImage getImage() {
        return this.theImage;
    }

    public Dimension getImageSize() {
        if (this.theImage != null) {
            return new Dimension(this.theImage.getWidth(), this.theImage.getHeight());
        }
        return new Dimension(0, 0);
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean bl) {
        this.snapToGrid = bl;
    }

    public int getSnapGrid() {
        return this.grid;
    }

    public void setSnapGrid(int n) {
        this.grid = n;
    }

    public int addCrossMarker(int n, int n2, Color color) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(1, n, n2, color));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addRectangleMarker(int n, int n2, int n3, int n4, Color color) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(2, new Rectangle(n, n2, n3, n4), color));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addVerticalLineMarker(int n, Color color) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(3, n, 0, color));
        this.repaint();
        return this.markers.size() - 1;
    }

    public int addHorizontalLineMarker(int n, Color color) {
        if (this.markers == null) {
            this.markers = new Vector();
        }
        this.markers.add(new Marker(4, 0, n, color));
        this.repaint();
        return this.markers.size() - 1;
    }

    public void setMarkerPos(int n, int n2, int n3, int n4, int n5) {
        if (this.markers != null) {
            if (n >= 0 && n < this.markers.size()) {
                Marker marker = this.markers.get(n);
                marker.markerRect.setBounds(n2, n3, n4, n5);
            }
            this.repaint();
        }
    }

    public void clearMarkers() {
        if (this.markers != null) {
            this.markers.clear();
            this.markers = null;
            this.repaint();
        }
    }

    public int getMarkerNumber() {
        if (this.markers == null) {
            return 0;
        }
        return this.markers.size();
    }

    public void setMarkerScale(double d) {
        this.markerScaleFactor = d;
    }

    public int getHorizontalPosition() {
        return this.horizontalPosition;
    }

    public void setHorizontalPosition(int n) {
        this.horizontalPosition = n;
        this.repaint();
    }

    public int getVerticalPosition() {
        return this.verticalPosition;
    }

    public void setVerticalPosition(int n) {
        this.verticalPosition = n;
        this.repaint();
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color color) {
        this.selectionColor = color;
        this.repaint();
    }

    protected void paintCursor(Graphics graphics) {
        Dimension dimension = this.getImageSize();
        if (this.crossCursor && this.xCursor >= 0 && this.yCursor >= 0 && this.xCursor <= dimension.width && this.yCursor <= dimension.height) {
            graphics.setColor(this.cursorColor);
            graphics.drawLine(0, this.yCursor, dimension.width, this.yCursor);
            graphics.drawLine(this.xCursor, 0, this.xCursor, dimension.height);
        }
    }

    protected void paintSelection(Graphics graphics) {
        if (this.hasSelection()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            if (this.selectionColor != null) {
                graphics2D.setColor(this.selectionColor);
            } else {
                graphics2D.setColor(Color.RED);
            }
            Stroke stroke = graphics2D.getStroke();
            BasicStroke basicStroke = new BasicStroke(2.0f);
            graphics2D.setStroke(basicStroke);
            Rectangle rectangle = this.buildSelectionRect();
            Rectangle rectangle2 = new Rectangle(0, 0, this.cornerWidth, this.cornerWidth);
            switch (this.mode) {
                case 0: {
                    graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
                    graphics2D.setStroke(stroke);
                    int n = (this.x1 + this.x2) / 2;
                    int n2 = (this.y1 + this.y2) / 2;
                    double d = this.y2 - this.y1;
                    double d2 = -(this.x2 - this.x1);
                    double d3 = Math.sqrt(d * d + d2 * d2);
                    int n3 = (int)(8.0 * (d / d3));
                    int n4 = (int)(8.0 * (d2 / d3));
                    d = this.x2 - this.x1;
                    d2 = this.y2 - this.y1;
                    d3 = Math.sqrt(d * d + d2 * d2);
                    int n5 = (int)(10.0 * (d / d3));
                    int n6 = (int)(10.0 * (d2 / d3));
                    graphics2D.drawLine(n - n3, n2 - n4, n + n3, n2 + n4);
                    graphics2D.drawLine(n + n3, n2 + n4, n + n5, n2 + n6);
                    graphics2D.drawLine(n + n5, n2 + n6, n - n3, n2 - n4);
                    rectangle2.translate(this.x1 - this.cornerWidth / 2, this.y1 - this.cornerWidth / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(this.x2 - this.x1, this.y2 - this.y1);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    break;
                }
                case 1: {
                    graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    graphics2D.setStroke(stroke);
                    rectangle2.translate(rectangle.x - this.cornerWidth / 2, rectangle.y - this.cornerWidth / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(rectangle.width, 0);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(0, rectangle.height);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(-rectangle.width, 0);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(rectangle.width / 2, -rectangle.height / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    break;
                }
                case 2: {
                    int n;
                    int n7;
                    switch (this.horizontalPosition) {
                        case 0: {
                            n7 = this.y1 < this.y2 ? this.y1 : this.y2;
                            break;
                        }
                        case 1: {
                            n7 = (this.y1 + this.y2) / 2;
                            break;
                        }
                        case 2: {
                            n7 = this.y1 < this.y2 ? this.y2 : this.y1;
                            break;
                        }
                        default: {
                            n7 = -1;
                        }
                    }
                    switch (this.verticalPosition) {
                        case 0: {
                            n = this.x1 < this.x2 ? this.x1 : this.x2;
                            break;
                        }
                        case 1: {
                            n = (this.x1 + this.x2) / 2;
                            break;
                        }
                        case 2: {
                            n = this.x1 < this.x2 ? this.x2 : this.x1;
                            break;
                        }
                        default: {
                            n = -1;
                        }
                    }
                    if (n < 0 || n7 < 0) break;
                    graphics2D.drawLine(this.x1, n7, this.x2, n7);
                    graphics2D.drawLine(n, this.y1, n, this.y2);
                    if (this.x1 < this.x2) {
                        graphics2D.drawLine(this.x2, n7, this.x2 - 8, n7 - 8);
                        graphics2D.drawLine(this.x2 - 8, n7 - 8, this.x2 - 8, n7 + 8);
                        graphics2D.drawLine(this.x2 - 8, n7 + 8, this.x2, n7);
                    } else {
                        graphics2D.drawLine(this.x2, n7, this.x2 + 8, n7 - 8);
                        graphics2D.drawLine(this.x2 + 8, n7 - 8, this.x2 + 8, n7 + 8);
                        graphics2D.drawLine(this.x2 + 8, n7 + 8, this.x2, n7);
                    }
                    if (this.y1 < this.y2) {
                        graphics2D.drawLine(n, this.y2, n - 8, this.y2 - 8);
                        graphics2D.drawLine(n - 8, this.y2 - 8, n + 8, this.y2 - 8);
                        graphics2D.drawLine(n + 8, this.y2 - 8, n, this.y2);
                    } else {
                        graphics2D.drawLine(n, this.y2, n - 8, this.y2 + 8);
                        graphics2D.drawLine(n - 8, this.y2 + 8, n + 8, this.y2 + 8);
                        graphics2D.drawLine(n + 8, this.y2 + 8, n, this.y2);
                    }
                    graphics2D.setStroke(stroke);
                    rectangle2.translate(rectangle.x - this.cornerWidth / 2, rectangle.y - this.cornerWidth / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(rectangle.width, 0);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(0, rectangle.height);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(-rectangle.width, 0);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    rectangle2.translate(rectangle.width / 2, -rectangle.height / 2);
                    graphics2D.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            }
            graphics2D.setColor(color);
            graphics2D.setPaintMode();
        }
    }

    protected void measureAxis() {
        this.xAxisHeight = 0;
        this.yAxisWidth = 0;
        this.xAxisUpMargin = 0;
        this.yAxisRightMargin = 0;
        if (this.xAxis.isVisible()) {
            this.xAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth(), 0);
            if (this.xAxis.getOrientation() == 2) {
                this.xAxisHeight = 7;
                this.xAxisUpMargin = this.xAxis.getThickness();
            } else {
                this.xAxisHeight = this.xAxis.getThickness();
                this.xAxisUpMargin = 7;
            }
        }
        if (this.yAxis.isVisible()) {
            this.yAxis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight());
            this.yAxisWidth = this.yAxis.getThickness();
            this.yAxisRightMargin = 15;
        }
    }

    protected void paintAxis(Graphics graphics) {
        if (this.yAxis.isVisible()) {
            if (this.yAxis.getOrientation() == 5) {
                this.yAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth() - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            } else {
                this.yAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), -this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                if (this.yAxis.isDrawOpposite()) {
                    this.yAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), this.theImage.getWidth() - this.yAxis.getThickness(), 0, Color.BLACK, 0, 0);
                }
            }
        }
        if (this.xAxis.isVisible()) {
            if (this.xAxis.getOrientation() == 2) {
                this.xAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight(), Color.BLACK, 0, 0);
                }
            } else {
                this.xAxis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, this.theImage.getHeight(), Color.BLACK, 0, 0);
                if (this.xAxis.isDrawOpposite()) {
                    this.xAxis.paintAxisOpposite(graphics, ATKGraphicsUtils.getDefaultRenderContext(), 0, 0, Color.BLACK, 0, 0);
                }
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.theImage == null) {
            return;
        }
        if (this.xAxis.isAutoScale()) {
            this.xAxis.setAutoScale(false);
            this.xAxis.setMinimum(0.0);
            this.xAxis.setMaximum((double)this.theImage.getWidth() / this.markerScaleFactor);
            this.xAxis.setAutoScale(true);
        }
        if (this.yAxis.isAutoScale()) {
            this.yAxis.setAutoScale(false);
            this.yAxis.setMinimum(0.0);
            this.yAxis.setMaximum((double)this.theImage.getHeight() / this.markerScaleFactor);
            this.yAxis.setAutoScale(true);
        }
        this.measureAxis();
        this.xOrg = (dimension.width - (this.theImage.getWidth() + this.yAxisWidth + this.yAxisRightMargin)) / 2;
        this.yOrg = (dimension.height - (this.theImage.getHeight() + this.xAxisHeight + this.xAxisUpMargin)) / 2;
        graphics.translate(this.xOrg + this.yAxisWidth, this.yOrg + this.xAxisUpMargin);
        graphics.drawImage(this.theImage, 0, 0, null);
        this.paintAxis(graphics);
        this.paintSelection(graphics);
        this.paintCursor(graphics);
        if (this.markers != null) {
            block6: for (int i = 0; i < this.markers.size(); ++i) {
                Marker marker = this.markers.get(i);
                graphics.setColor(marker.markerColor);
                int n = (int)((double)marker.markerRect.x * this.markerScaleFactor);
                int n2 = (int)((double)marker.markerRect.y * this.markerScaleFactor);
                int n3 = (int)((double)marker.markerRect.width * this.markerScaleFactor);
                int n4 = (int)((double)marker.markerRect.height * this.markerScaleFactor);
                Rectangle rectangle = new Rectangle(0, 0, this.theImage.getWidth() + 1, this.theImage.getHeight() + 1);
                Rectangle rectangle2 = n3 == 0 ? new Rectangle(n, n2, 1, 1) : new Rectangle(n, n2, n3, n4);
                if (!rectangle.contains(rectangle2)) continue;
                switch (marker.type) {
                    case 1: {
                        graphics.drawLine(n, 0, n, this.theImage.getHeight());
                        graphics.drawLine(0, n2, this.theImage.getWidth(), n2);
                        graphics.drawRect(n - 2, n2 - 2, 5, 5);
                        continue block6;
                    }
                    case 2: {
                        graphics.drawRect(n, n2, n3, n4);
                        continue block6;
                    }
                    case 3: {
                        graphics.drawLine(n, 0, n, this.theImage.getHeight());
                        continue block6;
                    }
                    case 4: {
                        graphics.drawLine(0, n2, this.theImage.getWidth(), n2);
                    }
                }
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.theImage == null) {
            return new Dimension(320, 200);
        }
        this.measureAxis();
        return new Dimension(this.theImage.getWidth() + this.margin.right + this.margin.left + this.yAxisWidth + this.yAxisRightMargin, this.theImage.getHeight() + this.margin.top + this.margin.bottom + this.xAxisHeight + this.xAxisUpMargin);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    protected boolean cornerMatch(int n, int n2, int n3, int n4) {
        int n5 = this.cornerWidth / 2;
        return n >= n3 - n5 && n <= n3 + n5 && n2 >= n4 - n5 && n2 <= n4 + n5;
    }

    protected int findCorner(int n, int n2) {
        if (this.hasSelection()) {
            int n3 = (this.x2 + this.x1) / 2;
            int n4 = (this.y2 + this.y1) / 2;
            if (this.cornerMatch(n, n2, this.x1, this.y1)) {
                return 1;
            }
            if (this.cornerMatch(n, n2, this.x2, this.y1) && this.mode != 0) {
                return 2;
            }
            if (this.cornerMatch(n, n2, this.x2, this.y2)) {
                return 3;
            }
            if (this.cornerMatch(n, n2, this.x1, this.y2) && this.mode != 0) {
                return 4;
            }
            if (this.cornerMatch(n, n2, n3, n4)) {
                return 5;
            }
        }
        return 0;
    }

    protected Rectangle buildSelectionRect() {
        Rectangle rectangle = new Rectangle();
        if (this.x1 < this.x2) {
            if (this.y1 < this.y2) {
                rectangle.setRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
            } else {
                rectangle.setRect(this.x1, this.y2, this.x2 - this.x1, this.y1 - this.y2);
            }
        } else if (this.y1 < this.y2) {
            rectangle.setRect(this.x2, this.y1, this.x1 - this.x2, this.y2 - this.y1);
        } else {
            rectangle.setRect(this.x2, this.y2, this.x1 - this.x2, this.y1 - this.y2);
        }
        return rectangle;
    }

    protected void repaintBoundingRect(Rectangle rectangle) {
        Rectangle rectangle2 = this.buildSelectionRect();
        if (!rectangle2.equals(rectangle)) {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.x + rectangle.width;
            int n4 = rectangle.y + rectangle.height;
            if (rectangle2.x < n) {
                n = rectangle2.x;
            }
            if (rectangle2.y < n2) {
                n2 = rectangle2.y;
            }
            if (rectangle2.width + rectangle2.x > n3) {
                n3 = rectangle2.width + rectangle2.x;
            }
            if (rectangle2.height + rectangle2.y > n4) {
                n4 = rectangle2.height + rectangle2.y;
            }
            int n5 = this.cornerWidth / 2;
            if (this.mode == 0 || this.mode == 2) {
                this.repaint(0L, n - n5 + this.xOrg + this.yAxisWidth - 4, n2 - n5 + this.yOrg + this.xAxisUpMargin - 4, n3 - n + this.cornerWidth + 8, n4 - n2 + this.cornerWidth + 8);
            } else {
                this.repaint(0L, n - n5 + this.xOrg + this.yAxisWidth, n2 - n5 + this.yOrg + this.xAxisUpMargin, n3 - n + this.cornerWidth + 1, n4 - n2 + this.cornerWidth + 1);
            }
        }
    }

    protected void clipSelection() {
        if (this.hasSelection()) {
            Dimension dimension = this.getImageSize();
            if (this.mode == 0) {
                if (this.x1 >= dimension.width) {
                    this.x1 = dimension.width - 1;
                }
                if (this.y1 >= dimension.height) {
                    this.y1 = dimension.height - 1;
                }
                if (this.x2 >= dimension.width) {
                    this.x2 = dimension.width - 1;
                }
                if (this.y2 >= dimension.height) {
                    this.y2 = dimension.height - 1;
                }
                if (this.x1 < 0) {
                    this.x1 = 0;
                }
                if (this.y1 < 0) {
                    this.y1 = 0;
                }
                if (this.x2 < 0) {
                    this.x2 = 0;
                }
                if (this.y2 < 0) {
                    this.y2 = 0;
                }
            } else {
                if (this.x1 == this.x2) {
                    this.x2 += this.grid;
                }
                if (this.y1 == this.y2) {
                    this.y2 += this.grid;
                }
                if (dimension.width > 1) {
                    if (this.x1 >= dimension.width - 1) {
                        this.x1 = dimension.width;
                    }
                    if (this.x2 >= dimension.width - 1) {
                        this.x2 = dimension.width;
                    }
                } else {
                    this.x1 = 0;
                    this.x2 = 1;
                }
                if (dimension.height > 1) {
                    if (this.y1 >= dimension.height - 1) {
                        this.y1 = dimension.height;
                    }
                    if (this.y2 >= dimension.height - 1) {
                        this.y2 = dimension.height;
                    }
                } else {
                    this.y1 = 0;
                    this.y2 = 1;
                }
                if (this.x1 < 0) {
                    this.x1 = 0;
                }
                if (this.y1 < 0) {
                    this.y1 = 0;
                }
                if (this.x2 < 0) {
                    this.x2 = 0;
                }
                if (this.y2 < 0) {
                    this.y2 = 0;
                }
            }
        }
    }

    protected void alignSelection() {
        if (this.snapToGrid && this.hasSelection()) {
            if (this.mode == 1) {
                this.x1 = this.x1 / this.grid * this.grid;
                this.x2 = this.x2 / this.grid * this.grid;
                this.y1 = this.y1 / this.grid * this.grid;
                this.y2 = this.y2 / this.grid * this.grid;
            } else {
                Dimension dimension = this.getImageSize();
                this.x1 = this.x1 >= dimension.width - 1 ? dimension.width - 1 : this.x1 / this.grid * this.grid;
                this.x2 = this.x2 >= dimension.width - 1 ? dimension.width - 1 : this.x2 / this.grid * this.grid;
                this.y1 = this.y1 >= dimension.height - 1 ? dimension.height - 1 : this.y1 / this.grid * this.grid;
                this.y2 = this.y2 >= dimension.height - 1 ? dimension.height - 1 : this.y2 / this.grid * this.grid;
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.crossCursor) {
            this.xCursor = mouseEvent.getX() - this.xOrg - this.yAxisWidth;
            this.yCursor = mouseEvent.getY() - this.yOrg - this.xAxisUpMargin;
            this.repaint();
        }
        if (this.isDragging) {
            Rectangle rectangle = this.buildSelectionRect();
            int n = mouseEvent.getX() - this.xOrg - this.yAxisWidth;
            int n2 = mouseEvent.getY() - this.yOrg - this.xAxisUpMargin;
            Dimension dimension = this.getImageSize();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (this.mode == 0) {
                if (n >= dimension.width) {
                    n = dimension.width - 1;
                }
                if (n2 >= dimension.height) {
                    n2 = dimension.height - 1;
                }
            } else {
                if (n >= dimension.width) {
                    n = dimension.width;
                }
                if (n2 >= dimension.height) {
                    n2 = dimension.height;
                }
            }
            switch (this.dragCorner) {
                case 1: {
                    this.x1 = n;
                    this.y1 = n2;
                    break;
                }
                case 2: {
                    this.x2 = n;
                    this.y1 = n2;
                    break;
                }
                case 3: {
                    this.x2 = n;
                    this.y2 = n2;
                    break;
                }
                case 4: {
                    this.x1 = n;
                    this.y2 = n2;
                    break;
                }
                case 5: {
                    Rectangle rectangle2 = this.buildSelectionRect();
                    int n3 = rectangle2.x + rectangle2.width / 2;
                    int n4 = rectangle2.y + rectangle2.height / 2;
                    int n5 = n - n3;
                    int n6 = n2 - n4;
                    if (this.x1 + n5 < 0) {
                        n5 = -this.x1;
                    }
                    if (this.x2 + n5 < 0) {
                        n5 = -this.x2;
                    }
                    if (this.y1 + n6 < 0) {
                        n6 = -this.y1;
                    }
                    if (this.y2 + n6 < 0) {
                        n6 = -this.y2;
                    }
                    if (this.mode == 0) {
                        if (this.x1 + n5 >= dimension.width) {
                            n5 = dimension.width - 1 - this.x1;
                        }
                        if (this.x2 + n5 >= dimension.width) {
                            n5 = dimension.width - 1 - this.x2;
                        }
                        if (this.y1 + n6 >= dimension.height) {
                            n6 = dimension.height - 1 - this.y1;
                        }
                        if (this.y2 + n6 >= dimension.height) {
                            n6 = dimension.height - 1 - this.y2;
                        }
                    } else {
                        if (this.x1 + n5 >= dimension.width) {
                            n5 = dimension.width - this.x1;
                        }
                        if (this.x2 + n5 >= dimension.width) {
                            n5 = dimension.width - this.x2;
                        }
                        if (this.y1 + n6 >= dimension.height) {
                            n6 = dimension.height - this.y1;
                        }
                        if (this.y2 + n6 >= dimension.height) {
                            n6 = dimension.height - this.y2;
                        }
                    }
                    this.x1 += n5;
                    this.x2 += n5;
                    this.y1 += n6;
                    this.y2 += n6;
                }
            }
            this.alignSelection();
            this.repaintBoundingRect(rectangle);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.crossCursor) {
            this.xCursor = mouseEvent.getX() - this.xOrg - this.yAxisWidth;
            this.yCursor = mouseEvent.getY() - this.yOrg - this.xAxisUpMargin;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.crossCursor) {
            this.xCursor = -1;
            this.yCursor = -1;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isDragging = false;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.grabFocus();
            int n = mouseEvent.getX() - this.xOrg - this.yAxisWidth;
            int n2 = mouseEvent.getY() - this.yOrg - this.xAxisUpMargin;
            if (this.selectionEnabled) {
                Cloneable cloneable;
                this.dragCorner = this.findCorner(n, n2);
                if (this.dragCorner == 0 && !this.hasSelection()) {
                    cloneable = this.getImageSize();
                    if (n > ((Dimension)cloneable).width || n2 > ((Dimension)cloneable).height) {
                        return;
                    }
                    if (n < 0) {
                        n = 0;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    this.x1 = this.x2 = n;
                    this.y1 = this.y2 = n2;
                    this.dragCorner = 3;
                    this.repaint(0L, this.x1 - this.cornerWidth, this.y1 - this.cornerWidth, this.x1 + this.cornerWidth, this.y1 + this.cornerWidth);
                }
                cloneable = this.buildSelectionRect();
                this.alignSelection();
                this.repaintBoundingRect((Rectangle)cloneable);
                this.isDragging = true;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.hasSelection()) {
            if (keyEvent.isShiftDown()) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        if (this.horizontalPosition == 2) {
                            this.setHorizontalPosition(1);
                            break;
                        }
                        this.setHorizontalPosition(0);
                        break;
                    }
                    case 40: {
                        if (this.horizontalPosition == 0) {
                            this.setHorizontalPosition(1);
                            break;
                        }
                        this.setHorizontalPosition(2);
                        break;
                    }
                    case 37: {
                        if (this.verticalPosition == 2) {
                            this.setVerticalPosition(1);
                            break;
                        }
                        this.setVerticalPosition(0);
                        break;
                    }
                    case 39: {
                        if (this.verticalPosition == 0) {
                            this.setVerticalPosition(1);
                            break;
                        }
                        this.setVerticalPosition(2);
                    }
                }
            } else {
                Dimension dimension = this.getImageSize();
                Rectangle rectangle = this.buildSelectionRect();
                int n = this.isSnapToGrid() ? this.grid : 1;
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        if (this.y1 < n || this.y2 < n) break;
                        this.y1 -= n;
                        this.y2 -= n;
                        break;
                    }
                    case 40: {
                        if (!((double)this.y2 < dimension.getHeight() - (double)n) || !((double)this.y1 < dimension.getHeight() - (double)n)) break;
                        this.y1 += n;
                        this.y2 += n;
                        break;
                    }
                    case 37: {
                        if (this.x1 < n || this.x2 < n) break;
                        this.x1 -= n;
                        this.x2 -= n;
                        break;
                    }
                    case 39: {
                        if (!((double)this.x2 < dimension.getWidth() - (double)n) || !((double)this.x1 < dimension.getWidth() - (double)n)) break;
                        this.x1 += n;
                        this.x2 += n;
                    }
                }
                this.alignSelection();
                this.repaintBoundingRect(rectangle);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        JImage jImage = new JImage();
        BufferedImage bufferedImage = new BufferedImage(800, 600, 1);
        jImage.setImage(bufferedImage);
        jImage.mode = 2;
        jImage.setSelectionColor(Color.GREEN);
        jFrame.setContentPane(jImage);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

