/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.Gradient;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JGradientViewer
extends JComponent {
    private Gradient gradient;
    private int[] colorMap;
    private JLAxis axis;
    private int barWidth = 20;

    public JGradientViewer() {
        this.setLayout(null);
        this.setBorder(null);
        this.setOpaque(true);
        this.gradient = new Gradient();
        this.colorMap = this.gradient.buildColorMap(256);
        this.axis = new JLAxis(this, 5);
        this.axis.setAutoScale(false);
        this.axis.setAnnotation(2);
        this.axis.setMinimum(0.0);
        this.axis.setMaximum(100.0);
    }

    public Gradient getGradient() {
        return this.gradient;
    }

    public void setGradient(Gradient gradient) {
        this.gradient = gradient;
        this.colorMap = this.gradient.buildColorMap(256);
    }

    public JLAxis getAxis() {
        return this.axis;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int n) {
        this.barWidth = n;
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        int n2 = 0;
        boolean bl = false;
        if (dimension.height <= 20 || dimension.width <= 0) {
            return;
        }
        this.axis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, dimension.height - 21);
        if (dimension.width < this.barWidth) {
            n = dimension.width;
            n2 = 0;
        } else {
            n = this.barWidth;
            if (dimension.width < this.barWidth + this.axis.getThickness()) {
                n2 = (dimension.width - this.barWidth) / 2;
            } else {
                n2 = (dimension.width - (this.barWidth + this.axis.getThickness())) / 2;
                bl = true;
            }
        }
        double d = 256.0 / (double)(dimension.height - 20);
        for (int i = 10; i < dimension.height - 10; ++i) {
            int n3 = (int)(d * (double)(i - 10));
            if (n3 <= 255) {
                graphics.setColor(new Color(this.colorMap[255 - n3]));
            } else {
                graphics.setColor(new Color(this.colorMap[0]));
            }
            graphics.drawLine(n2, i, n2 + n, i);
        }
        if (bl) {
            this.axis.paintAxisDirect(graphics, ATKGraphicsUtils.getDefaultRenderContext(), n2 + n, 10, Color.BLACK, 0, 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        this.axis.measureAxis(ATKGraphicsUtils.getDefaultRenderContext(), 0, this.getHeight() - 21);
        return new Dimension(this.axis.getThickness() + this.barWidth + 4, 20);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JGradientViewer jGradientViewer = new JGradientViewer();
        jGradientViewer.setPreferredSize(new Dimension(50, 200));
        jGradientViewer.getAxis().setMinimum(1.0E-9);
        jGradientViewer.getAxis().setMaximum(1.0E-6);
        jGradientViewer.getAxis().setScale(1);
        jFrame.setContentPane(jGradientViewer);
        jFrame.setDefaultCloseOperation(3);
        ATKGraphicsUtils.centerFrameOnScreen(jFrame);
        jFrame.setVisible(true);
    }
}

