/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.EditorPanel;
import fr.esrf.tangoatk.widget.util.Gradient;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class JGradientEditor
extends JComponent
implements ActionListener,
MouseMotionListener,
MouseListener {
    private boolean isEditable;
    private boolean isDragging;
    private Gradient grad;
    private int[] palette;
    private int currentSel = -1;
    private double currentPos;
    private int barHeight = 25;
    private JPopupMenu popMenu;
    private JMenuItem infoMenuItem;
    private JMenuItem addMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem changeColorMenuItem;
    private JMenuItem resetMenuItem;
    private JMenuItem rainbowMenuItem;
    private static final int[] cursorShapeX = new int[]{-5, -2, 2, 5, 5, 2, -2, -5, -5};
    private static final int[] cursorShapeY = new int[]{10, 15, 15, 10, -10, -15, -15, -10, 10};

    public JGradientEditor() {
        this.setBorder(null);
        this.setOpaque(true);
        this.setOpaque(true);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.isEditable = true;
        this.grad = new Gradient();
        this.palette = this.grad.buildColorMap(256);
        this.popMenu = new JPopupMenu();
        this.infoMenuItem = new JMenuItem("Gradient editor");
        this.infoMenuItem.setEnabled(false);
        this.addMenuItem = new JMenuItem("Add color here");
        this.addMenuItem.addActionListener(this);
        this.removeMenuItem = new JMenuItem("Remove");
        this.removeMenuItem.addActionListener(this);
        this.changeColorMenuItem = new JMenuItem("Change color");
        this.changeColorMenuItem.addActionListener(this);
        this.resetMenuItem = new JMenuItem("Reset to default gradient");
        this.resetMenuItem.addActionListener(this);
        this.rainbowMenuItem = new JMenuItem("Reset to rainbow gradient");
        this.rainbowMenuItem.addActionListener(this);
        this.popMenu.add(this.infoMenuItem);
        this.popMenu.add(new JSeparator());
        this.popMenu.add(this.addMenuItem);
        this.popMenu.add(this.removeMenuItem);
        this.popMenu.add(this.changeColorMenuItem);
        this.popMenu.add(this.resetMenuItem);
        this.popMenu.add(this.rainbowMenuItem);
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public boolean isEditable() {
        Dimension dimension = this.getSize();
        return this.isEditable && dimension.width >= 256;
    }

    public void setGradient(Gradient gradient) {
        if (gradient != null) {
            this.grad = gradient;
            this.palette = gradient.buildColorMap(256);
        }
    }

    public Gradient getGradient() {
        return this.grad;
    }

    public void setRainbowGradient() {
        this.grad = new Gradient();
        this.grad.buildRainbowGradient();
        this.palette = this.grad.buildColorMap(256);
        this.repaint();
    }

    public void setDefaultGradient() {
        this.grad = new Gradient();
        this.palette = this.grad.buildColorMap(256);
        this.repaint();
    }

    public void invertGradient() {
        this.grad.invertGradient();
        this.palette = this.grad.buildColorMap(256);
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        block8: {
            int n;
            Dimension dimension;
            block7: {
                dimension = this.getSize();
                if (dimension.width <= 0) {
                    return;
                }
                if (this.isOpaque()) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                }
                if (dimension.width >= 256) break block7;
                int n2 = (dimension.height - this.barHeight) / 2;
                double d = 256.0 / (double)dimension.width;
                for (int i = 0; i < dimension.width; ++i) {
                    int n3 = (int)(d * (double)i);
                    if (n3 <= 255) {
                        graphics.setColor(new Color(this.palette[n3]));
                    } else {
                        graphics.setColor(new Color(this.palette[255]));
                    }
                    graphics.drawLine(i, n2, i, n2 + this.barHeight);
                }
                break block8;
            }
            int n4 = (dimension.width - 256) / 2;
            int n5 = (dimension.height - this.barHeight) / 2;
            for (n = 0; n < 256; ++n) {
                graphics.setColor(new Color(this.palette[n]));
                graphics.drawLine(n4 + n, n5, n4 + n, n5 + this.barHeight);
            }
            if (!this.isEditable) break block8;
            for (n = 0; n < this.grad.getEntryNumber(); ++n) {
                Color color = this.grad.getColorAt(n);
                double d = this.grad.getPosAt(n);
                int n6 = n4 + (int)(d * 256.0);
                int n7 = n5 + this.barHeight / 2;
                graphics.translate(n6, n7);
                this.paintCursor(graphics, color);
                graphics.translate(-n6, -n7);
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(300, 50);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isDragging) {
            Dimension dimension = this.getSize();
            int n = mouseEvent.getX();
            int n2 = (dimension.width - 256) / 2;
            this.currentPos = (double)(n - n2) / 256.0;
            if (this.currentPos < 0.0) {
                this.currentPos = 0.0;
            }
            if (this.currentPos > 1.0) {
                this.currentPos = 1.0;
            }
            this.grad.setPosAt(this.currentSel, this.currentPos);
            this.palette = this.grad.buildColorMap(256);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Color color;
        if (!this.isEditable()) {
            return;
        }
        if (!this.isInsideBar(mouseEvent)) {
            return;
        }
        if (mouseEvent.getClickCount() == 2 && this.foundEntry(mouseEvent) && (color = JColorChooser.showDialog(this, "Choose gradient color #" + (this.currentSel + 1), this.grad.getColorAt(this.currentSel))) != null) {
            this.grad.setColorAt(this.currentSel, color);
            this.palette = this.grad.buildColorMap(256);
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isDragging = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.isEditable()) {
            return;
        }
        if (!this.isInsideBar(mouseEvent)) {
            return;
        }
        if (this.foundEntry(mouseEvent)) {
            if (mouseEvent.getButton() == 3) {
                this.addMenuItem.setVisible(false);
                this.removeMenuItem.setVisible(this.currentSel > 0 && this.currentSel < this.grad.getEntryNumber() - 1);
                this.changeColorMenuItem.setVisible(true);
                this.popMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            if (mouseEvent.getButton() == 1) {
                this.isDragging = true;
            }
        } else if (mouseEvent.getButton() == 3) {
            this.addMenuItem.setVisible(true);
            this.removeMenuItem.setVisible(false);
            this.changeColorMenuItem.setVisible(false);
            this.popMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.changeColorMenuItem) {
            Color color;
            if (this.currentSel >= 0 && this.currentSel < this.grad.getEntryNumber() && (color = JColorChooser.showDialog(this, "Choose gradient color #" + (this.currentSel + 1), this.grad.getColorAt(this.currentSel))) != null) {
                this.grad.setColorAt(this.currentSel, color);
                this.palette = this.grad.buildColorMap(256);
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.resetMenuItem) {
            this.setDefaultGradient();
        } else if (actionEvent.getSource() == this.rainbowMenuItem) {
            this.setRainbowGradient();
        } else if (actionEvent.getSource() == this.addMenuItem) {
            Color color = JColorChooser.showDialog(this, "Choose new color", Color.black);
            if (color != null) {
                this.grad.addEntry(color, this.currentPos);
                this.palette = this.grad.buildColorMap(256);
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.removeMenuItem) {
            this.grad.removeEntry(this.currentSel);
            this.palette = this.grad.buildColorMap(256);
            this.repaint();
        }
    }

    public static Gradient showDialog(JDialog jDialog, Gradient gradient) {
        JDialog jDialog2 = new JDialog((Dialog)jDialog, true);
        return JGradientEditor.showDefDialog(jDialog2, gradient);
    }

    public static Gradient showDialog(JFrame jFrame, Gradient gradient) {
        JDialog jDialog = new JDialog((Frame)jFrame, true);
        return JGradientEditor.showDefDialog(jDialog, gradient);
    }

    public static Gradient showDialog(JComponent jComponent, Gradient gradient) {
        Container container = jComponent.getRootPane().getParent();
        JDialog jDialog = container instanceof JDialog ? new JDialog((Dialog)((JDialog)container), true) : (container instanceof JFrame ? new JDialog((Frame)((JFrame)container), true) : new JDialog((Frame)null, true));
        return JGradientEditor.showDefDialog(jDialog, gradient);
    }

    private Color transformColor(Color color, int n) {
        int n2 = color.getRed() + n;
        int n3 = color.getBlue() + n;
        int n4 = color.getGreen() + n;
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return new Color(n2, n3, n4);
    }

    private boolean isLightColor(Color color) {
        int n;
        int n2;
        int n3 = color.getRed();
        return Math.sqrt(n3 * n3 + (n2 = color.getGreen()) * n2 + (n = color.getBlue()) * n) > 180.0;
    }

    private void paintCursor(Graphics graphics, Color color) {
        graphics.setColor(color);
        graphics.fillPolygon(cursorShapeX, cursorShapeY, 9);
        if (this.isLightColor(color)) {
            graphics.setColor(this.transformColor(color, -128));
        } else {
            graphics.setColor(this.transformColor(color, 128));
        }
        graphics.drawPolygon(cursorShapeX, cursorShapeY, 9);
    }

    private boolean isInsideBar(MouseEvent mouseEvent) {
        Dimension dimension = this.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = (dimension.width - 256) / 2;
        int n4 = (dimension.height - this.barHeight) / 2;
        return n >= n3 - 5 && n <= n3 + 261 && n2 >= n4 && n2 <= n4 + this.barHeight;
    }

    private boolean foundEntry(MouseEvent mouseEvent) {
        int n;
        int n2;
        double d;
        boolean bl = false;
        Dimension dimension = this.getSize();
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = (dimension.width - 256) / 2;
        int n6 = (dimension.height - this.barHeight) / 2;
        int n7 = this.grad.getEntryNumber() - 2;
        while (n7 > 0 && !bl) {
            d = this.grad.getPosAt(n7);
            n2 = n5 + (int)(d * 256.0);
            n = n6 + this.barHeight / 2;
            bl = n3 > n2 - 8 && n3 < n2 + 8 && n4 > n - 15 && n4 < n + 15;
            if (bl) continue;
            --n7;
        }
        if (bl) {
            this.currentSel = n7;
        } else {
            d = this.grad.getPosAt(0);
            n2 = n5 + (int)(d * 256.0);
            n = n6 + this.barHeight / 2;
            boolean bl2 = bl = n3 > n2 - 8 && n3 < n2 + 8 && n4 > n - 15 && n4 < n + 15;
            if (!bl) {
                d = this.grad.getPosAt(this.grad.getEntryNumber() - 1);
                n2 = n5 + (int)(d * 256.0);
                n = n6 + this.barHeight / 2;
                boolean bl3 = bl = n3 > n2 - 8 && n3 < n2 + 8 && n4 > n - 15 && n4 < n + 15;
                this.currentSel = !bl ? -1 : this.grad.getEntryNumber() - 1;
            } else {
                this.currentSel = 0;
            }
        }
        this.currentPos = (double)(n3 - n5) / 256.0;
        if (this.currentPos < 0.0) {
            this.currentPos = 0.0;
        }
        if (this.currentPos > 1.0) {
            this.currentPos = 1.0;
        }
        return bl;
    }

    private static Gradient showDefDialog(JDialog jDialog, Gradient gradient) {
        EditorPanel editorPanel = new EditorPanel();
        if (gradient != null) {
            Gradient gradient2 = gradient.cloneMe();
            editorPanel.setGradient(gradient2);
        }
        jDialog.setResizable(false);
        jDialog.setContentPane(editorPanel);
        jDialog.setTitle("Colormap gradient editor");
        ATKGraphicsUtils.centerDialog(jDialog);
        jDialog.setVisible(true);
        jDialog.dispose();
        if (editorPanel.dlgRetValue == 0) {
            return null;
        }
        return editorPanel.getGradient();
    }

    public static void main(String[] stringArray) {
        Gradient gradient = new Gradient();
        gradient.buildRainbowGradient();
        JGradientEditor.showDialog((JFrame)null, gradient);
    }
}

