/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.DevStateScalarEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IDevStateScalar;
import fr.esrf.tangoatk.core.IDevStateScalarListener;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StateViewer
extends JPanel
implements IDevStateScalarListener {
    private JLabel textLabel;
    private JLabel valueLabel;
    private IDevStateScalar model = null;
    private boolean useDeviceAlias = true;
    private String currentState = "UNKNOWN";
    private boolean externalSetText = false;
    private boolean stateInTooltip = false;

    public StateViewer() {
        this.initComponents();
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.textLabel.setText("Not Connected");
        this.textLabel.setFont(new Font("Dialog", 0, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.textLabel, gridBagConstraints);
        this.valueLabel.setBackground(Color.red);
        this.valueLabel.setFont(new Font("Dialog", 0, 12));
        this.valueLabel.setPreferredSize(new Dimension(40, 14));
        this.valueLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        this.add((Component)this.valueLabel, gridBagConstraints);
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeDevStateScalarListener((IDevStateScalarListener)this);
            this.model = null;
        }
    }

    public void setModel(IDevStateScalar iDevStateScalar) {
        if (this.model != null) {
            this.clearModel();
        }
        if (iDevStateScalar == null) {
            return;
        }
        this.model = iDevStateScalar;
        if (!iDevStateScalar.areAttPropertiesLoaded()) {
            iDevStateScalar.loadAttProperties();
        }
        iDevStateScalar.addDevStateScalarListener((IDevStateScalarListener)this);
        if (!this.externalSetText) {
            if (this.useDeviceAlias) {
                if (this.model.getDevice().getAlias() != null) {
                    this.textLabel.setText(this.model.getDevice().getAlias());
                } else {
                    this.textLabel.setText(this.model.getDevice().getName());
                }
            } else {
                this.textLabel.setText(this.model.getDevice().getName());
            }
        }
        this.valueLabel.setToolTipText(this.model.getDevice().getName());
        this.setCurrentState(this.model.getDeviceValue());
    }

    public IDevStateScalar getModel() {
        return this.model;
    }

    public void setLabel(String string) {
        this.externalSetText = true;
        this.textLabel.setText(string);
    }

    public String getLabel() {
        return this.textLabel.getText();
    }

    public void setLabelVisible(boolean bl) {
        this.textLabel.setVisible(bl);
    }

    public boolean isLabelVisible() {
        return this.textLabel.isVisible();
    }

    public boolean getUseDeviceAlias() {
        return this.useDeviceAlias;
    }

    public void setUseDeviceAlias(boolean bl) {
        this.useDeviceAlias = bl;
    }

    public void setStateVisible(boolean bl) {
        this.valueLabel.setVisible(bl);
    }

    public boolean isStateVisible() {
        return this.valueLabel.isVisible();
    }

    public boolean getStateInTooltip() {
        return this.stateInTooltip;
    }

    public void setStateInTooltip(boolean bl) {
        if (this.stateInTooltip != bl) {
            if (!bl && this.model != null) {
                this.valueLabel.setToolTipText(this.model.getDevice().getName());
            }
            this.stateInTooltip = bl;
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public void devStateScalarChange(DevStateScalarEvent devStateScalarEvent) {
        this.setCurrentState(devStateScalarEvent.getValue());
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setCurrentState("UNKNOWN");
    }

    private void setCurrentState(String string) {
        this.currentState = string;
        this.valueLabel.setBackground(ATKConstant.getColor4State(this.currentState, this.model.getInvertedOpenClose(), this.model.getInvertedInsertExtract()));
        if (this.stateInTooltip) {
            this.valueLabel.setToolTipText(this.model.getDevice().getName() + " : " + this.currentState);
        }
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setStateText(String string) {
        this.valueLabel.setText(string);
    }

    public String getStateText() {
        return this.valueLabel.getText();
    }

    public void setStateFont(Font font) {
        this.valueLabel.setFont(font);
    }

    @Override
    public void setFont(Font font) {
        if (this.valueLabel != null) {
            this.valueLabel.setFont(font);
        }
        if (this.textLabel != null) {
            this.textLabel.setFont(font);
        }
        super.setFont(font);
    }

    public Font getStateFont() {
        return this.valueLabel.getFont();
    }

    public void setStateForeground(Color color) {
        this.valueLabel.setForeground(color);
    }

    public Color getStateForeground() {
        return this.valueLabel.getForeground();
    }

    @Override
    public void setForeground(Color color) {
        if (this.valueLabel != null) {
            this.valueLabel.setForeground(color);
        }
        if (this.textLabel != null) {
            this.textLabel.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setStateHorizontalAlignment(int n) {
        this.valueLabel.setHorizontalAlignment(n);
    }

    public int getStateHorizontalAlignment() {
        return this.valueLabel.getHorizontalAlignment();
    }

    public void setStatePreferredSize(Dimension dimension) {
        this.valueLabel.setPreferredSize(dimension);
    }

    public Dimension getStatePreferredSize() {
        return this.valueLabel.getPreferredSize();
    }

    public void setStateBorder(Border border) {
        if (this.valueLabel == null) {
            return;
        }
        this.valueLabel.setBorder(border);
    }

    public Border getStateBorder() {
        if (this.valueLabel == null) {
            return null;
        }
        return this.valueLabel.getBorder();
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        StateViewer stateViewer = new StateViewer();
        try {
            IDevStateScalar iDevStateScalar = (IDevStateScalar)attributeList.add("fp/test/1/State");
            stateViewer.setModel(iDevStateScalar);
            stateViewer.setLabel("FP status");
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(stateViewer);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

