/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.TangoDs.AttrManip;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.ISpectrumListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.NumberSpectrumEvent;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumTableEditor;
import fr.esrf.tangoatk.widget.attribute.SimplePropertyFrame;
import fr.esrf.tangoatk.widget.util.ATKConstant;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.chart.AdvancedJLChart;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class NumberSpectrumViewer
extends AdvancedJLChart
implements ISpectrumListener,
INumberScalarListener,
IJLChartActionListener,
IJLChartListener,
JDrawable {
    protected INumberSpectrum model = null;
    protected JLDataView dvy;
    protected SimplePropertyFrame pf = null;
    protected double A0 = 0.0;
    protected double A1 = 1.0;
    protected String xAxisUnit = "";
    protected String format;
    protected boolean unitVisible = false;
    protected boolean qualityVisible = false;
    protected static final String DISPLAY_UNIT_STRING = "Display/Hide Unit";
    protected static final String DISPLAY_QUALITY_STRING = "Display/Hide Attribute Quality";
    protected static final String SET_SPECTRUM_MENU_LABEL = "Set attribute";
    private boolean manageXaxis = false;
    private boolean xAxisManagedByProps = false;
    private boolean xAxisManagedByAtts = false;
    private boolean xAxisMinMaxApplied = false;
    private double xAxisMin = -1.0;
    private double xAxisMax = -1.0;
    private INumberScalar x_min_model = null;
    private INumberScalar x_max_model = null;
    private double x_min_value = 0.0;
    private double x_max_value = 0.0;
    private NumberSpectrumTableEditor spectrumEditor = null;
    private JMenuItem setAttMenuItem = null;
    static String[] exts = new String[]{"manageXaxis", "graphSettings"};

    public NumberSpectrumViewer() {
        this.setBorder(new EtchedBorder());
        this.setBackground(new Color(180, 180, 180));
        this.getY1Axis().setAutoScale(true);
        this.getXAxis().setAutoScale(true);
        this.getXAxis().setAnnotation(2);
        this.dvy = new JLDataView();
        this.getY1Axis().addDataView(this.dvy);
        this.removeMenuItem(6);
        this.removeMenuItem(7);
        this.addUserAction("Attribute properties");
        this.addUserAction(DISPLAY_UNIT_STRING);
        this.addUserAction(DISPLAY_QUALITY_STRING);
        this.addUserAction(SET_SPECTRUM_MENU_LABEL);
        this.setAttMenuItem = this.getUserActionMenuItem(SET_SPECTRUM_MENU_LABEL);
        if (this.setAttMenuItem != null) {
            this.setAttMenuItem.setEnabled(false);
        }
        this.addJLChartActionListener(this);
        this.setJLChartListener(this);
    }

    public boolean getManageXaxis() {
        return this.manageXaxis;
    }

    public void setManageXaxis(boolean bl) {
        if (this.model != null) {
            return;
        }
        this.manageXaxis = bl;
    }

    public String getXAxisUnit() {
        return this.xAxisUnit;
    }

    public void setXAxisUnit(String string) {
        this.xAxisUnit = string;
    }

    public void setXAxisAffineTransform(double d, double d2) {
        this.A0 = d;
        this.A1 = d2;
    }

    @Override
    public void initForEditing() {
        this.dvy.add(0.0, 0.0);
        this.dvy.add(2.0, 1.0);
        this.dvy.add(4.0, 1.2);
        this.dvy.add(6.0, 3.0);
        this.dvy.add(8.0, 0.2);
        this.dvy.add(10.0, 1.5);
        this.setPreferredSize(new Dimension(400, 300));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getDescription(String string) {
        if (string.equalsIgnoreCase("manageXaxis")) {
            return "When enabled, the viewer will adapt the Xaxis min and Xaxis max \nto the attribute properties defined in the Tango DataBase. \nPossible values are: true, false.";
        }
        if (string.equalsIgnoreCase("graphSettings")) {
            return this.getHelpString();
        }
        return "";
    }

    @Override
    public String[] getExtensionList() {
        return exts;
    }

    @Override
    public boolean setExtendedParam(String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("manageXaxis")) {
            if (string2.equalsIgnoreCase("true")) {
                this.setManageXaxis(true);
                return true;
            }
            if (string2.equalsIgnoreCase("false")) {
                this.setManageXaxis(false);
                return true;
            }
            this.showJdrawError(bl, "manageXaxis", "Wrong syntax: 'true' or 'false' expected.");
            return false;
        }
        if (string.equalsIgnoreCase("graphSettings")) {
            String string3;
            if (!string2.endsWith("\n")) {
                string2 = string2 + "\n";
            }
            if ((string3 = this.setSettings(string2)).length() > 0) {
                this.showJdrawError(bl, "graphSettings", string3);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getExtendedParam(String string) {
        if (string.equalsIgnoreCase("manageXaxis")) {
            if (this.getManageXaxis()) {
                return "true";
            }
            return "false";
        }
        if (string.equalsIgnoreCase("graphSettings")) {
            return this.getSettings();
        }
        return "";
    }

    private void showJdrawError(boolean bl, String string, String string2) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "NumberSpectrumViewer: " + string + " incorrect.\n" + string2, "Error", 0);
        }
    }

    @Override
    public void actionPerformed(JLChartActionEvent jLChartActionEvent) {
        if (jLChartActionEvent.getName().equals("Attribute properties")) {
            if (this.pf == null) {
                this.pf = new SimplePropertyFrame();
                this.pf.setModel((IAttribute)this.model);
            }
            this.pf.setVisible(true);
        } else if (DISPLAY_UNIT_STRING.equals(jLChartActionEvent.getName())) {
            this.setUnitVisible(!this.isUnitVisible());
        } else if (DISPLAY_QUALITY_STRING.equals(jLChartActionEvent.getName())) {
            this.setQualityVisible(!this.isQualityVisible());
        } else if (SET_SPECTRUM_MENU_LABEL.equals(jLChartActionEvent.getName())) {
            this.setSpectrumAttribute();
        }
    }

    @Override
    public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
        return this.model != null;
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (errorEvent.getSource() != this.model) {
            return;
        }
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": " + "UNKNOWN");
            this.dvy.setLabelColor(ATKConstant.getColor4Quality("UNKNOWN"));
        }
        this.dvy.reset();
        this.repaint();
        this.refreshTableSingle(this.dvy);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": " + attributeStateEvent.getState());
            this.dvy.setLabelColor(ATKConstant.getColor4Quality(attributeStateEvent.getState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spectrumChange(NumberSpectrumEvent numberSpectrumEvent) {
        double[] dArray = numberSpectrumEvent.getValue();
        int n = dArray.length;
        if (this.xAxisManagedByProps) {
            if (!this.xAxisMinMaxApplied) {
                this.changeXaxisAffineTransform(this.xAxisMin, this.xAxisMax, n);
            } else if (this.dvy == null) {
                this.changeXaxisAffineTransform(this.xAxisMin, this.xAxisMax, n);
            } else if (this.dvy.getDataLength() != n) {
                this.changeXaxisAffineTransform(this.xAxisMin, this.xAxisMax, n);
            }
        }
        if (this.xAxisManagedByAtts && !this.xAxisMinMaxApplied) {
            this.changeXaxisAffineTransform(this.x_min_value, this.x_max_value, n);
        }
        JLDataView jLDataView = this.dvy;
        synchronized (jLDataView) {
            this.dvy.reset();
            for (int i = 0; i < n; ++i) {
                this.dvy.add(this.A0 + this.A1 * (double)i, dArray[i], false);
            }
            this.dvy.updateFilters();
            this.repaint();
            this.refreshTableSingle(this.dvy);
        }
    }

    @Override
    public String[] clickOnChart(JLChartEvent jLChartEvent) {
        String[] stringArray;
        if (this.model != null) {
            String string = this.format == null ? Double.toString(jLChartEvent.getTransformedYValue()) : (this.format.indexOf(37) == -1 ? AttrManip.format((String)this.format, (double)jLChartEvent.getTransformedYValue()) : ATKFormat.format(this.format, jLChartEvent.getTransformedYValue()));
            stringArray = new String[]{this.model.getName(), this.xAxisUnit.length() > 0 ? "X=" + jLChartEvent.getTransformedXValue() + " " + this.xAxisUnit : "X=" + jLChartEvent.getTransformedXValue(), "Y=" + string + " " + this.model.getUnit()};
        } else {
            stringArray = new String[]{this.xAxisUnit.length() > 0 ? "X=" + jLChartEvent.getTransformedXValue() + " " + this.xAxisUnit : "X=" + jLChartEvent.getTransformedXValue(), "Y=" + jLChartEvent.getTransformedYValue()};
        }
        return stringArray;
    }

    public void setModel(INumberSpectrum iNumberSpectrum) {
        this.clearModel();
        if (iNumberSpectrum == null) {
            this.repaint();
            return;
        }
        this.model = iNumberSpectrum;
        if (this.model.isWritable()) {
            if (this.setAttMenuItem != null) {
                this.setAttMenuItem.setEnabled(true);
            }
            this.spectrumEditor = new NumberSpectrumTableEditor();
            this.spectrumEditor.setModel(this.model);
        }
        if (this.manageXaxis) {
            if (!this.model.areAttPropertiesLoaded()) {
                this.model.loadAttProperties();
            }
            if (this.model.hasMinxMaxxAttributes()) {
                this.xAxisManagedByAtts = true;
            } else if (this.model.hasMinxMaxxProperties()) {
                this.xAxisManagedByProps = true;
                this.getXAxis().setAutoScale(false);
                this.xAxisMin = this.model.getMinx();
                this.xAxisMax = this.model.getMaxx();
            }
            this.xAxisMinMaxApplied = false;
        }
        this.format = this.model.getFormat();
        this.dvy.setUserFormat(this.format);
        this.dvy.setUnit(iNumberSpectrum.getUnit());
        this.dvy.setName(iNumberSpectrum.getName());
        if (this.isQualityVisible()) {
            this.setToolTipText(this.model.getName() + ": " + this.model.getState());
            this.dvy.setLabelColor(ATKConstant.getColor4Quality(this.model.getState()));
        }
        this.model.addSpectrumListener((ISpectrumListener)this);
        if (this.pf != null) {
            this.pf.setModel((IAttribute)this.model);
        }
        if (this.unitVisible) {
            this.getY1Axis().setName(iNumberSpectrum.getUnit());
        } else {
            this.getY1Axis().setName("");
        }
        this.repaint();
    }

    public void clearModel() {
        this.xAxisManagedByProps = false;
        this.xAxisManagedByAtts = false;
        this.xAxisMinMaxApplied = false;
        this.xAxisMin = -1.0;
        this.xAxisMax = -1.0;
        this.x_min_value = 0.0;
        this.x_max_value = 0.0;
        if (this.model != null) {
            this.model.removeSpectrumListener((ISpectrumListener)this);
            if (this.pf != null) {
                this.pf.setModel(null);
            }
            this.model = null;
        }
        if (this.x_min_model != null) {
            this.x_min_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_min_model = null;
        }
        if (this.x_max_model != null) {
            this.x_max_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_max_model = null;
        }
        this.setToolTipText(null);
        this.dvy.setLabelColor(Color.BLACK);
        if (this.spectrumEditor != null) {
            this.spectrumEditor.clearModel();
            this.spectrumEditor = null;
        }
        if (this.setAttMenuItem != null) {
            this.setAttMenuItem.setEnabled(false);
        }
    }

    public String setSettings(String string) {
        CfFileReader cfFileReader = new CfFileReader();
        if (!cfFileReader.parseText(string)) {
            return "NumberSpectrumViewer.setSettings: Failed to parse given config";
        }
        this.applyConfiguration(cfFileReader);
        Vector<String> vector = cfFileReader.getParam("xaxis_transform");
        if (vector != null) {
            this.setXAxisAffineTransform(OFormat.getDouble(vector.get(0).toString()), OFormat.getDouble(vector.get(1).toString()));
        }
        if ((vector = cfFileReader.getParam("xaxis_unit")) != null) {
            this.xAxisUnit = vector.get(0).toString();
        }
        this.getXAxis().applyConfiguration("x", cfFileReader);
        this.getY1Axis().applyConfiguration("y1", cfFileReader);
        this.dvy.applyConfiguration("dvy", cfFileReader);
        return "";
    }

    public String getSettings() {
        String string = "";
        string = string + this.getConfiguration();
        string = string + "xaxis_transform:" + this.A0 + "," + this.A1 + "\n";
        string = string + "xaxis_unit:'" + this.xAxisUnit + "'\n";
        string = string + this.getXAxis().getConfiguration("x");
        string = string + this.getY1Axis().getConfiguration("y1");
        string = string + this.dvy.getConfiguration("dvy");
        return string;
    }

    public boolean isUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean bl) {
        this.unitVisible = bl;
        if (bl && this.model != null) {
            this.getY1Axis().setName(this.model.getUnit());
        } else {
            this.getY1Axis().setName("");
        }
        this.repaint();
    }

    public boolean isQualityVisible() {
        return this.qualityVisible;
    }

    public void setQualityVisible(boolean bl) {
        if (this.qualityVisible != bl) {
            this.qualityVisible = bl;
            if (bl) {
                if (this.model != null) {
                    this.setToolTipText(this.model.getName() + ": " + this.model.getState());
                    this.dvy.setLabelColor(ATKConstant.getColor4Quality(this.model.getState()));
                }
            } else {
                this.setToolTipText(null);
                this.dvy.setLabelColor(Color.BLACK);
            }
            this.repaint();
        }
    }

    public void setSpectrumAttribute() {
        if (this.spectrumEditor == null) {
            return;
        }
        this.spectrumEditor.centerWindow();
        this.spectrumEditor.setVisible(true);
    }

    @Override
    public void removeDataView(JLDataView jLDataView) {
        if (jLDataView != this.dvy) {
            super.removeDataView(jLDataView);
        }
    }

    @Override
    protected boolean prepareDataViewMenu(JLDataView jLDataView) {
        if (jLDataView == this.dvy) {
            return false;
        }
        boolean bl = super.prepareDataViewMenu(jLDataView);
        return bl;
    }

    private void changeXaxisAffineTransform(double d, double d2, int n) {
        if (d2 <= d) {
            return;
        }
        if (n <= 0) {
            return;
        }
        this.getXAxis().setMinimum(d);
        this.getXAxis().setMaximum(d2);
        double d3 = (d2 - d) / (double)n;
        this.setXAxisAffineTransform(d, d3);
        this.xAxisMinMaxApplied = true;
    }

    private void changeXaxisAffineTransform() {
        if (this.dvy == null) {
            return;
        }
        this.changeXaxisAffineTransform(this.x_min_value, this.x_max_value, this.dvy.getDataLength());
    }

    public void setXaxisModels(INumberScalar iNumberScalar, INumberScalar iNumberScalar2) {
        if (!this.manageXaxis) {
            return;
        }
        if (!this.xAxisManagedByAtts) {
            return;
        }
        if (this.x_min_model != null) {
            this.x_min_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_min_model = null;
        }
        if (this.x_max_model != null) {
            this.x_max_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_max_model = null;
        }
        this.x_min_value = 0.0;
        this.x_max_value = 0.0;
        this.getXAxis().setAutoScale(true);
        this.xAxisMinMaxApplied = false;
        if (iNumberScalar == null || iNumberScalar2 == null) {
            return;
        }
        if (iNumberScalar == iNumberScalar2) {
            return;
        }
        if (!iNumberScalar.getNameSansDevice().equalsIgnoreCase(this.model.getMinxAttName())) {
            return;
        }
        if (!iNumberScalar2.getNameSansDevice().equalsIgnoreCase(this.model.getMaxxAttName())) {
            return;
        }
        this.x_min_model = iNumberScalar;
        this.x_max_model = iNumberScalar2;
        this.getXAxis().setAutoScale(false);
        this.x_min_model.addNumberScalarListener((INumberScalarListener)this);
        this.x_max_model.addNumberScalarListener((INumberScalarListener)this);
        iNumberScalar.refresh();
        iNumberScalar2.refresh();
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        if (numberScalarEvent.getSource() == this.x_min_model) {
            this.minXchange(numberScalarEvent);
            return;
        }
        if (numberScalarEvent.getSource() == this.x_max_model) {
            this.maxXchange(numberScalarEvent);
            return;
        }
    }

    private void minXchange(NumberScalarEvent numberScalarEvent) {
        this.x_min_value = numberScalarEvent.getValue();
        if (this.x_min_value < this.x_max_value) {
            if (!this.getXAxis().isAutoScale()) {
                // empty if block
            }
            this.getXAxis().setMinimum(this.x_min_value);
            this.getXAxis().setMaximum(this.x_max_value);
            this.changeXaxisAffineTransform();
        }
    }

    private void maxXchange(NumberScalarEvent numberScalarEvent) {
        this.x_max_value = numberScalarEvent.getValue();
        if (this.x_min_value < this.x_max_value) {
            if (!this.getXAxis().isAutoScale()) {
                // empty if block
            }
            this.getXAxis().setMinimum(this.x_min_value);
            this.getXAxis().setMaximum(this.x_max_value);
            this.changeXaxisAffineTransform();
        }
    }

    private static void addXaxisMinMaxAtt(NumberSpectrumViewer numberSpectrumViewer, INumberSpectrum iNumberSpectrum) {
        if (numberSpectrumViewer == null) {
            return;
        }
        if (iNumberSpectrum == null) {
            return;
        }
        if (iNumberSpectrum.hasMinxMaxxAttributes()) {
            String string = null;
            AttributeList attributeList = new AttributeList();
            INumberScalar iNumberScalar = null;
            INumberScalar iNumberScalar2 = null;
            try {
                if (iNumberSpectrum.getMinxAttName() != null && iNumberSpectrum.getMaxxAttName() != null) {
                    string = iNumberSpectrum.getDevice().getName() + "/" + iNumberSpectrum.getMinxAttName();
                    IEntity iEntity = attributeList.add(string);
                    if (iEntity != null && iEntity instanceof INumberScalar) {
                        iNumberScalar = (INumberScalar)iEntity;
                    }
                    if ((iEntity = attributeList.add(string = iNumberSpectrum.getDevice().getName() + "/" + iNumberSpectrum.getMaxxAttName())) != null && iEntity instanceof INumberScalar) {
                        iNumberScalar2 = (INumberScalar)iEntity;
                    }
                }
                if (iNumberScalar != null && iNumberScalar2 != null) {
                    numberSpectrumViewer.setXaxisModels(iNumberScalar, iNumberScalar2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            NumberSpectrumViewer numberSpectrumViewer = new NumberSpectrumViewer();
            numberSpectrumViewer.setManageXaxis(true);
            INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add("//kidiboo:10000/fp/test/1/double_spectrum");
            numberSpectrumViewer.setModel(iNumberSpectrum);
            NumberSpectrumViewer.addXaxisMinMaxAtt(numberSpectrumViewer, iNumberSpectrum);
            numberSpectrumViewer.setBorder(BorderFactory.createLoweredBevelBorder());
            numberSpectrumViewer.setFont(new Font("Dialog", 0, 12));
            numberSpectrumViewer.setXAxisUnit("mA");
            JFrame jFrame = new JFrame();
            attributeList.startRefresher();
            jFrame.setContentPane(numberSpectrumViewer);
            jFrame.setSize(640, 480);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

