/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.Property;
import fr.esrf.tangoatk.widget.attribute.NumberScalarWheelEditor;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import fr.esrf.tangoatk.widget.util.WheelSwitch;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NumberScalarViewer
extends WheelSwitch
implements INumberScalarListener,
PropertyChangeListener {
    private INumberScalar model = null;

    public NumberScalarViewer() {
        super(false);
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public void setModel(INumberScalar iNumberScalar) {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
            this.model = null;
        }
        if (iNumberScalar == null) {
            return;
        }
        this.model = iNumberScalar;
        this.model.addNumberScalarListener((INumberScalarListener)this);
        this.model.getProperty("format").addPresentationListener((PropertyChangeListener)this);
        this.setFormat(this.model.getProperty("format").getPresentation());
        this.model.refresh();
        double d = this.model.getNumberScalarValue();
        this.setValue(d);
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        double d = numberScalarEvent.getValue();
        if (this.getValue() != d) {
            this.setValue(d);
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        this.setValue(Double.NaN);
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Property property = (Property)propertyChangeEvent.getSource();
        if (this.model != null && property.getName().equalsIgnoreCase("format")) {
            this.setFormat(property.getValue().toString());
            this.model.refresh();
        }
    }

    public static void main(String[] stringArray) {
        INumberScalar iNumberScalar = null;
        AttributeList attributeList = new AttributeList();
        try {
            iNumberScalar = (INumberScalar)attributeList.add("jlp/test/1/att_trois");
        }
        catch (Exception exception) {
            ErrorPane.showErrorMessage(null, "jlp/test/1", exception);
            System.exit(0);
        }
        attributeList.startRefresher();
        JFrame jFrame = new JFrame();
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        NumberScalarWheelEditor numberScalarWheelEditor = new NumberScalarWheelEditor();
        NumberScalarViewer numberScalarViewer = new NumberScalarViewer();
        numberScalarWheelEditor.setModel(iNumberScalar);
        numberScalarViewer.setModel(iNumberScalar);
        jPanel.add(numberScalarWheelEditor);
        jPanel.add(numberScalarViewer);
        jFrame.setContentPane(jPanel);
        ATKGraphicsUtils.centerFrameOnScreen(jFrame);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }
}

