/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.tools.ListDialog;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.ErrorPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ServerUsageDialog
extends JDialog {
    private JFrame parent;
    private ArrayList<TangoClass> tangoClasses = new ArrayList();
    private ArrayList<Domain> deviceDomains = new ArrayList();
    private ArrayList<Domain> serverDomains = new ArrayList();
    private int nbServers;
    private String wildcard;
    private static final int ByDevice = 0;
    private static final int ByServer = 1;
    private JTextArea textArea;
    private JLabel titleLabel;

    public ServerUsageDialog(JFrame jFrame) throws DevFailed {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.initComponents();
        this.displayServerUsage();
        this.pack();
        ATKGraphicsUtils.centerDialog((Dialog)this);
    }

    private void displayServerUsage() throws DevFailed {
        String[] stringArray = ApiUtil.get_db_obj().get_server_name_list();
        ListDialog listDialog = new ListDialog(this.parent, "Servers in " + ApiUtil.getTangoHost(), stringArray);
        this.wildcard = listDialog.showDialog();
        if (this.wildcard == null) {
            this.doClose();
            return;
        }
        this.wildcard = this.wildcard + "/*";
        this.titleLabel.setText(this.wildcard);
        this.tangoClasses.clear();
        this.deviceDomains.clear();
        this.serverDomains.clear();
        String[] stringArray2 = ApiUtil.get_db_obj().get_server_list(this.wildcard);
        this.nbServers = stringArray2.length;
        for (String string : stringArray2) {
            this.fillTangoClasses(string);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.textArea.setText(this.toString());
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        this.titleLabel = new JLabel();
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton();
        JLabel jLabel = new JLabel();
        JButton jButton2 = new JButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ServerUsageDialog.this.closeDialog(windowEvent);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        jPanel.add(this.titleLabel);
        this.getContentPane().add((Component)jPanel, "North");
        jButton.setText("Another Server");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerUsageDialog.this.anotherBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton);
        jLabel.setText("                              ");
        jPanel2.add(jLabel);
        jButton2.setText("Dismiss");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerUsageDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jPanel2, "South");
        jScrollPane.setPreferredSize(new Dimension(400, 500));
        this.textArea.setColumns(20);
        this.textArea.setRows(5);
        jScrollPane.setViewportView(this.textArea);
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose();
    }

    private void anotherBtnActionPerformed(ActionEvent actionEvent) {
        try {
            this.displayServerUsage();
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)this.parent, null, (DevFailed)devFailed);
        }
    }

    private void doClose() {
        if (this.parent == null) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private void fillTangoClasses(String string) throws DevFailed {
        DbServer dbServer = new DbServer(string);
        String[] stringArray = dbServer.get_device_class_list();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; i += 2) {
            String string2 = stringArray[i];
            String string3 = stringArray[i + 1];
            if (string3.equals("DServer")) continue;
            ArrayList arrayList = null;
            for (TangoClass tangoClass : this.tangoClasses) {
                if (!tangoClass.name.toLowerCase().equals(string3.toLowerCase())) continue;
                arrayList = tangoClass;
            }
            if (arrayList == null) {
                arrayList = new TangoClass(string3);
                this.tangoClasses.add((TangoClass)arrayList);
            }
            arrayList.add(string2);
            this.fillDomains(string2, 0);
            if (bl) continue;
            this.fillDomains(string2, 1);
            bl = true;
        }
    }

    private void fillDomains(String string, int n) throws DevFailed {
        ArrayList arrayList = null;
        String string2 = string.substring(0, string.indexOf("/"));
        ArrayList<Domain> arrayList2 = n == 0 ? this.deviceDomains : this.serverDomains;
        for (Domain domain : arrayList2) {
            if (!domain.name.toLowerCase().equals(string2.toLowerCase())) continue;
            arrayList = domain;
        }
        if (arrayList == null) {
            arrayList = new Domain(string2);
            arrayList2.add((Domain)arrayList);
        }
        arrayList.add(string);
    }

    @Override
    public String toString() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.wildcard).append("\n");
        stringBuffer.append("\n=====================================\n");
        for (TangoClass tangoClass : this.tangoClasses) {
            stringBuffer.append(tangoClass);
            n += tangoClass.size();
        }
        stringBuffer.append("\n=====================================\n");
        for (int i = 0; i < this.deviceDomains.size() && i < this.serverDomains.size(); ++i) {
            stringBuffer.append("Domain ").append(this.deviceDomains.get((int)i).name).append(":\t");
            stringBuffer.append(this.deviceDomains.get(i).size()).append(" devices\t");
            stringBuffer.append(this.serverDomains.get(i).size()).append(" servers\n");
        }
        stringBuffer.append("\n=====================================\n");
        stringBuffer.append(this.nbServers).append("\tservers\n");
        stringBuffer.append(n).append("\tdevices\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            new ServerUsageDialog(null).setVisible(true);
        }
        catch (DevFailed devFailed) {
            ErrorPane.showErrorMessage((Component)new JFrame(), null, (DevFailed)devFailed);
        }
    }

    class TangoClass
    extends ArrayList<String> {
        String name;

        TangoClass(String string) {
            this.name = string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Class " + this.name + ":\t");
            stringBuffer.append(this.size()).append(" devices\n");
            return stringBuffer.toString();
        }
    }

    class Domain
    extends ArrayList<String> {
        String name;

        Domain(String string) {
            this.name = string;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Domain " + this.name + ":\t");
            stringBuffer.append(this.size()).append(" devices\n");
            return stringBuffer.toString();
        }
    }
}

