/*
 * Decompiled with CFR 0.152.
 */
package admin.astor.tools;

import admin.astor.AstorUtil;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoDs.Except;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class PingHosts {
    private ArrayList<DevState> states = new ArrayList();
    private String[] hosts;

    public PingHosts(String[] stringArray) throws DevFailed {
        this.hosts = stringArray;
        ArrayList<PingThread> arrayList = new ArrayList<PingThread>();
        for (String string : stringArray) {
            arrayList.add(new PingThread(string));
        }
        for (PingThread pingThread : arrayList) {
            pingThread.start();
        }
        try {
            if (AstorUtil.osIsUnix()) {
                Thread.sleep(2000L);
            } else {
                Thread.sleep(5000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        for (PingThread pingThread : arrayList) {
            if (pingThread.hostAlive()) {
                this.states.add(DevState.ON);
            } else {
                this.states.add(DevState.FAULT);
            }
            pingThread.interrupt();
        }
    }

    public ArrayList<DevState> getStates() throws DevFailed {
        return this.states;
    }

    public ArrayList<String> getRunning() throws DevFailed {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.hosts.length && i < this.states.size(); ++i) {
            if (this.states.get(i) != DevState.ON) continue;
            arrayList.add(this.hosts[i]);
        }
        return arrayList;
    }

    public ArrayList<String> getStopped() throws DevFailed {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.hosts.length && i < this.states.size(); ++i) {
            if (this.states.get(i) != DevState.FAULT) continue;
            arrayList.add(this.hosts[i]);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = AstorUtil.getInstance().getHostControlledList();
            int n = 0;
            int n2 = 0;
            long l = System.currentTimeMillis();
            PingHosts pingHosts = new PingHosts(stringArray2);
            ArrayList<DevState> arrayList = pingHosts.getStates();
            for (int i = 0; i < stringArray2.length && i < arrayList.size(); ++i) {
                if (arrayList.get(i) == DevState.FAULT) {
                    ++n2;
                } else {
                    ++n;
                }
                System.out.println(stringArray2[i] + ":\t" + (arrayList.get(i) == DevState.FAULT ? "NOT " : "") + " alive");
            }
            long l2 = System.currentTimeMillis();
            System.out.println("elapsed time: " + (l2 - l) + " ms");
            System.out.println(n + " hosts alive   and  " + n2 + " hosts dead");
        }
        catch (DevFailed devFailed) {
            Except.print_exception((Exception)((Object)devFailed));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private class PingThread
    extends Thread {
        private String hostName;
        private boolean alive = false;

        private PingThread(String string) {
            this.hostName = string;
        }

        private boolean hostAlive() {
            return this.alive;
        }

        @Override
        public void run() {
            try {
                String string = this.executeShellCmdOneLine("ping " + this.hostName);
                this.alive = AstorUtil.osIsUnix() ? string.toLowerCase().indexOf("unreachable") < 0 : string.toLowerCase().indexOf("unreachable") < 0 && string.length() > 0 && string.indexOf("timed out") < 0;
            }
            catch (DevFailed devFailed) {
                Except.print_exception((Exception)((Object)devFailed));
            }
        }

        public String executeShellCmdOneLine(String string) throws DevFailed {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string2;
                Process process = Runtime.getRuntime().exec(string);
                InputStream inputStream = process.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                int n = 0;
                while (n < 2 && (string2 = bufferedReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    stringBuffer.append(string2.trim()).append("\n");
                    ++n;
                }
                process.destroy();
            }
            catch (Exception exception) {
                Except.throw_exception((String)exception.toString(), (String)("The shell command\n" + string + "\nHas failed"), (String)"Utils.executeShellCmd()");
            }
            return stringBuffer.toString();
        }
    }
}

